/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataVersion;
import org.finra.herd.model.api.xml.BusinessObjectDataVersions;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceGetBusinessObjectDataVersionsTest
extends AbstractServiceTest {
    private static final int NUMBER_OF_FORMAT_VERSIONS = 2;
    private static final int NUMBER_OF_DATA_VERSIONS_PER_FORMAT_VERSION = 3;

    @Test
    public void testGetBusinessObjectDataVersions() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        for (int businessObjectFormatVersion = INITIAL_FORMAT_VERSION.intValue(); businessObjectFormatVersion < 2; ++businessObjectFormatVersion) {
            for (int businessObjectDataVersion = INITIAL_DATA_VERSION.intValue(); businessObjectDataVersion < 3; ++businessObjectDataVersion) {
                BusinessObjectDataVersions businessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(businessObjectFormatVersion), PARTITION_VALUE, SUBPARTITION_VALUES, Integer.valueOf(businessObjectDataVersion)));
                Assert.assertNotNull((Object)businessObjectDataVersions);
                Assert.assertEquals((long)1L, (long)businessObjectDataVersions.getBusinessObjectDataVersions().size());
                this.businessObjectDataServiceTestHelper.validateBusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, businessObjectFormatVersion, PARTITION_VALUE, SUBPARTITION_VALUES, businessObjectDataVersion, ((BusinessObjectDataVersion)businessObjectDataVersions.getBusinessObjectDataVersions().get(0)).getBusinessObjectDataKey());
                Assert.assertEquals((Object)BDATA_STATUS, (Object)((BusinessObjectDataVersion)businessObjectDataVersions.getBusinessObjectDataVersions().get(0)).getStatus());
            }
        }
    }

    @Test
    public void testGetBusinessObjectDataVersionsMissingRequiredParameters() {
        try {
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey("      \t\t ", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t "), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataMissingOptionalParameters() {
        this.createTestDatabaseEntities(NO_SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, null, null));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)6L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    @Test
    public void testGetBusinessObjectDataMissingFormatVersionParameter() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)2L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    @Test
    public void testGetBusinessObjectDataMissingDataVersionParameter() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)3L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    @Test
    public void testGetBusinessObjectDataAttributeTrimParameters() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), INITIAL_FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)1L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    @Test
    public void testGetBusinessObjectDataUpperCaseParameters() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)1L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    @Test
    public void testGetBusinessObjectDataLowerCaseParameters() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)1L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    @Test
    public void testGetBusinessObjectDataInvalidParameters() {
        this.createTestDatabaseEntities(SUBPARTITION_VALUES);
        BusinessObjectDataVersions resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)1L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, "I_DO_NOT_EXIST", SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        for (int i = 0; i < SUBPARTITION_VALUES.size(); ++i) {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.set(i, "I_DO_NOT_EXIST");
            resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, INITIAL_DATA_VERSION));
            Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
            Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        }
        try {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.add("EXTRA_SUBPARTITION_VALUE");
            this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, INITIAL_DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when passing too many subpartition values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Exceeded maximum number of allowed subpartitions: %d.", 4), (Object)e.getMessage());
        }
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
        resultBusinessObjectDataVersions = this.businessObjectDataService.getBusinessObjectDataVersions(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INVALID_DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataVersions);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataVersions.getBusinessObjectDataVersions().size());
    }

    private void createTestDatabaseEntities(List<String> subPartitionValues) {
        for (int businessObjectFormatVersion = INITIAL_FORMAT_VERSION.intValue(); businessObjectFormatVersion < 2; ++businessObjectFormatVersion) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(businessObjectFormatVersion), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(businessObjectFormatVersion == SECOND_FORMAT_VERSION), PARTITION_KEY);
            for (int businessObjectDataVersion = INITIAL_DATA_VERSION.intValue(); businessObjectDataVersion < 3; ++businessObjectDataVersion) {
                this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(businessObjectFormatVersion), PARTITION_VALUE, subPartitionValues, Integer.valueOf(businessObjectDataVersion), Boolean.valueOf(businessObjectDataVersion == SECOND_DATA_VERSION), BDATA_STATUS);
            }
        }
    }
}

