/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataServiceRestoreBusinessObjectDataTest
extends AbstractServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreBusinessObjectData() throws Exception {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(S3_BUCKET_NAME + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        try {
            for (StorageFileEntity storageFileEntity : storageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFileEntity.getPath(), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), NO_S3_CLIENT);
            }
            BusinessObjectData businessObjectData = this.businessObjectDataService.restoreBusinessObjectData(businessObjectDataKey, EXPIRATION_IN_DAYS);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectData(businessObjectDataEntity.getId(), businessObjectDataKey, LATEST_VERSION_FLAG_SET, BDATA_STATUS, businessObjectData);
            Assert.assertEquals((Object)"RESTORING", (Object)storageUnitEntity.getStatus().getCode());
            for (StorageFileEntity storageFileEntity : storageUnitEntity.getStorageFiles()) {
                ObjectMetadata objectMetadata = this.s3Operations.getObjectMetadata(S3_BUCKET_NAME, storageFileEntity.getPath(), NO_S3_CLIENT);
                Assert.assertTrue((boolean)objectMetadata.getOngoingRestore());
            }
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreBusinessObjectDataAmazonServiceException() throws Exception {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(S3_BUCKET_NAME + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        String s3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(businessObjectDataKey, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_SUB_PARTITION_KEYS);
        this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, String.format("%s/%s", s3KeyPrefix, "mock_s3_file_name_service_exception"), Long.valueOf(1024L), ROW_COUNT);
        try {
            for (StorageFileEntity storageFileEntity : storageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFileEntity.getPath(), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), NO_S3_CLIENT);
            }
            try {
                this.businessObjectDataService.restoreBusinessObjectData(businessObjectDataKey, EXPIRATION_IN_DAYS);
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("Failed to initiate a restore request for \"%s/%s\" key in \"%s\" bucket. Reason: InternalError (Service: null; Status Code: 0; Error Code: InternalError; Request ID: null)", s3KeyPrefix, "mock_s3_file_name_service_exception", S3_BUCKET_NAME), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"ARCHIVED", (Object)storageUnitEntity.getStatus().getCode());
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreBusinessObjectDataNonGlacierStorageClass() throws Exception {
        S3FileTransferRequestParamsDto glacierS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(S3_BUCKET_NAME + "/" + TEST_S3_KEY_PREFIX + "/").build();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForInitiateRestoreTesting(businessObjectDataKey, AbstractServiceTest.STORAGE_NAME, AbstractServiceTest.S3_BUCKET_NAME, "ARCHIVED", Collections.singletonList("foo.dat"));
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        try {
            for (StorageFileEntity storageFileEntity : storageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Standard);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFileEntity.getPath(), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), NO_S3_CLIENT);
            }
            try {
                this.businessObjectDataService.restoreBusinessObjectData(businessObjectDataKey, EXPIRATION_IN_DAYS);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)String.format("S3 file \"%s\" is not archived (found %s storage class when expecting %s). S3 Bucket Name: \"%s\"", ((StorageFileEntity)Iterables.get((Iterable)storageUnitEntity.getStorageFiles(), (int)0)).getPath(), StorageClass.Standard.toString(), StorageClass.Glacier.toString(), S3_BUCKET_NAME), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"ARCHIVED", (Object)storageUnitEntity.getStatus().getCode());
        }
        finally {
            if (!this.s3Dao.listDirectory(glacierS3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(glacierS3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }
}

