/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumn;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnChangeEvent;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnKeys;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnSearchRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnSearchResponse;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.jpa.BusinessObjectDefinitionColumnEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.SchemaColumnEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDefinitionColumnServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDefinitionColumnServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateBusinessObjectDefinitionColumn() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        SchemaColumnEntity schemaColumnEntity = this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
        BusinessObjectDefinitionColumnEntity resultBusinessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoHelper.getBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, Boolean.valueOf(true));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, (List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnChangeEvent[]{new BusinessObjectDefinitionColumnChangeEvent(BDEF_COLUMN_DESCRIPTION, ((BusinessObjectDefinitionColumnChangeEvent)resultBusinessObjectDefinitionColumn.getBusinessObjectDefinitionColumnChangeEvents().get(0)).getEventTime(), resultBusinessObjectDefinitionColumnEntity.getCreatedBy())})), (Object)resultBusinessObjectDefinitionColumn);
        Assert.assertEquals((Object)resultBusinessObjectDefinitionColumn.getId(), (Object)schemaColumnEntity.getBusinessObjectDefinitionColumn().getId());
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnBusinessObjectDefinitionColumnAlreadyExists() {
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), BDEF_COLUMN_DESCRIPTION);
        for (String businessObjectDefinitionColumnName : Lists.newArrayList((Object[])new String[]{BDEF_COLUMN_NAME, BDEF_COLUMN_NAME.toUpperCase(), BDEF_COLUMN_NAME.toLowerCase()})) {
            try {
                this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, businessObjectDefinitionColumnName), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION_2));
                Assert.fail((String)"Should throw an AlreadyExistsException when business object definition column already exists.");
            }
            catch (AlreadyExistsException e) {
                Assert.assertEquals((Object)String.format("Unable to create business object definition column with name \"%s\" because it already exists for the business object definition {%s}.", businessObjectDefinitionColumnName, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnBusinessObjectDefinitionNoExists() {
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnInvalidParameters() {
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(BDEF_COLUMN_NAME)), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition column name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition column name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnLowerCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), BDEF_COLUMN_NAME.toLowerCase()), COLUMN_NAME.toLowerCase(), BDEF_COLUMN_DESCRIPTION.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME.toLowerCase()), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION.toLowerCase(), NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnMissingOptionalParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(businessObjectDefinitionColumnKey, COLUMN_NAME, NO_BDEF_COLUMN_DESCRIPTION));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, NO_BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey("      \t\t ", BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, "      \t\t ", BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t "), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition column name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition column name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), "      \t\t ", BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when schema column name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema column name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnSchemaColumnAlreadyLinked() {
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        for (String schemaColumnName : Lists.newArrayList((Object[])new String[]{COLUMN_NAME.toUpperCase(), COLUMN_NAME.toLowerCase()})) {
            try {
                this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), schemaColumnName, BDEF_COLUMN_DESCRIPTION_2));
                Assert.fail((String)"Should throw an AlreadyExistsException when a business object definition column already exists with this schema column name.");
            }
            catch (AlreadyExistsException e) {
                Assert.assertEquals((Object)String.format("Unable to create business object definition column because a business object definition column with schema column name \"%s\" already exists for the business object definition {%s}.", schemaColumnName, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnSchemaColumnNoExists() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when no matching schema column exists.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Unable to create business object definition column because there are no format schema columns with name \"%s\" for the business object definition {%s}.", COLUMN_NAME, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnSchemaColumnNoExistsForDescriptiveFormat() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        businessObjectDefinitionEntity.setDescriptiveBusinessObjectFormat(businessObjectFormatEntity);
        this.businessObjectDefinitionDao.saveAndRefresh((Object)businessObjectDefinitionEntity);
        try {
            this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when no matching schema column exists.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Unable to create business object definition column because there are no format schema columns with name \"%s\" in the descriptive business object format for the business object definition {%s}.", COLUMN_NAME, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnTrimParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(BDEF_COLUMN_NAME)), this.addWhitespace(COLUMN_NAME), this.addWhitespace(BDEF_COLUMN_DESCRIPTION)));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, this.addWhitespace(BDEF_COLUMN_DESCRIPTION), NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testCreateBusinessObjectDefinitionColumnUpperCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), BDEF_COLUMN_NAME.toUpperCase()), COLUMN_NAME.toUpperCase(), BDEF_COLUMN_DESCRIPTION.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME.toUpperCase()), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION.toUpperCase(), NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumn() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        Assert.assertNotNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
        BusinessObjectDefinitionColumn deletedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey);
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinitionColumn);
        Assert.assertNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumnBusinessObjectDefinitionColumnNoExists() {
        try {
            this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition column does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Column with name \"%s\" does not exist for business object definition {%s}.", BDEF_COLUMN_NAME, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumnLowerCaseParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        Assert.assertNotNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
        BusinessObjectDefinitionColumn deletedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), BDEF_COLUMN_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinitionColumn);
        Assert.assertNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumnMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey("      \t\t ", BDEF_NAME, BDEF_COLUMN_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, "      \t\t ", BDEF_COLUMN_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition column name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition column name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumnNoLinkedSchemaColumn() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        Assert.assertNotNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
        BusinessObjectDefinitionColumn deletedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey);
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(deletedBusinessObjectDefinitionColumn.getId(), businessObjectDefinitionColumnKey, NO_COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinitionColumn);
        Assert.assertNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumnTrimParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        Assert.assertNotNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
        BusinessObjectDefinitionColumn deletedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(BDEF_COLUMN_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinitionColumn);
        Assert.assertNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionColumnUpperCaseParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        Assert.assertNotNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
        BusinessObjectDefinitionColumn deletedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.deleteBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), BDEF_COLUMN_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinitionColumn);
        Assert.assertNull((Object)this.businessObjectDefinitionColumnDao.getBusinessObjectDefinitionColumnByKey(businessObjectDefinitionColumnKey));
    }

    @Test
    public void testGetBusinessObjectDefinitionColumn() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, Boolean.valueOf(false));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnWithChangeEvents() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
        BusinessObjectDefinitionColumnEntity resultBusinessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoHelper.getBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, Boolean.valueOf(true));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, (List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnChangeEvent[]{new BusinessObjectDefinitionColumnChangeEvent(BDEF_COLUMN_DESCRIPTION, ((BusinessObjectDefinitionColumnChangeEvent)resultBusinessObjectDefinitionColumn.getBusinessObjectDefinitionColumnChangeEvents().get(0)).getEventTime(), resultBusinessObjectDefinitionColumnEntity.getCreatedBy())})), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnWithChangeEventsWithUpdate() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME);
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        this.businessObjectDefinitionColumnService.createBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnCreateRequest(businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION));
        BusinessObjectDefinitionColumnEntity resultBusinessObjectDefinitionColumnEntityCreated = this.businessObjectDefinitionColumnDaoHelper.getBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey);
        this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, new BusinessObjectDefinitionColumnUpdateRequest(BDEF_COLUMN_DESCRIPTION_2));
        BusinessObjectDefinitionColumnEntity resultBusinessObjectDefinitionColumnEntityUpdated = this.businessObjectDefinitionColumnDaoHelper.getBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, Boolean.valueOf(true));
        ArrayList expectedBusinessObjectDefinitionColumnChangeEvents = Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnChangeEvent[]{new BusinessObjectDefinitionColumnChangeEvent(BDEF_COLUMN_DESCRIPTION_2, ((BusinessObjectDefinitionColumnChangeEvent)resultBusinessObjectDefinitionColumn.getBusinessObjectDefinitionColumnChangeEvents().get(0)).getEventTime(), resultBusinessObjectDefinitionColumnEntityUpdated.getCreatedBy()), new BusinessObjectDefinitionColumnChangeEvent(BDEF_COLUMN_DESCRIPTION, ((BusinessObjectDefinitionColumnChangeEvent)resultBusinessObjectDefinitionColumn.getBusinessObjectDefinitionColumnChangeEvents().get(1)).getEventTime(), resultBusinessObjectDefinitionColumnEntityCreated.getCreatedBy())});
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(resultBusinessObjectDefinitionColumn.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION_2, (List)expectedBusinessObjectDefinitionColumnChangeEvents), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnBusinessObjectDefinitionColumnNoExists() {
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition column does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Column with name \"%s\" does not exist for business object definition {%s}.", BDEF_COLUMN_NAME, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnLowerCaseParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), BDEF_COLUMN_NAME.toLowerCase()), Boolean.valueOf(false));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey("      \t\t ", BDEF_NAME, BDEF_COLUMN_NAME), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, "      \t\t ", BDEF_COLUMN_NAME), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t "), Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition column name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition column name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnTrimParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(BDEF_COLUMN_NAME)), Boolean.valueOf(false));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnUpperCaseParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), BDEF_COLUMN_NAME.toUpperCase()), Boolean.valueOf(false));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumns() {
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), DESCRIPTION_2);
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), DESCRIPTION);
        BusinessObjectDefinitionColumnKeys resultBusinessObjectDefinitionColumnKeys = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnKeys((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnKey[]{new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2)})), (Object)resultBusinessObjectDefinitionColumnKeys);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnsBusinessObjectDefinitionColumnsNoExist() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        Assert.assertEquals((long)0L, (long)this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME)).getBusinessObjectDefinitionColumnKeys().size());
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnsBusinessObjectDefinitionNoExists() {
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnsLowerCaseParameters() {
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), DESCRIPTION_2);
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), DESCRIPTION);
        BusinessObjectDefinitionColumnKeys resultBusinessObjectDefinitionColumnKeys = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnKeys((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnKey[]{new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2)})), (Object)resultBusinessObjectDefinitionColumnKeys);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnsMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnsTrimParameters() {
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), DESCRIPTION_2);
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), DESCRIPTION);
        BusinessObjectDefinitionColumnKeys resultBusinessObjectDefinitionColumnKeys = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnKeys((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnKey[]{new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2)})), (Object)resultBusinessObjectDefinitionColumnKeys);
    }

    @Test
    public void testGetBusinessObjectDefinitionColumnsUpperCaseParameters() {
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), DESCRIPTION_2);
        this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), DESCRIPTION);
        BusinessObjectDefinitionColumnKeys resultBusinessObjectDefinitionColumnKeys = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumns(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnKeys((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnKey[]{new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2)})), (Object)resultBusinessObjectDefinitionColumnKeys);
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumns() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionColumnSearchTesting();
        BusinessObjectDefinitionColumnSearchResponse businessObjectDefinitionColumnSearchResponse = this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD, "description"}));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), COLUMN_NAME_2, BDEF_COLUMN_DESCRIPTION_2, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)businessObjectDefinitionColumnSearchResponse);
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumnsInvalidParameters() {
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter(), new BusinessObjectDefinitionColumnSearchFilter()})), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition column search filter must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(), new BusinessObjectDefinitionColumnSearchKey()}))})), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition column search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{"INVALID_FIELD_OPTION"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Search response field \"invalid_field_option\" is not supported.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey("INVALID BDEF NAMESPACE", BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD, "description"}));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)("Business object definition with name \"" + BDEF_NAME + "\" doesn't exist for namespace \"INVALID BDEF NAMESPACE\"."), (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, "INVALID BDEF NAME")}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD, "description"}));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)("Business object definition with name \"INVALID BDEF NAME\" doesn't exist for namespace \"" + BDEF_NAMESPACE + "\"."), (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumnsLowerCaseParameters() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionColumnSearchTesting();
        BusinessObjectDefinitionColumnSearchResponse businessObjectDefinitionColumnSearchResponse = this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD.toLowerCase(), "description".toLowerCase()}));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), COLUMN_NAME_2, BDEF_COLUMN_DESCRIPTION_2, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)businessObjectDefinitionColumnSearchResponse);
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumnsMissingOptionalParameters() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionColumnSearchTesting();
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, null, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), COLUMN_NAME_2, null, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD})));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), null, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), null, BDEF_COLUMN_DESCRIPTION_2, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{"description"})));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), null, null, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), null, null, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet()));
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumnsMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(null, NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition column search request must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest(), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition column search filter must be specified.", (Object)e.getMessage());
        }
        try {
            ArrayList<Object> businessObjectDefinitionColumnSearchFilters = new ArrayList<Object>();
            businessObjectDefinitionColumnSearchFilters.add(null);
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest(businessObjectDefinitionColumnSearchFilters), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition column search filter must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter()})), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition column search key must be specified.", (Object)e.getMessage());
        }
        try {
            ArrayList<Object> businessObjectDefinitionColumnSearchKeys = new ArrayList<Object>();
            businessObjectDefinitionColumnSearchKeys.add(null);
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter(businessObjectDefinitionColumnSearchKeys)})), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition column search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(NO_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD, "description"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, NO_BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD, "description"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumnsTrimParameters() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionColumnSearchTesting();
        BusinessObjectDefinitionColumnSearchResponse businessObjectDefinitionColumnSearchResponse = this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME))}))})), (Set)Sets.newHashSet((Object[])new String[]{this.addWhitespace(BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD), this.addWhitespace("description")}));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), COLUMN_NAME_2, BDEF_COLUMN_DESCRIPTION_2, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)businessObjectDefinitionColumnSearchResponse);
    }

    @Test
    public void testSearchBusinessObjectDefinitionColumnsUpperCaseParameters() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionColumnSearchTesting();
        BusinessObjectDefinitionColumnSearchResponse businessObjectDefinitionColumnSearchResponse = this.businessObjectDefinitionColumnService.searchBusinessObjectDefinitionColumns(new BusinessObjectDefinitionColumnSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchFilter[]{new BusinessObjectDefinitionColumnSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumnSearchKey[]{new BusinessObjectDefinitionColumnSearchKey(BDEF_NAMESPACE, BDEF_NAME)}))})), (Set)Sets.newHashSet((Object[])new String[]{BusinessObjectDefinitionColumnServiceImpl.SCHEMA_COLUMN_NAME_FIELD.toUpperCase(), "description".toUpperCase()}));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumnSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionColumn[]{new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), COLUMN_NAME, BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), new BusinessObjectDefinitionColumn(NO_ID, new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), COLUMN_NAME_2, BDEF_COLUMN_DESCRIPTION_2, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS)})), (Object)businessObjectDefinitionColumnSearchResponse);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumn() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, new BusinessObjectDefinitionColumnUpdateRequest(BDEF_COLUMN_DESCRIPTION_2));
        BusinessObjectDefinitionColumn resultBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.getBusinessObjectDefinitionColumn(businessObjectDefinitionColumnKey, Boolean.valueOf(false));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION_2, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)resultBusinessObjectDefinitionColumn);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumnBusinessObjectDefinitionColumnNoExists() {
        try {
            this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnUpdateRequest(BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition column does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Column with name \"%s\" does not exist for business object definition {%s}.", BDEF_COLUMN_NAME, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumnLowerCaseParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn updatedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), BDEF_COLUMN_NAME.toLowerCase()), new BusinessObjectDefinitionColumnUpdateRequest(BDEF_COLUMN_DESCRIPTION_2.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION_2.toLowerCase(), NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinitionColumn);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumnMissingOptionalParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn updatedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnUpdateRequest(NO_BDEF_COLUMN_DESCRIPTION));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, NO_BDEF_COLUMN_DESCRIPTION, NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinitionColumn);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumnMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey("      \t\t ", BDEF_NAME, BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnUpdateRequest(NO_BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, "      \t\t ", BDEF_COLUMN_NAME), new BusinessObjectDefinitionColumnUpdateRequest(NO_BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t "), new BusinessObjectDefinitionColumnUpdateRequest(NO_BDEF_COLUMN_DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition column name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition column name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumnTrimParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn updatedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(BDEF_COLUMN_NAME)), new BusinessObjectDefinitionColumnUpdateRequest(this.addWhitespace(BDEF_COLUMN_DESCRIPTION_2)));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, this.addWhitespace(BDEF_COLUMN_DESCRIPTION_2), NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinitionColumn);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionColumnUpperCaseParameters() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(businessObjectDefinitionColumnKey, BDEF_COLUMN_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        BusinessObjectDefinitionColumn updatedBusinessObjectDefinitionColumn = this.businessObjectDefinitionColumnService.updateBusinessObjectDefinitionColumn(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), BDEF_COLUMN_NAME.toUpperCase()), new BusinessObjectDefinitionColumnUpdateRequest(BDEF_COLUMN_DESCRIPTION_2.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionColumn(businessObjectDefinitionColumnEntity.getId(), businessObjectDefinitionColumnKey, COLUMN_NAME, BDEF_COLUMN_DESCRIPTION_2.toUpperCase(), NO_BUSINESS_OBJECT_DEFINITION_COLUMN_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinitionColumn);
    }

    private void createDatabaseEntitiesForBusinessObjectDefinitionColumnSearchTesting() {
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME), BDEF_COLUMN_DESCRIPTION);
        BusinessObjectDefinitionColumnEntity businessObjectDefinitionColumnEntity2 = this.businessObjectDefinitionColumnDaoTestHelper.createBusinessObjectDefinitionColumnEntity(new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME_2), BDEF_COLUMN_DESCRIPTION_2);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME, businessObjectDefinitionColumnEntity);
        this.schemaColumnDaoTestHelper.createSchemaColumnEntity(businessObjectFormatEntity, COLUMN_NAME_2, businessObjectDefinitionColumnEntity2);
    }
}

