/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.BusinessObjectDefinitionDescriptionSuggestionDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestion;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionAcceptanceRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionSearchRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionSearchResponse;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.jpa.BusinessObjectDefinitionDescriptionSuggestionEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionDescriptionSuggestionStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.MessageNotificationEventService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDescriptionSuggestionDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.SearchIndexUpdateHelper;
import org.finra.herd.service.impl.BusinessObjectDefinitionDescriptionSuggestionServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDefinitionDescriptionSuggestionServiceTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionDaoHelper businessObjectDefinitionDaoHelper;
    @Mock
    private BusinessObjectDefinitionDescriptionSuggestionDao businessObjectDefinitionDescriptionSuggestionDao;
    @Mock
    private BusinessObjectDefinitionDescriptionSuggestionDaoHelper businessObjectDefinitionDescriptionSuggestionDaoHelper;
    @Mock
    private BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelper businessObjectDefinitionDescriptionSuggestionStatusDaoHelper;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private MessageNotificationEventService messageNotificationEventService;
    @Mock
    private SearchIndexUpdateHelper searchIndexUpdateHelper;
    @InjectMocks
    private BusinessObjectDefinitionDescriptionSuggestionServiceImpl businessObjectDefinitionDescriptionSuggestionService;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateBusinessObjectDefinitionDescriptionSuggestion() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionCreateRequest businessObjectDefinitionDescriptionSuggestionCreateRequest = new BusinessObjectDefinitionDescriptionSuggestionCreateRequest(businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(USER_ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(CREATED_ON.toGregorianCalendar().getTimeInMillis()));
        businessObjectDefinitionDescriptionSuggestionEntity.setUpdatedBy(UPDATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setUpdatedOn(new Timestamp(UPDATED_ON.toGregorianCalendar().getTimeInMillis()));
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", NAMESPACE)).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", BDEF_NAME)).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", USER_ID)).thenReturn((Object)USER_ID);
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn(null);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.saveAndRefresh(ArgumentMatchers.any(BusinessObjectDefinitionDescriptionSuggestionEntity.class))).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        BusinessObjectDefinitionDescriptionSuggestion result = this.businessObjectDefinitionDescriptionSuggestionService.createBusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionCreateRequest);
        Assert.assertEquals((Object)businessObjectDefinitionDescriptionSuggestion, (Object)result);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", NAMESPACE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", BDEF_NAME);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", USER_ID);
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name());
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).saveAndRefresh(ArgumentMatchers.any(BusinessObjectDefinitionDescriptionSuggestionEntity.class));
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processBusinessObjectDefinitionDescriptionSuggestionChangeNotificationEvent(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateBusinessObjectDefinitionDescriptionSuggestionWithBusinessObjectDefinitionDescriptionSuggestionAlreadyExists() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionCreateRequest request = new BusinessObjectDefinitionDescriptionSuggestionCreateRequest(businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.createBusinessObjectDefinitionDescriptionSuggestion(request);
            TestCase.fail();
        }
        catch (AlreadyExistsException alreadyExistsException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)alreadyExistsException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)String.format("A business object definition description suggestion already exists with the parameters {namespace=\"%s\", businessObjectDefinitionName=\"%s\", userId=\"%s\"}.", businessObjectDefinitionDescriptionSuggestionKey.getNamespace(), businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName(), businessObjectDefinitionDescriptionSuggestionKey.getUserId()))));
        }
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateBusinessObjectDefinitionDescriptionSuggestionWithNullRequest() {
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.createBusinessObjectDefinitionDescriptionSuggestion(null);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion create request must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateBusinessObjectDefinitionDescriptionSuggestionWithNullKey() {
        BusinessObjectDefinitionDescriptionSuggestionCreateRequest request = new BusinessObjectDefinitionDescriptionSuggestionCreateRequest(null, null);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.createBusinessObjectDefinitionDescriptionSuggestion(request);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion key must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateBusinessObjectDefinitionDescriptionSuggestionWithNullDescriptionSuggestion() {
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionCreateRequest request = new BusinessObjectDefinitionDescriptionSuggestionCreateRequest(businessObjectDefinitionDescriptionSuggestionKey, null);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.createBusinessObjectDefinitionDescriptionSuggestion(request);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion must be specified.")));
        }
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteBusinessObjectDefinitionDescriptionSuggestion() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(BusinessObjectDefinitionDescriptionSuggestionServiceTest.getRandomDate().getTime()));
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionEntity.getId().intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, businessObjectDefinitionDescriptionSuggestionEntity.getStatus().getCode(), businessObjectDefinitionDescriptionSuggestionEntity.getCreatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionDescriptionSuggestionEntity.getCreatedOn()));
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        BusinessObjectDefinitionDescriptionSuggestion result = this.businessObjectDefinitionDescriptionSuggestionService.deleteBusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionKey);
        Assert.assertThat((String)"Result does not equal businessObjectDefinitionDescriptionSuggestionEntity.", (Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestion)));
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).delete((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteBusinessObjectDefinitionDescriptionSuggestionWithNullKey() {
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.deleteBusinessObjectDefinitionDescriptionSuggestion(null);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion key must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionByKey() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(BusinessObjectDefinitionDescriptionSuggestionServiceTest.getRandomDate().getTime()));
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionEntity.getId().intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, businessObjectDefinitionDescriptionSuggestionEntity.getStatus().getCode(), businessObjectDefinitionDescriptionSuggestionEntity.getCreatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionDescriptionSuggestionEntity.getCreatedOn()));
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        BusinessObjectDefinitionDescriptionSuggestion result = this.businessObjectDefinitionDescriptionSuggestionService.getBusinessObjectDefinitionDescriptionSuggestionByKey(businessObjectDefinitionDescriptionSuggestionKey);
        Assert.assertThat((String)"Result does not equal businessObjectDefinitionDescriptionSuggestionEntity.", (Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestion)));
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionWithNullKey() {
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.getBusinessObjectDefinitionDescriptionSuggestionByKey(null);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion key must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestions() {
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey2 = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE_2, BDEF_NAME_2, USER_ID_2);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        ArrayList businessObjectDefinitionDescriptionSuggestionKeyList = Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionKey[]{businessObjectDefinitionDescriptionSuggestionKey, businessObjectDefinitionDescriptionSuggestionKey2});
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinition(businessObjectDefinitionEntity)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKeyList);
        List results = this.businessObjectDefinitionDescriptionSuggestionService.getBusinessObjectDefinitionDescriptionSuggestions(businessObjectDefinitionKey).getBusinessObjectDefinitionDescriptionSuggestionKeys();
        for (int i = 0; i < results.size(); ++i) {
            Assert.assertEquals((Object)((BusinessObjectDefinitionDescriptionSuggestionKey)businessObjectDefinitionDescriptionSuggestionKeyList.get(i)).getNamespace(), (Object)((BusinessObjectDefinitionDescriptionSuggestionKey)results.get(i)).getNamespace());
            Assert.assertEquals((Object)((BusinessObjectDefinitionDescriptionSuggestionKey)businessObjectDefinitionDescriptionSuggestionKeyList.get(i)).getBusinessObjectDefinitionName(), (Object)((BusinessObjectDefinitionDescriptionSuggestionKey)results.get(i)).getBusinessObjectDefinitionName());
            Assert.assertEquals((Object)((BusinessObjectDefinitionDescriptionSuggestionKey)businessObjectDefinitionDescriptionSuggestionKeyList.get(i)).getUserId(), (Object)((BusinessObjectDefinitionDescriptionSuggestionKey)results.get(i)).getUserId());
        }
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).validateBusinessObjectDefinitionKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinition(businessObjectDefinitionEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testSearchBusinessObjectDefinitionDescriptionSuggestions() {
        HashSet<String> fields = new HashSet<String>();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_BY_USER_ID_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_ON_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.DESCRIPTION_SUGGESTION_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.STATUS_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_ON_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.DESCRIPTION_SUGGESTION_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.STATUS_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.DESCRIPTION_SUGGESTION_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.STATUS_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.STATUS_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_BY_USER_ID_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_BY_USER_ID_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_ON_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
        fields = new HashSet();
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_BY_USER_ID_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_ON_FIELD);
        fields.add(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.DESCRIPTION_SUGGESTION_FIELD);
        this.testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(fields);
    }

    private void testSearchBusinessObjectDefinitionDescriptionSuggestionsWithDifferentFields(Set<String> fields) {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Date createdOn = BusinessObjectDefinitionDescriptionSuggestionServiceTest.getRandomDate();
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(createdOn.getTime()));
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion();
        businessObjectDefinitionDescriptionSuggestion.setId(businessObjectDefinitionDescriptionSuggestionEntity.getId().intValue());
        businessObjectDefinitionDescriptionSuggestion.setBusinessObjectDefinitionDescriptionSuggestionKey(businessObjectDefinitionDescriptionSuggestionKey);
        if (fields.contains(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_BY_USER_ID_FIELD)) {
            businessObjectDefinitionDescriptionSuggestion.setCreatedByUserId(CREATED_BY);
        }
        if (fields.contains(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.CREATED_ON_FIELD)) {
            businessObjectDefinitionDescriptionSuggestion.setCreatedOn(HerdDateUtils.getXMLGregorianCalendarValue((Date)createdOn));
        }
        if (fields.contains(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.DESCRIPTION_SUGGESTION_FIELD)) {
            businessObjectDefinitionDescriptionSuggestion.setDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionEntity.getDescriptionSuggestion());
        }
        if (fields.contains(BusinessObjectDefinitionDescriptionSuggestionServiceImpl.STATUS_FIELD)) {
            businessObjectDefinitionDescriptionSuggestion.setStatus(businessObjectDefinitionDescriptionSuggestionEntity.getStatus().getCode());
        }
        BusinessObjectDefinitionDescriptionSuggestionSearchKey businessObjectDefinitionDescriptionSuggestionSearchKey = new BusinessObjectDefinitionDescriptionSuggestionSearchKey(NAMESPACE, BDEF_NAME, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionSearchFilter businessObjectDefinitionDescriptionSuggestionSearchFilter = new BusinessObjectDefinitionDescriptionSuggestionSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchKey[]{businessObjectDefinitionDescriptionSuggestionSearchKey}));
        BusinessObjectDefinitionDescriptionSuggestionSearchRequest request = new BusinessObjectDefinitionDescriptionSuggestionSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchFilter[]{businessObjectDefinitionDescriptionSuggestionSearchFilter}));
        BusinessObjectDefinitionDescriptionSuggestionSearchResponse businessObjectDefinitionDescriptionSuggestionSearchResponse = new BusinessObjectDefinitionDescriptionSuggestionSearchResponse((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestion[]{businessObjectDefinitionDescriptionSuggestion}));
        ArrayList businessObjectDefinitionDescriptionSuggestionEntities = Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionEntity[]{businessObjectDefinitionDescriptionSuggestionEntity});
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, BDEF_DESCRIPTION_SUGGESTION_STATUS)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntities);
        BusinessObjectDefinitionDescriptionSuggestionSearchResponse result = this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(request, fields);
        Assert.assertThat((String)"Result does not equal businessObjectDefinitionDescriptionSuggestionSearchResponse.", (Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionSearchResponse)));
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        ((BusinessObjectDefinitionDescriptionSuggestionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        this.verifyNoMoreInteractionsHelper();
        Mockito.reset((Object[])new AlternateKeyHelper[]{this.alternateKeyHelper});
        Mockito.reset((Object[])new BusinessObjectDefinitionDescriptionSuggestionDaoHelper[]{this.businessObjectDefinitionDescriptionSuggestionDaoHelper});
    }

    @Test
    public void testSearchBusinessObjectDefinitionDescriptionSuggestionsWithBogusField() {
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionSearchKey businessObjectDefinitionDescriptionSuggestionSearchKey = new BusinessObjectDefinitionDescriptionSuggestionSearchKey(NAMESPACE, BDEF_NAME, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionSearchFilter businessObjectDefinitionDescriptionSuggestionSearchFilter = new BusinessObjectDefinitionDescriptionSuggestionSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchKey[]{businessObjectDefinitionDescriptionSuggestionSearchKey}));
        BusinessObjectDefinitionDescriptionSuggestionSearchRequest request = new BusinessObjectDefinitionDescriptionSuggestionSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchFilter[]{businessObjectDefinitionDescriptionSuggestionSearchFilter}));
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        HashSet<String> fields = new HashSet<String>();
        fields.add(BOGUS_SEARCH_FIELD);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(request, fields);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)String.format("Search response field \"%s\" is not supported.", BOGUS_SEARCH_FIELD))));
        }
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testSearchBusinessObjectDefinitionDescriptionSuggestionsWithNullSearchRequest() {
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(null, new HashSet());
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion search request must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testSearchBusinessObjectDefinitionDescriptionSuggestionsWithWrongNumberOfSearchFilters() {
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(new BusinessObjectDefinitionDescriptionSuggestionSearchRequest((List)Lists.newArrayList()), new HashSet());
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Exactly one business object definition description suggestion search filter must be specified.")));
        }
        BusinessObjectDefinitionDescriptionSuggestionSearchFilter businessObjectDefinitionDescriptionSuggestionSearchFilter1 = new BusinessObjectDefinitionDescriptionSuggestionSearchFilter((List)Lists.newArrayList());
        BusinessObjectDefinitionDescriptionSuggestionSearchFilter businessObjectDefinitionDescriptionSuggestionSearchFilter2 = new BusinessObjectDefinitionDescriptionSuggestionSearchFilter((List)Lists.newArrayList());
        BusinessObjectDefinitionDescriptionSuggestionSearchRequest request = new BusinessObjectDefinitionDescriptionSuggestionSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchFilter[]{businessObjectDefinitionDescriptionSuggestionSearchFilter1, businessObjectDefinitionDescriptionSuggestionSearchFilter2}));
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(request, new HashSet());
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Exactly one business object definition description suggestion search filter must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testSearchBusinessObjectDefinitionDescriptionSuggestionsWithZeroSearchKeys() {
        BusinessObjectDefinitionDescriptionSuggestionSearchFilter businessObjectDefinitionDescriptionSuggestionSearchFilter = new BusinessObjectDefinitionDescriptionSuggestionSearchFilter((List)Lists.newArrayList());
        BusinessObjectDefinitionDescriptionSuggestionSearchRequest request = new BusinessObjectDefinitionDescriptionSuggestionSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchFilter[]{businessObjectDefinitionDescriptionSuggestionSearchFilter}));
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(request, new HashSet());
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Exactly one business object definition description suggestion search key must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testSearchBusinessObjectDefinitionDescriptionSuggestionsWithTwoSearchKeys() {
        BusinessObjectDefinitionDescriptionSuggestionSearchKey businessObjectDefinitionDescriptionSuggestionSearchKey1 = new BusinessObjectDefinitionDescriptionSuggestionSearchKey(NAMESPACE, BDEF_NAME, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionSearchKey businessObjectDefinitionDescriptionSuggestionSearchKey2 = new BusinessObjectDefinitionDescriptionSuggestionSearchKey(NAMESPACE_2, BDEF_NAME_2, BDEF_DESCRIPTION_SUGGESTION_STATUS_2);
        BusinessObjectDefinitionDescriptionSuggestionSearchFilter businessObjectDefinitionDescriptionSuggestionSearchFilter = new BusinessObjectDefinitionDescriptionSuggestionSearchFilter((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchKey[]{businessObjectDefinitionDescriptionSuggestionSearchKey1, businessObjectDefinitionDescriptionSuggestionSearchKey2}));
        BusinessObjectDefinitionDescriptionSuggestionSearchRequest request = new BusinessObjectDefinitionDescriptionSuggestionSearchRequest((List)Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionSearchFilter[]{businessObjectDefinitionDescriptionSuggestionSearchFilter}));
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.searchBusinessObjectDefinitionDescriptionSuggestions(request, new HashSet());
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Exactly one business object definition description suggestion search key must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptionSuggestion() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionUpdateRequest businessObjectDefinitionDescriptionSuggestionUpdateRequest = new BusinessObjectDefinitionDescriptionSuggestionUpdateRequest(DESCRIPTION_SUGGESTION_2);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(USER_ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(CREATED_ON.toGregorianCalendar().getTimeInMillis()));
        businessObjectDefinitionDescriptionSuggestionEntity.setUpdatedBy(UPDATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setUpdatedOn(new Timestamp(UPDATED_ON.toGregorianCalendar().getTimeInMillis()));
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION_2, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", NAMESPACE)).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", BDEF_NAME)).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", USER_ID)).thenReturn((Object)USER_ID);
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, USER_ID)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        BusinessObjectDefinitionDescriptionSuggestion result = this.businessObjectDefinitionDescriptionSuggestionService.updateBusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionKey, businessObjectDefinitionDescriptionSuggestionUpdateRequest);
        Assert.assertEquals((Object)businessObjectDefinitionDescriptionSuggestion, (Object)result);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", NAMESPACE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", BDEF_NAME);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", USER_ID);
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).saveAndRefresh((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processBusinessObjectDefinitionDescriptionSuggestionChangeNotificationEvent(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptionSuggestionWithNullRequest() {
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.updateBusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionKey, null);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion update request must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptionSuggestionWithNullKey() {
        BusinessObjectDefinitionDescriptionSuggestionUpdateRequest request = new BusinessObjectDefinitionDescriptionSuggestionUpdateRequest(DESCRIPTION_SUGGESTION);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.updateBusinessObjectDefinitionDescriptionSuggestion(null, request);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion key must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptionSuggestionWithNullDescriptionSuggestion() {
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestionUpdateRequest request = new BusinessObjectDefinitionDescriptionSuggestionUpdateRequest(null);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.updateBusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionKey, request);
            TestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion must be specified.")));
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testAcceptBusinessObjectDefinitionDescriptionSuggestion() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(BusinessObjectDefinitionDescriptionSuggestionServiceTest.getRandomDate().getTime()));
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.ACCEPTED.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity acceptedBusinessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        acceptedBusinessObjectDefinitionDescriptionSuggestionEntity.setStatus(acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity);
        BusinessObjectDefinitionDescriptionSuggestion acceptedBusinessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(businessObjectDefinitionDescriptionSuggestionEntity.getId().intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.ACCEPTED.name(), businessObjectDefinitionDescriptionSuggestionEntity.getCreatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionDescriptionSuggestionEntity.getCreatedOn()));
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(ArgumentMatchers.anyString())).thenReturn((Object)acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.saveAndRefresh(ArgumentMatchers.any(BusinessObjectDefinitionDescriptionSuggestionEntity.class))).thenReturn((Object)acceptedBusinessObjectDefinitionDescriptionSuggestionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDao.saveAndRefresh((Object)businessObjectDefinitionEntity)).thenReturn((Object)businessObjectDefinitionEntity);
        BusinessObjectDefinitionDescriptionSuggestionAcceptanceRequest request = new BusinessObjectDefinitionDescriptionSuggestionAcceptanceRequest(businessObjectDefinitionDescriptionSuggestionKey);
        BusinessObjectDefinitionDescriptionSuggestion response = this.businessObjectDefinitionDescriptionSuggestionService.acceptBusinessObjectDefinitionDescriptionSuggestion(request);
        Assert.assertThat((String)"Response does not equal to expected businessObjectDefinitionDescriptionSuggestionEntity.", (Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)acceptedBusinessObjectDefinitionDescriptionSuggestion)));
        Assert.assertThat((String)"Expected business object definition entity description to be equal to response description.", (Object)response.getDescriptionSuggestion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionEntity.getDescription())));
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.ACCEPTED.name());
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).saveAndRefresh((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        ((BusinessObjectDefinitionDescriptionSuggestionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper)).getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).saveBusinessObjectDefinitionChangeEvents(businessObjectDefinitionEntity);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).saveAndRefresh((Object)businessObjectDefinitionEntity);
        ((SearchIndexUpdateHelper)Mockito.verify((Object)this.searchIndexUpdateHelper)).modifyBusinessObjectDefinitionInSearchIndex(businessObjectDefinitionEntity, "UPDATE");
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testAcceptBusinessObjectDefinitionDescriptionSuggestionWithNullRequest() {
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.acceptBusinessObjectDefinitionDescriptionSuggestion(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion acceptance request must be specified.")));
        }
    }

    @Test
    public void testAcceptBusinessObjectDefinitionDescriptionSuggestionWithSuggestionStatusNotPendingStatus() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(NAMESPACE, BDEF_NAME, USER_ID);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        businessObjectDefinitionEntity.setName(businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName());
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.ACCEPTED.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setId(ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedBy(CREATED_BY);
        businessObjectDefinitionDescriptionSuggestionEntity.setCreatedOn(new Timestamp(BusinessObjectDefinitionDescriptionSuggestionServiceTest.getRandomDate().getTime()));
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.ACCEPTED.name());
        BusinessObjectDefinitionDescriptionSuggestionEntity acceptedBusinessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        acceptedBusinessObjectDefinitionDescriptionSuggestionEntity.setStatus(acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", businessObjectDefinitionDescriptionSuggestionKey.getNamespace())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", businessObjectDefinitionDescriptionSuggestionKey.getBusinessObjectDefinitionName())).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionKey.getUserId());
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionKey.getUserId())).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(ArgumentMatchers.anyString())).thenReturn((Object)acceptedBusinessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.saveAndRefresh(ArgumentMatchers.any(BusinessObjectDefinitionDescriptionSuggestionEntity.class))).thenReturn((Object)acceptedBusinessObjectDefinitionDescriptionSuggestionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDao.saveAndRefresh((Object)businessObjectDefinitionEntity)).thenReturn((Object)businessObjectDefinitionEntity);
        BusinessObjectDefinitionDescriptionSuggestionAcceptanceRequest request = new BusinessObjectDefinitionDescriptionSuggestionAcceptanceRequest(businessObjectDefinitionDescriptionSuggestionKey);
        try {
            this.businessObjectDefinitionDescriptionSuggestionService.acceptBusinessObjectDefinitionDescriptionSuggestion(request);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"A business object definition description suggestion status is expected to be \"PENDING\" but was \"ACCEPTED\".")));
        }
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionDaoHelper, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionDaoHelper, this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper, this.businessObjectDefinitionHelper, this.messageNotificationEventService, this.searchIndexUpdateHelper});
    }
}

