/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.dao.helper.TagDaoHelper;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.SearchIndexUpdateDto;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.functional.QuadConsumer;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.ConfigurationDaoHelper;
import org.finra.herd.service.helper.TagHelper;
import org.finra.herd.service.impl.BusinessObjectDefinitionServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class BusinessObjectDefinitionServiceIndexTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @InjectMocks
    private BusinessObjectDefinitionServiceImpl businessObjectDefinitionService;
    @Mock
    private ConfigurationDaoHelper configurationDaoHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private IndexFunctionsDao indexFunctionsDao;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private TagDaoHelper tagDaoHelper;
    @Mock
    private TagHelper tagHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testIndexValidateBusinessObjectDefinitions() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList<String> businessObjectDefinitionEntityIdList = new ArrayList<String>();
        businessObjectDefinitionEntityIdList.add("123456");
        businessObjectDefinitionEntityIdList.add("654321");
        businessObjectDefinitionEntityIdList.add("789012");
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitions()).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.indexFunctionsDao.getIdsInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn(businessObjectDefinitionEntityIdList);
        Future future = this.businessObjectDefinitionService.indexValidateAllBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index all business object definitions method returned null value.", (Object)future, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"Business object definition service index all business object definitions method return value is not instance of future.", (Object)future, (Matcher)CoreMatchers.instanceOf(Future.class));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitions();
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getIdsInIndex((String)Matchers.any(), (String)Matchers.any());
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).executeFunctionForBusinessObjectDefinitionEntities((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (List)Matchers.eq(businessObjectDefinitionEntityList), (QuadConsumer)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)businessObjectDefinitionEntityIdList.size()))).deleteDocumentById((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSizeCheckValidationBusinessObjectDefinitions() {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)100L);
        Mockito.when((Object)this.businessObjectDefinitionDao.getCountOfAllBusinessObjectDefinitions()).thenReturn((Object)100L);
        boolean isIndexSizeValid = this.businessObjectDefinitionService.indexSizeCheckValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index size validation is false when it should have been true.", (Object)isIndexSizeValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getCountOfAllBusinessObjectDefinitions();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSizeCheckValidationBusinessObjectDefinitionsFalse() {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)100L);
        Mockito.when((Object)this.businessObjectDefinitionDao.getCountOfAllBusinessObjectDefinitions()).thenReturn((Object)200L);
        boolean isIndexSizeValid = this.businessObjectDefinitionService.indexSizeCheckValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index size validation is true when it should have been false.", (Object)isIndexSizeValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getCountOfAllBusinessObjectDefinitions();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckPercentageValidationBusinessObjectDefinitions() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.05);
        Mockito.when((Object)this.businessObjectDefinitionDao.getPercentageOfAllBusinessObjectDefinitions(0.05)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check random validation is false when it should have been true.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getPercentageOfAllBusinessObjectDefinitions(0.05);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckPercentageValidationBusinessObjectDefinitionsFalse() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.05);
        Mockito.when((Object)this.businessObjectDefinitionDao.getPercentageOfAllBusinessObjectDefinitions(0.05)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check random validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getPercentageOfAllBusinessObjectDefinitions(0.05);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckPercentageValidationBusinessObjectDefinitionsObjectMappingException() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.05);
        Mockito.when((Object)this.businessObjectDefinitionDao.getPercentageOfAllBusinessObjectDefinitions(0.05)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check random validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getPercentageOfAllBusinessObjectDefinitions(0.05);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationBusinessObjectDefinitions() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)100);
        Mockito.when((Object)this.businessObjectDefinitionDao.getMostRecentBusinessObjectDefinitions(100)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check most recent validation is false when it should have been true.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getMostRecentBusinessObjectDefinitions(100);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationBusinessObjectDefinitionsFalse() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)100);
        Mockito.when((Object)this.businessObjectDefinitionDao.getMostRecentBusinessObjectDefinitions(100)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check most recent validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getMostRecentBusinessObjectDefinitions(100);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationBusinessObjectDefinitionsObjectMappingException() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)100);
        Mockito.when((Object)this.businessObjectDefinitionDao.getMostRecentBusinessObjectDefinitions(100)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check most recent validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getMostRecentBusinessObjectDefinitions(100);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionCreate() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "CREATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).createIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionCreateEmpty() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "CREATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)"");
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).createIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUpdate() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).updateIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUpdateEmpty() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)"");
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).updateIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUpdateIdListSizeGreaterThanChunkSize() throws Exception {
        List<List> businessObjectDefinitionEntities = Arrays.asList(Collections.singletonList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes())), Collections.singletonList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2())));
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.addAll(Collections.nCopies(101, ID));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(0, 100))).thenReturn((Object)businessObjectDefinitionEntities.get(0));
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(100, businessObjectDefinitionIds.size()))).thenReturn((Object)businessObjectDefinitionEntities.get(1));
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(0).get(0))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(1).get(0))).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE"));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(0, 100));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(100, businessObjectDefinitionIds.size()));
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(0).get(0));
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(1).get(0));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).updateIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionDelete() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "DELETE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).deleteIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUnknown() {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UNKNOWN");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionsDao, this.jsonHelper, this.tagDaoHelper, this.tagHelper});
    }
}

