/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionChangeEvent;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptiveInformationUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKeys;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSearchRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSearchResponse;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionUpdateRequest;
import org.finra.herd.model.api.xml.DescriptiveBusinessObjectFormat;
import org.finra.herd.model.api.xml.DescriptiveBusinessObjectFormatUpdateRequest;
import org.finra.herd.model.api.xml.SampleDataFile;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.dto.BusinessObjectDefinitionSampleFileUpdateDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.SearchIndexUpdateDto;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionSampleDataFileEntity;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.model.jpa.TagTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDefinitionService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDefinitionServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDefinitionServiceImpl")
    private BusinessObjectDefinitionService businessObjectDefinitionServiceImpl;

    @Test
    public void testCreateBusinessObjectDefinition() throws Exception {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
        resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        ArrayList<BusinessObjectDefinitionChangeEvent> businessObjectDefinitionChangeEvents = new ArrayList<BusinessObjectDefinitionChangeEvent>();
        businessObjectDefinitionChangeEvents.add(new BusinessObjectDefinitionChangeEvent(BDEF_DISPLAY_NAME, BDEF_DESCRIPTION, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST, ((BusinessObjectDefinitionChangeEvent)resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents().get(0)).getEventTime(), ((BusinessObjectDefinitionChangeEvent)resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents().get(0)).getUserId()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), businessObjectDefinitionChangeEvents), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest("      \t\t ", BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, "      \t\t ", DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("      \t\t ", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionMissingOptionalParametersPassedAsWhitespace() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, "      \t\t ", "      \t\t ", Arrays.asList(new Attribute("Attribute Name 1", "      \t\t "))));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, "      \t\t ", NO_BDEF_SHORT_DESCRIPTION, "", Arrays.asList(new Attribute("Attribute Name 1", "      \t\t ")), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionMissingOptionalParametersPassedAsNulls() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, Arrays.asList(new Attribute("Attribute Name 1", null))));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, null, Arrays.asList(new Attribute("Attribute Name 1", null)), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
        resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, null, null, null, Arrays.asList(new Attribute("Attribute Name 1", null)), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionNoAttributes() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, NO_BDEF_DESCRIPTION, NO_BDEF_DISPLAY_NAME, NO_ATTRIBUTES));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, NO_BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, NO_BDEF_DISPLAY_NAME, NO_ATTRIBUTES, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionTrimParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(DATA_PROVIDER_NAME), this.addWhitespace(BDEF_DESCRIPTION), this.addWhitespace(BDEF_DISPLAY_NAME), Arrays.asList(new Attribute(this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1")))));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, this.addWhitespace(BDEF_DESCRIPTION), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("Attribute Name 1", this.addWhitespace("Attribute Value 1"))), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionUpperCaseParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(NAMESPACE.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase()))));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toUpperCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionLowerCaseParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(NAMESPACE.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase()))));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toLowerCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectDefinitionInvalidParameters() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", request.getNamespace()), (Object)e.getMessage());
        }
        request = new BusinessObjectDefinitionCreateRequest(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new BusinessObjectDefinitionCreateRequest(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing data provider name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", request.getDataProviderName()), (Object)e.getMessage());
        }
        request = new BusinessObjectDefinitionCreateRequest(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name contains a forward slash character");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Data provider name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionDuplicateAttributes() {
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionAlreadyExists() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        try {
            this.businessObjectDefinitionService.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES));
            Assert.fail((String)"Should throw an AlreadyExistsException when business object definition already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create business object definition with name \"%s\" because it already exists for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionDuplicateNamesWithDifferentNamespaces() throws Exception {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(NAMESPACE_2, DATA_PROVIDER_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE_2, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        Assert.assertEquals((Object)new BusinessObjectDefinition(resultBusinessObjectDefinition.getId(), NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinition() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        ArrayList<BusinessObjectDefinitionChangeEvent> businessObjectDefinitionChangeEvents = new ArrayList<BusinessObjectDefinitionChangeEvent>();
        businessObjectDefinitionChangeEvents.add(new BusinessObjectDefinitionChangeEvent(BDEF_DISPLAY_NAME_2, BDEF_DESCRIPTION_2, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST, ((BusinessObjectDefinitionChangeEvent)resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents().get(0)).getEventTime(), ((BusinessObjectDefinitionChangeEvent)resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents().get(0)).getUserId()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), businessObjectDefinitionChangeEvents), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, Arrays.asList(new Attribute("      \t\t ", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)), new BusinessObjectDefinitionUpdateRequest(this.addWhitespace(BDEF_DESCRIPTION_2), this.addWhitespace(BDEF_DISPLAY_NAME_2), Arrays.asList(new Attribute(this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1")))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, this.addWhitespace(BDEF_DESCRIPTION_2), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, Arrays.asList(new Attribute("Attribute Name 1", this.addWhitespace("Attribute Value 1"))), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())));
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2.toUpperCase(), BDEF_DISPLAY_NAME_2.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION_2.toUpperCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toUpperCase())), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())));
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2.toLowerCase(), BDEF_DISPLAY_NAME_2.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase()))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION_2.toLowerCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toLowerCase())), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDuplicateAttributes() {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionNoOriginalAttributes() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDuplicateOriginalAttributes() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1"), new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1 Updated")));
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2()));
            Assert.fail((String)"Should throw an IllegalStateException when business object definition contains duplicate attributes.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found duplicate attribute with name \"%s\" for business object definition {namespace: \"%s\", businessObjectDefinitionName: \"%s\"}.", "Attribute Name 1".toLowerCase(), NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformation() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE)));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue()), NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        ArrayList<BusinessObjectDefinitionChangeEvent> businessObjectDefinitionChangeEvents = new ArrayList<BusinessObjectDefinitionChangeEvent>();
        businessObjectDefinitionChangeEvents.add(new BusinessObjectDefinitionChangeEvent(BDEF_DISPLAY_NAME_2, BDEF_DESCRIPTION_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE), ((BusinessObjectDefinitionChangeEvent)resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents().get(0)).getEventTime(), ((BusinessObjectDefinitionChangeEvent)resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents().get(0)).getUserId()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue()), NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), businessObjectDefinitionChangeEvents), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, "      \t\t "), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, new DescriptiveBusinessObjectFormatUpdateRequest("      \t\t ", FORMAT_FILE_TYPE_CODE)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE, "      \t\t ")));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationOptionalParametersPassedAsWhitespace() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest("      \t\t ", "      \t\t ", NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, "      \t\t ", NO_BDEF_SHORT_DESCRIPTION, "      \t\t ".trim(), NO_ATTRIBUTES, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationOptionalParametersPassedAsNulls() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(NO_BDEF_DESCRIPTION, NO_BDEF_DISPLAY_NAME, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, NO_BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, NO_BDEF_DISPLAY_NAME, NO_ATTRIBUTES, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME)), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(this.addWhitespace(BDEF_DESCRIPTION_2), this.addWhitespace(BDEF_DISPLAY_NAME_2), new DescriptiveBusinessObjectFormatUpdateRequest(this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE))));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, this.addWhitespace(BDEF_DESCRIPTION_2), null, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue()), NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase())));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, null, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue()), NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase())));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue()), NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DESCRIPTION_2, NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT_UPDATE_REQUEST));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, BDEF_NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationDescriptiveBusinessObjectFormatNoExists() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        try {
            this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DESCRIPTION_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionDescriptiveInformationWithDescriptiveFormatHavingMultipleVersions() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE)));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION.intValue()), NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinition() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles(), businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testBusinessObjectDefinitionNoHtmlInShortDescription() {
        block0: {
            this.setUpTestEntitiesForSearchTesting();
            BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE_4), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"shortDescription"}));
            HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
            Assert.assertEquals((long)1L, (long)actualBusinessObjectDefinitions.size());
            Iterator iterator = actualBusinessObjectDefinitions.iterator();
            if (!iterator.hasNext()) break block0;
            BusinessObjectDefinition actualBdef = (BusinessObjectDefinition)iterator.next();
            Assert.assertEquals((Object)"Test Description. Value should be <30> value should be <40>", (Object)actualBdef.getShortDescription());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionNoSampleDataFiles() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_SAMPLE_DATA_FILES);
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionValidateSampleDataFilesOrder() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), Arrays.asList(new SampleDataFile(DIRECTORY_PATH_2, FILE_NAME_2), new SampleDataFile(DIRECTORY_PATH, FILE_NAME_2), new SampleDataFile(DIRECTORY_PATH, FILE_NAME)));
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, Arrays.asList(new SampleDataFile(DIRECTORY_PATH, FILE_NAME), new SampleDataFile(DIRECTORY_PATH, FILE_NAME_2), new SampleDataFile(DIRECTORY_PATH_2, FILE_NAME_2)), businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testGetBusinessObjectDefinitionNewTransaction() throws Exception {
        try {
            this.businessObjectDefinitionServiceImpl.createBusinessObjectDefinition(new BusinessObjectDefinitionCreateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionServiceImpl.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionServiceImpl.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinition(new BusinessObjectDefinitionKey(), new BusinessObjectDefinitionUpdateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        this.businessObjectDefinitionServiceImpl.updateSearchIndexDocumentBusinessObjectDefinition(new SearchIndexUpdateDto("BDEF", new ArrayList(), "CREATE"));
    }

    @Test
    public void testGetBusinessObjectDefinitions() throws Exception {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(NAMESPACE);
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeysForNamespace(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsNoParameters() throws Exception {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions();
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeys(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsTrimParameters() {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(this.addWhitespace(NAMESPACE));
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeysForNamespace(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsUpperCaseParameters() {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(NAMESPACE.toUpperCase());
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeysForNamespace(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsLowerCaseParameters() {
        for (BusinessObjectDefinitionKey key : this.businessObjectDefinitionDaoTestHelper.getTestBusinessObjectDefinitionKeys()) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_ATTRIBUTES);
        }
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions(NAMESPACE.toLowerCase());
        Assert.assertEquals((Object)this.businessObjectDefinitionDaoTestHelper.getExpectedBusinessObjectDefinitionKeysForNamespace(), (Object)resultKeys.getBusinessObjectDefinitionKeys());
    }

    @Test
    public void testGetBusinessObjectDefinitionsEmptyList() throws Exception {
        BusinessObjectDefinitionKeys resultKeys = this.businessObjectDefinitionService.getBusinessObjectDefinitions("I_DO_NOT_EXIST");
        Assert.assertNotNull((Object)resultKeys);
        Assert.assertEquals((long)0L, (long)resultKeys.getBusinessObjectDefinitionKeys().size());
    }

    @Test
    public void testDeleteBusinessObjectDefinition() throws Exception {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionTrimParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionUpperCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase());
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_DESCRIPTION.toLowerCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME.toLowerCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionLowerCaseParameters() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toLowerCase());
        Assert.assertNotNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
        BusinessObjectDefinition deletedBusinessObjectDefinition = this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_DESCRIPTION.toUpperCase(), NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME.toUpperCase(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)deletedBusinessObjectDefinition);
        Assert.assertNull((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionNoExists() throws Exception {
        try {
            this.businessObjectDefinitionService.deleteBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object definition doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    private Set<BusinessObjectDefinition> setUpTestEntitiesForSearchTesting() {
        List businessObjectDefinitionEntities = this.businessObjectDefinitionDaoTestHelper.createExpectedBusinessObjectDefinitionEntities();
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagEntity rootTagEntity = this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity childTagEntity1 = this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, rootTagEntity);
        TagEntity childTagEntity2 = this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_3, TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, rootTagEntity);
        TagEntity childTagEntity3 = this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_4, TAG_DISPLAY_NAME_4, TAG_SEARCH_SCORE_MULTIPLIER_4, TAG_DESCRIPTION_4, rootTagEntity);
        this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(0), childTagEntity1);
        this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(1), childTagEntity2);
        this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(2), childTagEntity3);
        return businessObjectDefinitionEntities.stream().map(this.businessObjectDefinitionServiceTestHelper::createBusinessObjectDefinitionFromEntityForSearchTesting).collect(Collectors.toSet());
    }

    @Test
    public void testSearchBusinessObjectDefinitionValidParams() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(expectedBusinessObjectDefinitions, actualBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionEmptyFilter() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(), (Set)Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(expectedBusinessObjectDefinitions, actualBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionInvalidParams() {
        try {
            this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter())), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(), new BusinessObjectDefinitionSearchFilter())), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition search filter must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(), new BusinessObjectDefinitionSearchKey())))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one business object definition search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey("I_DO_NOT_EXIST", "I_DO_NO_EXIST"), NOT_INCLUDE_TAG_HIERARCHY))))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)"Tag with code \"I_DO_NO_EXIST\" doesn't exist for tag type \"I_DO_NOT_EXIST\".", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"I_DO_NOT_EXIST"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Search response field \"i_do_not_exist\" is not supported.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"displayName", "I_DO_NOT_EXIST", "dataProviderName"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Search response field \"i_do_not_exist\" is not supported.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchBusinessObjectDefinitionLowerCaseParams() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"dataProviderName".toLowerCase(), "displayName".toLowerCase(), "shortDescription".toLowerCase()}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(expectedBusinessObjectDefinitions, actualBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsUpperCaseParams() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"dataProviderName".toUpperCase(), "displayName".toUpperCase(), "shortDescription".toUpperCase()}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(expectedBusinessObjectDefinitions, actualBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsMissingOptionalParams() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setDisplayName(null);
            businessObjectDefinition.setShortDescription(null);
            businessObjectDefinition.setDataProviderName(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"      \t\t "}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(actualBusinessObjectDefinitions, expectedBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsOnlyDisplayName() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setShortDescription(null);
            businessObjectDefinition.setDataProviderName(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"displayName"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(actualBusinessObjectDefinitions, expectedBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsOnlyShortDescription() {
        HashSet<BusinessObjectDefinition> expectedBusinessObjectDefinitions = new HashSet<BusinessObjectDefinition>(this.setUpTestEntitiesForSearchTesting());
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setDisplayName(null);
            businessObjectDefinition.setDataProviderName(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"shortDescription"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedBusinessObjectDefinitions, actualBusinessObjectDefinitions));
    }

    @Test
    public void testSearchBusinessObjectDefinitionsOnlyDataProviderName() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setDisplayName(null);
            businessObjectDefinition.setShortDescription(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"dataProviderName"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(actualBusinessObjectDefinitions, expectedBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsOnlyDataProviderNameAndDisplayName() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setShortDescription(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(actualBusinessObjectDefinitions, expectedBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsOnlyShortDescriptionAndDataProviderName() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setDisplayName(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"shortDescription", "dataProviderName"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(actualBusinessObjectDefinitions, expectedBusinessObjectDefinitions);
    }

    @Test
    public void testSearchBusinessObjectDefinitionsOnlyShortDescriptionAndDisplayName() {
        Set<BusinessObjectDefinition> expectedBusinessObjectDefinitions = this.setUpTestEntitiesForSearchTesting();
        for (BusinessObjectDefinition businessObjectDefinition : expectedBusinessObjectDefinitions) {
            businessObjectDefinition.setDataProviderName(null);
        }
        BusinessObjectDefinitionSearchResponse searchResponse = this.businessObjectDefinitionService.searchBusinessObjectDefinitions(new BusinessObjectDefinitionSearchRequest(Arrays.asList(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Arrays.asList(new BusinessObjectDefinitionSearchKey(new TagKey(TAG_TYPE, TAG_CODE), INCLUDE_TAG_HIERARCHY))))), (Set)Sets.newHashSet((Object[])new String[]{"shortDescription", "displayName"}));
        HashSet actualBusinessObjectDefinitions = new HashSet(searchResponse.getBusinessObjectDefinitions());
        Assert.assertEquals(actualBusinessObjectDefinitions, expectedBusinessObjectDefinitions);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionSampleFiles() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        String fileName = "testfile.csv";
        long fileSize = 1820L;
        String path = NAMESPACE + "/" + BDEF_NAME + "/";
        BusinessObjectDefinitionSampleFileUpdateDto sampleFileUpdateDto = new BusinessObjectDefinitionSampleFileUpdateDto(path, fileName, Long.valueOf(fileSize));
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionEntitySampleFile(businessObjectDefinitionKey, sampleFileUpdateDto);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        List<SampleDataFile> sampleDataFiles = Arrays.asList(new SampleDataFile(NAMESPACE + "/" + BDEF_NAME + "/", fileName));
        Assert.assertEquals((Object)new BusinessObjectDefinition(updatedBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, sampleDataFiles, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionSampleFilesAddFile() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles());
        String fileName = "testfile.csv";
        long fileSize = 1820L;
        String path = NAMESPACE + "/" + BDEF_NAME + "/";
        BusinessObjectDefinitionSampleFileUpdateDto sampleFileUpdateDto = new BusinessObjectDefinitionSampleFileUpdateDto(path, fileName, Long.valueOf(fileSize));
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionEntitySampleFile(businessObjectDefinitionKey, sampleFileUpdateDto);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        List<SampleDataFile> updatedSampleDataFileList = this.businessObjectDefinitionServiceTestHelper.getTestSampleDataFiles();
        updatedSampleDataFileList.add(new SampleDataFile(NAMESPACE + "/" + BDEF_NAME + "/", fileName));
        Assert.assertEquals((Object)new BusinessObjectDefinition(updatedBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, updatedSampleDataFileList, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionSampleFilesDifferentFileSize() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        String fileName = "testfile.csv";
        long fileSize = 1820L;
        String path = NAMESPACE + "/" + BDEF_NAME + "/";
        BusinessObjectDefinitionSampleFileUpdateDto sampleFileUpdateDto = new BusinessObjectDefinitionSampleFileUpdateDto(path, fileName, Long.valueOf(fileSize));
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionEntitySampleFile(businessObjectDefinitionKey, sampleFileUpdateDto);
        fileSize = 1024L;
        sampleFileUpdateDto.setFileSize(Long.valueOf(fileSize));
        this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionEntitySampleFile(businessObjectDefinitionKey, sampleFileUpdateDto);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        List<SampleDataFile> sampleDataFiles = Arrays.asList(new SampleDataFile(NAMESPACE + "/" + BDEF_NAME + "/", fileName));
        Assert.assertEquals((Object)new BusinessObjectDefinition(updatedBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, sampleDataFiles, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
        Assert.assertEquals((long)((BusinessObjectDefinitionSampleDataFileEntity)businessObjectDefinitionEntity.getSampleDataFiles().iterator().next()).getFileSizeBytes(), (long)fileSize);
    }

    @Test
    public void testUpdateBusinessObjectDefinitionSampleFilesMissingFileName() {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        String fileName = "";
        long fileSize = 1820L;
        String path = NAMESPACE + "/" + BDEF_NAME + "/";
        BusinessObjectDefinitionSampleFileUpdateDto sampleFileUpdateDto = new BusinessObjectDefinitionSampleFileUpdateDto(path, fileName, Long.valueOf(fileSize));
        try {
            this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionEntitySampleFile(businessObjectDefinitionKey, sampleFileUpdateDto);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"A file name must be specified.");
        }
    }

    @Test
    public void testUpdateBusinessObjectDefinitionSampleFilesBusinessObjectDefinitionNoExists() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        String fileName = "testfile.csv";
        long fileSize = 1820L;
        String path = NAMESPACE + "/" + BDEF_NAME + "/";
        BusinessObjectDefinitionSampleFileUpdateDto sampleFileUpdateDto = new BusinessObjectDefinitionSampleFileUpdateDto(path, fileName, Long.valueOf(fileSize));
        try {
            this.businessObjectDefinitionServiceImpl.updateBusinessObjectDefinitionEntitySampleFile(businessObjectDefinitionKey, sampleFileUpdateDto);
        }
        catch (ObjectNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, NAMESPACE));
        }
    }
}

