/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSubjectMatterExpert;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSubjectMatterExpertCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSubjectMatterExpertKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSubjectMatterExpertKeys;
import org.finra.herd.model.jpa.BusinessObjectDefinitionSubjectMatterExpertEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDefinitionSubjectMatterExpertServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpert() {
        BusinessObjectDefinitionSubjectMatterExpertKey key = new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION);
        BusinessObjectDefinitionSubjectMatterExpert resultBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(key));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(resultBusinessObjectDefinitionSubjectMatterExpert.getId(), key), (Object)resultBusinessObjectDefinitionSubjectMatterExpert);
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertBusinessObjectDefinitionNoExists() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertBusinessObjectDefinitionSubjectMatterExpertAlreadyExists() {
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID));
        for (String userId : Arrays.asList(USER_ID, USER_ID.toUpperCase(), USER_ID.toLowerCase())) {
            try {
                this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, userId)));
                Assert.fail();
            }
            catch (AlreadyExistsException e) {
                Assert.assertEquals((Object)String.format("Unable to create business object definition subject matter expert with user id \"%s\" because it already exists for the business object definition {%s}.", userId, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertInvalidParameters() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, USER_ID)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), USER_ID)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(USER_ID))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"User id can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertLowerCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION);
        BusinessObjectDefinitionSubjectMatterExpert resultBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), USER_ID.toLowerCase())));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(resultBusinessObjectDefinitionSubjectMatterExpert.getId(), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID.toLowerCase())), (Object)resultBusinessObjectDefinitionSubjectMatterExpert);
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey("      \t\t ", BDEF_NAME, USER_ID)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, "      \t\t ", USER_ID)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ")));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertTrimParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION);
        BusinessObjectDefinitionSubjectMatterExpert resultBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME.toUpperCase()), this.addWhitespace(USER_ID))));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(resultBusinessObjectDefinitionSubjectMatterExpert.getId(), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID)), (Object)resultBusinessObjectDefinitionSubjectMatterExpert);
    }

    @Test
    public void testCreateBusinessObjectDefinitionSubjectMatterExpertUpperCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION);
        BusinessObjectDefinitionSubjectMatterExpert resultBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.createBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertCreateRequest(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), USER_ID.toUpperCase())));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(resultBusinessObjectDefinitionSubjectMatterExpert.getId(), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID.toUpperCase())), (Object)resultBusinessObjectDefinitionSubjectMatterExpert);
    }

    @Test
    public void testDeleteBusinessObjectDefinitionSubjectMatterExpert() {
        BusinessObjectDefinitionSubjectMatterExpertKey key = new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionSubjectMatterExpertEntity businessObjectDefinitionSubjectMatterExpertEntity = this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(key);
        Assert.assertNotNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
        BusinessObjectDefinitionSubjectMatterExpert deletedBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(key);
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(businessObjectDefinitionSubjectMatterExpertEntity.getId().intValue(), key), (Object)deletedBusinessObjectDefinitionSubjectMatterExpert);
        Assert.assertNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionSubjectMatterExpertBusinessObjectDefinitionSubjectMatterExpertNoExists() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Subject matter expert with user id \"%s\" does not exist for business object definition {%s}.", USER_ID, this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionKeyAsString(BDEF_NAMESPACE, BDEF_NAME)), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionSubjectMatterExpertLowerCaseParameters() {
        BusinessObjectDefinitionSubjectMatterExpertKey key = new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionSubjectMatterExpertEntity businessObjectDefinitionSubjectMatterExpertEntity = this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(key);
        Assert.assertNotNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
        BusinessObjectDefinitionSubjectMatterExpert deletedBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), USER_ID.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(businessObjectDefinitionSubjectMatterExpertEntity.getId().intValue(), key), (Object)deletedBusinessObjectDefinitionSubjectMatterExpert);
        Assert.assertNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionSubjectMatterExpertMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey("      \t\t ", BDEF_NAME, USER_ID));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, "      \t\t ", USER_ID));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDefinitionSubjectMatterExpertTrimParameters() {
        BusinessObjectDefinitionSubjectMatterExpertKey key = new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionSubjectMatterExpertEntity businessObjectDefinitionSubjectMatterExpertEntity = this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(key);
        Assert.assertNotNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
        BusinessObjectDefinitionSubjectMatterExpert deletedBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(USER_ID)));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(businessObjectDefinitionSubjectMatterExpertEntity.getId().intValue(), key), (Object)deletedBusinessObjectDefinitionSubjectMatterExpert);
        Assert.assertNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
    }

    @Test
    public void testDeleteBusinessObjectDefinitionSubjectMatterExpertUpperCaseParameters() {
        BusinessObjectDefinitionSubjectMatterExpertKey key = new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionSubjectMatterExpertEntity businessObjectDefinitionSubjectMatterExpertEntity = this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(key);
        Assert.assertNotNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
        BusinessObjectDefinitionSubjectMatterExpert deletedBusinessObjectDefinitionSubjectMatterExpert = this.businessObjectDefinitionSubjectMatterExpertService.deleteBusinessObjectDefinitionSubjectMatterExpert(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), USER_ID.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpert(businessObjectDefinitionSubjectMatterExpertEntity.getId().intValue(), key), (Object)deletedBusinessObjectDefinitionSubjectMatterExpert);
        Assert.assertNull((Object)this.businessObjectDefinitionSubjectMatterExpertDao.getBusinessObjectDefinitionSubjectMatterExpertByKey(key));
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition() throws Exception {
        List<BusinessObjectDefinitionSubjectMatterExpertKey> keys = Arrays.asList(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID));
        for (BusinessObjectDefinitionSubjectMatterExpertKey key : keys) {
            this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(key);
        }
        BusinessObjectDefinitionSubjectMatterExpertKeys resultBusinessObjectDefinitionSubjectMatterExperts = this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpertKeys(Arrays.asList(keys.get(1), keys.get(0))), (Object)resultBusinessObjectDefinitionSubjectMatterExperts);
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinitionBusinessObjectDefinitionNoExists() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDefinitionServiceTestHelper.getExpectedBusinessObjectDefinitionNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinitionLowerCaseParameters() {
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2));
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID));
        BusinessObjectDefinitionSubjectMatterExpertKeys resultBusinessObjectDefinitionSubjectMatterExpertKeys = this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpertKeys(Arrays.asList(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2))), (Object)resultBusinessObjectDefinitionSubjectMatterExpertKeys);
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinitionMissingRequiredParameters() {
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey("      \t\t ", BDEF_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinitionSubjectMatterExpertsNoExist() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        Assert.assertEquals((long)0L, (long)this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME)).getBusinessObjectDefinitionSubjectMatterExpertKeys().size());
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinitionTrimParameters() {
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2));
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID));
        BusinessObjectDefinitionSubjectMatterExpertKeys resultBusinessObjectDefinitionSubjectMatterExpertKeys = this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpertKeys(Arrays.asList(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2))), (Object)resultBusinessObjectDefinitionSubjectMatterExpertKeys);
    }

    @Test
    public void testGetBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinitionUpperCaseParameters() {
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2));
        this.businessObjectDefinitionSubjectMatterExpertDaoTestHelper.createBusinessObjectDefinitionSubjectMatterExpertEntity(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID));
        BusinessObjectDefinitionSubjectMatterExpertKeys resultBusinessObjectDefinitionSubjectMatterExpertKeys = this.businessObjectDefinitionSubjectMatterExpertService.getBusinessObjectDefinitionSubjectMatterExpertsByBusinessObjectDefinition(new BusinessObjectDefinitionKey(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDefinitionSubjectMatterExpertKeys(Arrays.asList(new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID), new BusinessObjectDefinitionSubjectMatterExpertKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID_2))), (Object)resultBusinessObjectDefinitionSubjectMatterExpertKeys);
    }
}

