/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.core.Command;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.dao.AllowedAttributeValueDao;
import org.finra.herd.dao.GlobalAttributeDefinitionDaoTestHelper;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.AttributeValueListKey;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlOutputFormatEnum;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptiveInformationUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.BusinessObjectFormatAttributeDefinitionsUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatAttributesUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdl;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlCollectionResponse;
import org.finra.herd.model.api.xml.BusinessObjectFormatDdlRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatKeys;
import org.finra.herd.model.api.xml.BusinessObjectFormatParentsUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatUpdateRequest;
import org.finra.herd.model.api.xml.DescriptiveBusinessObjectFormat;
import org.finra.herd.model.api.xml.DescriptiveBusinessObjectFormatUpdateRequest;
import org.finra.herd.model.api.xml.Schema;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.jpa.AttributeValueListEntity;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.GlobalAttributeDefinitionEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectFormatServiceImpl;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectFormatServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectFormatServiceImpl")
    private BusinessObjectFormatServiceImpl businessObjectFormatServiceImpl;
    @Autowired
    private GlobalAttributeDefinitionDaoTestHelper globalAttributeDefinitionDaoTestHelper;
    @Autowired
    private AllowedAttributeValueDao allowedAttributeValueDao;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testBusinessObjectDataServiceMethodsNewTx() throws Exception {
        try {
            BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey();
            this.businessObjectFormatServiceImpl.getBusinessObjectFormat(businessObjectFormatKey);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = new BusinessObjectFormatDdlRequest();
            this.businessObjectFormatServiceImpl.generateBusinessObjectFormatDdl(businessObjectFormatDdlRequest);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            BusinessObjectFormatDdlCollectionRequest businessObjectFormatDdlCollectionRequest = new BusinessObjectFormatDdlCollectionRequest();
            this.businessObjectFormatServiceImpl.generateBusinessObjectFormatDdlCollection(businessObjectFormatDdlCollectionRequest);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one business object format DDL request must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormat() {
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatCreateSecondVersion() {
        this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), resultBusinessObjectFormat);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null));
        Assert.assertEquals((Object)SECOND_FORMAT_VERSION, (Object)businessObjectFormatEntity.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)true, (Object)businessObjectFormatEntity.getLatestVersion());
    }

    @Test
    public void testCreateBusinessObjectFormatCreateSecondVersionNoPartitioningColumns() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY, PARTITION_KEY_GROUP, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(RANDOM_SUFFIX), null);
        Schema testSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        testSchema.setPartitions(null);
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), testSchema);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setPartitions(null);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, resultBusinessObjectFormat);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null));
        Assert.assertEquals((Object)SECOND_FORMAT_VERSION, (Object)businessObjectFormatEntity.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)true, (Object)businessObjectFormatEntity.getLatestVersion());
    }

    @Test
    public void testCreateBusinessObjectFormatDuplicateAttributeDefinitions() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        AttributeDefinition attributeDefinition = new AttributeDefinition();
        attributeDefinition.setName("Attribute Name 1");
        request.getAttributeDefinitions().add(attributeDefinition);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Expecting an Illegal Argument Exception to be thrown which wasn't since duplicate attribute definitions are present.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateBusinessObjectFormatDuplicateAttributes() {
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3")), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatDuplicateColumns() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        for (String columnName : Arrays.asList("duplicate_column_name", "DUPLICATE_COLUMN_NAME")) {
            SchemaColumn schemaColumn = new SchemaColumn();
            request.getSchema().getColumns().add(schemaColumn);
            schemaColumn.setName(columnName);
            schemaColumn.setType("TYPE");
        }
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate column names are present.");
        }
        catch (IllegalArgumentException e) {
            String expectedErrorMessage = String.format("Duplicate schema column name \"DUPLICATE_COLUMN_NAME\" found.", new Object[0]);
            Assert.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatDuplicatePartitionColumns() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        for (String columnName : Arrays.asList("duplicate_column_name", "DUPLICATE_COLUMN_NAME")) {
            SchemaColumn partitionColumn = new SchemaColumn();
            request.getSchema().getPartitions().add(partitionColumn);
            partitionColumn.setName(columnName);
            partitionColumn.setType("TYPE");
        }
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate partition column names are present.");
        }
        catch (IllegalArgumentException e) {
            String expectedErrorMessage = String.format("Duplicate schema column name \"DUPLICATE_COLUMN_NAME\" found.", new Object[0]);
            Assert.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatIncorrectLatestVersion() throws Exception {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        try {
            final BusinessObjectFormatCreateRequest businessObjectFormatCreateRequest = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
            this.executeWithoutLogging(SqlExceptionHelper.class, new Command(){

                public void execute() {
                    BusinessObjectFormatServiceTest.this.businessObjectFormatService.createBusinessObjectFormat(businessObjectFormatCreateRequest);
                    Assert.fail((String)"Should throw a PersistenceException since the latest flag does not identify the maximum format version.");
                }
            });
        }
        catch (PersistenceException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("ConstraintViolationException: could not execute"));
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsAsDescriptiveFormatForBusinessObjectDefinition() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, NO_ATTRIBUTES);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        DescriptiveBusinessObjectFormatUpdateRequest descriptiveBusinessObjectFormatUpdateRequest = new DescriptiveBusinessObjectFormatUpdateRequest(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.updateBusinessObjectDefinitionDescriptiveInformation(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), new BusinessObjectDefinitionDescriptiveInformationUpdateRequest(BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, descriptiveBusinessObjectFormatUpdateRequest));
        DescriptiveBusinessObjectFormat descriptiveBusinessObjectFormat = new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION.intValue());
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, null, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, descriptiveBusinessObjectFormat, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
        this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_DESCRIPTION, PARTITION_KEY, FORMAT_DOCUMENT_SCHEMA, null, null, null));
        descriptiveBusinessObjectFormat = new DescriptiveBusinessObjectFormat(FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION.intValue());
        updatedBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), NOT_INCLUDE_BUSINESS_OBJECT_DEFINITION_UPDATE_HISTORY);
        Assert.assertEquals((Object)new BusinessObjectDefinition(businessObjectDefinitionEntity.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION_2, null, BDEF_DISPLAY_NAME_2, NO_ATTRIBUTES, descriptiveBusinessObjectFormat, NO_SAMPLE_DATA_FILES, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaAdditiveSchemaChangesColumnDescriptionUpdated() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        Schema initialSchema = new Schema(Arrays.asList(new SchemaColumn(COLUMN_NAME, COLUMN_DATA_TYPE, COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION)), Arrays.asList(new SchemaColumn(COLUMN_NAME_2, COLUMN_DATA_TYPE_2, COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION_2)), "\\N", "|", "\\", PARTITION_KEY_GROUP);
        Schema updatedSchema = (Schema)initialSchema.clone();
        ((SchemaColumn)updatedSchema.getColumns().get(0)).setDescription(COLUMN_DESCRIPTION_3);
        ((SchemaColumn)updatedSchema.getPartitions().get(0)).setDescription(COLUMN_DESCRIPTION_4);
        BusinessObjectFormat initialBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, COLUMN_NAME_2, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, initialSchema));
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, COLUMN_NAME_2, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, updatedSchema));
        BusinessObjectFormat expectedBusinessObjectFormat = (BusinessObjectFormat)initialBusinessObjectFormat.clone();
        expectedBusinessObjectFormat.setId(resultBusinessObjectFormat.getId());
        expectedBusinessObjectFormat.setBusinessObjectFormatVersion(SECOND_FORMAT_VERSION.intValue());
        expectedBusinessObjectFormat.setSchema(updatedSchema);
        Assert.assertEquals((Object)expectedBusinessObjectFormat, (Object)resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaAdditiveSchemaChangesColumnSizeIncreased() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        int i = 0;
        for (String columnDataType : Arrays.asList("CHAR", "VARCHAR", "VARCHAR2", "char", "varchar", "varchar2")) {
            Schema initialSchema = new Schema(Arrays.asList(new SchemaColumn(COLUMN_NAME, columnDataType, COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION)), Arrays.asList(new SchemaColumn(COLUMN_NAME_2, columnDataType, COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION_2)), "\\N", "|", "\\", PARTITION_KEY_GROUP);
            Schema updatedSchema = (Schema)initialSchema.clone();
            ((SchemaColumn)updatedSchema.getColumns().get(0)).setSize(COLUMN_SIZE_2);
            ((SchemaColumn)updatedSchema.getPartitions().get(0)).setSize(COLUMN_SIZE_2);
            String formatUsage = String.format("%s_%d", FORMAT_USAGE_CODE, i++);
            BusinessObjectFormat initialBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, formatUsage, FORMAT_FILE_TYPE_CODE, COLUMN_NAME_2, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, initialSchema));
            BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, formatUsage, FORMAT_FILE_TYPE_CODE, COLUMN_NAME_2, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, updatedSchema));
            BusinessObjectFormat expectedBusinessObjectFormat = (BusinessObjectFormat)initialBusinessObjectFormat.clone();
            expectedBusinessObjectFormat.setId(resultBusinessObjectFormat.getId());
            expectedBusinessObjectFormat.setBusinessObjectFormatVersion(SECOND_FORMAT_VERSION.intValue());
            expectedBusinessObjectFormat.setSchema(updatedSchema);
            Assert.assertEquals((Object)expectedBusinessObjectFormat, (Object)resultBusinessObjectFormat);
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaAdditiveSchemaChangesNewColumnAdded() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema newFormatVersionSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        SchemaColumn newSchemaColumn = new SchemaColumn();
        newFormatVersionSchema.getColumns().add(newSchemaColumn);
        newSchemaColumn.setName("NEW_COLUMN");
        newSchemaColumn.setType("TYPE");
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newFormatVersionSchema);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newFormatVersionSchema, resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaHavingNullRowFormatValuesNoSchemaChanges() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setDelimiter(null);
        request.getSchema().setEscapeCharacter(null);
        this.businessObjectFormatService.createBusinessObjectFormat(request);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        Assert.assertNotNull((Object)businessObjectFormatEntity);
        businessObjectFormatEntity.setNullValue(null);
        this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity);
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setNullValue("");
        request.getSchema().setDelimiter(null);
        request.getSchema().setEscapeCharacter(null);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setNullValue(null);
        expectedSchema.setDelimiter(null);
        expectedSchema.setEscapeCharacter(null);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(resultBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, resultBusinessObjectFormat);
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setNullValue("");
        request.getSchema().setDelimiter("");
        request.getSchema().setEscapeCharacter("");
        resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(resultBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, THIRD_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaHavingNullRowFormatValuesNonAdditiveSchemaChanges() {
        Schema newSchema;
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setDelimiter(null);
        request.getSchema().setEscapeCharacter(null);
        this.businessObjectFormatService.createBusinessObjectFormat(request);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        Assert.assertNotNull((Object)businessObjectFormatEntity);
        businessObjectFormatEntity.setNullValue(null);
        this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity);
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setNullValue("NULL");
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version null value does not match to the previous format version null value.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setNullValue("");
            newSchema.setDelimiter(",");
            newSchema.setEscapeCharacter(null);
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version delimiter character does not match to the previous format version delimiter character.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setNullValue("");
            newSchema.setDelimiter(null);
            newSchema.setEscapeCharacter("~");
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version escape character does not match to the previous format version escape character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNoSchemaChanges() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        this.businessObjectFormatService.createBusinessObjectFormat(request);
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNonAdditiveSchemaChanges() {
        Schema newSchema;
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version schema is not specified.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setNullValue("NULL");
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version null value does not match to the previous format version null value.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setDelimiter(",");
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version delimiter character does not match to the previous format version delimiter character.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setEscapeCharacter("~");
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version escape character does not match to the previous format version escape character.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setPartitions(null);
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined partition columns.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setPartitions(newSchema.getPartitions().subList(0, newSchema.getPartitions().size() - 1));
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined partition columns.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setPartitions(this.businessObjectFormatServiceTestHelper.getTestSchema2().getPartitions());
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined partition columns.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setColumns(newSchema.getColumns().subList(0, newSchema.getColumns().size() - 1));
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined regular (non-partitioning) columns.", (Object)e.getMessage());
        }
        try {
            newSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            newSchema.setColumns(this.businessObjectFormatServiceTestHelper.getTestSchema2().getColumns());
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), newSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined regular (non-partitioning) columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNonAdditiveSchemaChangesColumnSizeDecreased() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        Schema initialSchema = new Schema(Arrays.asList(new SchemaColumn(COLUMN_NAME, "CHAR", COLUMN_SIZE_2, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION)), NO_PARTITION_COLUMNS, "\\N", "|", "\\", PARTITION_KEY_GROUP);
        this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, initialSchema));
        Schema updatedSchema = (Schema)initialSchema.clone();
        ((SchemaColumn)updatedSchema.getColumns().get(0)).setSize(COLUMN_SIZE);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, updatedSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined regular (non-partitioning) columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNonAdditiveSchemaChangesColumnSizeIncreasedForNotAllowedDataType() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        Schema initialSchema = new Schema(Arrays.asList(new SchemaColumn(COLUMN_NAME, COLUMN_DATA_TYPE, COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION)), NO_PARTITION_COLUMNS, "\\N", "|", "\\", PARTITION_KEY_GROUP);
        this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, initialSchema));
        Schema updatedSchema = (Schema)initialSchema.clone();
        ((SchemaColumn)updatedSchema.getColumns().get(0)).setSize(COLUMN_SIZE_2);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, updatedSchema));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined regular (non-partitioning) columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNonAdditiveSchemaChangesColumnSizeIncreasedOriginalColumnSizeNotPositiveInteger() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        int i = 0;
        for (String originalColumnSize : Arrays.asList("NOT_AN_INTEGER", NEGATIVE_COLUMN_SIZE, "0")) {
            Schema initialSchema = new Schema(Arrays.asList(new SchemaColumn(COLUMN_NAME, "CHAR", originalColumnSize, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION)), NO_PARTITION_COLUMNS, "\\N", "|", "\\", PARTITION_KEY_GROUP);
            String formatUsage = String.format("%s_%d", FORMAT_USAGE_CODE, i++);
            this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, formatUsage, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, initialSchema));
            Schema updatedSchema = (Schema)initialSchema.clone();
            ((SchemaColumn)updatedSchema.getColumns().get(0)).setSize(COLUMN_SIZE);
            try {
                this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, formatUsage, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, updatedSchema));
                Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined regular (non-partitioning) columns.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNonAdditiveSchemaChangesColumnSizeIncreasedUpdatedColumnSizeNotPositiveInteger() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        Schema initialSchema = new Schema(Arrays.asList(new SchemaColumn(COLUMN_NAME, "CHAR", COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION)), NO_PARTITION_COLUMNS, "\\N", "|", "\\", PARTITION_KEY_GROUP);
        this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, initialSchema));
        for (String updatedColumnSize : Arrays.asList("NOT_AN_INTEGER", NEGATIVE_COLUMN_SIZE, "0")) {
            Schema updatedSchema = (Schema)initialSchema.clone();
            ((SchemaColumn)updatedSchema.getColumns().get(0)).setSize(updatedColumnSize);
            try {
                this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, updatedSchema));
                Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined regular (non-partitioning) columns.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithSchemaNonAdditiveSchemaChangesPartitionColumnsAdded() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        Schema originalSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        originalSchema.setPartitions(null);
        this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), originalSchema));
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException when the new format version is not \"additive\" to the previous format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. Non-additive changes detected to the previously defined partition columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatInitialVersionExistsWithoutSchema() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA);
        this.businessObjectFormatService.createBusinessObjectFormat(request);
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(resultBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA, resultBusinessObjectFormat);
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(resultBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, THIRD_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatInvalidParameters() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing namespace is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getBusinessObjectDefinitionName(), request.getNamespace()), (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing business object definition name is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getBusinessObjectDefinitionName(), request.getNamespace()), (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(FORMAT_USAGE_CODE), FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing business object format file type code is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, this.addSlash(FORMAT_FILE_TYPE_CODE), PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format file type can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, this.addSlash(PARTITION_KEY), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition key can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setPartitionKeyGroup("I_DO_NOT_EXIST");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing partition key group is specified.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Partition key group \"%s\" doesn't exist.", request.getSchema().getPartitionKeyGroup()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatLowerCaseParameters() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE.toUpperCase(), DATA_PROVIDER_NAME.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), PARTITION_KEY_GROUP.toUpperCase());
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), PARTITION_KEY.toLowerCase(), FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setPartitionKeyGroup(PARTITION_KEY_GROUP.toLowerCase());
        ((SchemaColumn)request.getSchema().getPartitions().get(0)).setName(PARTITION_KEY.toUpperCase());
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setPartitionKeyGroup(PARTITION_KEY_GROUP.toUpperCase());
        ((SchemaColumn)expectedSchema.getPartitions().get(0)).setName(PARTITION_KEY.toUpperCase());
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase(), FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatMissingOptionalParameters() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_FILE_TYPE_CODE, PARTITION_KEY_GROUP);
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatMissingRequiredParameters() {
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, "      \t\t ", FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("      \t\t ", "Attribute Value 1")), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoAttributeDefinitionPublishOptionSpecified() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_FILE_TYPE_CODE, PARTITION_KEY_GROUP);
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), Arrays.asList(new AttributeDefinition("Attribute Name 1", null)), NO_SCHEMA);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), Arrays.asList(new AttributeDefinition("Attribute Name 1", NO_PUBLISH_ATTRIBUTE)), NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatNoPartitionKeyGroupSpecified() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        Integer expectedBusinessObjectFormatVersion = INITIAL_FORMAT_VERSION;
        for (String partitionKeyGroupName : Arrays.asList("      \t\t ", null)) {
            BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
            request.getSchema().setPartitionKeyGroup(partitionKeyGroupName);
            BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
            Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
            expectedSchema.setPartitionKeyGroup(null);
            Integer n = expectedBusinessObjectFormatVersion;
            Integer n2 = expectedBusinessObjectFormatVersion = Integer.valueOf(expectedBusinessObjectFormatVersion + 1);
            this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, n, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaColumnName() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        SchemaColumn schemaColumn = new SchemaColumn();
        request.getSchema().getColumns().add(schemaColumn);
        schemaColumn.setName("      \t\t ");
        schemaColumn.setType("TYPE");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when schema has an empty column name.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema column name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaColumnType() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        SchemaColumn schemaColumn = new SchemaColumn();
        request.getSchema().getColumns().add(schemaColumn);
        schemaColumn.setName("COLUMN_NAME");
        schemaColumn.setType("      \t\t ");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when schema has an empty column data type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema column data type must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaColumns() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setColumns(null);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when schema has no columns.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema must have at least one column.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaDelimiter() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setDelimiter(null);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setDelimiter(null);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaEscapeCharacter() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setEscapeCharacter(" ");
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setEscapeCharacter(" ");
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaNullValue() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setNullValue(null);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when schema null value is null.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema null value can not be null.", (Object)e.getMessage());
        }
        request.getSchema().setNullValue("");
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setNullValue(null);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaPartitionColumnName() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        SchemaColumn partitionColumn = new SchemaColumn();
        request.getSchema().getPartitions().add(partitionColumn);
        partitionColumn.setName("      \t\t ");
        partitionColumn.setType("TYPE");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when schema has an empty partition column name.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema column name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaPartitionColumnType() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        SchemaColumn partitionColumn = new SchemaColumn();
        request.getSchema().getPartitions().add(partitionColumn);
        partitionColumn.setName("COLUMN_NAME");
        partitionColumn.setType("      \t\t ");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when schema has an empty partition column data type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema column data type must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatNoSchemaPartitions() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setPartitions(null);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setPartitions(null);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatNullSchemaEscapeCharacter() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setEscapeCharacter(null);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setEscapeCharacter(null);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatPartitionAndRegularColumnsHaveConflictingValues() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        SchemaColumn schemaColumn = (SchemaColumn)request.getSchema().getColumns().get(0);
        ((SchemaColumn)request.getSchema().getPartitions().get(0)).setName(schemaColumn.getName());
        ((SchemaColumn)request.getSchema().getPartitions().get(0)).setType("DIFFERENT_DATA_TYPE");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition column has a conflict value with the corresponding regular schema column.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Schema data and partition column configurations with name \"%s\" have conflicting values. All column values are case sensitive and must be identical.", schemaColumn.getName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatSchemaWhitespaceNullValueAndDelimiter() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setNullValue(" ");
        request.getSchema().setDelimiter(" ");
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setNullValue(" ");
        expectedSchema.setDelimiter(" ");
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatTopPartitionColumnNameNoMatchPartitionKey() {
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        ((SchemaColumn)request.getSchema().getPartitions().get(0)).setName("NOT_A_PARTITION_KEY");
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when the first schema partition column name does not match the partition key.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition key \"%s\" does not match the first schema partition column name \"%s\".", PARTITION_KEY, ((SchemaColumn)request.getSchema().getPartitions().get(0)).getName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatTrimParameters() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), this.addWhitespace(PARTITION_KEY), this.addWhitespace(FORMAT_DESCRIPTION), this.addWhitespace(FORMAT_DOCUMENT_SCHEMA), Arrays.asList(new Attribute(this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1"))), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.addWhitespace(this.businessObjectFormatServiceTestHelper.getTestSchema()));
        request.getSchema().setPartitionKeyGroup(this.addWhitespace(PARTITION_KEY_GROUP));
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, this.addWhitespace(FORMAT_DESCRIPTION), FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 1", this.addWhitespace("Attribute Value 1"))), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatAllBlankSpaceDocumentSchema() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, StringUtils.repeat((String)" ", (int)10), Arrays.asList(new Attribute("Attribute Name 1", "Attribute Value 1")), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setPartitionKeyGroup(PARTITION_KEY_GROUP);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, "", Arrays.asList(new Attribute("Attribute Name 1", "Attribute Value 1")), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatNullDocumentSchema() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 1", "Attribute Value 1")), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setPartitionKeyGroup(PARTITION_KEY_GROUP);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 1", "Attribute Value 1")), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatUnprintableSchemaEscapeCharacter() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setEscapeCharacter(String.valueOf('\u0001'));
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setEscapeCharacter(String.valueOf('\u0001'));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatUpperCaseParameters() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE.toLowerCase(), DATA_PROVIDER_NAME.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), PARTITION_KEY_GROUP.toLowerCase());
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), PARTITION_KEY.toUpperCase(), FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        request.getSchema().setPartitionKeyGroup(PARTITION_KEY_GROUP.toUpperCase());
        ((SchemaColumn)request.getSchema().getPartitions().get(0)).setName(PARTITION_KEY.toLowerCase());
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        expectedSchema.setPartitionKeyGroup(PARTITION_KEY_GROUP.toLowerCase());
        ((SchemaColumn)expectedSchema.getPartitions().get(0)).setName(PARTITION_KEY.toLowerCase());
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase(), FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), expectedSchema, businessObjectFormat);
    }

    @Test
    public void testDeleteBusinessObjectFormat() throws Exception {
        this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
    }

    @Test
    public void testDeleteBusinessObjectFormatDataIsRegistered() {
        this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when trying to delete a business object format that has business object data associated with it.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Can not delete a business object format that has business object data associated with it. Business object format: {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectFormatInvalidParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(999)));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 999), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectFormatLatestVersionWhenPreviousVersionExists() {
        BusinessObjectFormatEntity initialVersionBusinessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        BusinessObjectFormatEntity latestVersionBusinessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        Assert.assertFalse((boolean)initialVersionBusinessObjectFormatEntity.getLatestVersion());
        Assert.assertTrue((boolean)latestVersionBusinessObjectFormatEntity.getLatestVersion());
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(latestVersionBusinessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_DATA_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        latestVersionBusinessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION));
        Assert.assertNull((Object)latestVersionBusinessObjectFormatEntity);
        initialVersionBusinessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        Assert.assertNotNull((Object)initialVersionBusinessObjectFormatEntity);
        Assert.assertTrue((boolean)initialVersionBusinessObjectFormatEntity.getLatestVersion());
    }

    @Test
    public void testDeleteBusinessObjectFormatLowerCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase());
        Assert.assertNotNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase(), FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
    }

    @Test
    public void testDeleteBusinessObjectFormatMissingOptionalParameters() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
    }

    @Test
    public void testDeleteBusinessObjectFormatMissingRequiredParameters() {
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectFormatNotLatestVersion() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, false, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
    }

    @Test
    public void testDeleteBusinessObjectFormatTrimParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        Assert.assertNotNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
    }

    @Test
    public void testDeleteBusinessObjectFormatUpperCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase());
        Assert.assertNotNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase(), FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION)));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdl() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(CUSTOM_DDL_NAME, this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(AbstractServiceTest.PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlCollection() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlCollectionTesting();
        BusinessObjectFormatDdlCollectionResponse resultBusinessObjectFormatDdlCollectionResponse = this.businessObjectFormatService.generateBusinessObjectFormatDdlCollection(this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlCollectionRequest());
        Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdlCollectionResponse(), (Object)resultBusinessObjectFormatDdlCollectionResponse);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlInvalidParameters() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName("I_DO_NOT_EXIST");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing business object format is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setCustomDdlName("I_DO_NOT_EXIST");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing custom ddl is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Custom DDL with name \"%s\" does not exist for business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\".", request.getCustomDdlName(), request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlLowerCaseParameters() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setNamespace(request.getNamespace().toLowerCase());
        request.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName().toLowerCase());
        request.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage().toLowerCase());
        request.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType().toLowerCase());
        request.setCustomDdlName(request.getCustomDdlName().toLowerCase());
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(CUSTOM_DDL_NAME, this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(AbstractServiceTest.PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlMissingOptionalParameters() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", "PRTN_CLMN001", "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), CUSTOM_DDL_NAME);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest("      \t\t ");
        request.setBusinessObjectFormatVersion(null);
        request.setIncludeDropTableStatement(null);
        request.setIncludeIfNotExistsOption(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", false, false);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl("", expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlMissingRequiredParameters() {
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setNamespace("      \t\t ");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName("      \t\t ");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setBusinessObjectFormatUsage("      \t\t ");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setBusinessObjectFormatFileType("      \t\t ");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setOutputFormat(null);
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when output format parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An output format must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setTableName("      \t\t ");
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when table name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A table name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlAllKnownFileTypes() {
        StorageEntity storageEntity = this.storageDao.getStorageByName("S3_MANAGED");
        HashMap<String, String> businessObjectFormatFileTypeMap = new HashMap<String, String>();
        businessObjectFormatFileTypeMap.put("BZ", "TEXTFILE");
        businessObjectFormatFileTypeMap.put("GZ", "TEXTFILE");
        businessObjectFormatFileTypeMap.put("ORC", "ORC");
        businessObjectFormatFileTypeMap.put("PARQUET", "PARQUET");
        businessObjectFormatFileTypeMap.put("TXT", "TEXTFILE");
        for (String businessObjectFormatFileType : businessObjectFormatFileTypeMap.keySet()) {
            List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1);
            String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
            BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, businessObjectFormatFileType, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, partitionKey, NO_PARTITION_KEY_GROUP, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns);
            for (String partitionValue : UNSORTED_PARTITION_VALUES) {
                BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, businessObjectFormatFileType, FORMAT_VERSION, partitionValue, NO_SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
                String s3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity), storageEntity.getName());
                StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
                for (int i = 0; i < 2; ++i) {
                    this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, String.format("%s/data%d.dat", s3KeyPrefix, i), Long.valueOf(1024L), Long.valueOf(1000L));
                }
                this.herdDao.saveAndRefresh((Object)storageUnitEntity);
                this.herdDao.saveAndRefresh((Object)businessObjectDataEntity);
            }
            BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
            request.setBusinessObjectFormatFileType(businessObjectFormatFileType);
            BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            String expectedHiveFileFormat = (String)businessObjectFormatFileTypeMap.get(businessObjectFormatFileType);
            String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(partitionColumns.size(), "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", expectedHiveFileFormat, businessObjectFormatFileType, true, true);
            this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, businessObjectFormatFileType, FORMAT_VERSION, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, null, expectedDdl, resultDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlEscapeBackslashInRowFormat() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, "\\", "\\", "\\", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\\\' ESCAPED BY '\\\\' NULL DEFINED AS '\\'";
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlEscapeSingleQuoteInRowFormat() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, "'", "'", "'", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\'' ESCAPED BY '\\'' NULL DEFINED AS '\\''";
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlForwardSlashInPartitionColumnName() {
        String invalidPartitionColumnName = "INVALID_/_PRTN_CLMN";
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        ((SchemaColumn)partitionColumns.get(0)).setName(invalidPartitionColumnName);
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", PARTITION_KEY, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition column name contains a '/' character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition column name \"%s\" can not contain a '/' character. Business object format: {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}", invalidPartitionColumnName, request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlMissingSchemaDelimiterCharacter() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, null, "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED NULL DEFINED AS '\\N'";
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlMissingSchemaEscapeCharacter() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, "|", null, "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' NULL DEFINED AS '\\N'";
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlMissingSchemaNullValue() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, "|", "\\", null, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS ''";
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlNoPartitioning() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", "partition", "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(0, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlNotSupportedFileType() {
        String businessObjectFileType = "UNKNOWN";
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting(businessObjectFileType, PARTITION_KEY, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        request.setBusinessObjectFormatFileType(businessObjectFileType);
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format has an unsupported file type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Unsupported format file type for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlNotSupportedSchemaColumnDataType() {
        List schemaColumns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        SchemaColumn schemaColumn = new SchemaColumn();
        schemaColumns.add(schemaColumn);
        schemaColumn.setName("COLUMN");
        schemaColumn.setType("UNKNOWN");
        String partitionKey = ((SchemaColumn)schemaColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, "|", "\\", "\\N", schemaColumns, this.schemaColumnDaoTestHelper.getTestPartitionColumns(), null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        try {
            this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format has a column with an unsupported data type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Column \"%s\" has an unsupported data type \"%s\" in the schema for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", schemaColumn.getName(), schemaColumn.getType(), request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlPartitionColumnIsAlsoRegularColumn() {
        List schemaColumns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        schemaColumns.set(0, partitionColumns.get(0));
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", "PRTN_CLMN001", "|", "\\", "\\N", schemaColumns, partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(partitionColumns.size(), "ORGNL_PRTN_CLMN001", "DATE", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlSingleLevelPartitioning() {
        List<SchemaColumn> partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1);
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(partitionColumns.size(), "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoCustomDdlUnprintableCharactersInRowFormat() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", partitionKey, String.valueOf('\u0001'), String.valueOf('\n'), String.valueOf('\u0080'), this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, null);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\001' ESCAPED BY '\\012' NULL DEFINED AS '\\200'";
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(null, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoDropTable() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", "PRTN_CLMN001", "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), CUSTOM_DDL_NAME);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setIncludeDropTableStatement(Boolean.valueOf(false));
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", false, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(CUSTOM_DDL_NAME, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlNoPartitioning() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting("TXT", "partition", "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null, CUSTOM_DDL_NAME);
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        String expectedDdl = this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(0, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(CUSTOM_DDL_NAME, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlTrimParameters() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName(this.addWhitespace(request.getBusinessObjectDefinitionName()));
        request.setBusinessObjectFormatUsage(this.addWhitespace(request.getBusinessObjectFormatUsage()));
        request.setBusinessObjectFormatFileType(this.addWhitespace(request.getBusinessObjectFormatFileType()));
        request.setTableName(this.addWhitespace(request.getTableName()));
        request.setCustomDdlName(this.addWhitespace(request.getCustomDdlName()));
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(CUSTOM_DDL_NAME, this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(AbstractServiceTest.PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlUpperCaseParameters() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdlRequest request = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(CUSTOM_DDL_NAME);
        request.setNamespace(request.getNamespace().toUpperCase());
        request.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName().toUpperCase());
        request.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage().toUpperCase());
        request.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType().toUpperCase());
        request.setCustomDdlName(request.getCustomDdlName().toUpperCase());
        BusinessObjectFormatDdl resultDdl = this.businessObjectFormatService.generateBusinessObjectFormatDdl(request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatDdl(CUSTOM_DDL_NAME, this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatDdl(AbstractServiceTest.PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", true, true), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWhenReplaceColumns() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest("      \t\t ");
        businessObjectFormatDdlRequest.setReplaceColumns(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setIncludeDropTableStatement(Boolean.valueOf(false));
        businessObjectFormatDdlRequest.setIncludeIfNotExistsOption(Boolean.valueOf(false));
        BusinessObjectFormatDdl result = this.businessObjectFormatService.generateBusinessObjectFormatDdl(businessObjectFormatDdlRequest);
        Assert.assertEquals((String)"result DDL", (Object)result.getDdl(), (Object)("ALTER TABLE `" + businessObjectFormatDdlRequest.getTableName() + "` REPLACE COLUMNS (\n" + "    `COLUMN001` TINYINT,\n" + "    `COLUMN002` SMALLINT COMMENT 'This is \\'COLUMN002\\' column. Here are \\'single\\' and \"double\" quotes along with a backslash \\.',\n" + "    `COLUMN003` INT,\n" + "    `COLUMN004` BIGINT,\n" + "    `COLUMN005` FLOAT,\n" + "    `COLUMN006` DOUBLE,\n" + "    `COLUMN007` DECIMAL,\n" + "    `COLUMN008` DECIMAL(p,s),\n" + "    `COLUMN009` DECIMAL,\n" + "    `COLUMN010` DECIMAL(p),\n" + "    `COLUMN011` DECIMAL(p,s),\n" + "    `COLUMN012` TIMESTAMP,\n" + "    `COLUMN013` DATE,\n" + "    `COLUMN014` STRING,\n" + "    `COLUMN015` VARCHAR(n),\n" + "    `COLUMN016` VARCHAR(n),\n" + "    `COLUMN017` CHAR(n),\n" + "    `COLUMN018` BOOLEAN,\n" + "    `COLUMN019` BINARY);"));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWhenReplaceColumnsAndCustomDdlNameThrowsError() {
        final BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        businessObjectFormatDdlRequest.setReplaceColumns(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setIncludeDropTableStatement(null);
        businessObjectFormatDdlRequest.setIncludeIfNotExistsOption(null);
        businessObjectFormatDdlRequest.setCustomDdlName(CUSTOM_DDL_NAME);
        this.assertExceptionThrown(new Runnable(){

            @Override
            public void run() {
                BusinessObjectFormatServiceTest.this.businessObjectFormatService.generateBusinessObjectFormatDdl(businessObjectFormatDdlRequest);
            }
        }, IllegalArgumentException.class, "'customDdlName' must not be specified when 'replaceColumns' is true");
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWhenReplaceColumnsAndIncludeDropTableStatementThrowsError() {
        final BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        businessObjectFormatDdlRequest.setReplaceColumns(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setIncludeDropTableStatement(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setIncludeIfNotExistsOption(null);
        businessObjectFormatDdlRequest.setCustomDdlName(null);
        this.assertExceptionThrown(new Runnable(){

            @Override
            public void run() {
                BusinessObjectFormatServiceTest.this.businessObjectFormatService.generateBusinessObjectFormatDdl(businessObjectFormatDdlRequest);
            }
        }, IllegalArgumentException.class, "'includeDropTableStatement' must not be specified when 'replaceColumns' is true");
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWhenReplaceColumnsAndIncludeIfNotExistsOptionThrowsError() {
        final BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        businessObjectFormatDdlRequest.setReplaceColumns(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setIncludeDropTableStatement(null);
        businessObjectFormatDdlRequest.setIncludeIfNotExistsOption(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setCustomDdlName(null);
        this.assertExceptionThrown(new Runnable(){

            @Override
            public void run() {
                BusinessObjectFormatServiceTest.this.businessObjectFormatService.generateBusinessObjectFormatDdl(businessObjectFormatDdlRequest);
            }
        }, IllegalArgumentException.class, "'includeIfNotExistsOption' must not be specified when 'replaceColumns' is true");
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWhenReplaceColumnsMissingOptionalParameters() {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        BusinessObjectFormatDdlRequest businessObjectFormatDdlRequest = this.businessObjectFormatServiceTestHelper.getTestBusinessObjectFormatDdlRequest(null);
        businessObjectFormatDdlRequest.setReplaceColumns(Boolean.valueOf(true));
        businessObjectFormatDdlRequest.setIncludeDropTableStatement(null);
        businessObjectFormatDdlRequest.setIncludeIfNotExistsOption(null);
        BusinessObjectFormatDdl result = this.businessObjectFormatService.generateBusinessObjectFormatDdl(businessObjectFormatDdlRequest);
        Assert.assertEquals((String)"result DDL", (Object)result.getDdl(), (Object)("ALTER TABLE `" + businessObjectFormatDdlRequest.getTableName() + "` REPLACE COLUMNS (\n" + "    `COLUMN001` TINYINT,\n" + "    `COLUMN002` SMALLINT COMMENT 'This is \\'COLUMN002\\' column. Here are \\'single\\' and \"double\" quotes along with a backslash \\.',\n" + "    `COLUMN003` INT,\n" + "    `COLUMN004` BIGINT,\n" + "    `COLUMN005` FLOAT,\n" + "    `COLUMN006` DOUBLE,\n" + "    `COLUMN007` DECIMAL,\n" + "    `COLUMN008` DECIMAL(p,s),\n" + "    `COLUMN009` DECIMAL,\n" + "    `COLUMN010` DECIMAL(p),\n" + "    `COLUMN011` DECIMAL(p,s),\n" + "    `COLUMN012` TIMESTAMP,\n" + "    `COLUMN013` DATE,\n" + "    `COLUMN014` STRING,\n" + "    `COLUMN015` VARCHAR(n),\n" + "    `COLUMN016` VARCHAR(n),\n" + "    `COLUMN017` CHAR(n),\n" + "    `COLUMN018` BOOLEAN,\n" + "    `COLUMN019` BINARY);"));
    }

    @Test
    public void testGetBusinessObjectFormat() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), resultBusinessObjectFormat);
    }

    @Test
    public void testGetBusinessObjectFormatInvalidParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(999)));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 999), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectFormatLowerCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase());
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase(), FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testGetBusinessObjectFormatMissingOptionalParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testGetBusinessObjectFormatMissingRequiredParameters() {
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", INITIAL_FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectFormatTrimParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testGetBusinessObjectFormatUpperCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase());
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase(), FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testGetBusinessObjectFormats() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        for (BusinessObjectFormatKey key : this.businessObjectFormatDaoTestHelper.getTestBusinessObjectFormatKeys()) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), key.getBusinessObjectFormatUsage(), key.getBusinessObjectFormatFileType(), key.getBusinessObjectFormatVersion(), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        }
        BusinessObjectFormatKeys resultKeys = this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), false);
        Assert.assertEquals((Object)this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatKeys(), (Object)resultKeys.getBusinessObjectFormatKeys());
        resultKeys = this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), true);
        Assert.assertEquals((Object)this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatLatestVersionKeys(), (Object)resultKeys.getBusinessObjectFormatKeys());
    }

    @Test
    public void testGetBusinessObjectFormatsWithFilters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        for (BusinessObjectFormatKey key : this.businessObjectFormatDaoTestHelper.getTestBusinessObjectFormatKeys()) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), key.getBusinessObjectFormatUsage(), key.getBusinessObjectFormatFileType(), key.getBusinessObjectFormatVersion(), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        }
        String filteredFormatUsage = FORMAT_USAGE_CODE;
        BusinessObjectFormatKeys resultKeys = this.businessObjectFormatService.getBusinessObjectFormatsWithFilters(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), " " + filteredFormatUsage.toLowerCase() + " ", false);
        List expectedKeyList = this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatKeys();
        expectedKeyList = expectedKeyList.stream().filter(formatKey -> formatKey.getBusinessObjectFormatUsage().equalsIgnoreCase(filteredFormatUsage)).collect(Collectors.toList());
        Assert.assertEquals(expectedKeyList, (Object)resultKeys.getBusinessObjectFormatKeys());
        resultKeys = this.businessObjectFormatService.getBusinessObjectFormatsWithFilters(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), " " + filteredFormatUsage.toLowerCase() + " ", true);
        expectedKeyList = this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatLatestVersionKeys();
        expectedKeyList = expectedKeyList.stream().filter(formatKey -> formatKey.getBusinessObjectFormatUsage().equalsIgnoreCase(filteredFormatUsage)).collect(Collectors.toList());
        Assert.assertEquals(expectedKeyList, (Object)resultKeys.getBusinessObjectFormatKeys());
    }

    @Test
    public void testGetBusinessObjectFormatsInvalidParameters() {
        try {
            this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey("I_DO_NOT_EXIST", BDEF_NAME), false);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object definition.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE, "I_DO_NOT_EXIST"), false);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object definition.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", "I_DO_NOT_EXIST", NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectFormatsLowerCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        for (BusinessObjectFormatKey key : this.businessObjectFormatDaoTestHelper.getTestBusinessObjectFormatKeys()) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), key.getBusinessObjectFormatUsage(), key.getBusinessObjectFormatFileType(), key.getBusinessObjectFormatVersion(), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        }
        BusinessObjectFormatKeys resultKeys = this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase()), false);
        Assert.assertEquals((Object)this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatKeys(), (Object)resultKeys.getBusinessObjectFormatKeys());
    }

    @Test
    public void testGetBusinessObjectFormatsMissingOptionalParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        for (BusinessObjectFormatKey key : this.businessObjectFormatDaoTestHelper.getTestBusinessObjectFormatKeys()) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), key.getBusinessObjectFormatUsage(), key.getBusinessObjectFormatFileType(), key.getBusinessObjectFormatVersion(), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        }
        BusinessObjectFormatKeys resultKeys = this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME), false);
        Assert.assertEquals((Object)this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatKeys(), (Object)resultKeys.getBusinessObjectFormatKeys());
    }

    @Test
    public void testGetBusinessObjectFormatsMissingRequiredParameters() {
        try {
            this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE, "      \t\t "), false);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectFormatsTrimParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        for (BusinessObjectFormatKey key : this.businessObjectFormatDaoTestHelper.getTestBusinessObjectFormatKeys()) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), key.getBusinessObjectFormatUsage(), key.getBusinessObjectFormatFileType(), key.getBusinessObjectFormatVersion(), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        }
        BusinessObjectFormatKeys resultKeys = this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME)), false);
        Assert.assertEquals((Object)this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatKeys(), (Object)resultKeys.getBusinessObjectFormatKeys());
    }

    @Test
    public void testGetBusinessObjectFormatsUpperCaseParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, null);
        for (BusinessObjectFormatKey key : this.businessObjectFormatDaoTestHelper.getTestBusinessObjectFormatKeys()) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(key.getNamespace(), key.getBusinessObjectDefinitionName(), key.getBusinessObjectFormatUsage(), key.getBusinessObjectFormatFileType(), key.getBusinessObjectFormatVersion(), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(false), PARTITION_KEY);
        }
        BusinessObjectFormatKeys resultKeys = this.businessObjectFormatService.getBusinessObjectFormats(new BusinessObjectDefinitionKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase()), false);
        Assert.assertEquals((Object)this.businessObjectFormatDaoTestHelper.getExpectedBusinessObjectFormatKeys(), (Object)resultKeys.getBusinessObjectFormatKeys());
    }

    @Test
    public void testUpdateBusinessObjectFormat() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatAlreadyExistingDuplicateAttributes() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP, Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1"), new Attribute("Attribute Name 1".toUpperCase(), "   Attribute Value 2  ")));
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3")), this.businessObjectFormatServiceTestHelper.getTestSchema2()));
            Assert.fail((String)"Should throw an IllegalStateException when business object format has duplicate attributes.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Found duplicate attribute with name \"%s\" for business object format {%s}.", "Attribute Name 1".toLowerCase(), this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatDuplicateAttributes() {
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 3".toLowerCase(), "Attribute Value 3"), new Attribute("Attribute Name 3".toUpperCase(), "Attribute Value 3")), this.businessObjectFormatServiceTestHelper.getTestSchema2()));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate attributes are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate attribute name found: %s", "Attribute Name 3".toUpperCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatInitialSchemaPresentAndDataIsRegistered() {
        this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION));
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, true, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatInvalidParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_ATTRIBUTE_DEFINITIONS, this.businessObjectFormatServiceTestHelper.getTestSchema2(), businessObjectFormat);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)("Business object format with namespace \"" + NAMESPACE + "\", business object definition name \"I_DO_NOT_EXIST\", format usage \"" + FORMAT_USAGE_CODE + "\", format file type \"" + FORMAT_FILE_TYPE_CODE + "\", and format version \"" + INITIAL_FORMAT_VERSION + "\" doesn't exist."), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", INITIAL_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(999)), request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 999), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatLowerCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase(), NO_PARTITION_KEY_GROUP, Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())));
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2.toUpperCase());
        Schema testSchema = this.businessObjectFormatServiceTestHelper.getTestSchema2();
        testSchema.setPartitionKeyGroup(testSchema.getPartitionKeyGroup().toLowerCase());
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2.toLowerCase(), FORMAT_DOCUMENT_SCHEMA_2.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION), request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema2();
        expectedSchema.setPartitionKeyGroup(expectedSchema.getPartitionKeyGroup().toUpperCase());
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toUpperCase(), FORMAT_DESCRIPTION_2.toLowerCase(), FORMAT_DOCUMENT_SCHEMA_2.toLowerCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toLowerCase())), null, expectedSchema, updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatMissingOptionalParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectFormatEntity originalBusinessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY, PARTITION_KEY_GROUP, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), ",", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        Schema testSchema2 = this.businessObjectFormatServiceTestHelper.getTestSchema2();
        testSchema2.setPartitions(null);
        for (String blankText : Arrays.asList("      \t\t ", "", null)) {
            BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(blankText, FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 4", blankText)), testSchema2);
            BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, blankText, FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 4", blankText)), NO_ATTRIBUTE_DEFINITIONS, testSchema2, resultBusinessObjectFormat);
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatMissingRequiredParameters() {
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, Arrays.asList(new Attribute("      \t\t ", "Attribute Value 1")), this.businessObjectFormatServiceTestHelper.getTestSchema2()));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatNoChangesToDescriptionDocumentSchemaAndSchema() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatNoInitialDescriptionAndSchema() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, null, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_ATTRIBUTE_DEFINITIONS, this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatNoInitialDocumentSchema() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, null, Boolean.valueOf(true), PARTITION_KEY);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_ATTRIBUTE_DEFINITIONS, this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatDocumentSchemaToNull() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, null, Boolean.valueOf(true), PARTITION_KEY);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_ATTRIBUTE_DEFINITIONS, this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatRemoveAttributesAndSchema() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, NO_ATTRIBUTES, NO_SCHEMA);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, NO_ATTRIBUTES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA, resultBusinessObjectFormat);
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_3, FORMAT_DOCUMENT_SCHEMA_3, NO_ATTRIBUTES, NO_SCHEMA);
        resultBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_3, FORMAT_DOCUMENT_SCHEMA_3, NO_ATTRIBUTES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatRemoveSchema() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat();
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), NO_SCHEMA);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_SCHEMA, resultBusinessObjectFormat);
    }

    @Test
    public void testDeleteBusinessObjectFormatUsedAsDescriptiveFormat() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP);
        businessObjectFormatEntity.getBusinessObjectDefinition().setDescriptiveBusinessObjectFormat(businessObjectFormatEntity);
        this.businessObjectDefinitionDao.saveAndRefresh((Object)businessObjectFormatEntity.getBusinessObjectDefinition());
        Assert.assertNotNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION)));
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, deletedBusinessObjectFormat);
        Assert.assertNull((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION)));
    }

    @Test
    public void testUpdateBusinessObjectFormatTrimParameters() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(this.addWhitespace(FORMAT_DESCRIPTION_2), this.addWhitespace(FORMAT_DOCUMENT_SCHEMA), Arrays.asList(new Attribute(this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1"))), this.addWhitespace(this.businessObjectFormatServiceTestHelper.getTestSchema2()));
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, this.addWhitespace(FORMAT_DESCRIPTION_2), FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute("Attribute Name 1", this.addWhitespace("Attribute Value 1"))), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatUpperCaseParameters() {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase(), NO_PARTITION_KEY_GROUP, Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase())));
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2.toLowerCase());
        Schema testSchema = this.businessObjectFormatServiceTestHelper.getTestSchema2();
        testSchema.setPartitionKeyGroup(testSchema.getPartitionKeyGroup().toUpperCase());
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2.toUpperCase(), FORMAT_DOCUMENT_SCHEMA_2.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase())), testSchema);
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), INITIAL_FORMAT_VERSION), request);
        Schema expectedSchema = this.businessObjectFormatServiceTestHelper.getTestSchema2();
        expectedSchema.setPartitionKeyGroup(expectedSchema.getPartitionKeyGroup().toLowerCase());
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormatEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY.toLowerCase(), FORMAT_DESCRIPTION_2.toUpperCase(), FORMAT_DOCUMENT_SCHEMA_2.toUpperCase(), Arrays.asList(new Attribute("Attribute Name 1".toLowerCase(), "Attribute Value 1".toUpperCase())), null, expectedSchema, updatedBusinessObjectFormat);
    }

    private void assertExceptionThrown(Runnable runnable, Class<? extends Exception> expectedExeceptionType, String expectedMessage) {
        try {
            runnable.run();
            Assert.fail((String)("expected '" + expectedExeceptionType.getSimpleName() + "', but no exception was thrown."));
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", expectedExeceptionType, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithParentsNotExisting() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_FILE_TYPE_CODE, PARTITION_KEY_GROUP);
        List<BusinessObjectFormatKey> businessObjectFormatParents = Arrays.asList(new BusinessObjectFormatKey(NAMESPACE_2, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null));
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Parent business object format not found.");
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithParentsInValidParameters() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_FILE_TYPE_CODE, PARTITION_KEY_GROUP);
        List<BusinessObjectFormatKey> businessObjectFormatParents = Arrays.asList(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null));
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest("", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"A namespace must be specified.");
        }
        businessObjectFormatParents = Arrays.asList(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(1)));
        request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(request);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Business object format version should be null.");
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithParents() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_FILE_TYPE_CODE, PARTITION_KEY_GROUP);
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE_2, DATA_PROVIDER_NAME_2, BDEF_NAME_2, FORMAT_FILE_TYPE_CODE_2, PARTITION_KEY_GROUP_2);
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        List<BusinessObjectFormatKey> businessObjectFormatParents = Arrays.asList(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null));
        BusinessObjectFormatCreateRequest request2 = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        BusinessObjectFormat resultBusinessObjectFormatV0 = this.businessObjectFormatService.createBusinessObjectFormat(request);
        BusinessObjectFormat resultBusinessObjectFormatChildV0 = this.businessObjectFormatService.createBusinessObjectFormat(request2);
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null);
        BusinessObjectFormatKey childBusinessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, null);
        BusinessObjectFormatEntity formatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(businessObjectFormatKey);
        BusinessObjectFormatEntity childFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(childBusinessObjectFormatKey);
        childFormatEntity.getBusinessObjectFormatParents().add(formatEntity);
        formatEntity.getBusinessObjectFormatChildren().add(childFormatEntity);
        BusinessObjectFormat resultBusinessObjectFormatChildV1 = this.businessObjectFormatService.createBusinessObjectFormat(request2);
        BusinessObjectFormat expectedBusinessObjectFormatChild = resultBusinessObjectFormatChildV0;
        expectedBusinessObjectFormatChild.setId(resultBusinessObjectFormatChildV1.getId());
        expectedBusinessObjectFormatChild.setBusinessObjectFormatVersion(resultBusinessObjectFormatChildV1.getBusinessObjectFormatVersion());
        expectedBusinessObjectFormatChild.setBusinessObjectFormatParents(resultBusinessObjectFormatChildV1.getBusinessObjectFormatParents());
        Assert.assertEquals((long)resultBusinessObjectFormatChildV1.getBusinessObjectFormatParents().size(), (long)1L);
        Assert.assertEquals((Object)expectedBusinessObjectFormatChild, (Object)resultBusinessObjectFormatChildV1);
        BusinessObjectFormat resultBusinessObjectFormatParentV2 = this.businessObjectFormatService.createBusinessObjectFormat(request);
        Assert.assertEquals((long)resultBusinessObjectFormatParentV2.getBusinessObjectFormatChildren().size(), (long)1L);
        BusinessObjectFormat expectedBusinessObjectParent = resultBusinessObjectFormatV0;
        expectedBusinessObjectParent.setId(resultBusinessObjectFormatParentV2.getId());
        expectedBusinessObjectParent.setBusinessObjectFormatVersion(resultBusinessObjectFormatParentV2.getBusinessObjectFormatVersion());
        expectedBusinessObjectParent.setBusinessObjectFormatChildren(resultBusinessObjectFormatParentV2.getBusinessObjectFormatChildren());
        Assert.assertEquals((Object)expectedBusinessObjectParent, (Object)resultBusinessObjectFormatParentV2);
    }

    @Test
    public void testGetBusinessObjectFormatWithParents() {
        this.setupBusinessObjectFormatParentChild();
        BusinessObjectFormatKey businessObjectFormat = new BusinessObjectFormatKey(NAMESPACE + " ", BDEF_NAME.toLowerCase(), " " + FORMAT_USAGE_CODE, "  " + FORMAT_FILE_TYPE_CODE + " ", null);
        BusinessObjectFormatKey childBusinessObjectFormat = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, null);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormat);
        BusinessObjectFormat resultChildBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(childBusinessObjectFormat);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectFormat.getBusinessObjectFormatParents().size());
        Assert.assertEquals((long)1L, (long)resultChildBusinessObjectFormat.getBusinessObjectFormatParents().size());
        Assert.assertEquals((long)1L, (long)resultBusinessObjectFormat.getBusinessObjectFormatChildren().size());
    }

    @Test
    public void testUpdateBusinessObjectFormatParentsValidation() {
        Object businessObjectFormatParents = null;
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null);
        BusinessObjectFormatParentsUpdateRequest request = null;
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatParents(businessObjectFormatKey, request);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"A Business Object Format Parents Update Request is required.", (Object)ex.getMessage());
        }
        businessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(1));
        request = new BusinessObjectFormatParentsUpdateRequest();
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatParents(businessObjectFormatKey, request);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Business object format version must not be specified.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatParents() {
        this.setupBusinessObjectFormatParentChild();
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null);
        BusinessObjectFormatKey parentBusinessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, null);
        BusinessObjectFormatParentsUpdateRequest updateRequest = new BusinessObjectFormatParentsUpdateRequest();
        updateRequest.setBusinessObjectFormatParents(Arrays.asList(parentBusinessObjectFormatKey));
        BusinessObjectFormat format = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKey);
        format.setBusinessObjectFormatParents(Arrays.asList(parentBusinessObjectFormatKey));
        BusinessObjectFormat resultFormat = this.businessObjectFormatService.updateBusinessObjectFormatParents(businessObjectFormatKey, updateRequest);
        Assert.assertEquals((Object)format, (Object)resultFormat);
        this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKey);
        format.setBusinessObjectFormatParents(new ArrayList());
        updateRequest.setBusinessObjectFormatParents(new ArrayList());
        resultFormat = this.businessObjectFormatService.updateBusinessObjectFormatParents(businessObjectFormatKey, updateRequest);
        format.setBusinessObjectFormatParents(new ArrayList());
        Assert.assertEquals((Object)format, (Object)resultFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatParentsDuplicateParents() {
        this.setupBusinessObjectFormatParentChild();
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        List<BusinessObjectFormatKey> parentBusinessObjectFormatKeys = Arrays.asList(new BusinessObjectFormatKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE_2.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), NO_FORMAT_VERSION), new BusinessObjectFormatKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE_2.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), NO_FORMAT_VERSION));
        BusinessObjectFormatParentsUpdateRequest businessObjectFormatParentsUpdateRequest = new BusinessObjectFormatParentsUpdateRequest();
        businessObjectFormatParentsUpdateRequest.setBusinessObjectFormatParents(parentBusinessObjectFormatKeys);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormatParents(businessObjectFormatKey, businessObjectFormatParentsUpdateRequest);
        Assert.assertNotNull((Object)resultBusinessObjectFormat);
        Assert.assertEquals(Arrays.asList(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION)), (Object)resultBusinessObjectFormat.getBusinessObjectFormatParents());
    }

    private void setupBusinessObjectFormatParentChild() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_FILE_TYPE_CODE, PARTITION_KEY_GROUP);
        BusinessObjectFormatCreateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        BusinessObjectFormatKey businessObjectFormat = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null);
        this.businessObjectFormatService.createBusinessObjectFormat(request);
        BusinessObjectFormatCreateRequest childRequest = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA);
        this.businessObjectFormatService.createBusinessObjectFormat(childRequest);
        BusinessObjectFormatKey childAltBusinessObjectFormat = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, null);
        BusinessObjectFormatEntity formatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(businessObjectFormat);
        BusinessObjectFormatEntity childFormatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(childAltBusinessObjectFormat);
        childFormatEntity.getBusinessObjectFormatParents().add(formatEntity);
        formatEntity.getBusinessObjectFormatChildren().add(childFormatEntity);
    }

    @Test
    public void testDeleteBusinessObjectFormatWithChildren() {
        this.setupBusinessObjectFormatParentChild();
        BusinessObjectFormatKey altBusinessObjectFormat = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(0));
        BusinessObjectFormatEntity formatEntity = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(altBusinessObjectFormat);
        String errorMessage = String.format("Can not delete a business object format that has children associated with it. Business object format: {%s}", this.businessObjectFormatHelper.businessObjectFormatEntityAltKeyToString(formatEntity));
        try {
            this.businessObjectFormatService.deleteBusinessObjectFormat(altBusinessObjectFormat);
            Assert.fail((String)"should not get here");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)errorMessage, (Object)ex.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithGlobalAttributeMissing() {
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        try {
            BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
            Assert.fail((String)"should throw exception before");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("The business object format has a required attribute \"%s\" which was not specified or has a value which is blank.", GLOBAL_ATTRIBUTE_DEFINITON_NAME), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithGlobalAttributes() {
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT_1", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, "test attribute 1"));
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, attributes, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), businessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatWithMissingGlobalAttributes() {
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT_1", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, "test attribute 1"));
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        try {
            BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2(), this.businessObjectFormatServiceTestHelper.getTestSchema2());
            BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"should throw exception before");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("The business object format has a required attribute \"%s\" which was not specified or has a value which is blank.", GLOBAL_ATTRIBUTE_DEFINITON_NAME), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithMissingGlobalAttributesEmptyValue() {
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.createGlobalAttributeDefinitionEntityWithAllowedAttributeValues();
        String invalidAttributeValue = "";
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, invalidAttributeValue));
        try {
            BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
            Assert.fail((String)"Should throw exception before");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("The business object format has a required attribute \"%s\" which was not specified or has a value which is blank.", GLOBAL_ATTRIBUTE_DEFINITON_NAME), (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatWithGlobalAttributes() {
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT_1", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, "test attribute 1"));
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        List<Attribute> newAttributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        newAttributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, "test attribute 2"));
        BusinessObjectFormatUpdateRequest request = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatUpdateRequest(FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, newAttributes, this.businessObjectFormatServiceTestHelper.getTestSchema2());
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(businessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION_2, FORMAT_DOCUMENT_SCHEMA_2, newAttributes, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema2(), updatedBusinessObjectFormat);
    }

    @Test
    public void testCreateBusinessObjectFormatWithGlobalAttributesAndAllowedAttributeValuesNegative() {
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.createGlobalAttributeDefinitionEntityWithAllowedAttributeValues();
        String invalidAttributeValue = "test attribute 1";
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, invalidAttributeValue));
        try {
            BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
            Assert.fail((String)"Should throw exception before");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("The business object format attribute \"%s\" value \"%s\" is not from allowed attribute values.", GLOBAL_ATTRIBUTE_DEFINITON_NAME, invalidAttributeValue), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithGlobalAttributesAndAllowedAttributeValuesNegative2() {
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.createGlobalAttributeDefinitionEntityWithAllowedAttributeValues();
        String invalidAttributeValue = "Attribute_Value_1".toLowerCase();
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, invalidAttributeValue));
        attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME, invalidAttributeValue));
        try {
            BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
            Assert.fail((String)"Should throw exception before");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("The business object format attribute \"%s\" value \"%s\" is not from allowed attribute values.", GLOBAL_ATTRIBUTE_DEFINITON_NAME, "Attribute_Value_1".toLowerCase()), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithGlobalAttributesAndAllowedAttributeValues() {
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.createGlobalAttributeDefinitionEntityWithAllowedAttributeValues();
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        attributes.add(new Attribute(GLOBAL_ATTRIBUTE_DEFINITON_NAME.toLowerCase(), "Attribute_Value_2"));
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, 0, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, attributes, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), businessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributes() {
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes2();
        BusinessObjectFormatAttributesUpdateRequest request = new BusinessObjectFormatAttributesUpdateRequest(attributes);
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormatAttributes(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, attributes, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitions() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        List<AttributeDefinition> attributeDefinitions = this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions2();
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, attributes, attributeDefinitions, this.businessObjectFormatServiceTestHelper.getTestSchema(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsMissingRequiredParameters() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition(null, AbstractServiceTest.NO_PUBLISH_ATTRIBUTE));
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("An attribute definition name must be specified.", new Object[0]), (Object)ex.getMessage());
        }
        attributeDefinitions = new ArrayList();
        attributeDefinitions.add(new AttributeDefinition("", AbstractServiceTest.NO_PUBLISH_ATTRIBUTE));
        request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("An attribute definition name must be specified.", new Object[0]), (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsNullAsParameters() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(null);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("A business object format attribute definitions list is required.", new Object[0]), (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsMissingOptionalParameters() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1", null));
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals(null, (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsTrim() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        ArrayList<AttributeDefinition> validateAttributeDefinitions = new ArrayList<AttributeDefinition>();
        validateAttributeDefinitions.add(new AttributeDefinition("Attribute Name 1", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition(" Attribute Name 1 ", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, attributes, validateAttributeDefinitions, this.businessObjectFormatServiceTestHelper.getTestSchema(), updatedBusinessObjectFormat);
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsUpperAndLowerCase() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        ArrayList<AttributeDefinition> validateAttributeDefinitions = new ArrayList<AttributeDefinition>();
        validateAttributeDefinitions.add(new AttributeDefinition("Attribute Name 1", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition(" Attribute Name 1 ", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        BusinessObjectFormat updatedBusinessObjectFormat = this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormat(originalBusinessObjectFormat.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, attributes, validateAttributeDefinitions, this.businessObjectFormatServiceTestHelper.getTestSchema(), updatedBusinessObjectFormat);
        attributeDefinitions = new ArrayList();
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1".toUpperCase(), AbstractServiceTest.PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1".toLowerCase(), AbstractServiceTest.PUBLISH_ATTRIBUTE));
        request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("Duplicate attribute definition name \"%s\" found.", "Attribute Name 1".toLowerCase()), (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsDuplicateAttributeDefinitions() {
        List<Attribute> attributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        BusinessObjectFormat originalBusinessObjectFormat = this.businessObjectFormatServiceTestHelper.createTestBusinessObjectFormat(attributes);
        List<AttributeDefinition> attributeDefinitions = this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions2();
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1", AbstractServiceTest.NO_PUBLISH_ATTRIBUTE));
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(attributeDefinitions);
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)String.format("Duplicate attribute definition name \"%s\" found.", "Attribute Name 1"), (Object)ex.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectFormatAttributeDefinitionsBusinessObjectFormatNoExists() {
        BusinessObjectFormatAttributeDefinitionsUpdateRequest request = new BusinessObjectFormatAttributeDefinitionsUpdateRequest(this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions2());
        try {
            this.businessObjectFormatService.updateBusinessObjectFormatAttributeDefinitions(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), request);
            Assert.fail((String)"Business object format does not exist: No update con be performed if the format does not exists.");
        }
        catch (ObjectNotFoundException ex) {
            Assert.assertEquals((Object)String.format("Business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%s\" doesn't exist.", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectFormatWithAllowNonBackwardsCompatibleChangesSet() {
        this.businessObjectFormatServiceTestHelper.createTestDatabaseEntitiesForBusinessObjectFormatTesting();
        BusinessObjectFormat businessObjectFormatV0 = this.businessObjectFormatService.createBusinessObjectFormat(this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectFormatServiceTestHelper.getTestSchema()));
        Assert.assertNull((Object)businessObjectFormatV0.isAllowNonBackwardsCompatibleChanges());
        BusinessObjectFormatKey businessObjectFormatKeyV0 = new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION);
        Schema nonBackwardsCompatibleSchema = this.businessObjectFormatServiceTestHelper.getTestSchema();
        nonBackwardsCompatibleSchema.setNullValue("NULL");
        BusinessObjectFormatCreateRequest businessObjectFormatCreateRequest = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormatCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, PARTITION_KEY, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), nonBackwardsCompatibleSchema);
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(businessObjectFormatCreateRequest);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version null value does not match to the previous format version null value.", (Object)e.getMessage());
        }
        BusinessObjectFormatEntity businessObjectFormatEntityV0 = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(businessObjectFormatKeyV0);
        Assert.assertNotNull((Object)businessObjectFormatEntityV0);
        businessObjectFormatEntityV0.setAllowNonBackwardsCompatibleChanges(Boolean.valueOf(false));
        Assert.assertFalse((boolean)businessObjectFormatEntityV0.isAllowNonBackwardsCompatibleChanges());
        try {
            this.businessObjectFormatService.createBusinessObjectFormat(businessObjectFormatCreateRequest);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"New format version schema is not \"additive\" to the previous format version schema. New format version null value does not match to the previous format version null value.", (Object)e.getMessage());
        }
        businessObjectFormatV0 = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKeyV0);
        Assert.assertFalse((boolean)businessObjectFormatV0.isAllowNonBackwardsCompatibleChanges());
        businessObjectFormatEntityV0.setAllowNonBackwardsCompatibleChanges(Boolean.valueOf(true));
        Assert.assertTrue((boolean)businessObjectFormatEntityV0.isAllowNonBackwardsCompatibleChanges());
        BusinessObjectFormat businessObjectFormatV1 = this.businessObjectFormatService.createBusinessObjectFormat(businessObjectFormatCreateRequest);
        Assert.assertNotNull((Object)businessObjectFormatV1);
        Assert.assertEquals((Object)true, (Object)businessObjectFormatV1.isAllowNonBackwardsCompatibleChanges());
        Assert.assertEquals((Object)SECOND_FORMAT_VERSION, (Object)businessObjectFormatV1.getBusinessObjectFormatVersion());
        Assert.assertNull((Object)businessObjectFormatEntityV0.isAllowNonBackwardsCompatibleChanges());
        businessObjectFormatV0 = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKeyV0);
        Assert.assertTrue((boolean)businessObjectFormatV0.isAllowNonBackwardsCompatibleChanges());
        BusinessObjectFormat deletedBusinessObjectFormat = this.businessObjectFormatService.deleteBusinessObjectFormat(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, SECOND_FORMAT_VERSION));
        Assert.assertNotNull((Object)deletedBusinessObjectFormat);
        Assert.assertTrue((boolean)deletedBusinessObjectFormat.isAllowNonBackwardsCompatibleChanges());
        businessObjectFormatEntityV0 = this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(businessObjectFormatKeyV0);
        Assert.assertNotNull((Object)businessObjectFormatEntityV0);
        Assert.assertEquals((Object)true, (Object)businessObjectFormatEntityV0.isAllowNonBackwardsCompatibleChanges());
        Assert.assertEquals((Object)INITIAL_FORMAT_VERSION, (Object)businessObjectFormatEntityV0.getBusinessObjectFormatVersion());
        Assert.assertTrue((boolean)businessObjectFormatEntityV0.isAllowNonBackwardsCompatibleChanges());
    }

    private GlobalAttributeDefinitionEntity createGlobalAttributeDefinitionEntityWithAllowedAttributeValues() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(NAMESPACE_CODE, ATTRIBUTE_VALUE_LIST_NAME);
        List<String> allowedAttributeValueList = Arrays.asList("Attribute_Value_1", "Attribute_Value_2");
        AttributeValueListEntity attributeValueListEntity = this.attributeValueListDaoTestHelper.createAttributeValueListEntity(NAMESPACE_CODE, ATTRIBUTE_VALUE_LIST_NAME);
        List allowedAttributeValueEntities = this.allowedAttributeValueDaoTestHelper.createAllowedAttributeValueEntities(attributeValueListKey, allowedAttributeValueList);
        attributeValueListEntity.getAllowedAttributeValues().addAll(allowedAttributeValueEntities);
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        globalAttributeDefinitionEntity.setAttributeValueList(attributeValueListEntity);
        return globalAttributeDefinitionEntity;
    }
}

