/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.CustomDdl;
import org.finra.herd.model.api.xml.CustomDdlKey;
import org.finra.herd.model.api.xml.CustomDdlKeys;
import org.finra.herd.model.jpa.CustomDdlEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class CustomDdlServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateCustomDdl() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        CustomDdl resultCustomDdl = this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
        this.customDdlServiceTestHelper.validateCustomDdl(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;", resultCustomDdl);
    }

    @Test
    public void testCreateCustomDdlMissingRequiredParameters() {
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A custom DDL name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"DDL must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateCustomDdlTrimParameters() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        CustomDdl resultCustomDdl = this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(CUSTOM_DDL_NAME), this.addWhitespace("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;")));
        this.customDdlServiceTestHelper.validateCustomDdl(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;", resultCustomDdl);
    }

    @Test
    public void testCreateCustomDdlUpperCaseParameters() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, FORMAT_DESCRIPTION.toLowerCase(), FORMAT_DOCUMENT_SCHEMA.toLowerCase(), Boolean.valueOf(true), PARTITION_KEY.toLowerCase());
        CustomDdl resultCustomDdl = this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(null, NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase(), resultCustomDdl);
    }

    @Test
    public void testCreateCustomDdlLowerCaseParameters() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, FORMAT_DESCRIPTION.toUpperCase(), FORMAT_DOCUMENT_SCHEMA.toUpperCase(), Boolean.valueOf(true), PARTITION_KEY.toUpperCase());
        CustomDdl resultCustomDdl = this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(null, NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase(), resultCustomDdl);
    }

    @Test
    public void testCreateCustomDdlInvalidParameters() {
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(this.addSlash(NAMESPACE), BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, this.addSlash(BDEF_NAME), FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, this.addSlash(FORMAT_USAGE_CODE), FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, this.addSlash(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format file type can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, this.addSlash(CUSTOM_DDL_NAME), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Custom DDL name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateCustomDdlBusinessObjectFormatNoExists() {
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object format does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateCustomDdlCustomDdlAlreadyExists() {
        this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        try {
            this.customDdlService.createCustomDdl(this.customDdlServiceTestHelper.createCustomDdlCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;"));
            Assert.fail((String)"Should throw an AlreadyExistsException when custom DDL already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create custom DDL with name \"%s\" because it already exists for the business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", CUSTOM_DDL_NAME.toLowerCase(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetCustomDdl() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        CustomDdl resultCustomDdl = this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;", resultCustomDdl);
    }

    @Test
    public void testGetCustomDdlMissingRequiredParameters() {
        try {
            this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A custom DDL name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetCustomDdlTrimParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        CustomDdl resultCustomDdl = this.customDdlService.getCustomDdl(new CustomDdlKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(CUSTOM_DDL_NAME)));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;", resultCustomDdl);
    }

    @Test
    public void testGetCustomDdlUpperCaseParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase());
        CustomDdl resultCustomDdl = this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase(), resultCustomDdl);
    }

    @Test
    public void testGetCustomDdlLowerCaseParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase());
        CustomDdl resultCustomDdl = this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase(), resultCustomDdl);
    }

    @Test
    public void testGetCustomDdlCustomDdlNoExists() {
        try {
            this.customDdlService.getCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when custom DDL does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Custom DDL with name \"%s\" does not exist for business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\".", CUSTOM_DDL_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetCustomDdls() {
        List<String> testCustomDdlNames = Arrays.asList(CUSTOM_DDL_NAME, CUSTOM_DDL_NAME_2);
        for (String customDdlName : testCustomDdlNames) {
            this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, customDdlName, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        }
        CustomDdlKeys resultCustomDdlKeys = this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION));
        Assert.assertNotNull((Object)resultCustomDdlKeys);
        Assert.assertEquals((long)testCustomDdlNames.size(), (long)resultCustomDdlKeys.getCustomDdlKeys().size());
        for (int i = 0; i < testCustomDdlNames.size(); ++i) {
            Assert.assertEquals((Object)new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testCustomDdlNames.get(i)), resultCustomDdlKeys.getCustomDdlKeys().get(i));
        }
    }

    @Test
    public void testGetCustomDdlsMissingRequiredParameters() {
        try {
            this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetCustomDdlsTrimParameters() {
        List<String> testCustomDdlNames = Arrays.asList(CUSTOM_DDL_NAME, CUSTOM_DDL_NAME_2);
        for (String customDdlName : testCustomDdlNames) {
            this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, customDdlName, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        }
        CustomDdlKeys resultCustomDdlKeys = this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION));
        Assert.assertNotNull((Object)resultCustomDdlKeys);
        Assert.assertEquals((long)testCustomDdlNames.size(), (long)resultCustomDdlKeys.getCustomDdlKeys().size());
        for (int i = 0; i < testCustomDdlNames.size(); ++i) {
            Assert.assertEquals((Object)new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testCustomDdlNames.get(i)), resultCustomDdlKeys.getCustomDdlKeys().get(i));
        }
    }

    @Test
    public void testGetCustomDdlsUpperCaseParameters() {
        List<String> testCustomDdlNames = Arrays.asList(CUSTOM_DDL_NAME, CUSTOM_DDL_NAME_2);
        for (String customDdlName : testCustomDdlNames) {
            this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, customDdlName.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase());
        }
        CustomDdlKeys resultCustomDdlKeys = this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION));
        Assert.assertNotNull((Object)resultCustomDdlKeys);
        Assert.assertEquals((long)testCustomDdlNames.size(), (long)resultCustomDdlKeys.getCustomDdlKeys().size());
        for (int i = 0; i < testCustomDdlNames.size(); ++i) {
            Assert.assertEquals((Object)new CustomDdlKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, testCustomDdlNames.get(i).toLowerCase()), resultCustomDdlKeys.getCustomDdlKeys().get(i));
        }
    }

    @Test
    public void testGetCustomDdlsLowerCaseParameters() {
        List<String> testCustomDdlNames = Arrays.asList(CUSTOM_DDL_NAME, CUSTOM_DDL_NAME_2);
        for (String customDdlName : testCustomDdlNames) {
            this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, customDdlName.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase());
        }
        CustomDdlKeys resultCustomDdlKeys = this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION));
        Assert.assertNotNull((Object)resultCustomDdlKeys);
        Assert.assertEquals((long)testCustomDdlNames.size(), (long)resultCustomDdlKeys.getCustomDdlKeys().size());
        for (int i = 0; i < testCustomDdlNames.size(); ++i) {
            Assert.assertEquals((Object)new CustomDdlKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, testCustomDdlNames.get(i).toUpperCase()), resultCustomDdlKeys.getCustomDdlKeys().get(i));
        }
    }

    @Test
    public void testGetCustomDdlsBusinessObjectFormatNoExists() {
        try {
            this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object format does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetCustomDdlsCustomDdlsNoExist() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        CustomDdlKeys resultCustomDdlKeys = this.customDdlService.getCustomDdls(new BusinessObjectFormatKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION));
        Assert.assertNotNull((Object)resultCustomDdlKeys);
        Assert.assertEquals((long)0L, (long)resultCustomDdlKeys.getCustomDdlKeys().size());
    }

    @Test
    public void testUpdateCustomDdl() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        CustomDdl updatedCustomDdl = this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;"));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;", updatedCustomDdl);
    }

    @Test
    public void testUpdateCustomDdlMissingRequiredParameters() {
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t "), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A custom DDL name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"DDL must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateCustomDdlTrimParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        CustomDdl updatedCustomDdl = this.customDdlService.updateCustomDdl(new CustomDdlKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(CUSTOM_DDL_NAME)), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest(this.addWhitespace("DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;")));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;", updatedCustomDdl);
    }

    @Test
    public void testUpdateCustomDdlUpperCaseParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase());
        CustomDdl updatedCustomDdl = this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase()), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;".toUpperCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;".toUpperCase(), updatedCustomDdl);
    }

    @Test
    public void testUpdateCustomDdlLowerCaseParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase());
        CustomDdl updatedCustomDdl = this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase()), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;".toLowerCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "DROP TABLE `Test`;\nCREATE EXTERNAL TABLE `TEST`;".toLowerCase(), updatedCustomDdl);
    }

    @Test
    public void testUpdateCustomDdlCustomDdlNoExists() {
        try {
            this.customDdlService.updateCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME), this.customDdlServiceTestHelper.createCustomDdlUpdateRequest("CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when custom DDL does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Custom DDL with name \"%s\" does not exist for business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\".", CUSTOM_DDL_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteCustomDdl() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        CustomDdlKey customDdlKey = new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME);
        Assert.assertNotNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
        CustomDdl deletedCustomDdl = this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;", deletedCustomDdl);
        Assert.assertNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
    }

    @Test
    public void testDeleteCustomDdlMissingRequiredParameters() {
        try {
            this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when custom DDL name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A custom DDL name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteCustomDdlTrimParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;");
        CustomDdlKey customDdlKey = new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME);
        Assert.assertNotNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
        CustomDdl deletedCustomDdl = this.customDdlService.deleteCustomDdl(new CustomDdlKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(CUSTOM_DDL_NAME)));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME, "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;", deletedCustomDdl);
        Assert.assertNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
    }

    @Test
    public void testDeleteCustomDdlUpperCaseParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase());
        CustomDdlKey customDdlKey = new CustomDdlKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase());
        Assert.assertNotNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
        CustomDdl deletedCustomDdl = this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toLowerCase(), deletedCustomDdl);
        Assert.assertNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
    }

    @Test
    public void testDeleteCustomDdlLowerCaseParameters() {
        CustomDdlEntity customDdlEntity = this.customDdlDaoTestHelper.createCustomDdlEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase());
        CustomDdlKey customDdlKey = new CustomDdlKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase());
        Assert.assertNotNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
        CustomDdl deletedCustomDdl = this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toLowerCase()));
        this.customDdlServiceTestHelper.validateCustomDdl(customDdlEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, CUSTOM_DDL_NAME.toUpperCase(), "CREATE EXTERNAL TABLE `ITEMS` (\n    `ORGNL_TRANSFORM` INT,\n    `DATA` DOUBLE)\nPARTITIONED BY (`TRANSFORM` INT)\nROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '\\\\' NULL DEFINED AS '\\001'\nSTORED AS TEXTFILE;".toUpperCase(), deletedCustomDdl);
        Assert.assertNull((Object)this.customDdlDao.getCustomDdlByKey(customDdlKey));
    }

    @Test
    public void testDeleteCustomDdlCustomDdlNoExists() {
        try {
            this.customDdlService.deleteCustomDdl(new CustomDdlKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, CUSTOM_DDL_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when custom DDL does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Custom DDL with name \"%s\" does not exist for business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\".", CUSTOM_DDL_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }
}

