/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.api.xml.CustomDdl;
import org.finra.herd.model.api.xml.CustomDdlCreateRequest;
import org.finra.herd.model.api.xml.CustomDdlKey;
import org.finra.herd.model.api.xml.CustomDdlUpdateRequest;
import org.junit.Assert;
import org.springframework.stereotype.Component;

@Component
public class CustomDdlServiceTestHelper {
    public CustomDdlCreateRequest createCustomDdlCreateRequest(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion, String customDdlName, String ddl) {
        CustomDdlCreateRequest request = new CustomDdlCreateRequest();
        request.setCustomDdlKey(new CustomDdlKey(namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion, customDdlName));
        request.setDdl(ddl);
        return request;
    }

    public CustomDdlUpdateRequest createCustomDdlUpdateRequest(String ddl) {
        CustomDdlUpdateRequest request = new CustomDdlUpdateRequest();
        request.setDdl(ddl);
        return request;
    }

    public String getTestCustomDdl(boolean partitioned) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE EXTERNAL TABLE IF NOT EXISTS `${table.name}` (\n");
        sb.append("    `COLUMN001` TINYINT,\n");
        sb.append("    `COLUMN002` SMALLINT COMMENT 'This is \\'COLUMN002\\' column. ");
        sb.append("Here are \\'single\\' and \"double\" quotes along with a backslash \\.',\n");
        sb.append("    `COLUMN003` INT,\n");
        sb.append("    `COLUMN004` BIGINT,\n");
        sb.append("    `COLUMN005` FLOAT,\n");
        sb.append("    `COLUMN006` DOUBLE,\n");
        sb.append("    `COLUMN007` DECIMAL,\n");
        sb.append("    `COLUMN008` DECIMAL(p,s),\n");
        sb.append("    `COLUMN009` DECIMAL,\n");
        sb.append("    `COLUMN010` DECIMAL(p),\n");
        sb.append("    `COLUMN011` DECIMAL(p,s),\n");
        sb.append("    `COLUMN012` TIMESTAMP,\n");
        sb.append("    `COLUMN013` DATE,\n");
        sb.append("    `COLUMN014` STRING,\n");
        sb.append("    `COLUMN015` VARCHAR(n),\n");
        sb.append("    `COLUMN016` VARCHAR(n),\n");
        sb.append("    `COLUMN017` CHAR(n),\n");
        sb.append("    `COLUMN018` BOOLEAN,\n");
        sb.append("    `COLUMN019` BINARY)\n");
        if (partitioned) {
            sb.append("PARTITIONED BY (`PRTN_CLMN001` DATE, `PRTN_CLMN002` STRING, `PRTN_CLMN003` INT, `PRTN_CLMN004` DECIMAL, `PRTN_CLMN005` BOOLEAN, `PRTN_CLMN006` DECIMAL, `PRTN_CLMN007` DECIMAL)\n");
        }
        sb.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'\n");
        if (partitioned) {
            sb.append("STORED AS TEXTFILE;");
        } else {
            sb.append("STORED AS TEXTFILE\n");
            sb.append("LOCATION '${non-partitioned.table.location}';");
        }
        return sb.toString();
    }

    public void validateCustomDdl(Integer customDdlId, String expectedNamespace, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, String expectedCustomDdlName, String expectedDdl, CustomDdl actualCustomDdl) {
        Assert.assertNotNull((Object)actualCustomDdl);
        if (customDdlId != null) {
            Assert.assertEquals((Object)customDdlId, (Object)actualCustomDdl.getId());
        }
        Assert.assertEquals((Object)new CustomDdlKey(expectedNamespace, expectedBusinessObjectDefinitionName, expectedBusinessObjectFormatUsage, expectedBusinessObjectFormatFileType, expectedBusinessObjectFormatVersion, expectedCustomDdlName), (Object)actualCustomDdl.getCustomDdlKey());
        Assert.assertEquals((Object)expectedDdl, (Object)actualCustomDdl.getDdl());
    }
}

