/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.EmrClusterDefinitionCreateRequest;
import org.finra.herd.model.api.xml.EmrClusterDefinitionInformation;
import org.finra.herd.model.api.xml.EmrClusterDefinitionKey;
import org.finra.herd.model.api.xml.EmrClusterDefinitionKeys;
import org.finra.herd.model.api.xml.EmrClusterDefinitionUpdateRequest;
import org.finra.herd.model.api.xml.InstanceDefinition;
import org.finra.herd.model.api.xml.NodeTag;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.EmrClusterDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.EmrClusterDefinitionServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class EmrClusterDefinitionServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateEmrClusterDefinition() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.createEmrClusterDefinition(request);
        this.validateEmrClusterDefinition(null, NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterDefinitionMissingRequiredParameters() throws Exception {
        NodeTag nodeTag;
        EmrClusterDefinition emrClusterDefinitionConfiguration;
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest("      \t\t ", EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, "      \t\t ", this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An EMR cluster definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, null));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition configuration is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An EMR cluster definition configuration must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.setInstanceDefinitions(null);
            emrClusterDefinitionConfiguration.setInstanceFleets(null);
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Instance group definitions or instance fleets must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().setMasterInstances(null);
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when master instances are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Master instances must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getMasterInstances().setInstanceCount(0);
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance count is less than one for master instances.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 1 master instance must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getMasterInstances().setInstanceType("      \t\t ");
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance type for master instances is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An instance type for master instances must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getCoreInstances().setInstanceCount(-1);
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance count is less than one for core instances.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 0 core instance must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getCoreInstances().setInstanceType("      \t\t ");
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance type for core instances is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An instance type for core instances must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.setNodeTags(new ArrayList());
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when node tags are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Node tags must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            nodeTag = new NodeTag();
            nodeTag.setTagName("      \t\t ");
            nodeTag.setTagValue("Attribute Value 1");
            emrClusterDefinitionConfiguration.getNodeTags().add(nodeTag);
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when node tag name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A node tag name must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            nodeTag = new NodeTag();
            nodeTag.setTagName("Attribute Name 1");
            nodeTag.setTagValue("      \t\t ");
            emrClusterDefinitionConfiguration.getNodeTags().add(nodeTag);
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when node tag value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A node tag value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterDefinitionTrimParameters() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(this.addWhitespace(NAMESPACE), this.addWhitespace(EMR_CLUSTER_DEFINITION_NAME), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.createEmrClusterDefinition(request);
        this.validateEmrClusterDefinition(null, NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterDefinitionUpperCaseParameters() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toLowerCase());
        EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.createEmrClusterDefinition(request);
        this.validateEmrClusterDefinition(null, NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterDefinitionLowerCaseParameters() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toUpperCase());
        EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.createEmrClusterDefinition(request);
        this.validateEmrClusterDefinition(null, NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterDefinitionInvalidParameters() throws Exception {
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(this.addSlash(NAMESPACE), EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, this.addSlash(EMR_CLUSTER_DEFINITION_NAME), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"EMR cluster definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterDefinitionNamespaceNoExists() throws Exception {
        String testNamespace = "I_DO_NOT_EXIST";
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(testNamespace, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an ObjectNotFoundException when namespace is not specified.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", testNamespace), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterDefinitionEmrClusterDefinitionAlreadyExists() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an AlreadyExistsException when EMR cluster definition already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create EMR cluster definition with name \"%s\" for namespace \"%s\" because it already exists.", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEmrClusterDefinitionMaxInstancesSetToZero() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.MAX_EMR_INSTANCES_COUNT.getKey(), "0");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
            EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.createEmrClusterDefinition(request);
            this.validateEmrClusterDefinition(null, NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEmrClusterDefinitionMaxInstancesExceeded() throws Exception {
        Integer TEST_MAX_EMR_INSTANCES_COUNT = 10;
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.MAX_EMR_INSTANCES_COUNT.getKey(), TEST_MAX_EMR_INSTANCES_COUNT.toString());
        this.modifyPropertySourceInEnvironment(overrideMap);
        EmrClusterDefinition emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
        emrClusterDefinitionConfiguration.getInstanceDefinitions().getMasterInstances().setInstanceCount(TEST_MAX_EMR_INSTANCES_COUNT.intValue());
        emrClusterDefinitionConfiguration.getInstanceDefinitions().getCoreInstances().setInstanceCount(1);
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when total number of instances exceeds maximum allowed.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Total number of instances requested can not exceed : %d", TEST_MAX_EMR_INSTANCES_COUNT), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testCreateEmrClusterDefinitionDuplicateNodeTags() throws Exception {
        try {
            EmrClusterDefinition emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            for (int i = 0; i < 2; ++i) {
                NodeTag nodeTag = new NodeTag();
                nodeTag.setTagName("Attribute Name 1");
                nodeTag.setTagValue("Attribute Value 1");
                emrClusterDefinitionConfiguration.getNodeTags().add(nodeTag);
            }
            this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate node tag names are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate node tag \"%s\" is found.", "Attribute Name 1"), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEmrClusterDefinitionMissingMandatoryNodeTags() throws Exception {
        List<String> testMandatoryAwsTagNames = Arrays.asList("Attribute Name 1", "Attribute Name 2", "Attribute Name 3");
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.MANDATORY_AWS_TAGS.getKey(), StringUtils.join(testMandatoryAwsTagNames, (String)"|"));
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            for (String mandatoryAwsTagName : testMandatoryAwsTagNames) {
                EmrClusterDefinition emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
                emrClusterDefinitionConfiguration.setNodeTags(this.getTestNodeTags(testMandatoryAwsTagNames, mandatoryAwsTagName));
                try {
                    this.emrClusterDefinitionService.createEmrClusterDefinition(this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinitionConfiguration));
                    Assert.fail((String)String.format("Should throw an IllegalArgumentException when \"%s\" required AWS node tag is not specified.", mandatoryAwsTagName));
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)String.format("Mandatory AWS tag not specified: \"%s\"", mandatoryAwsTagName), (Object)e.getMessage());
                }
            }
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testCreateEmrClusterDefinitionCoreInstanceCount0AssertResponseCoreInstanceDefinitionIsNull() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        InstanceDefinition coreInstanceDefinition = new InstanceDefinition(0, "m1.medium", NO_EMR_CLUSTER_DEFINITION_EBS_CONFIGURATION, NO_INSTANCE_SPOT_PRICE, NO_INSTANCE_MAX_SEARCH_PRICE, NO_INSTANCE_ON_DEMAND_THRESHOLD);
        request.getEmrClusterDefinition().getInstanceDefinitions().setCoreInstances(coreInstanceDefinition);
        EmrClusterDefinitionInformation emrClusterDefinitionInformation = this.emrClusterDefinitionService.createEmrClusterDefinition(request);
        Assert.assertNull((Object)emrClusterDefinitionInformation.getEmrClusterDefinition().getInstanceDefinitions().getCoreInstances());
    }

    @Test
    public void testCreateEmrClusterDefinitionCoreInstanceCountNegativeAssertException() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionCreateRequest request = this.createEmrClusterDefinitionCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        InstanceDefinition coreInstanceDefinition = new InstanceDefinition(-1, "m1.medium", NO_EMR_CLUSTER_DEFINITION_EBS_CONFIGURATION, NO_INSTANCE_SPOT_PRICE, NO_INSTANCE_MAX_SEARCH_PRICE, NO_INSTANCE_ON_DEMAND_THRESHOLD);
        request.getEmrClusterDefinition().getInstanceDefinitions().setCoreInstances(coreInstanceDefinition);
        try {
            this.emrClusterDefinitionService.createEmrClusterDefinition(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 0 core instance must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetEmrClusterDefinition() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME));
        this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testGetEmrClusterDefinitionMissingRequiredParameters() throws Exception {
        try {
            this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey("      \t\t ", EMR_CLUSTER_DEFINITION_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An EMR cluster definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetEmrClusterDefinitionTrimParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(EMR_CLUSTER_DEFINITION_NAME)));
        this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testGetEmrClusterDefinitionUpperCaseParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toLowerCase());
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase()));
        this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testGetEmrClusterDefinitionLowerCaseParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toUpperCase());
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        EmrClusterDefinitionInformation resultEmrClusterDefinition = this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase()));
        this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), resultEmrClusterDefinition);
    }

    @Test
    public void testGetEmrClusterDefinitionEmrClusterDefinitionNoExists() throws Exception {
        String testEmrClusterDefinitionName = "I_DO_NOT_EXIST";
        try {
            this.emrClusterDefinitionService.getEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, testEmrClusterDefinitionName));
            Assert.fail((String)"Should throw an ObjectNotFoundException when EMR cluster definition does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", testEmrClusterDefinitionName, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateEmrClusterDefinition() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinitionMinimal.xml"));
        EmrClusterDefinitionUpdateRequest request = this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation updatedEmrClusterDefinition = this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), request);
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), updatedEmrClusterDefinition);
        });
    }

    @Test
    public void testUpdateEmrClusterDefinitionMissingRequiredParameters() throws Exception {
        NodeTag nodeTag;
        EmrClusterDefinition emrClusterDefinitionConfiguration;
        try {
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey("      \t\t ", EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, "      \t\t "), this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An EMR cluster definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(null));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition configuration is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An EMR cluster definition configuration must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.setInstanceDefinitions(null);
            emrClusterDefinitionConfiguration.setInstanceFleets(null);
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Instance group definitions or instance fleets must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().setMasterInstances(null);
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when master instances are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Master instances must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getMasterInstances().setInstanceCount(0);
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance count is less than one for master instances.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 1 master instance must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getMasterInstances().setInstanceType("      \t\t ");
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance type for master instances is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An instance type for master instances must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getCoreInstances().setInstanceCount(-1);
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance count is less than one for core instances.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 0 core instance must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.getInstanceDefinitions().getCoreInstances().setInstanceType("      \t\t ");
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when instance type for core instances is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An instance type for core instances must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            emrClusterDefinitionConfiguration.setNodeTags(new ArrayList());
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when node tags are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Node tags must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            nodeTag = new NodeTag();
            nodeTag.setTagName("      \t\t ");
            nodeTag.setTagValue("Attribute Value 1");
            emrClusterDefinitionConfiguration.getNodeTags().add(nodeTag);
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when node tag name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A node tag name must be specified.", (Object)e.getMessage());
        }
        try {
            emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            nodeTag = new NodeTag();
            nodeTag.setTagName("Attribute Name 1");
            nodeTag.setTagValue("      \t\t ");
            emrClusterDefinitionConfiguration.getNodeTags().add(nodeTag);
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when node tag value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A node tag value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateEmrClusterDefinitionTrimParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinitionMinimal.xml"));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation updatedEmrClusterDefinition = this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(EMR_CLUSTER_DEFINITION_NAME)), this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), updatedEmrClusterDefinition);
        });
    }

    @Test
    public void testUpdateEmrClusterDefinitionUpperCaseParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toLowerCase());
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinitionMinimal.xml"));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation updatedEmrClusterDefinition = this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase()), this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), updatedEmrClusterDefinition);
        });
    }

    @Test
    public void testUpdateEmrClusterDefinitionLowerCaseParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toUpperCase());
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinitionMinimal.xml"));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation updatedEmrClusterDefinition = this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase()), this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), updatedEmrClusterDefinition);
        });
    }

    @Test
    public void testUpdateEmrClusterDefinitionEmrClusterDefinitionNoExists() throws Exception {
        String testEmrClusterDefinitionName = "I_DO_NOT_EXIST";
        try {
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, testEmrClusterDefinitionName), this.createEmrClusterDefinitionUpdateRequest(this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml")));
            Assert.fail((String)"Should throw an ObjectNotFoundException when EMR cluster definition does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", testEmrClusterDefinitionName, NAMESPACE), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEmrClusterDefinitionMaxInstancesExceeded() throws Exception {
        Integer TEST_MAX_EMR_INSTANCES_COUNT = 10;
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.MAX_EMR_INSTANCES_COUNT.getKey(), TEST_MAX_EMR_INSTANCES_COUNT.toString());
        this.modifyPropertySourceInEnvironment(overrideMap);
        EmrClusterDefinition emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
        emrClusterDefinitionConfiguration.getInstanceDefinitions().getMasterInstances().setInstanceCount(TEST_MAX_EMR_INSTANCES_COUNT.intValue());
        emrClusterDefinitionConfiguration.getInstanceDefinitions().getCoreInstances().setInstanceCount(1);
        try {
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when total number of instances exceeds maximum allowed.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Total number of instances requested can not exceed : %d", TEST_MAX_EMR_INSTANCES_COUNT), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testUpdateEmrClusterDefinitionDuplicateNodeTags() throws Exception {
        try {
            EmrClusterDefinition emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
            for (int i = 0; i < 2; ++i) {
                NodeTag nodeTag = new NodeTag();
                nodeTag.setTagName("Attribute Name 1");
                nodeTag.setTagValue("Attribute Value 1");
                emrClusterDefinitionConfiguration.getNodeTags().add(nodeTag);
            }
            this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate node tag names are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate node tag \"%s\" is found.", "Attribute Name 1"), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEmrClusterDefinitionMissingMandatoryNodeTags() throws Exception {
        List<String> testMandatoryAwsTagNames = Arrays.asList("Attribute Name 1", "Attribute Name 2", "Attribute Name 3");
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.MANDATORY_AWS_TAGS.getKey(), StringUtils.join(testMandatoryAwsTagNames, (String)"|"));
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            for (String mandatoryAwsTagName : testMandatoryAwsTagNames) {
                EmrClusterDefinition emrClusterDefinitionConfiguration = this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml");
                emrClusterDefinitionConfiguration.setNodeTags(this.getTestNodeTags(testMandatoryAwsTagNames, mandatoryAwsTagName));
                try {
                    this.emrClusterDefinitionService.updateEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME), this.createEmrClusterDefinitionUpdateRequest(emrClusterDefinitionConfiguration));
                    Assert.fail((String)String.format("Should throw an IllegalArgumentException when \"%s\" required AWS node tag is not specified.", mandatoryAwsTagName));
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)String.format("Mandatory AWS tag not specified: \"%s\"", mandatoryAwsTagName), (Object)e.getMessage());
                }
            }
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testDeleteEmrClusterDefinition() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        Assert.assertNotNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation deletedEmrClusterDefinition = this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), deletedEmrClusterDefinition);
            Assert.assertNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME));
        });
    }

    @Test
    public void testDeleteEmrClusterDefinitionMissingRequiredParameters() throws Exception {
        try {
            this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey("      \t\t ", EMR_CLUSTER_DEFINITION_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An EMR cluster definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteEmrClusterDefinitionTrimParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        Assert.assertNotNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation deletedEmrClusterDefinition = this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey(this.addWhitespace(NAMESPACE), this.addWhitespace(EMR_CLUSTER_DEFINITION_NAME)));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), deletedEmrClusterDefinition);
            Assert.assertNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME));
        });
    }

    @Test
    public void testDeleteEmrClusterDefinitionUpperCaseParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toLowerCase());
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        Assert.assertNotNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toLowerCase()));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation deletedEmrClusterDefinition = this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase()));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), deletedEmrClusterDefinition);
            Assert.assertNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toLowerCase()));
        });
    }

    @Test
    public void testDeleteEmrClusterDefinitionLowerCaseParameters() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toUpperCase());
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfigurationXml("classpath:testEmrClusterDefinition.xml"));
        Assert.assertNotNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toUpperCase()));
        this.executeWithoutLogging(EmrClusterDefinitionServiceImpl.class, () -> {
            EmrClusterDefinitionInformation deletedEmrClusterDefinition = this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE.toLowerCase(), EMR_CLUSTER_DEFINITION_NAME.toLowerCase()));
            this.validateEmrClusterDefinition(emrClusterDefinitionEntity.getId(), NAMESPACE.toUpperCase(), EMR_CLUSTER_DEFINITION_NAME.toUpperCase(), this.getTestEmrClusterDefinitionConfiguration("classpath:testEmrClusterDefinition.xml"), deletedEmrClusterDefinition);
            Assert.assertNull((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME.toUpperCase()));
        });
    }

    @Test
    public void testDeleteEmrClusterDefinitionEmrClusterDefinitionNoExists() throws Exception {
        String testEmrClusterDefinitionName = "I_DO_NOT_EXIST";
        try {
            this.emrClusterDefinitionService.deleteEmrClusterDefinition(new EmrClusterDefinitionKey(NAMESPACE, testEmrClusterDefinitionName));
            Assert.fail((String)"Should throw an ObjectNotFoundException when EMR cluster definition does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", testEmrClusterDefinitionName, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetEmrClusterDefinitions() throws Exception {
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE), EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterDefinitionKey emrClusterDefinitionKey = new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME);
        Assert.assertEquals((Object)new EmrClusterDefinitionKeys(Arrays.asList(emrClusterDefinitionKey)), (Object)this.emrClusterDefinitionService.getEmrClusterDefinitions(NAMESPACE));
    }

    @Test
    public void testGetEmrClusterDefinitionsMissingRequiredParameters() throws Exception {
        try {
            this.emrClusterDefinitionService.getEmrClusterDefinitions("      \t\t ");
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetEmrClusterDefinitionsTrimParameters() throws Exception {
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE), EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterDefinitionKey emrClusterDefinitionKey = new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME);
        Assert.assertEquals((Object)new EmrClusterDefinitionKeys(Arrays.asList(emrClusterDefinitionKey)), (Object)this.emrClusterDefinitionService.getEmrClusterDefinitions(this.addWhitespace(NAMESPACE)));
    }

    @Test
    public void testGetEmrClusterDefinitionsUpperCaseParameters() throws Exception {
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE), EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterDefinitionKey emrClusterDefinitionKey = new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME);
        Assert.assertEquals((Object)new EmrClusterDefinitionKeys(Arrays.asList(emrClusterDefinitionKey)), (Object)this.emrClusterDefinitionService.getEmrClusterDefinitions(NAMESPACE.toUpperCase()));
    }

    @Test
    public void testGetEmrClusterDefinitionsLowerCaseParameters() throws Exception {
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE), EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterDefinitionKey emrClusterDefinitionKey = new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME);
        Assert.assertEquals((Object)new EmrClusterDefinitionKeys(Arrays.asList(emrClusterDefinitionKey)), (Object)this.emrClusterDefinitionService.getEmrClusterDefinitions(NAMESPACE.toLowerCase()));
    }

    @Test
    public void testGetEmrClusterDefinitionsNamespaceNoExists() throws Exception {
        Assert.assertEquals((Object)new EmrClusterDefinitionKeys(new ArrayList()), (Object)this.emrClusterDefinitionService.getEmrClusterDefinitions("I_DO_NOT_EXIST"));
    }

    private String getTestEmrClusterDefinitionConfigurationXml(String xmlFileClasspath) throws Exception {
        return IOUtils.toString((InputStream)this.resourceLoader.getResource(xmlFileClasspath).getInputStream());
    }

    private EmrClusterDefinition getTestEmrClusterDefinitionConfiguration(String xmlFileClasspath) throws Exception {
        String xmlString = this.getTestEmrClusterDefinitionConfigurationXml(xmlFileClasspath);
        return (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, xmlString);
    }

    private EmrClusterDefinitionCreateRequest createEmrClusterDefinitionCreateRequest(String namespace, String emrClusterDefinitionName, EmrClusterDefinition emrClusterDefinitionConfiguration) {
        EmrClusterDefinitionCreateRequest request = new EmrClusterDefinitionCreateRequest();
        request.setEmrClusterDefinitionKey(new EmrClusterDefinitionKey(namespace, emrClusterDefinitionName));
        request.setEmrClusterDefinition(emrClusterDefinitionConfiguration);
        return request;
    }

    private EmrClusterDefinitionUpdateRequest createEmrClusterDefinitionUpdateRequest(EmrClusterDefinition emrClusterDefinitionConfiguration) {
        EmrClusterDefinitionUpdateRequest request = new EmrClusterDefinitionUpdateRequest();
        request.setEmrClusterDefinition(emrClusterDefinitionConfiguration);
        return request;
    }

    private void validateEmrClusterDefinition(Integer expectedEmrClusterDefinitionId, String expectedNamespace, String expectedEmrClusterDefinitionName, EmrClusterDefinition expectedEmrClusterConfiguration, EmrClusterDefinitionInformation actualEmrClusterDefinition) {
        Assert.assertNotNull((Object)actualEmrClusterDefinition);
        if (expectedEmrClusterDefinitionId != null) {
            Assert.assertEquals((Object)expectedEmrClusterDefinitionId, (Object)actualEmrClusterDefinition.getId());
        }
        Assert.assertEquals((Object)expectedNamespace, (Object)actualEmrClusterDefinition.getEmrClusterDefinitionKey().getNamespace());
        Assert.assertEquals((Object)expectedEmrClusterDefinitionName, (Object)actualEmrClusterDefinition.getEmrClusterDefinitionKey().getEmrClusterDefinitionName());
        Assert.assertEquals((Object)expectedEmrClusterConfiguration, (Object)actualEmrClusterDefinition.getEmrClusterDefinition());
    }

    private List<NodeTag> getTestNodeTags(List<String> nodeTagNames, String excludedNodeTagName) {
        ArrayList<NodeTag> nodeTags = new ArrayList<NodeTag>();
        for (String nodeTagName : nodeTagNames) {
            if (nodeTagName.equals(excludedNodeTagName)) continue;
            NodeTag nodeTag = new NodeTag();
            nodeTag.setTagName(nodeTagName);
            nodeTag.setTagValue("Attribute Value 1");
            nodeTags.add(nodeTag);
        }
        return nodeTags;
    }
}

