/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListStepsResult;
import com.amazonaws.services.elasticmapreduce.model.StepSummary;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.finra.herd.dao.EmrDao;
import org.finra.herd.dao.EmrOperations;
import org.finra.herd.dao.helper.EmrHelper;
import org.finra.herd.dao.impl.MockAwsOperationsHelper;
import org.finra.herd.dao.impl.MockEc2OperationsImpl;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.ConfigurationFiles;
import org.finra.herd.model.api.xml.EmrCluster;
import org.finra.herd.model.api.xml.EmrClusterCreateRequest;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.EmrClusterDefinitionInstanceFleet;
import org.finra.herd.model.api.xml.EmrClusterDefinitionKerberosAttributes;
import org.finra.herd.model.api.xml.EmrClusterDefinitionKey;
import org.finra.herd.model.api.xml.EmrHadoopJarStep;
import org.finra.herd.model.api.xml.EmrHadoopJarStepAddRequest;
import org.finra.herd.model.api.xml.EmrHiveStepAddRequest;
import org.finra.herd.model.api.xml.EmrMasterSecurityGroup;
import org.finra.herd.model.api.xml.EmrMasterSecurityGroupAddRequest;
import org.finra.herd.model.api.xml.EmrPigStepAddRequest;
import org.finra.herd.model.api.xml.EmrShellStep;
import org.finra.herd.model.api.xml.EmrShellStepAddRequest;
import org.finra.herd.model.api.xml.HadoopJarStep;
import org.finra.herd.model.api.xml.InstanceDefinition;
import org.finra.herd.model.api.xml.InstanceDefinitions;
import org.finra.herd.model.api.xml.KeyValuePairConfigurations;
import org.finra.herd.model.api.xml.NodeTag;
import org.finra.herd.model.api.xml.ScriptDefinition;
import org.finra.herd.model.dto.AwsParamsDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.EmrClusterAlternateKeyDto;
import org.finra.herd.model.jpa.EmrClusterCreationLogEntity;
import org.finra.herd.model.jpa.EmrClusterCreationLogEntity_;
import org.finra.herd.model.jpa.EmrClusterDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.NamespaceEntity_;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.EmrService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.EmrClusterDefinitionDaoHelper;
import org.finra.herd.service.helper.EmrStepHelper;
import org.finra.herd.service.helper.NamespaceDaoHelper;
import org.finra.herd.service.impl.EmrServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.util.ReflectionTestUtils;

public class EmrServiceTest
extends AbstractServiceTest {
    @Autowired
    private EmrOperations emrOperations;
    @Autowired
    @Qualifier(value="emrServiceImpl")
    private EmrService emrServiceImpl;

    @Before
    public void createDatabaseEntities() {
        this.ec2OnDemandPricingDaoTestHelper.createEc2OnDemandPricingEntities();
    }

    @Test
    public void testAddSecurityGroup() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequest(request.getEmrClusterName());
        EmrMasterSecurityGroup emrMasterSecurityGroup = this.emrService.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
        Assert.assertNotNull((Object)emrMasterSecurityGroup);
        Assert.assertTrue((boolean)emrMasterSecurityGroup.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrMasterSecurityGroup.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrMasterSecurityGroup.getEmrClusterName().equals(request.getEmrClusterName()));
    }

    @Test(expected=AmazonServiceException.class)
    public void testAddSecurityGroupAmazonException() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequest(request.getEmrClusterName());
        emrMasterSecurityGroupAddRequest.getSecurityGroupIds().clear();
        emrMasterSecurityGroupAddRequest.getSecurityGroupIds().add("amazon_service_exception");
        this.emrService.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSecurityGroupClusterDoesNotExist() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequest("DOES_NOT_EXIST");
        this.emrService.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSecurityGroupEC2InstanceNotProvisioned() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        request.setEmrClusterName("mock_cluster_not_provisioned_name");
        this.emrService.createCluster(request);
        EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequest(request.getEmrClusterName());
        this.emrService.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSecurityGroupNoneSpecified() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequest(request.getEmrClusterName());
        emrMasterSecurityGroupAddRequest.setSecurityGroupIds(null);
        this.emrService.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
    }

    @Test
    public void testCreateEmrCluster() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        Assert.assertEquals((Object)"scaleDownBehavior", (Object)expectedEmrClusterDefinition.getScaleDownBehavior());
        Assert.assertNotNull((Object)expectedEmrClusterDefinition.getKerberosAttributes());
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNull((Object)emrCluster.getAccountId());
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterAdditionalInfo() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAdditionalInfo("{ami64: \"ami-e82af080\", amiHvm64: \"ami-e82af080\", hadoopVersion: \"2.4.0\", hadoopConfigurationVersion: \"3.1\"}");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateEmrClusterAmazonBadRequest() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion("amazon_bad_request");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateEmrClusterAmazonObjectNotFound() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion("amazon_not_found_exception");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test(expected=AmazonServiceException.class)
    public void testCreateEmrClusterAmazonOtherException() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion("amazon_service_exception");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterBlankParams() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        List scriptDefinitions = emrClusterDefinition.getCustomBootstrapActionAll();
        ((ScriptDefinition)scriptDefinitions.get(0)).setScriptArguments(null);
        emrClusterDefinition.setCustomBootstrapActionAll(scriptDefinitions);
        scriptDefinitions = emrClusterDefinition.getCustomBootstrapActionMaster();
        ((ScriptDefinition)scriptDefinitions.get(0)).setScriptArguments(null);
        emrClusterDefinition.setCustomBootstrapActionMaster(scriptDefinitions);
        emrClusterDefinition.setVisibleToAll(null);
        emrClusterDefinition.setServiceIamRole(null);
        emrClusterDefinition.setAmiVersion(null);
        emrClusterDefinition.setServiceIamRole(emrClusterDefinition.getEc2NodeIamProfileName());
        emrClusterDefinition.setScaleDownBehavior(null);
        emrClusterDefinition.setKerberosAttributes(null);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterDryRunFalseNoOverride() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        request.setDryRun(Boolean.valueOf(false));
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNotNull((Object)emrCluster.isDryRun());
        Assert.assertFalse((boolean)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterDryRunTrueNoOverride() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        request.setDryRun(Boolean.valueOf(true));
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNull((Object)emrCluster.getId());
        Assert.assertNotNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isDryRun());
        Assert.assertFalse((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.assertEmrClusterCreationLogNotExist(emrCluster);
    }

    @Test
    public void testCreateEmrClusterDuplicate() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertFalse((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNull((Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterInstanceNotDefined() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setInstanceDefinitions(null);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        try {
            this.emrService.createCluster(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Instance group definitions or instance fleets must be specified.", (Object)e.getMessage());
        }
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateEmrClusterInvalidDefinition() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateEmrClusterInvalidNamespace() throws Exception {
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterInvalidParameters() throws Exception {
        EmrClusterCreateRequest request;
        try {
            request = this.getNewEmrClusterCreateRequest();
            request.setNamespace(this.addSlash(request.getNamespace()));
            this.emrService.createCluster(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            request = this.getNewEmrClusterCreateRequest();
            request.setEmrClusterDefinitionName(this.addSlash(request.getEmrClusterDefinitionName()));
            this.emrService.createCluster(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"EMR cluster definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            request = this.getNewEmrClusterCreateRequest();
            request.setEmrClusterName(this.addSlash(request.getEmrClusterName()));
            this.emrService.createCluster(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when EMR cluster name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"EMR cluster name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterMandatoryTagsNull() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.MANDATORY_AWS_TAGS.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        this.restorePropertySourceInEnvironment();
    }

    @Test
    public void testCreateEmrClusterMultipleBootstrap() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        ScriptDefinition allScript = (ScriptDefinition)emrClusterDefinition.getCustomBootstrapActionAll().get(0);
        ScriptDefinition secondAllScript = new ScriptDefinition();
        secondAllScript.setScriptName(allScript.getScriptName() + "_second");
        secondAllScript.setScriptLocation(allScript.getScriptLocation());
        secondAllScript.setScriptArguments(allScript.getScriptArguments());
        emrClusterDefinition.getCustomBootstrapActionAll().add(secondAllScript);
        ScriptDefinition masterScript = (ScriptDefinition)emrClusterDefinition.getCustomBootstrapActionMaster().get(0);
        ScriptDefinition secondMasterScript = new ScriptDefinition();
        secondMasterScript.setScriptName(masterScript.getScriptName() + "_second");
        secondMasterScript.setScriptLocation(masterScript.getScriptLocation());
        secondMasterScript.setScriptArguments(masterScript.getScriptArguments());
        emrClusterDefinition.getCustomBootstrapActionMaster().add(secondMasterScript);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.xmlHelper.objectToXml((Object)emrClusterDefinition));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
    }

    @Test
    public void testCreateEmrClusterOverrideAllNull() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterOverrideExistingCoreInstanceTo0InstanceCountAssertSuccess() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        emrClusterDefinition.getInstanceDefinitions().getCoreInstances().setInstanceCount(1);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.xmlHelper.objectToXml((Object)emrClusterDefinition));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setInstanceDefinitions(emrClusterDefinition.getInstanceDefinitions());
        emrClusterDefinitionOverride.getInstanceDefinitions().getCoreInstances().setInstanceCount(0);
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrClusterCreateResponse = this.emrService.createCluster(request);
        Assert.assertNull((Object)emrClusterCreateResponse.getEmrClusterDefinition().getInstanceDefinitions().getCoreInstances());
    }

    @Test
    public void testCreateEmrClusterOverrideExistingCoreInstanceToNegativeInstanceCountAssertException() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        emrClusterDefinition.getInstanceDefinitions().getCoreInstances().setInstanceCount(1);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.xmlHelper.objectToXml((Object)emrClusterDefinition));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setInstanceDefinitions(emrClusterDefinition.getInstanceDefinitions());
        emrClusterDefinitionOverride.getInstanceDefinitions().getCoreInstances().setInstanceCount(-1);
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        try {
            this.emrService.createCluster(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least 0 core instance must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterOverrideExistingCoreInstanceToNullAssertSuccess() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        emrClusterDefinition.getInstanceDefinitions().getCoreInstances().setInstanceCount(1);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.xmlHelper.objectToXml((Object)emrClusterDefinition));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setInstanceDefinitions(emrClusterDefinition.getInstanceDefinitions());
        emrClusterDefinitionOverride.getInstanceDefinitions().setCoreInstances(null);
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrClusterCreateResponse = this.emrService.createCluster(request);
        Assert.assertNull((Object)emrClusterCreateResponse.getEmrClusterDefinition().getInstanceDefinitions().getCoreInstances());
    }

    @Test
    public void testCreateEmrClusterOverrideHadoopConfigurations() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        ArrayList<Object> hadoopConfigurations = new ArrayList<Object>();
        hadoopConfigurations.add(new ConfigurationFiles());
        hadoopConfigurations.add(new KeyValuePairConfigurations());
        emrClusterDefinitionOverride.setHadoopConfigurations(hadoopConfigurations);
        expectedEmrClusterDefinition.setHadoopConfigurations(emrClusterDefinitionOverride.getHadoopConfigurations());
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterOverrideList() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setApplications(Collections.emptyList());
        expectedEmrClusterDefinition.setApplications(emrClusterDefinitionOverride.getApplications());
        emrClusterDefinitionOverride.setConfigurations(Collections.emptyList());
        expectedEmrClusterDefinition.setConfigurations(emrClusterDefinitionOverride.getConfigurations());
        emrClusterDefinitionOverride.setCustomBootstrapActionAll(Collections.emptyList());
        expectedEmrClusterDefinition.setCustomBootstrapActionAll(emrClusterDefinitionOverride.getCustomBootstrapActionAll());
        emrClusterDefinitionOverride.setCustomBootstrapActionMaster(Collections.emptyList());
        expectedEmrClusterDefinition.setCustomBootstrapActionMaster(emrClusterDefinitionOverride.getCustomBootstrapActionMaster());
        emrClusterDefinitionOverride.setDaemonConfigurations(Collections.emptyList());
        expectedEmrClusterDefinition.setDaemonConfigurations(emrClusterDefinitionOverride.getDaemonConfigurations());
        emrClusterDefinitionOverride.setHadoopConfigurations(Collections.emptyList());
        expectedEmrClusterDefinition.setHadoopConfigurations(emrClusterDefinitionOverride.getHadoopConfigurations());
        emrClusterDefinitionOverride.setHadoopJarSteps(Collections.emptyList());
        expectedEmrClusterDefinition.setHadoopJarSteps(emrClusterDefinitionOverride.getHadoopJarSteps());
        emrClusterDefinitionOverride.setAdditionalMasterSecurityGroups(Collections.emptyList());
        expectedEmrClusterDefinition.setAdditionalMasterSecurityGroups(emrClusterDefinitionOverride.getAdditionalMasterSecurityGroups());
        emrClusterDefinitionOverride.setAdditionalSlaveSecurityGroups(Collections.emptyList());
        expectedEmrClusterDefinition.setAdditionalSlaveSecurityGroups(emrClusterDefinitionOverride.getAdditionalSlaveSecurityGroups());
        List nodeTags = expectedEmrClusterDefinition.getNodeTags();
        nodeTags.add(new NodeTag("testTag", "test"));
        emrClusterDefinitionOverride.setNodeTags(nodeTags);
        expectedEmrClusterDefinition.setNodeTags(nodeTags);
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterOverrideObject() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        int instanceCount = expectedEmrClusterDefinition.getInstanceDefinitions().getMasterInstances().getInstanceCount();
        expectedEmrClusterDefinition.getInstanceDefinitions().getMasterInstances().setInstanceCount(instanceCount + 1);
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setInstanceDefinitions(expectedEmrClusterDefinition.getInstanceDefinitions());
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterOverrideInstanceDefinitionsWithInstanceFleets() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setInstanceDefinitions(new InstanceDefinitions());
        emrClusterDefinitionOverride.setInstanceFleets(Arrays.asList(new EmrClusterDefinitionInstanceFleet()));
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        expectedEmrClusterDefinition.setInstanceDefinitions(new InstanceDefinitions());
        expectedEmrClusterDefinition.setInstanceFleets(Arrays.asList(new EmrClusterDefinitionInstanceFleet()));
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterOverrideInstanceFleetsWithInstanceDefinitions() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        InstanceDefinitions instanceDefinitions = expectedEmrClusterDefinition.getInstanceDefinitions();
        expectedEmrClusterDefinition.setInstanceDefinitions(null);
        expectedEmrClusterDefinition.setInstanceFleets(Arrays.asList(new EmrClusterDefinitionInstanceFleet()));
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, this.xmlHelper.objectToXml((Object)expectedEmrClusterDefinition));
        instanceDefinitions.getMasterInstances().setInstanceCount(instanceDefinitions.getMasterInstances().getInstanceCount() + 1);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setInstanceDefinitions(instanceDefinitions);
        emrClusterDefinitionOverride.setInstanceFleets(new ArrayList());
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        expectedEmrClusterDefinition.setInstanceDefinitions(instanceDefinitions);
        expectedEmrClusterDefinition.setInstanceFleets(new ArrayList());
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterOverrideScalar() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setReleaseLabel("4.8.0." + Math.random());
        expectedEmrClusterDefinition.setReleaseLabel(emrClusterDefinitionOverride.getReleaseLabel());
        emrClusterDefinitionOverride.setAdditionalInfo("test" + Math.random());
        expectedEmrClusterDefinition.setAdditionalInfo(emrClusterDefinitionOverride.getAdditionalInfo());
        emrClusterDefinitionOverride.setAmiVersion("test" + Math.random());
        expectedEmrClusterDefinition.setAmiVersion(emrClusterDefinitionOverride.getAmiVersion());
        emrClusterDefinitionOverride.setEc2NodeIamProfileName("test" + Math.random());
        expectedEmrClusterDefinition.setEc2NodeIamProfileName(emrClusterDefinitionOverride.getEc2NodeIamProfileName());
        emrClusterDefinitionOverride.setEncryptionEnabled(Boolean.valueOf(expectedEmrClusterDefinition.isEncryptionEnabled() == false));
        expectedEmrClusterDefinition.setEncryptionEnabled(emrClusterDefinitionOverride.isEncryptionEnabled());
        emrClusterDefinitionOverride.setHadoopVersion("test" + Math.random());
        expectedEmrClusterDefinition.setHadoopVersion(emrClusterDefinitionOverride.getHadoopVersion());
        emrClusterDefinitionOverride.setHiveVersion("test" + Math.random());
        expectedEmrClusterDefinition.setHiveVersion(emrClusterDefinitionOverride.getHiveVersion());
        emrClusterDefinitionOverride.setInstallOozie(Boolean.valueOf(expectedEmrClusterDefinition.isInstallOozie() == false));
        expectedEmrClusterDefinition.setInstallOozie(emrClusterDefinitionOverride.isInstallOozie());
        emrClusterDefinitionOverride.setKeepAlive(Boolean.valueOf(expectedEmrClusterDefinition.isKeepAlive() == false));
        expectedEmrClusterDefinition.setKeepAlive(emrClusterDefinitionOverride.isKeepAlive());
        emrClusterDefinitionOverride.setLogBucket("test" + Math.random());
        expectedEmrClusterDefinition.setLogBucket(emrClusterDefinitionOverride.getLogBucket());
        emrClusterDefinitionOverride.setPigVersion("test" + Math.random());
        expectedEmrClusterDefinition.setPigVersion(emrClusterDefinitionOverride.getPigVersion());
        emrClusterDefinitionOverride.setServiceIamRole("test" + Math.random());
        expectedEmrClusterDefinition.setServiceIamRole(emrClusterDefinitionOverride.getServiceIamRole());
        emrClusterDefinitionOverride.setSshKeyPairName("test" + Math.random());
        expectedEmrClusterDefinition.setSshKeyPairName(emrClusterDefinitionOverride.getSshKeyPairName());
        emrClusterDefinitionOverride.setSubnetId(MockEc2OperationsImpl.SUBNET_1);
        expectedEmrClusterDefinition.setSubnetId(emrClusterDefinitionOverride.getSubnetId());
        emrClusterDefinitionOverride.setSupportedProduct("test" + Math.random());
        expectedEmrClusterDefinition.setSupportedProduct(emrClusterDefinitionOverride.getSupportedProduct());
        emrClusterDefinitionOverride.setSecurityConfiguration("test" + Math.random());
        expectedEmrClusterDefinition.setSecurityConfiguration(emrClusterDefinitionOverride.getSecurityConfiguration());
        emrClusterDefinitionOverride.setScaleDownBehavior("test" + Math.random());
        expectedEmrClusterDefinition.setScaleDownBehavior(emrClusterDefinitionOverride.getScaleDownBehavior());
        emrClusterDefinitionOverride.setTerminationProtection(Boolean.valueOf(expectedEmrClusterDefinition.isTerminationProtection() == false));
        expectedEmrClusterDefinition.setTerminationProtection(emrClusterDefinitionOverride.isTerminationProtection());
        emrClusterDefinitionOverride.setVisibleToAll(Boolean.valueOf(expectedEmrClusterDefinition.isVisibleToAll() == false));
        expectedEmrClusterDefinition.setVisibleToAll(emrClusterDefinitionOverride.isVisibleToAll());
        emrClusterDefinitionOverride.setKerberosAttributes(new EmrClusterDefinitionKerberosAttributes("test" + Math.random(), "test" + Math.random(), "test" + Math.random(), "test" + Math.random(), "test" + Math.random()));
        expectedEmrClusterDefinition.setKerberosAttributes(emrClusterDefinitionOverride.getKerberosAttributes());
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterSecurityConfiguration() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setSecurityConfiguration("securityConfiguration");
        emrClusterDefinition.setReleaseLabel("4.8.0");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterSecurityConfigurationInvalidReleaseLabel() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setSecurityConfiguration("securityConfiguration");
        emrClusterDefinition.setReleaseLabel("4.7.9");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        try {
            this.emrService.createCluster(this.getNewEmrClusterCreateRequest());
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"EMR security configuration is not supported prior to EMR release 4.8.0.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterSecurityConfigurationNoReleaseLabel() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setSecurityConfiguration("securityConfiguration");
        emrClusterDefinition.setReleaseLabel("      \t\t ");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        try {
            this.emrService.createCluster(this.getNewEmrClusterCreateRequest());
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"EMR security configuration is not supported prior to EMR release 4.8.0.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateEmrClusterSecurityConfigurationReleaseLabelWithPrefix() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setSecurityConfiguration("securityConfiguration");
        emrClusterDefinition.setReleaseLabel("emr-4.8.0");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterServiceRole() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setServiceIamRole(emrClusterDefinition.getEc2NodeIamProfileName());
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterStartupSteps() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
        ListStepsRequest listStepsRequest = new ListStepsRequest().withClusterId(emrCluster.getId());
        ListStepsResult listStepsResult = this.emrOperations.listStepsRequest(null, listStepsRequest);
        List addedSteps = listStepsResult.getSteps();
        for (HadoopJarStep hadoopJarStep : expectedEmrClusterDefinition.getHadoopJarSteps()) {
            boolean stepFound = false;
            for (StepSummary stepSummary : addedSteps) {
                if (!stepSummary.getName().equals(hadoopJarStep.getStepName())) continue;
                stepFound = true;
                break;
            }
            Assert.assertTrue((boolean)stepFound);
        }
    }

    @Test
    public void testCreateEmrClusterSupportedProduct() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setSupportedProduct("mapr-m3");
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testCreateEmrClusterWithTaskInstances() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        InstanceDefinition taskDef = new InstanceDefinition();
        taskDef.setInstanceCount(1);
        taskDef.setInstanceType(MockEc2OperationsImpl.INSTANCE_TYPE_1);
        emrClusterDefinition.getInstanceDefinitions().setTaskInstances(taskDef);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
    }

    @Test
    public void testCreateEmrClusterWithInstanceFleets() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setInstanceFleets(Arrays.asList(new EmrClusterDefinitionInstanceFleet()));
        emrClusterDefinition.setInstanceDefinitions(null);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
    }

    @Test
    public void testCreateEmrClusterWithSecurityGroups() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setMasterSecurityGroup(EMR_MASTER_SECURITY_GROUP);
        emrClusterDefinition.setSlaveSecurityGroup(EMR_SLAVE_SECURITY_GROUP);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinition().getMasterSecurityGroup().equals(EMR_MASTER_SECURITY_GROUP));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinition().getSlaveSecurityGroup().equals(EMR_SLAVE_SECURITY_GROUP));
    }

    @Test
    public void testCreateEmrClusterOverrideSecurityGroups() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        expectedEmrClusterDefinition.setMasterSecurityGroup(EMR_MASTER_SECURITY_GROUP + "override");
        expectedEmrClusterDefinition.setSlaveSecurityGroup(EMR_SLAVE_SECURITY_GROUP + "override");
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setMasterSecurityGroup(EMR_MASTER_SECURITY_GROUP + "override");
        emrClusterDefinitionOverride.setSlaveSecurityGroup(EMR_SLAVE_SECURITY_GROUP + "override");
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterWrongInstanceConfigs() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        this.emrService.createCluster(request);
    }

    @Test
    public void testEmrAddSteps() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
        EmrShellStep emrShellStep = (EmrShellStep)this.emrService.addStepToCluster((Object)stepRequest);
        Assert.assertNotNull((Object)emrShellStep);
        Assert.assertTrue((boolean)emrShellStep.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrShellStep.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrShellStep.getEmrClusterName().equals(request.getEmrClusterName()));
    }

    @Test
    public void testEmrAddStepsAllTypes() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        ArrayList<Object> emrSteps = new ArrayList<Object>();
        ArrayList<String> shellScriptArgs = new ArrayList<String>();
        shellScriptArgs.add("Hello");
        shellScriptArgs.add("herd");
        shellScriptArgs.add("How Are You");
        EmrShellStepAddRequest shellStepRequest = new EmrShellStepAddRequest();
        shellStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/test/test_script.sh");
        shellStepRequest.setStepName("Test Shell Script");
        shellStepRequest.setScriptArguments(shellScriptArgs);
        emrSteps.add(shellStepRequest);
        EmrHiveStepAddRequest hiveStepRequest = new EmrHiveStepAddRequest();
        ArrayList<String> scriptArgs1 = new ArrayList<String>();
        scriptArgs1.add("arg2=sampleArg");
        scriptArgs1.add("arg1=tables");
        hiveStepRequest.setStepName("Test Hive");
        hiveStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/test/test_hive.hql");
        hiveStepRequest.setScriptArguments(scriptArgs1);
        emrSteps.add(hiveStepRequest);
        EmrPigStepAddRequest pigStepRequest = new EmrPigStepAddRequest();
        pigStepRequest.setStepName("Test Pig");
        pigStepRequest.setScriptArguments(shellScriptArgs);
        pigStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/test/test_pig.pig");
        emrSteps.add(pigStepRequest);
        shellStepRequest = new EmrShellStepAddRequest();
        shellStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/bootstrap/install_oozie.sh");
        shellStepRequest.setStepName("Install Oozie");
        ArrayList<String> shellScriptArgsOozie = new ArrayList<String>();
        shellScriptArgsOozie.add("s3://test-bucket-managed/app-a/bootstrap/oozie-4.0.1-distro.tar");
        shellStepRequest.setScriptArguments(shellScriptArgsOozie);
        emrSteps.add(shellStepRequest);
        EmrHadoopJarStepAddRequest hadoopJarStepRequest = new EmrHadoopJarStepAddRequest();
        ArrayList<String> scriptArgs2 = new ArrayList<String>();
        scriptArgs2.add("oozie_run");
        scriptArgs2.add("wordcountOutput");
        hadoopJarStepRequest.setStepName("Hadoop Jar");
        hadoopJarStepRequest.setJarLocation("s3://test-bucket-managed/app-a/test/hadoop-mapreduce-examples-2.4.0.jar");
        hadoopJarStepRequest.setMainClass("wordcount");
        hadoopJarStepRequest.setScriptArguments(scriptArgs2);
        emrSteps.add(hadoopJarStepRequest);
        for (Object e : emrSteps) {
            EmrStepHelper stepHelper = this.emrStepHelperFactory.getStepHelper(e.getClass().getName());
            stepHelper.setRequestNamespace(e, NAMESPACE);
            stepHelper.setRequestEmrClusterDefinitionName(e, EMR_CLUSTER_DEFINITION_NAME);
            stepHelper.setRequestEmrClusterName(e, request.getEmrClusterName());
            Object emrStep = this.emrService.addStepToCluster(e);
            Assert.assertNotNull((Object)emrStep);
            Assert.assertNotNull((Object)stepHelper.getStepId(emrStep));
            Method getNameMethod = emrStep.getClass().getMethod("getStepName", new Class[0]);
            String emrStepName = (String)getNameMethod.invoke(emrStep, new Object[0]);
            Assert.assertEquals((Object)stepHelper.getRequestStepName(e), (Object)emrStepName);
            Method isContinueOnErrorMethod = emrStep.getClass().getMethod("isContinueOnError", new Class[0]);
            Object emrStepIsContinueOnError = isContinueOnErrorMethod.invoke(emrStep, new Object[0]);
            Assert.assertEquals((Object)stepHelper.isRequestContinueOnError(e), (Object)emrStepIsContinueOnError);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmrAddStepsAmazonBadRequest() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
        stepRequest.setStepName("amazon_bad_request");
        this.emrService.addStepToCluster((Object)stepRequest);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testEmrAddStepsAmazonObjectNotFound() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
        stepRequest.setStepName("amazon_not_found_exception");
        this.emrService.addStepToCluster((Object)stepRequest);
    }

    @Test(expected=AmazonServiceException.class)
    public void testEmrAddStepsAmazonOtherException() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
        stepRequest.setStepName("amazon_service_exception");
        this.emrService.addStepToCluster((Object)stepRequest);
    }

    @Test
    public void testEmrAddStepsHadoopNoMainClass() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        ArrayList<EmrHadoopJarStepAddRequest> emrSteps = new ArrayList<EmrHadoopJarStepAddRequest>();
        EmrHadoopJarStepAddRequest hadoopJarStepRequest = new EmrHadoopJarStepAddRequest();
        hadoopJarStepRequest.setNamespace(request.getNamespace());
        hadoopJarStepRequest.setEmrClusterDefinitionName(request.getEmrClusterDefinitionName());
        hadoopJarStepRequest.setEmrClusterName(request.getEmrClusterName());
        hadoopJarStepRequest.setStepName("Hadoop Jar");
        hadoopJarStepRequest.setJarLocation("s3://test-bucket-managed/app-a/test/hadoop-mapreduce-examples-2.4.0.jar");
        emrSteps.add(hadoopJarStepRequest);
        EmrHadoopJarStep emrHadoopJarStep = (EmrHadoopJarStep)this.emrService.addStepToCluster((Object)hadoopJarStepRequest);
        Assert.assertNotNull((Object)emrHadoopJarStep);
        Assert.assertNotNull((Object)emrHadoopJarStep.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmrAddStepsInvalidCluster() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
        EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
        stepRequest.setEmrClusterName("InvalidName");
        this.emrService.addStepToCluster((Object)stepRequest);
    }

    @Test
    public void testEmrServiceMethodsNewTx() throws Exception {
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto;
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        try {
            this.emrServiceImpl.createCluster(request);
            Assert.fail((String)"Should throw a ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
        try {
            EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
            this.emrServiceImpl.addStepToCluster((Object)stepRequest);
            Assert.fail((String)"Should throw a ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
        try {
            EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequest(request.getEmrClusterName());
            this.emrServiceImpl.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
            Assert.fail((String)"Should throw a ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
        try {
            emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName("test_cluster").build();
            this.emrServiceImpl.getCluster(emrClusterAlternateKeyDto, null, null, false, null, Boolean.valueOf(false));
            Assert.fail((String)"Should throw a ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
        try {
            emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName("test_cluster").build();
            this.emrServiceImpl.terminateCluster(emrClusterAlternateKeyDto, false, null, null);
            Assert.fail((String)"Should throw a ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetEmrClusterById() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion(MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), null, true, null, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
        this.emrService.terminateCluster(emrClusterAlternateKeyDto, true, null, null);
        emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), null, true, null, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
    }

    @Test
    public void testGetEmrClusterByIdWithFleetInstance() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion(MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), null, true, null, Boolean.valueOf(true));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
        Assert.assertNotNull((Object)emrClusterGet.getInstanceFleets());
        Assert.assertTrue((emrClusterGet.getInstanceFleets().size() == 1 ? 1 : 0) != 0);
    }

    @Test(expected=AmazonServiceException.class)
    public void testGetEmrClusterByIdAmazonException() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName("test").build();
        this.emrService.getCluster(emrClusterAlternateKeyDto, "amazon_service_exception", null, true, null, Boolean.valueOf(false));
        Assert.fail((String)"Should throw an AmazonServiceException.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetEmrClusterByIdDoesNotExist() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName("cluster_does_not_exist").build();
        this.emrService.getCluster(emrClusterAlternateKeyDto, "cluster_does_not_exist", null, true, null, Boolean.valueOf(false));
        Assert.fail((String)"Should throw an IllegalArgumentException.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetEmrClusterByIdDoesNotExistForNamespace() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        NamespaceEntity namespaceEntity_2 = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE_2);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity_2, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto_2 = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE_2).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        this.emrService.getCluster(emrClusterAlternateKeyDto_2, emrCluster.getId(), null, true, null, Boolean.valueOf(false));
        Assert.fail((String)"Should throw an IllegalArgumentException.");
    }

    @Test
    public void testGetEmrClusterByIdWithStepId() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrShellStepAddRequest stepRequest = this.getNewEmrShellStepAddRequest(request.getEmrClusterName());
        stepRequest.setStepName("mock_step_running_name");
        EmrShellStep emrShellStep = (EmrShellStep)this.emrService.addStepToCluster((Object)stepRequest);
        String stepId = emrShellStep.getId();
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), stepId, true, null, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
        Assert.assertTrue((boolean)stepId.equals(emrClusterGet.getActiveStep().getId()));
        Assert.assertTrue((boolean)stepId.equals(emrClusterGet.getStep().getId()));
        emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), stepId, false, null, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
        Assert.assertTrue((boolean)stepId.equals(emrClusterGet.getActiveStep().getId()));
        Assert.assertTrue((boolean)stepId.equals(emrClusterGet.getStep().getId()));
    }

    @Test
    public void testGetEmrClusterByName() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, null, null, true, null, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
    }

    @Test
    public void testGetEmrClusterIdByNameForBlank() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        this.emrService.createCluster(request);
    }

    @Test
    public void testTerminateEmrCluster() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterTerminated = this.emrService.terminateCluster(emrClusterAlternateKeyDto, true, null, null);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterTerminated);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterTerminated.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterTerminated.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterTerminated.getEmrClusterName()));
    }

    @Test(expected=AmazonServiceException.class)
    public void testTerminateEmrClusterAmazonException() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        request.setEmrClusterName("amazon_service_exception");
        this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        this.emrService.terminateCluster(emrClusterAlternateKeyDto, true, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTerminateEmrClusterNoCluster() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName("cluster_not_found").build();
        this.emrService.terminateCluster(emrClusterAlternateKeyDto, true, null, null);
    }

    @Test
    public void testTerminateEmrClusterWithClusterId() throws Exception {
        EmrServiceImpl emrService = new EmrServiceImpl();
        AlternateKeyHelper mockAlternateKeyHelper = (AlternateKeyHelper)Mockito.mock(AlternateKeyHelper.class);
        ReflectionTestUtils.setField((Object)emrService, (String)"alternateKeyHelper", (Object)mockAlternateKeyHelper);
        EmrHelper mockEmrHelper = (EmrHelper)Mockito.mock(EmrHelper.class);
        ReflectionTestUtils.setField((Object)emrService, (String)"emrHelper", (Object)mockEmrHelper);
        EmrDao mockEmrDao = (EmrDao)Mockito.mock(EmrDao.class);
        ReflectionTestUtils.setField((Object)emrService, (String)"emrDao", (Object)mockEmrDao);
        NamespaceDaoHelper mockNamespaceDaoHelper = (NamespaceDaoHelper)Mockito.mock(NamespaceDaoHelper.class);
        ReflectionTestUtils.setField((Object)emrService, (String)"namespaceDaoHelper", (Object)mockNamespaceDaoHelper);
        EmrClusterDefinitionDaoHelper mockEmrClusterDefinitionDaoHelper = (EmrClusterDefinitionDaoHelper)Mockito.mock(EmrClusterDefinitionDaoHelper.class);
        ReflectionTestUtils.setField((Object)emrService, (String)"emrClusterDefinitionDaoHelper", (Object)mockEmrClusterDefinitionDaoHelper);
        String namespace = "namespace";
        String emrClusterDefinitionName = "emrClusterDefinitionName";
        String emrClusterName = "emrClusterName";
        boolean overrideTerminationProtection = false;
        String emrClusterId = "emrClusterId";
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = new EmrClusterAlternateKeyDto();
        emrClusterAlternateKeyDto.setNamespace(namespace);
        emrClusterAlternateKeyDto.setEmrClusterDefinitionName(emrClusterDefinitionName);
        emrClusterAlternateKeyDto.setEmrClusterName(emrClusterName);
        AwsParamsDto awsParamsDto = new AwsParamsDto();
        Mockito.when((Object)mockEmrHelper.getAwsParamsDtoByAcccountId((String)Matchers.any())).thenReturn((Object)awsParamsDto);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = new EmrClusterDefinitionEntity();
        emrClusterDefinitionEntity.setNamespace(namespaceEntity);
        Mockito.when((Object)mockEmrClusterDefinitionDaoHelper.getEmrClusterDefinitionEntity((EmrClusterDefinitionKey)Matchers.any())).thenReturn((Object)emrClusterDefinitionEntity);
        String buildEmrClusterNameResult = "buildEmrClusterNameResult";
        Mockito.when((Object)mockEmrHelper.buildEmrClusterName((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)buildEmrClusterNameResult);
        Mockito.when((Object)mockEmrHelper.getActiveEmrClusterId((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)buildEmrClusterNameResult);
        Mockito.when((Object)mockEmrDao.getEmrClusterStatusById((String)Matchers.any(), (AwsParamsDto)Matchers.any())).thenReturn((Object)buildEmrClusterNameResult);
        emrService.terminateCluster(emrClusterAlternateKeyDto, overrideTerminationProtection, emrClusterId, null);
        ((AlternateKeyHelper)Mockito.verify((Object)mockAlternateKeyHelper)).validateStringParameter("namespace", namespace);
        ((AlternateKeyHelper)Mockito.verify((Object)mockAlternateKeyHelper)).validateStringParameter("An", "EMR cluster definition name", emrClusterDefinitionName);
        ((AlternateKeyHelper)Mockito.verify((Object)mockAlternateKeyHelper)).validateStringParameter("An", "EMR cluster name", emrClusterName);
        ((EmrClusterDefinitionDaoHelper)Mockito.verify((Object)mockEmrClusterDefinitionDaoHelper)).getEmrClusterDefinitionEntity(new EmrClusterDefinitionKey(emrClusterAlternateKeyDto.getNamespace(), emrClusterAlternateKeyDto.getEmrClusterDefinitionName()));
        ((EmrHelper)Mockito.verify((Object)mockEmrHelper)).buildEmrClusterName(namespaceEntity.getCode(), emrClusterDefinitionEntity.getName(), emrClusterAlternateKeyDto.getEmrClusterName());
        ((EmrHelper)Mockito.verify((Object)mockEmrHelper)).getActiveEmrClusterId(emrClusterId, buildEmrClusterNameResult, null);
        ((EmrDao)Mockito.verify((Object)mockEmrDao)).terminateEmrCluster(buildEmrClusterNameResult, overrideTerminationProtection, awsParamsDto);
        ((EmrDao)Mockito.verify((Object)mockEmrDao)).getEmrClusterStatusById(buildEmrClusterNameResult, awsParamsDto);
    }

    @Test
    public void testUnmarshallXmlWithNestedElements() throws JAXBException {
        String xml = "<emrClusterCreateRequest><namespace>" + NAMESPACE + "</namespace>" + "<emrClusterDefinitionName>" + EMR_CLUSTER_DEFINITION_NAME + "</emrClusterDefinitionName>" + "<emrClusterName>cluster1</emrClusterName>" + "<dryRun>true</dryRun>" + "<emrClusterDefinitionOverride>" + "<customBootstrapActionMaster/>" + "<customBootstrapActionAll/>" + "<instanceDefinitions/>" + "<nodeTags/>" + "<daemonConfigurations/>" + "<hadoopConfigurations/>" + "</emrClusterDefinitionOverride>" + "</emrClusterCreateRequest>";
        this.xmlHelper.unmarshallXmlToObject(EmrClusterCreateRequest.class, xml);
    }

    protected List<EmrClusterCreationLogEntity> getEmrClusterCreationLogEntities(String namespace, String definitionName, String clusterName) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(EmrClusterCreationLogEntity.class);
        Root emrClusterCreationLogEntity = query.from(EmrClusterCreationLogEntity.class);
        Join namespaceEntity = emrClusterCreationLogEntity.join(EmrClusterCreationLogEntity_.namespace);
        Predicate namespacePredicate = builder.equal(builder.upper((Expression)namespaceEntity.get(NamespaceEntity_.code)), (Object)namespace.toUpperCase());
        Predicate definitionNamePredicate = builder.equal(builder.upper((Expression)emrClusterCreationLogEntity.get(EmrClusterCreationLogEntity_.emrClusterDefinitionName)), (Object)definitionName.toUpperCase());
        Predicate clusterNamePredicate = builder.equal(builder.upper((Expression)emrClusterCreationLogEntity.get(EmrClusterCreationLogEntity_.emrClusterName)), (Object)clusterName.toUpperCase());
        query.select((Selection)emrClusterCreationLogEntity).where((Expression)builder.and(new Predicate[]{namespacePredicate, definitionNamePredicate, clusterNamePredicate}));
        return this.entityManager.createQuery(query).getResultList();
    }

    protected void validateEmrClusterCreationLogUnique(EmrCluster emrCluster, EmrClusterDefinition expectedEmrClusterDefinition) throws JAXBException {
        String namespace = emrCluster.getNamespace();
        String emrClusterDefinitionName = emrCluster.getEmrClusterDefinitionName();
        String emrClusterName = emrCluster.getEmrClusterName();
        List<EmrClusterCreationLogEntity> list = this.getEmrClusterCreationLogEntities(namespace, emrClusterDefinitionName, emrClusterName);
        Assert.assertEquals((String)"EMR cluster creation log size", (long)1L, (long)list.size());
        EmrClusterCreationLogEntity log = list.get(0);
        Assert.assertEquals((String)"EMR cluster creation log cluster ID", (Object)emrCluster.getId(), (Object)log.getEmrClusterId());
        Assert.assertEquals((String)"EMR cluster creation log namespace", (Object)namespace, (Object)log.getNamespace().getCode());
        String expectedDefinitionXml = this.xmlHelper.objectToXml((Object)expectedEmrClusterDefinition);
        Assert.assertEquals((String)"EMR cluster creation log definition", (Object)expectedDefinitionXml, (Object)log.getEmrClusterDefinition());
    }

    private void assertEmrClusterCreationLogNotExist(EmrCluster emrCluster) {
        List<EmrClusterCreationLogEntity> list = this.getEmrClusterCreationLogEntities(emrCluster.getNamespace(), emrCluster.getEmrClusterDefinitionName(), emrCluster.getEmrClusterName());
        Assert.assertTrue((String)"EMR cluster creation log empty", (boolean)list.isEmpty());
    }

    private EmrMasterSecurityGroupAddRequest getNewEmrAddSecurityGroupMasterRequest(String clusterName) throws Exception {
        EmrMasterSecurityGroupAddRequest request = new EmrMasterSecurityGroupAddRequest();
        request.setNamespace(NAMESPACE);
        request.setEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME);
        request.setEmrClusterName(clusterName);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("A_TEST_SECURITY_GROUP");
        request.setSecurityGroupIds(groupIds);
        return request;
    }

    private EmrClusterCreateRequest getNewEmrClusterCreateRequest() throws Exception {
        EmrClusterCreateRequest request = new EmrClusterCreateRequest();
        request.setNamespace(NAMESPACE);
        request.setEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME);
        request.setEmrClusterName("UT_EMR_CLUSTER-" + Math.random());
        return request;
    }

    private EmrShellStepAddRequest getNewEmrShellStepAddRequest(String clusterName) throws Exception {
        EmrShellStepAddRequest request = new EmrShellStepAddRequest();
        request.setNamespace(NAMESPACE);
        request.setEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME);
        request.setEmrClusterName(clusterName);
        request.setStepName("A_SHELL_STEP");
        request.setScriptLocation("SCRIPT_LOCATION");
        request.setContinueOnError(Boolean.valueOf(false));
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("one");
        arguments.add("two");
        request.setScriptArguments(arguments);
        return request;
    }
}

