/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.FileUploadCleanupServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileUploadCleanupServiceTest
extends AbstractServiceTest {
    private String s3BucketName;

    @Before
    public void before() {
        this.s3BucketName = this.storageDaoTestHelper.getS3ManagedBucketName();
    }

    @After
    public void cleanEnv() throws IOException {
        this.s3Dao.deleteDirectory(this.s3DaoTestHelper.getTestS3FileTransferRequestParamsDto());
        this.s3Operations.rollback();
    }

    @Test
    public void testDeleteBusinessObjectData() throws Exception {
        StorageEntity storageEntity = this.createTestStorageEntity(STORAGE_NAME, this.s3BucketName);
        List<BusinessObjectDataKey> testBusinessObjectKeys = Arrays.asList(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION_2), new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION_2));
        this.createTestDatabaseEntities(testBusinessObjectKeys.get(0), "UPLOADING", storageEntity, TARGET_S3_KEY, 15);
        this.createTestDatabaseEntities(testBusinessObjectKeys.get(1), "UPLOADING", storageEntity, TARGET_S3_KEY, 5);
        this.createTestDatabaseEntities(testBusinessObjectKeys.get(2), "RE-ENCRYPTING", storageEntity, TARGET_S3_KEY, 20);
        this.createTestDatabaseEntities(testBusinessObjectKeys.get(3), BDATA_STATUS, storageEntity, TARGET_S3_KEY, 20);
        List resultBusinessObjectDataKeys = this.fileUploadCleanupService.deleteBusinessObjectData(STORAGE_NAME, 10);
        Assert.assertNotNull((Object)resultBusinessObjectDataKeys);
        Assert.assertEquals(Arrays.asList(testBusinessObjectKeys.get(2), testBusinessObjectKeys.get(0)), (Object)resultBusinessObjectDataKeys);
        this.validateBusinessObjectDataStatus(testBusinessObjectKeys.get(0), "DELETED");
        this.validateBusinessObjectDataStatus(testBusinessObjectKeys.get(1), "UPLOADING");
        this.validateBusinessObjectDataStatus(testBusinessObjectKeys.get(2), "DELETED");
        this.validateBusinessObjectDataStatus(testBusinessObjectKeys.get(3), BDATA_STATUS);
    }

    @Test
    public void testDeleteBusinessObjectDataS3FileExists() throws Exception {
        StorageEntity storageEntity = this.createTestStorageEntity(STORAGE_NAME, this.s3BucketName);
        BusinessObjectDataKey testBusinessObjectKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.createTestDatabaseEntities(testBusinessObjectKey, "UPLOADING", storageEntity, TARGET_S3_KEY, 15);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.s3BucketName, TARGET_S3_KEY, (InputStream)new ByteArrayInputStream(new byte[1]), new ObjectMetadata());
        this.s3Operations.putObject(putObjectRequest, null);
        List resultBusinessObjectDataKeys = this.fileUploadCleanupService.deleteBusinessObjectData(STORAGE_NAME, 10);
        Assert.assertNotNull((Object)resultBusinessObjectDataKeys);
        Assert.assertTrue((boolean)resultBusinessObjectDataKeys.isEmpty());
        this.validateBusinessObjectDataStatus(testBusinessObjectKey, "UPLOADING");
    }

    @Test
    public void testDeleteBusinessObjectDataAmazonServiceException() throws Exception {
        StorageEntity storageEntity = this.createTestStorageEntity(STORAGE_NAME, this.s3BucketName);
        BusinessObjectDataKey testBusinessObjectKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.createTestDatabaseEntities(testBusinessObjectKey, "UPLOADING", storageEntity, "mock_s3_file_name_service_exception", 15);
        this.executeWithoutLogging(FileUploadCleanupServiceImpl.class, () -> {
            List resultBusinessObjectDataKeys = this.fileUploadCleanupService.deleteBusinessObjectData(STORAGE_NAME, 10);
            Assert.assertNotNull((Object)resultBusinessObjectDataKeys);
            Assert.assertTrue((boolean)resultBusinessObjectDataKeys.isEmpty());
            this.validateBusinessObjectDataStatus(testBusinessObjectKey, "UPLOADING");
        });
    }

    private void createTestDatabaseEntities(BusinessObjectDataKey businessObjectDataKey, String businessObjectDataStatus, StorageEntity storageEntity, String storageFilePath, int createdOnTimestampMinutesOffset) throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, Boolean.valueOf(true), businessObjectDataStatus);
        businessObjectDataEntity.setCreatedOn(new Timestamp(businessObjectDataEntity.getCreatedOn().getTime() - (long)(createdOnTimestampMinutesOffset * 60 * 1000)));
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, storageFilePath, Long.valueOf(1024L), Long.valueOf(1000L));
        this.herdDao.saveAndRefresh((Object)businessObjectDataEntity);
    }

    private StorageEntity createTestStorageEntity(String storageName, String bucketName) throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (StringUtils.isNotBlank((CharSequence)bucketName)) {
            attributes.add(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), bucketName));
        }
        return this.storageDaoTestHelper.createStorageEntity(storageName, "S3", attributes);
    }

    private void validateBusinessObjectDataStatus(BusinessObjectDataKey businessObjectDataKey, String expectedBusinessObjectDataStatus) {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        Assert.assertNotNull((Object)businessObjectDataEntity);
        Assert.assertEquals((Object)expectedBusinessObjectDataStatus, (Object)businessObjectDataEntity.getStatus().getCode());
    }
}

