/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.dao.JobDefinitionDao;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.dao.S3Dao;
import org.finra.herd.dao.helper.HerdStringHelper;
import org.finra.herd.dao.helper.JavaPropertiesHelper;
import org.finra.herd.model.api.xml.JobStatusEnum;
import org.finra.herd.model.api.xml.JobSummaries;
import org.finra.herd.model.api.xml.JobSummary;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.JobDefinitionAlternateKeyDto;
import org.finra.herd.model.jpa.JobDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.ActivitiService;
import org.finra.herd.service.helper.JobDefinitionHelper;
import org.finra.herd.service.helper.NamespaceDaoHelper;
import org.finra.herd.service.helper.NamespaceSecurityHelper;
import org.finra.herd.service.helper.S3PropertiesLocationHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.impl.JobServiceImpl;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class JobServiceGetJobsTest
extends AbstractServiceTest {
    @Mock
    private ActivitiService activitiService;
    @Mock
    private HerdStringHelper herdStringHelper;
    @Mock
    private JavaPropertiesHelper javaPropertiesHelper;
    @Mock
    private JobDefinitionDao jobDefinitionDao;
    @Mock
    private JobDefinitionHelper jobDefinitionHelper;
    @InjectMocks
    private JobServiceImpl jobServiceImpl;
    @Mock
    private NamespaceDao namespaceDao;
    @Mock
    private NamespaceDaoHelper namespaceDaoHelper;
    @Mock
    private NamespaceSecurityHelper namespaceSecurityHelper;
    @Mock
    private S3Dao s3Dao;
    @Mock
    private S3PropertiesLocationHelper s3PropertiesLocationHelper;
    @Mock
    private StorageDaoHelper storageDaoHelper;

    private static <T> Collection<T> equalsCollection(Collection<T> other) {
        return (Collection)Matchers.argThat(collection2 -> collection2.size() == other.size() && collection2.containsAll(other));
    }

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        Mockito.when((Object)this.herdStringHelper.getConfigurationValueAsInteger(ConfigurationValue.JOBS_QUERY_MAX_RESULTS)).thenReturn((Object)1);
        Mockito.when((Object)this.jobDefinitionHelper.getJobDefinitionKey((String)Matchers.eq((Object)"a.b"), (Pattern)Matchers.any())).thenReturn((Object)new JobDefinitionAlternateKeyDto("a", "b"));
    }

    @Test
    public void testGetJobsAssertJobNameTrimmed() throws Exception {
        String namespace = "namespace";
        String jobName = StringUtils.wrap((String)"jobName", (String)"      \t\t ");
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList("namespace"));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        ((JobDefinitionDao)Mockito.verify((Object)this.jobDefinitionDao)).getJobDefinitionsByFilter((Collection)Matchers.eq(authorizedNamespaces), (String)Matchers.eq((Object)jobName.trim()));
    }

    @Test
    public void testGetJobsGivenMultipleHistoricProcessInstanceWithSamKeyJobAssertReturnCompletedJob() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        ArrayList<JobDefinitionEntity> jobDefinitionEntities = new ArrayList<JobDefinitionEntity>();
        JobDefinitionEntity jobDefinitionEntity1 = new JobDefinitionEntity();
        jobDefinitionEntity1.setActivitiId(namespace + "." + jobName + ":1" + ":1");
        jobDefinitionEntities.add(jobDefinitionEntity1);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(jobDefinitionEntities);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getId()).thenReturn((Object)"a.b:1:1");
        Mockito.when((Object)processDefinition.getKey()).thenReturn((Object)"a.b");
        Mockito.when((Object)this.activitiService.getProcessDefinitionsByIds((Set)Matchers.any())).thenReturn(Arrays.asList(processDefinition));
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn((Object)1L);
        ArrayList<HistoricProcessInstanceEntity> historicProcessInstances = new ArrayList<HistoricProcessInstanceEntity>();
        HistoricProcessInstanceEntity historicProcessInstanceEntity1 = new HistoricProcessInstanceEntity();
        historicProcessInstanceEntity1.setId("historicProcessInstanceEntity1.id");
        historicProcessInstanceEntity1.setProcessDefinitionId("a.b:1:1");
        historicProcessInstanceEntity1.setStartTime(new Date(1234L));
        historicProcessInstanceEntity1.setEndTime(new Date(2345L));
        historicProcessInstances.add(historicProcessInstanceEntity1);
        historicProcessInstanceEntity1 = new HistoricProcessInstanceEntity();
        historicProcessInstanceEntity1.setId("historicProcessInstanceEntity2.id");
        historicProcessInstanceEntity1.setProcessDefinitionId("a.b:1:2");
        historicProcessInstanceEntity1.setStartTime(new Date(1234L));
        historicProcessInstanceEntity1.setEndTime(new Date(2345L));
        historicProcessInstances.add(historicProcessInstanceEntity1);
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn(historicProcessInstances);
        JobSummaries getJobsResult = this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        List jobSummaries = getJobsResult.getJobSummaries();
        Assert.assertEquals((long)1L, (long)jobSummaries.size());
    }

    @Test
    public void testGetJobsGivenOneCompletedJobAndPassingStartAndEndTimeAssertReturnCompletedJob() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        DateTime startTime = new DateTime((Object)new Date(83L));
        DateTime endTime = new DateTime((Object)new Date(3456L));
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        ArrayList<JobDefinitionEntity> jobDefinitionEntities = new ArrayList<JobDefinitionEntity>();
        JobDefinitionEntity jobDefinitionEntity1 = new JobDefinitionEntity();
        jobDefinitionEntity1.setActivitiId(namespace + "." + jobName + ":1" + ":1");
        jobDefinitionEntities.add(jobDefinitionEntity1);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(jobDefinitionEntities);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getId()).thenReturn((Object)"a.b:1:1");
        Mockito.when((Object)processDefinition.getKey()).thenReturn((Object)"a.b");
        Mockito.when((Object)this.activitiService.getProcessDefinitionsByIds((Set)Matchers.any())).thenReturn(Arrays.asList(processDefinition));
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn((Object)1L);
        ArrayList<HistoricProcessInstanceEntity> historicProcessInstances = new ArrayList<HistoricProcessInstanceEntity>();
        HistoricProcessInstanceEntity historicProcessInstanceEntity1 = new HistoricProcessInstanceEntity();
        historicProcessInstanceEntity1.setId("historicProcessInstanceEntity1.id");
        historicProcessInstanceEntity1.setProcessDefinitionId("a.b:1:1");
        historicProcessInstanceEntity1.setStartTime(new Date(1234L));
        historicProcessInstanceEntity1.setEndTime(new Date(2345L));
        historicProcessInstances.add(historicProcessInstanceEntity1);
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn(historicProcessInstances);
        JobSummaries getJobsResult = this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, startTime, endTime);
        List jobSummaries = getJobsResult.getJobSummaries();
        Assert.assertEquals((long)1L, (long)jobSummaries.size());
        JobSummary jobSummary = (JobSummary)jobSummaries.get(0);
        Assert.assertEquals((Object)historicProcessInstanceEntity1.getId(), (Object)jobSummary.getId());
        Assert.assertEquals((Object)"a", (Object)jobSummary.getNamespace());
        Assert.assertEquals((Object)"b", (Object)jobSummary.getJobName());
        Assert.assertEquals((Object)JobStatusEnum.COMPLETED, (Object)jobSummary.getStatus());
        Assert.assertEquals((long)historicProcessInstanceEntity1.getStartTime().getTime(), (long)jobSummary.getStartTime().toGregorianCalendar().getTimeInMillis());
        Assert.assertEquals((long)historicProcessInstanceEntity1.getEndTime().getTime(), (long)jobSummary.getEndTime().toGregorianCalendar().getTimeInMillis());
        Assert.assertEquals((long)0L, (long)jobSummary.getTotalExceptions());
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.eq((Object)JobStatusEnum.COMPLETED), (Collection)Matchers.any(), (DateTime)Matchers.eq((Object)startTime), (DateTime)Matchers.eq((Object)endTime));
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.eq((Object)JobStatusEnum.COMPLETED), (Collection)Matchers.any(), (DateTime)Matchers.eq((Object)startTime), (DateTime)Matchers.eq((Object)endTime));
    }

    @Test
    public void testGetJobsGivenOneRunningJobAssertReturnCompletedJob() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.RUNNING;
        long expectedNumberOfExceptions = 1234L;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        ArrayList<JobDefinitionEntity> jobDefinitionEntities = new ArrayList<JobDefinitionEntity>();
        JobDefinitionEntity jobDefinitionEntity1 = new JobDefinitionEntity();
        jobDefinitionEntity1.setActivitiId(namespace + "." + jobName + ":1" + ":1");
        jobDefinitionEntities.add(jobDefinitionEntity1);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(jobDefinitionEntities);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getId()).thenReturn((Object)"a.b:1:1");
        Mockito.when((Object)processDefinition.getKey()).thenReturn((Object)"a.b");
        Mockito.when((Object)this.activitiService.getProcessDefinitionsByIds((Set)Matchers.any())).thenReturn(Arrays.asList(processDefinition));
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn((Object)1L);
        ArrayList<HistoricProcessInstanceEntity> historicProcessInstances = new ArrayList<HistoricProcessInstanceEntity>();
        HistoricProcessInstanceEntity historicProcessInstanceEntity1 = new HistoricProcessInstanceEntity();
        historicProcessInstanceEntity1.setId("historicProcessInstanceEntity1.id");
        historicProcessInstanceEntity1.setProcessDefinitionId("a.b:1:1");
        historicProcessInstanceEntity1.setStartTime(new Date(1234L));
        historicProcessInstances.add(historicProcessInstanceEntity1);
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn(historicProcessInstances);
        Mockito.when((Object)this.activitiService.getJobsWithExceptionCountByProcessInstanceId((String)Matchers.any())).thenReturn((Object)expectedNumberOfExceptions);
        JobSummaries getJobsResult = this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        List jobSummaries = getJobsResult.getJobSummaries();
        Assert.assertEquals((long)1L, (long)jobSummaries.size());
        JobSummary jobSummary = (JobSummary)jobSummaries.get(0);
        Assert.assertEquals((Object)historicProcessInstanceEntity1.getId(), (Object)jobSummary.getId());
        Assert.assertEquals((Object)"a", (Object)jobSummary.getNamespace());
        Assert.assertEquals((Object)"b", (Object)jobSummary.getJobName());
        Assert.assertEquals((Object)JobStatusEnum.RUNNING, (Object)jobSummary.getStatus());
        Assert.assertEquals((long)historicProcessInstanceEntity1.getStartTime().getTime(), (long)jobSummary.getStartTime().toGregorianCalendar().getTimeInMillis());
        Assert.assertNull((Object)jobSummary.getEndTime());
        Assert.assertEquals((long)expectedNumberOfExceptions, (long)jobSummary.getTotalExceptions());
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getJobsWithExceptionCountByProcessInstanceId(historicProcessInstanceEntity1.getId());
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.eq((Object)JobStatusEnum.RUNNING), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any());
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.eq((Object)JobStatusEnum.RUNNING), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any());
    }

    @Test
    public void testGetJobsWhenActivitiIdIsNotExpectedFormatAssertSuccess() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        String processDefinitionKey = String.format("%s.%s", namespace, jobName);
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(new HashSet<String>(Arrays.asList(namespace)));
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        JobDefinitionEntity jobDefinitionEntity = new JobDefinitionEntity();
        jobDefinitionEntity.setNamespace(namespaceEntity);
        jobDefinitionEntity.setName(jobName);
        jobDefinitionEntity.setActivitiId("123456");
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(Arrays.asList(jobDefinitionEntity));
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getKey()).thenReturn((Object)processDefinitionKey);
        Mockito.when((Object)this.activitiService.getProcessDefinitionsByIds((Set)Matchers.any())).thenReturn(Arrays.asList(processDefinition));
        this.jobServiceImpl.getJobs(namespace, jobName, AbstractServiceTest.NO_ACTIVITI_JOB_STATUS, NO_START_TIME, NO_END_TIME);
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), JobServiceGetJobsTest.equalsCollection(Arrays.asList(processDefinitionKey)), (DateTime)Matchers.any(), (DateTime)Matchers.any());
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), JobServiceGetJobsTest.equalsCollection(Arrays.asList(processDefinitionKey)), (DateTime)Matchers.any(), (DateTime)Matchers.any());
    }

    @Test
    public void testGetJobsWhenJobDaoReturnEmptyAssertReturnEmpty() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(new ArrayList());
        JobSummaries getJobsResult = this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        List jobSummaries = getJobsResult.getJobSummaries();
        Assert.assertEquals((long)0L, (long)jobSummaries.size());
    }

    @Test
    public void testGetJobsWhenJobNameNullAssertQueryByNull() throws Exception {
        String namespace = "namespace";
        String jobName = null;
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList("namespace"));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        ((JobDefinitionDao)Mockito.verify((Object)this.jobDefinitionDao)).getJobDefinitionsByFilter((Collection)Matchers.eq(authorizedNamespaces), (String)Matchers.isNull(String.class));
    }

    @Test
    public void testGetJobsWhenJobStatusNullQueryIgnoreStatus() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = null;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        ArrayList<JobDefinitionEntity> jobDefinitionEntities = new ArrayList<JobDefinitionEntity>();
        JobDefinitionEntity jobDefinitionEntity1 = new JobDefinitionEntity();
        jobDefinitionEntity1.setActivitiId(namespace + "." + jobName + ":1" + ":1");
        jobDefinitionEntities.add(jobDefinitionEntity1);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(jobDefinitionEntities);
        Mockito.when((Object)this.activitiService.getProcessDefinitionsByIds((Set)Matchers.any())).thenReturn(Arrays.asList(new ProcessDefinition[0]));
        this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.isNull(JobStatusEnum.class), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any());
        ((ActivitiService)Mockito.verify((Object)this.activitiService)).getHistoricProcessInstancesByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.isNull(JobStatusEnum.class), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any());
    }

    @Test
    public void testGetJobsWhenNamespaceNotSpecifiedAssertQueryByAllAuthorizedNamespaces() throws Exception {
        String namespace = null;
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList("a", "b"));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(new ArrayList());
        this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        ((JobDefinitionDao)Mockito.verify((Object)this.jobDefinitionDao)).getJobDefinitionsByFilter((Collection)Matchers.eq(authorizedNamespaces), (String)Matchers.eq((Object)jobName));
    }

    @Test
    public void testGetJobsWhenNamespaceSpecifiedButDoesNotExistAssertResultEmpty() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn(null);
        JobSummaries getJobsResult = this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        List jobSummaries = getJobsResult.getJobSummaries();
        Assert.assertEquals((long)0L, (long)jobSummaries.size());
    }

    @Test
    public void testGetJobsWhenNamespaceSpecifiedButNotAuthorizedAssertNoQuery() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList("a", "b"));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
        ((JobDefinitionDao)Mockito.verify((Object)this.jobDefinitionDao, (VerificationMode)Mockito.times((int)0))).getJobDefinitionsByFilter((Collection)Matchers.eq(authorizedNamespaces), (String)Matchers.eq((Object)jobName));
    }

    @Test
    public void testGetJobsWhenResultTooLargeAssertThrowException() throws Exception {
        String namespace = "namespace";
        String jobName = "jobName";
        JobStatusEnum jobStatus = JobStatusEnum.COMPLETED;
        HashSet<String> authorizedNamespaces = new HashSet<String>(Arrays.asList(namespace));
        Mockito.when((Object)this.namespaceSecurityHelper.getAuthorizedNamespaces((NamespacePermissionEnum[])Matchers.any())).thenReturn(authorizedNamespaces);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd((String)Matchers.any())).thenReturn((Object)namespaceEntity);
        ArrayList<JobDefinitionEntity> jobDefinitionEntities = new ArrayList<JobDefinitionEntity>();
        JobDefinitionEntity jobDefinitionEntity1 = new JobDefinitionEntity();
        jobDefinitionEntity1.setActivitiId(namespace + "." + jobName + ":1" + ":1");
        jobDefinitionEntities.add(jobDefinitionEntity1);
        Mockito.when((Object)this.jobDefinitionDao.getJobDefinitionsByFilter((Collection)Matchers.any(Collection.class), (String)Matchers.any())).thenReturn(jobDefinitionEntities);
        Mockito.when((Object)this.activitiService.getProcessDefinitionsByIds((Set)Matchers.any())).thenReturn(Arrays.asList(new ProcessDefinition[0]));
        Mockito.when((Object)this.activitiService.getHistoricProcessInstancesCountByStatusAndProcessDefinitionKeys((JobStatusEnum)Matchers.any(), (Collection)Matchers.any(), (DateTime)Matchers.any(), (DateTime)Matchers.any())).thenReturn((Object)1000L);
        try {
            this.jobServiceImpl.getJobs(namespace, jobName, jobStatus, NO_START_TIME, NO_END_TIME);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Too many jobs found for the specified filter parameters. The maximum number of results allowed is 1 and the number of results returned was 1000.", (Object)e.getMessage());
        }
    }
}

