/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Namespace;
import org.finra.herd.model.api.xml.NamespaceKey;
import org.finra.herd.model.api.xml.NamespaceKeys;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class NamespaceServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateNamespace() throws Exception {
        Namespace resultNamespace = this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest(NAMESPACE));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE, resultNamespace);
    }

    @Test
    public void testCreateNamespaceMissingRequiredParameters() {
        try {
            this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateNamespaceTrimParameters() {
        Namespace resultNamespace = this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest(this.addWhitespace(NAMESPACE)));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE, resultNamespace);
    }

    @Test
    public void testCreateNamespaceUpperCaseParameters() {
        Namespace resultNamespace = this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest(NAMESPACE.toUpperCase()));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE.toUpperCase(), resultNamespace);
    }

    @Test
    public void testCreateNamespaceLowerCaseParameters() {
        Namespace resultNamespace = this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest(NAMESPACE.toLowerCase()));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE.toLowerCase(), resultNamespace);
    }

    @Test
    public void testCreateNamespaceInvalidParameters() {
        try {
            this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest(this.addSlash(NAMESPACE)));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateNamespaceAlreadyExists() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        try {
            this.namespaceService.createNamespace(this.namespaceServiceTestHelper.createNamespaceCreateRequest(NAMESPACE));
            Assert.fail((String)"Should throw an AlreadyExistsException when namespace already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create namespace \"%s\" because it already exists.", NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetNamespace() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        Namespace resultNamespace = this.namespaceService.getNamespace(new NamespaceKey(NAMESPACE));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE, resultNamespace);
    }

    @Test
    public void testGetNamespaceMissingRequiredParameters() {
        try {
            this.namespaceService.getNamespace(new NamespaceKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace code is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetNamespaceTrimParameters() {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        Namespace resultNamespace = this.namespaceService.getNamespace(new NamespaceKey(this.addWhitespace(NAMESPACE)));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE, resultNamespace);
    }

    @Test
    public void testGetNamespaceUpperCaseParameters() {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toLowerCase());
        Namespace resultNamespace = this.namespaceService.getNamespace(new NamespaceKey(NAMESPACE.toUpperCase()));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE.toLowerCase(), resultNamespace);
    }

    @Test
    public void testGetNamespaceLowerCaseParameters() {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toUpperCase());
        Namespace resultNamespace = this.namespaceService.getNamespace(new NamespaceKey(NAMESPACE.toLowerCase()));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE.toUpperCase(), resultNamespace);
    }

    @Test
    public void testGetNamespaceNoExists() throws Exception {
        try {
            this.namespaceService.getNamespace(new NamespaceKey(NAMESPACE));
            Assert.fail((String)"Should throw an ObjectNotFoundException when namespace doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetNamespaces() throws Exception {
        for (NamespaceKey key : this.namespaceDaoTestHelper.getTestNamespaceKeys()) {
            this.namespaceDaoTestHelper.createNamespaceEntity(key.getNamespaceCode());
        }
        NamespaceKeys resultNamespaceKeys = this.namespaceService.getNamespaces();
        Assert.assertNotNull((Object)resultNamespaceKeys);
        Assert.assertNotNull((Object)resultNamespaceKeys.getNamespaceKeys());
        Assert.assertTrue((resultNamespaceKeys.getNamespaceKeys().size() >= this.namespaceDaoTestHelper.getTestNamespaceKeys().size() ? 1 : 0) != 0);
        for (NamespaceKey key : this.namespaceDaoTestHelper.getTestNamespaceKeys()) {
            Assert.assertTrue((boolean)resultNamespaceKeys.getNamespaceKeys().contains(key));
        }
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        NamespaceKey namespaceKey = new NamespaceKey(NAMESPACE);
        Assert.assertNotNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
        Namespace deletedNamespace = this.namespaceService.deleteNamespace(new NamespaceKey(NAMESPACE));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE, deletedNamespace);
        Assert.assertNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
    }

    @Test
    public void testDeleteNamespaceMissingRequiredParameters() {
        try {
            this.namespaceService.deleteNamespace(new NamespaceKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace code is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteNamespaceTrimParameters() {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        NamespaceKey namespaceKey = new NamespaceKey(NAMESPACE);
        Assert.assertNotNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
        Namespace deletedNamespace = this.namespaceService.deleteNamespace(new NamespaceKey(this.addWhitespace(NAMESPACE)));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE, deletedNamespace);
        Assert.assertNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
    }

    @Test
    public void testDeleteNamespaceUpperCaseParameters() {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toLowerCase());
        NamespaceKey namespaceKey = new NamespaceKey(NAMESPACE.toLowerCase());
        Assert.assertNotNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
        Namespace deletedNamespace = this.namespaceService.deleteNamespace(new NamespaceKey(NAMESPACE.toUpperCase()));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE.toLowerCase(), deletedNamespace);
        Assert.assertNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
    }

    @Test
    public void testDeleteNamespaceLowerCaseParameters() {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE.toUpperCase());
        NamespaceKey namespaceKey = new NamespaceKey(NAMESPACE.toUpperCase());
        Assert.assertNotNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
        Namespace deletedNamespace = this.namespaceService.deleteNamespace(new NamespaceKey(NAMESPACE.toLowerCase()));
        this.namespaceServiceTestHelper.validateNamespace(NAMESPACE.toUpperCase(), deletedNamespace);
        Assert.assertNull((Object)this.namespaceDao.getNamespaceByKey(namespaceKey));
    }

    @Test
    public void testDeleteNamespaceNoExists() throws Exception {
        try {
            this.namespaceService.deleteNamespace(new NamespaceKey(NAMESPACE));
            Assert.fail((String)"Should throw an ObjectNotFoundException when namespace doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", NAMESPACE), (Object)e.getMessage());
        }
    }
}

