/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.dao.BusinessObjectDataStatusDao;
import org.finra.herd.dao.BusinessObjectDataStatusDaoTestHelper;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.BusinessObjectDefinitionDaoTestHelper;
import org.finra.herd.dao.FileTypeDaoTestHelper;
import org.finra.herd.dao.JobDefinitionDaoTestHelper;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.dao.NotificationEventTypeDao;
import org.finra.herd.dao.NotificationRegistrationDaoTestHelper;
import org.finra.herd.dao.StorageDaoTestHelper;
import org.finra.herd.dao.StorageUnitStatusDao;
import org.finra.herd.dao.StorageUnitStatusDaoTestHelper;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.JobAction;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NotificationRegistrationServiceTestHelper {
    @Autowired
    private BusinessObjectDataStatusDao businessObjectDataStatusDao;
    @Autowired
    private BusinessObjectDataStatusDaoTestHelper businessObjectDataStatusDaoTestHelper;
    @Autowired
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Autowired
    private BusinessObjectDefinitionDaoTestHelper businessObjectDefinitionDaoTestHelper;
    @Autowired
    private FileTypeDaoTestHelper fileTypeDaoTestHelper;
    @Autowired
    private JobDefinitionDaoTestHelper jobDefinitionDaoTestHelper;
    @Autowired
    private NamespaceDao namespaceDao;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    private NotificationEventTypeDao notificationEventTypeDao;
    @Autowired
    private NotificationRegistrationDaoTestHelper notificationRegistrationDaoTestHelper;
    @Autowired
    private StorageDaoTestHelper storageDaoTestHelper;
    @Autowired
    private StorageUnitStatusDao storageUnitStatusDao;
    @Autowired
    private StorageUnitStatusDaoTestHelper storageUnitStatusDaoTestHelper;

    public void createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting() {
        this.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(AbstractServiceTest.NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), AbstractServiceTest.NOTIFICATION_EVENT_TYPE), AbstractServiceTest.BDEF_NAMESPACE, AbstractServiceTest.BDEF_NAME, Arrays.asList(AbstractServiceTest.FORMAT_FILE_TYPE_CODE), Arrays.asList(AbstractServiceTest.STORAGE_NAME), Arrays.asList(AbstractServiceTest.BDATA_STATUS, AbstractServiceTest.BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions());
    }

    public void createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(String namespace, List<String> notificationEventTypes, String businessObjectDefinitionNamespace, String businessObjectDefinitionName, List<String> fileTypes, List<String> storageNames, List<String> businessObjectDataStatuses, List<JobAction> jobActions) {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity;
        NamespaceEntity namespaceEntity = this.namespaceDao.getNamespaceByCd(namespace);
        if (namespaceEntity == null) {
            this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        }
        if (!CollectionUtils.isEmpty(notificationEventTypes)) {
            for (String notificationEventType : notificationEventTypes) {
                NotificationEventTypeEntity notificationEventTypeEntity = this.notificationEventTypeDao.getNotificationEventTypeByCode(notificationEventType);
                if (notificationEventTypeEntity != null) continue;
                this.notificationRegistrationDaoTestHelper.createNotificationEventTypeEntity(notificationEventType);
            }
        }
        if ((businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(businessObjectDefinitionNamespace, businessObjectDefinitionName))) == null) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(businessObjectDefinitionNamespace, businessObjectDefinitionName, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_DESCRIPTION);
        }
        if (!CollectionUtils.isEmpty(fileTypes)) {
            for (String businessObjectFormatFileType : fileTypes) {
                this.fileTypeDaoTestHelper.createFileTypeEntity(businessObjectFormatFileType);
            }
        }
        if (!CollectionUtils.isEmpty(storageNames)) {
            for (String storageName : storageNames) {
                this.storageDaoTestHelper.createStorageEntity(storageName, "S3");
            }
        }
        if (!CollectionUtils.isEmpty(businessObjectDataStatuses)) {
            for (String businessObjectDataStatus : businessObjectDataStatuses) {
                BusinessObjectDataStatusEntity businessObjectDataStatusEntity = this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode(businessObjectDataStatus);
                if (businessObjectDataStatusEntity != null) continue;
                this.businessObjectDataStatusDaoTestHelper.createBusinessObjectDataStatusEntity(businessObjectDataStatus);
            }
        }
        if (!CollectionUtils.isEmpty(jobActions)) {
            for (JobAction jobAction : jobActions) {
                this.jobDefinitionDaoTestHelper.createJobDefinitionEntity(jobAction.getNamespace(), jobAction.getJobName(), String.format("Description of \"%s.%s\" job definition.", jobAction.getNamespace(), jobAction.getJobName()), String.format("%s.%s.%s", jobAction.getNamespace(), jobAction.getJobName(), AbstractServiceTest.ACTIVITI_ID));
            }
        }
    }

    public void createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting() {
        this.createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(AbstractServiceTest.NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), AbstractServiceTest.NOTIFICATION_EVENT_TYPE), AbstractServiceTest.BDEF_NAMESPACE, AbstractServiceTest.BDEF_NAME, Arrays.asList(AbstractServiceTest.FORMAT_FILE_TYPE_CODE), Arrays.asList(AbstractServiceTest.STORAGE_NAME), Arrays.asList(AbstractServiceTest.STORAGE_UNIT_STATUS, AbstractServiceTest.STORAGE_UNIT_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions());
    }

    public void createDatabaseEntitiesForStorageUnitNotificationRegistrationTesting(String namespace, List<String> notificationEventTypes, String businessObjectDefinitionNamespace, String businessObjectDefinitionName, List<String> fileTypes, List<String> storageNames, List<String> storageUnitStatuses, List<JobAction> jobActions) {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity;
        NamespaceEntity namespaceEntity = this.namespaceDao.getNamespaceByCd(namespace);
        if (namespaceEntity == null) {
            this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        }
        if (!CollectionUtils.isEmpty(notificationEventTypes)) {
            for (String notificationEventType : notificationEventTypes) {
                NotificationEventTypeEntity notificationEventTypeEntity = this.notificationEventTypeDao.getNotificationEventTypeByCode(notificationEventType);
                if (notificationEventTypeEntity != null) continue;
                this.notificationRegistrationDaoTestHelper.createNotificationEventTypeEntity(notificationEventType);
            }
        }
        if ((businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(businessObjectDefinitionNamespace, businessObjectDefinitionName))) == null) {
            this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(businessObjectDefinitionNamespace, businessObjectDefinitionName, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.BDEF_DESCRIPTION);
        }
        if (!CollectionUtils.isEmpty(fileTypes)) {
            for (String businessObjectFormatFileType : fileTypes) {
                this.fileTypeDaoTestHelper.createFileTypeEntity(businessObjectFormatFileType);
            }
        }
        if (!CollectionUtils.isEmpty(storageNames)) {
            for (String storageName : storageNames) {
                this.storageDaoTestHelper.createStorageEntity(storageName, "S3");
            }
        }
        if (!CollectionUtils.isEmpty(storageUnitStatuses)) {
            for (String storageUnitStatus : storageUnitStatuses) {
                StorageUnitStatusEntity storageUnitStatusEntity = this.storageUnitStatusDao.getStorageUnitStatusByCode(storageUnitStatus);
                if (storageUnitStatusEntity != null) continue;
                this.storageUnitStatusDaoTestHelper.createStorageUnitStatusEntity(storageUnitStatus);
            }
        }
        if (!CollectionUtils.isEmpty(jobActions)) {
            for (JobAction jobAction : jobActions) {
                this.jobDefinitionDaoTestHelper.createJobDefinitionEntity(jobAction.getNamespace(), jobAction.getJobName(), String.format("Description of \"%s.%s\" job definition.", jobAction.getNamespace(), jobAction.getJobName()), String.format("%s.%s.%s", jobAction.getNamespace(), jobAction.getJobName(), AbstractServiceTest.ACTIVITI_ID));
            }
        }
    }

    public void validateBusinessObjectDataNotificationRegistrationKey(String expectedNamespaceCode, String expectedNotificationName, NotificationRegistrationKey actualBusinessObjectDataNotificationRegistrationKey) {
        Assert.assertNotNull((Object)actualBusinessObjectDataNotificationRegistrationKey);
        Assert.assertEquals((Object)expectedNamespaceCode, (Object)actualBusinessObjectDataNotificationRegistrationKey.getNamespace());
        Assert.assertEquals((Object)expectedNotificationName, (Object)actualBusinessObjectDataNotificationRegistrationKey.getNotificationName());
    }
}

