/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.RelationalTableRegistrationCreateRequest;
import org.finra.herd.model.dto.RelationalStorageAttributesDto;
import org.finra.herd.model.dto.RelationalTableRegistrationDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.RelationalTableRegistrationHelperService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RelationalTableRegistrationHelperServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="relationalTableRegistrationHelperServiceImpl")
    private RelationalTableRegistrationHelperService relationalTableRegistrationHelperServiceImpl;

    @Test
    public void testPrepareForRelationalTableRegistrationBusinessObjectDefinitionAlreadyExists() {
        this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        try {
            this.relationalTableRegistrationHelperService.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (AlreadyExistsException ex) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" already exists for namespace \"%s\".", BDEF_NAME, BDEF_NAMESPACE), (Object)ex.getMessage());
        }
    }

    @Test
    public void testPrepareForRelationalTableRegistrationBusinessObjectFormatAlreadyExists() {
        this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", Integer.valueOf(1), FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY, PARTITION_KEY_GROUP);
        try {
            this.relationalTableRegistrationHelperService.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_TRUE);
            Assert.fail();
        }
        catch (AlreadyExistsException alreadyExistsException) {
            Assert.assertEquals((Object)String.format("Format with file type \"%s\" and usage \"%s\" already exists for business object definition \"%s\".", "RELATIONAL_TABLE", FORMAT_USAGE_CODE, BDEF_NAME), (Object)alreadyExistsException.getMessage());
        }
    }

    @Test
    public void testPrepareForRelationalTableRegistrationInvalidStoragePlatform() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, STORAGE_PLATFORM_CODE);
        try {
            this.relationalTableRegistrationHelperService.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME_2), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Cannot register relational table in \"%s\" storage of %s storage platform type. Only %s storage platform type is supported by this feature.", STORAGE_NAME_2, STORAGE_PLATFORM_CODE, "RELATIONAL"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareForRelationalTableRegistrationRequiredDatabaseEntitiesNoExist() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        try {
            this.relationalTableRegistrationHelperService.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, "I_DO_NOT_EXIST"), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testRegisterRelationalTableBusinessObjectDefinitionAlreadyExists() {
        this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (AlreadyExistsException ex) {
            Assert.assertEquals((Object)String.format("Unable to create business object definition with name \"%s\" because it already exists for namespace \"%s\".", BDEF_NAME, BDEF_NAMESPACE), (Object)ex.getMessage());
        }
    }

    @Test
    public void testRegisterRelationalTableBusinessObjectDefinitionDoesNotExist() {
        this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_TRUE);
            Assert.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", BDEF_NAME, BDEF_NAMESPACE), (Object)objectNotFoundException.getMessage());
        }
    }

    @Test
    public void testRegisterRelationalTableRequiredDatabaseEntitiesNoExist() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, "I_DO_NOT_EXIST"), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testRelationalTableRegistrationHelperServiceMethodsNewTransactionPropagation() {
        try {
            this.relationalTableRegistrationHelperServiceImpl.prepareForRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", BDEF_NAMESPACE), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.prepareForRelationalTableSchemaUpdate(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data storage unit {%s, storageName: \"%s\"} doesn't exist.", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION)), STORAGE_NAME), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.registerRelationalTable(new RelationalTableRegistrationCreateRequest(), new ArrayList(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.retrieveRelationalTableColumns(new RelationalStorageAttributesDto("jdbc:h2:mem:herdTestDb", USERNAME, NO_USER_CREDENTIAL_NAME), RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Failed to retrieve description of a relational table with \"%s\" name under \"%s\" schema at jdbc.url=\"%s\" using jdbc.username=\"%s\". Reason: Wrong user name or password [28000-196]", RELATIONAL_TABLE_NAME, RELATIONAL_SCHEMA_NAME, "jdbc:h2:mem:herdTestDb", USERNAME), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.updateRelationalTableSchema(new RelationalTableRegistrationDto(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), new RelationalStorageAttributesDto(), RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, new BusinessObjectFormat(ID.intValue(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue(), LATEST_VERSION_FLAG_SET.booleanValue(), PARTITION_KEY, DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, NO_ATTRIBUTES, NO_ATTRIBUTE_DEFINITIONS, NO_SCHEMA, NO_BUSINESS_OBJECT_FORMAT_PARENTS, NO_BUSINESS_OBJECT_FORMAT_CHILDREN, NO_RECORD_FLAG_SET, NO_RETENTION_PERIOD_IN_DAYS, NO_RETENTION_TYPE, NO_ALLOW_NON_BACKWARDS_COMPATIBLE_CHANGES_SET)), NO_COLUMNS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A schema must have at least one column.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRetrieveRelationalTableColumnsRelationTableNoExists() {
        RelationalStorageAttributesDto relationalStorageAttributesDto = new RelationalStorageAttributesDto();
        relationalStorageAttributesDto.setJdbcUrl("jdbc:h2:mem:herdTestDb");
        relationalStorageAttributesDto.setJdbcUsername("");
        relationalStorageAttributesDto.setJdbcUserCredentialName(NO_USER_CREDENTIAL_NAME);
        try {
            this.relationalTableRegistrationHelperService.retrieveRelationalTableColumns(relationalStorageAttributesDto, RELATIONAL_SCHEMA_NAME, "I_DO_NOT_EXIST");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Relational table with \"%s\" name not found under \"%s\" schema at jdbc.url=\"%s\" for jdbc.username=\"%s\".", "I_DO_NOT_EXIST", RELATIONAL_SCHEMA_NAME, "jdbc:h2:mem:herdTestDb", ""), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetrieveRelationalTableColumnsSqlException() {
        RelationalStorageAttributesDto relationalStorageAttributesDto = new RelationalStorageAttributesDto();
        relationalStorageAttributesDto.setJdbcUrl(INVALID_VALUE);
        relationalStorageAttributesDto.setJdbcUsername(USERNAME);
        relationalStorageAttributesDto.setJdbcUserCredentialName(NO_USER_CREDENTIAL_NAME);
        try {
            this.relationalTableRegistrationHelperService.retrieveRelationalTableColumns(relationalStorageAttributesDto, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Failed to retrieve description of a relational table with \"%s\" name under \"%s\" schema at jdbc.url=\"%s\" using jdbc.username=\"%s\". Reason: No suitable driver found for %s", RELATIONAL_TABLE_NAME, RELATIONAL_SCHEMA_NAME, INVALID_VALUE, USERNAME, INVALID_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestMissingOptionalParametersAsBlanks() {
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME);
        this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(relationalTableRegistrationCreateRequest);
        Assert.assertEquals((Object)new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, "", FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), (Object)relationalTableRegistrationCreateRequest);
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestMissingOptionalParametersAsNulls() {
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, NO_BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME);
        this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(relationalTableRegistrationCreateRequest);
        Assert.assertEquals((Object)new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, NO_BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), (Object)relationalTableRegistrationCreateRequest);
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestMissingRequiredParameters() {
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A relational table registration create request must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest("      \t\t ", BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, "      \t\t ", BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, "      \t\t ", DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, "      \t\t ", RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, "      \t\t ", RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A relational schema name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, "      \t\t ", STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A relational table name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestTrimParameters() {
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(BDEF_DISPLAY_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(DATA_PROVIDER_NAME), this.addWhitespace(RELATIONAL_SCHEMA_NAME), this.addWhitespace(RELATIONAL_TABLE_NAME), this.addWhitespace(STORAGE_NAME));
        this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(relationalTableRegistrationCreateRequest);
        Assert.assertEquals((Object)new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), (Object)relationalTableRegistrationCreateRequest);
    }
}

