/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.BusinessObjectFormatCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.RelationalTableRegistrationCreateRequest;
import org.finra.herd.model.api.xml.Schema;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.RelationalTableRegistrationService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RelationalTableRegistrationServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="relationalTableRegistrationServiceImpl")
    private RelationalTableRegistrationService relationalTableRegistrationServiceImpl;

    @Test
    public void testCreateRelationalTableRegistration() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        String relationalSchemaName = "PUBLIC";
        String relationalTableName = "bus_objct_dfntn".toUpperCase();
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, relationalSchemaName, relationalTableName, STORAGE_NAME);
        BusinessObjectData resultBusinessObjectData = this.relationalTableRegistrationService.createRelationalTableRegistration(relationalTableRegistrationCreateRequest, APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
        StorageUnit expectedStorageUnit = new StorageUnit();
        expectedStorageUnit.setStorage(new Storage(STORAGE_NAME, "RELATIONAL", this.relationalTableRegistrationServiceTestHelper.getStorageAttributes()));
        expectedStorageUnit.setStorageUnitStatus("ENABLED");
        BusinessObjectData expectedBusinessObjectData = new BusinessObjectData();
        expectedBusinessObjectData.setId(resultBusinessObjectData.getId());
        expectedBusinessObjectData.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectData.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectData.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectData.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectData.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION.intValue());
        expectedBusinessObjectData.setPartitionValue("none");
        expectedBusinessObjectData.setSubPartitionValues(new ArrayList());
        expectedBusinessObjectData.setVersion(INITIAL_DATA_VERSION.intValue());
        expectedBusinessObjectData.setPartitionKey("partition");
        expectedBusinessObjectData.setLatestVersion(LATEST_VERSION_FLAG_SET);
        expectedBusinessObjectData.setStatus("VALID");
        expectedBusinessObjectData.setStorageUnits(Collections.singletonList(expectedStorageUnit));
        expectedBusinessObjectData.setAttributes(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataParents(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataChildren(new ArrayList());
        Assert.assertEquals((Object)expectedBusinessObjectData, (Object)resultBusinessObjectData);
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", INITIAL_FORMAT_VERSION);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKey);
        Schema expectedSchema = new Schema();
        expectedSchema.setColumns(this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
        expectedSchema.setNullValue("");
        BusinessObjectFormat expectedBusinessObjectFormat = new BusinessObjectFormat();
        expectedBusinessObjectFormat.setId(resultBusinessObjectFormat.getId());
        expectedBusinessObjectFormat.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectFormat.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectFormat.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectFormat.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectFormat.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION.intValue());
        expectedBusinessObjectFormat.setLatestVersion(LATEST_VERSION_FLAG_SET.booleanValue());
        expectedBusinessObjectFormat.setPartitionKey("partition");
        expectedBusinessObjectFormat.setBusinessObjectFormatParents(new ArrayList());
        expectedBusinessObjectFormat.setBusinessObjectFormatChildren(new ArrayList());
        expectedBusinessObjectFormat.setAttributeDefinitions(new ArrayList());
        expectedBusinessObjectFormat.setAttributes(Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_SCHEMA_NAME), relationalSchemaName), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_TABLE_NAME), relationalTableName)));
        expectedBusinessObjectFormat.setSchema(expectedSchema);
        expectedBusinessObjectFormat.setAllowNonBackwardsCompatibleChanges(Boolean.valueOf(true));
        Assert.assertEquals((Object)expectedBusinessObjectFormat, (Object)resultBusinessObjectFormat);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        BusinessObjectDefinition resultBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, Boolean.valueOf(true));
        BusinessObjectDefinition expectedBusinessObjectDefinition = new BusinessObjectDefinition();
        expectedBusinessObjectDefinition.setId(resultBusinessObjectDefinition.getId());
        expectedBusinessObjectDefinition.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectDefinition.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectDefinition.setDataProviderName(DATA_PROVIDER_NAME);
        expectedBusinessObjectDefinition.setDisplayName(BDEF_DISPLAY_NAME);
        expectedBusinessObjectDefinition.setAttributes(new ArrayList());
        expectedBusinessObjectDefinition.setSampleDataFiles(new ArrayList());
        expectedBusinessObjectDefinition.setCreatedByUserId(resultBusinessObjectDefinition.getCreatedByUserId());
        expectedBusinessObjectDefinition.setLastUpdatedByUserId(resultBusinessObjectDefinition.getLastUpdatedByUserId());
        expectedBusinessObjectDefinition.setLastUpdatedOn(resultBusinessObjectDefinition.getLastUpdatedOn());
        expectedBusinessObjectDefinition.setBusinessObjectDefinitionChangeEvents(resultBusinessObjectDefinition.getBusinessObjectDefinitionChangeEvents());
        Assert.assertEquals((Object)expectedBusinessObjectDefinition, (Object)resultBusinessObjectDefinition);
    }

    @Test
    public void testCreateRelationalTableRegistrationWithAppendToExistingBusinessObjectDefinitionSetToTrue() {
        BusinessObjectDefinitionEntity existingBusinessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION, BDEF_DISPLAY_NAME, new ArrayList());
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(STORAGE_NAME);
        String relationalSchemaName = "PUBLIC";
        String relationalTableName = "bus_objct_dfntn".toUpperCase();
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, relationalSchemaName, relationalTableName, STORAGE_NAME);
        BusinessObjectData businessObjectData = this.relationalTableRegistrationService.createRelationalTableRegistration(relationalTableRegistrationCreateRequest, APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_TRUE);
        StorageUnit expectedStorageUnit = new StorageUnit();
        expectedStorageUnit.setStorage(new Storage(STORAGE_NAME, "RELATIONAL", this.relationalTableRegistrationServiceTestHelper.getStorageAttributes()));
        expectedStorageUnit.setStorageUnitStatus("ENABLED");
        BusinessObjectData expectedBusinessObjectData = new BusinessObjectData();
        expectedBusinessObjectData.setId(businessObjectData.getId());
        expectedBusinessObjectData.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectData.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectData.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectData.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectData.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION.intValue());
        expectedBusinessObjectData.setPartitionValue("none");
        expectedBusinessObjectData.setSubPartitionValues(new ArrayList());
        expectedBusinessObjectData.setVersion(INITIAL_DATA_VERSION.intValue());
        expectedBusinessObjectData.setPartitionKey("partition");
        expectedBusinessObjectData.setLatestVersion(LATEST_VERSION_FLAG_SET);
        expectedBusinessObjectData.setStatus("VALID");
        expectedBusinessObjectData.setStorageUnits(Collections.singletonList(expectedStorageUnit));
        expectedBusinessObjectData.setAttributes(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataParents(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataChildren(new ArrayList());
        Assert.assertEquals((Object)expectedBusinessObjectData, (Object)businessObjectData);
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", INITIAL_FORMAT_VERSION);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKey);
        Schema expectedSchema = new Schema();
        expectedSchema.setColumns(this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
        expectedSchema.setNullValue("");
        BusinessObjectFormat expectedBusinessObjectFormat = new BusinessObjectFormat();
        expectedBusinessObjectFormat.setId(businessObjectFormat.getId());
        expectedBusinessObjectFormat.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectFormat.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectFormat.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectFormat.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectFormat.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION.intValue());
        expectedBusinessObjectFormat.setLatestVersion(LATEST_VERSION_FLAG_SET.booleanValue());
        expectedBusinessObjectFormat.setPartitionKey("partition");
        expectedBusinessObjectFormat.setBusinessObjectFormatParents(new ArrayList());
        expectedBusinessObjectFormat.setBusinessObjectFormatChildren(new ArrayList());
        expectedBusinessObjectFormat.setAttributeDefinitions(new ArrayList());
        expectedBusinessObjectFormat.setAttributes(Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_SCHEMA_NAME), relationalSchemaName), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_TABLE_NAME), relationalTableName)));
        expectedBusinessObjectFormat.setSchema(expectedSchema);
        expectedBusinessObjectFormat.setAllowNonBackwardsCompatibleChanges(Boolean.valueOf(true));
        Assert.assertEquals((Object)expectedBusinessObjectFormat, (Object)businessObjectFormat);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        Assert.assertEquals((Object)existingBusinessObjectDefinitionEntity, (Object)businessObjectDefinitionEntity);
    }

    @Test
    public void testGetRelationalTableRegistrationsForSchemaUpdate() {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "RELATIONAL", new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", INITIAL_FORMAT_VERSION, "none", NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION), AbstractDaoTest.LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", AbstractDaoTest.NO_STORAGE_DIRECTORY_PATH);
        List result = this.relationalTableRegistrationService.getRelationalTableRegistrationsForSchemaUpdate();
        Assert.assertEquals(Collections.singletonList(this.storageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity)), (Object)result);
    }

    @Test
    public void testProcessRelationalTableRegistrationForSchemaUpdate() {
        String relationalSchemaName = "PUBLIC";
        String relationalTableName = "bus_objct_dfntn".toUpperCase();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "RELATIONAL", this.relationalTableRegistrationServiceTestHelper.getStorageAttributes());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION, BDEF_DISPLAY_NAME, new ArrayList());
        this.fileTypeDaoTestHelper.createFileTypeEntity("RELATIONAL_TABLE", AbstractServiceTest.FORMAT_FILE_TYPE_DESCRIPTION);
        Schema expectedSchema = new Schema();
        expectedSchema.setColumns(this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
        expectedSchema.setNullValue("");
        BusinessObjectFormat initialBusinessObjectFormat = this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", "partition", NO_FORMAT_DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_SCHEMA_NAME), relationalSchemaName), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_TABLE_NAME), relationalTableName)), NO_ATTRIBUTE_DEFINITIONS, new Schema(expectedSchema.getColumns().subList(0, expectedSchema.getColumns().size() - 1), NO_PARTITION_COLUMNS, "", null, null, NO_PARTITION_KEY_GROUP)));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", INITIAL_FORMAT_VERSION, "none", NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "RELATIONAL", businessObjectDataKey, AbstractDaoTest.LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", AbstractDaoTest.NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataStorageUnitKey storageUnitKey = this.storageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity);
        BusinessObjectData resultBusinessObjectData = this.relationalTableRegistrationService.processRelationalTableRegistrationForSchemaUpdate(storageUnitKey);
        StorageUnit expectedStorageUnit = new StorageUnit();
        expectedStorageUnit.setStorage(new Storage(STORAGE_NAME, "RELATIONAL", this.relationalTableRegistrationServiceTestHelper.getStorageAttributes()));
        expectedStorageUnit.setStorageUnitStatus("ENABLED");
        BusinessObjectData expectedBusinessObjectData = new BusinessObjectData();
        expectedBusinessObjectData.setId(resultBusinessObjectData.getId());
        expectedBusinessObjectData.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectData.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectData.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectData.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectData.setBusinessObjectFormatVersion(SECOND_FORMAT_VERSION.intValue());
        expectedBusinessObjectData.setPartitionValue("none");
        expectedBusinessObjectData.setSubPartitionValues(new ArrayList());
        expectedBusinessObjectData.setVersion(INITIAL_DATA_VERSION.intValue());
        expectedBusinessObjectData.setPartitionKey("partition");
        expectedBusinessObjectData.setLatestVersion(LATEST_VERSION_FLAG_SET);
        expectedBusinessObjectData.setStatus("VALID");
        expectedBusinessObjectData.setStorageUnits(Collections.singletonList(expectedStorageUnit));
        expectedBusinessObjectData.setAttributes(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataParents(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataChildren(new ArrayList());
        Assert.assertEquals((Object)expectedBusinessObjectData, (Object)resultBusinessObjectData);
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", SECOND_FORMAT_VERSION);
        BusinessObjectFormat resultBusinessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKey);
        BusinessObjectFormat expectedBusinessObjectFormat = (BusinessObjectFormat)initialBusinessObjectFormat.clone();
        expectedBusinessObjectFormat.setId(resultBusinessObjectFormat.getId());
        expectedBusinessObjectFormat.setBusinessObjectFormatVersion(SECOND_FORMAT_VERSION.intValue());
        expectedBusinessObjectFormat.setSchema(expectedSchema);
        Assert.assertEquals((Object)expectedBusinessObjectFormat, (Object)resultBusinessObjectFormat);
    }

    @Test
    public void testProcessRelationalTableRegistrationForSchemaUpdateNoSchemaChanges() {
        String relationalSchemaName = "PUBLIC";
        String relationalTableName = "bus_objct_dfntn".toUpperCase();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "RELATIONAL", this.relationalTableRegistrationServiceTestHelper.getStorageAttributes());
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, DESCRIPTION, BDEF_DISPLAY_NAME, new ArrayList());
        this.fileTypeDaoTestHelper.createFileTypeEntity("RELATIONAL_TABLE", AbstractServiceTest.FORMAT_FILE_TYPE_DESCRIPTION);
        this.businessObjectFormatService.createBusinessObjectFormat(new BusinessObjectFormatCreateRequest(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", "partition", DESCRIPTION, NO_FORMAT_DOCUMENT_SCHEMA, Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_SCHEMA_NAME), relationalSchemaName), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_TABLE_NAME), relationalTableName)), NO_ATTRIBUTE_DEFINITIONS, new Schema(this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns(), NO_PARTITION_COLUMNS, "", null, null, NO_PARTITION_KEY_GROUP)));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", INITIAL_FORMAT_VERSION, "none", NO_SUBPARTITION_VALUES, INITIAL_DATA_VERSION);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "RELATIONAL", businessObjectDataKey, AbstractDaoTest.LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", AbstractDaoTest.NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataStorageUnitKey storageUnitKey = this.storageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity);
        BusinessObjectData resultBusinessObjectData = this.relationalTableRegistrationService.processRelationalTableRegistrationForSchemaUpdate(storageUnitKey);
        Assert.assertNull((Object)resultBusinessObjectData);
    }

    @Test
    public void testRelationalTableRegistrationServiceMethodsNewTransactionPropagation() {
        try {
            this.relationalTableRegistrationServiceImpl.createRelationalTableRegistration(new RelationalTableRegistrationCreateRequest(), APPEND_TO_EXISTING_BUSINESS_OBJECT_DEFINTION_FALSE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        this.relationalTableRegistrationServiceImpl.getRelationalTableRegistrationsForSchemaUpdate();
        try {
            this.relationalTableRegistrationServiceImpl.processRelationalTableRegistrationForSchemaUpdate(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data storage unit {%s, storageName: \"%s\"} doesn't exist.", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION)), STORAGE_NAME), (Object)e.getMessage());
        }
    }
}

