/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.Tag;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.dao.S3Dao;
import org.finra.herd.model.dto.S3FileCopyRequestParamsDto;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.S3FileTransferResultsDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.S3ServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class S3ServiceTest
extends AbstractServiceTest {
    @Mock
    private S3Dao s3Dao;
    @InjectMocks
    private S3ServiceImpl s3Service;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCopyFile() throws InterruptedException {
        S3FileCopyRequestParamsDto s3FileCopyRequestParamsDto = new S3FileCopyRequestParamsDto();
        S3FileTransferResultsDto s3FileTransferResultsDto = new S3FileTransferResultsDto();
        Mockito.when((Object)this.s3Dao.copyFile(s3FileCopyRequestParamsDto)).thenReturn((Object)s3FileTransferResultsDto);
        S3FileTransferResultsDto result = this.s3Service.copyFile(s3FileCopyRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).copyFile(s3FileCopyRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals((Object)s3FileTransferResultsDto, (Object)result);
    }

    @Test
    public void testCreateDirectory() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        this.s3Service.createDirectory(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).createDirectory(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testDeleteDirectory() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        this.s3Service.deleteDirectory(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).deleteDirectory(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testDeleteDirectoryIgnoreException() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        this.s3Service.deleteDirectoryIgnoreException(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).deleteDirectory(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testDeleteDirectoryIgnoreExceptionWhenRuntimeExceptionOccurs() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        ((S3Dao)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.s3Dao)).deleteDirectory(s3FileTransferRequestParamsDto);
        this.s3Service.deleteDirectoryIgnoreException(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).deleteDirectory(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testDeleteFileList() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        this.s3Service.deleteFileList(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).deleteFileList(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testDownloadDirectory() throws InterruptedException {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferResultsDto s3FileTransferResultsDto = new S3FileTransferResultsDto();
        Mockito.when((Object)this.s3Dao.downloadDirectory(s3FileTransferRequestParamsDto)).thenReturn((Object)s3FileTransferResultsDto);
        S3FileTransferResultsDto result = this.s3Service.downloadDirectory(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).downloadDirectory(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals((Object)s3FileTransferResultsDto, (Object)result);
    }

    @Test
    public void testDownloadFile() throws InterruptedException {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferResultsDto s3FileTransferResultsDto = new S3FileTransferResultsDto();
        Mockito.when((Object)this.s3Dao.downloadFile(s3FileTransferRequestParamsDto)).thenReturn((Object)s3FileTransferResultsDto);
        S3FileTransferResultsDto result = this.s3Service.downloadFile(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).downloadFile(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals((Object)s3FileTransferResultsDto, (Object)result);
    }

    @Test
    public void testListDirectory() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        List<S3ObjectSummary> s3ObjectSummaries = Arrays.asList(new S3ObjectSummary());
        Mockito.when((Object)this.s3Dao.listDirectory(s3FileTransferRequestParamsDto, false)).thenReturn(s3ObjectSummaries);
        List result = this.s3Service.listDirectory(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).listDirectory(s3FileTransferRequestParamsDto, false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals(s3ObjectSummaries, (Object)result);
    }

    @Test
    public void testListDirectoryIgnoreZeroByteDirectoryMarkers() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        List<S3ObjectSummary> s3ObjectSummaries = Arrays.asList(new S3ObjectSummary());
        Mockito.when((Object)this.s3Dao.listDirectory(s3FileTransferRequestParamsDto, true)).thenReturn(s3ObjectSummaries);
        List result = this.s3Service.listDirectory(s3FileTransferRequestParamsDto, true);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).listDirectory(s3FileTransferRequestParamsDto, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals(s3ObjectSummaries, (Object)result);
    }

    @Test
    public void testRestoreObjects() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        this.s3Service.restoreObjects(s3FileTransferRequestParamsDto, INTEGER_VALUE.intValue());
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).restoreObjects(s3FileTransferRequestParamsDto, INTEGER_VALUE.intValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testTagObjects() {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        s3FileTransferRequestParamsDto.setFiles(Arrays.asList(new File(TEST_S3_KEY_PREFIX + "/" + "foo.dat")));
        S3FileTransferRequestParamsDto s3ObjectTaggerParamsDto = new S3FileTransferRequestParamsDto();
        s3ObjectTaggerParamsDto.setAwsAccessKeyId(AWS_ASSUMED_ROLE_ACCESS_KEY);
        s3ObjectTaggerParamsDto.setAwsSecretKey(AWS_ASSUMED_ROLE_SECRET_KEY);
        s3ObjectTaggerParamsDto.setSessionToken(AWS_ASSUMED_ROLE_SESSION_TOKEN);
        Tag tag = new Tag(S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE);
        this.s3Service.tagObjects(s3FileTransferRequestParamsDto, s3ObjectTaggerParamsDto, tag);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).tagObjects(s3FileTransferRequestParamsDto, s3ObjectTaggerParamsDto, tag);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }

    @Test
    public void testUploadDirectory() throws InterruptedException {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferResultsDto s3FileTransferResultsDto = new S3FileTransferResultsDto();
        Mockito.when((Object)this.s3Dao.uploadDirectory(s3FileTransferRequestParamsDto)).thenReturn((Object)s3FileTransferResultsDto);
        S3FileTransferResultsDto result = this.s3Service.uploadDirectory(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).uploadDirectory(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals((Object)s3FileTransferResultsDto, (Object)result);
    }

    @Test
    public void testUploadFile() throws InterruptedException {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferResultsDto s3FileTransferResultsDto = new S3FileTransferResultsDto();
        Mockito.when((Object)this.s3Dao.uploadFile(s3FileTransferRequestParamsDto)).thenReturn((Object)s3FileTransferResultsDto);
        S3FileTransferResultsDto result = this.s3Service.uploadFile(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).uploadFile(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals((Object)s3FileTransferResultsDto, (Object)result);
    }

    @Test
    public void testUploadFileList() throws InterruptedException {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferResultsDto s3FileTransferResultsDto = new S3FileTransferResultsDto();
        Mockito.when((Object)this.s3Dao.uploadFileList(s3FileTransferRequestParamsDto)).thenReturn((Object)s3FileTransferResultsDto);
        S3FileTransferResultsDto result = this.s3Service.uploadFileList(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).uploadFileList(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
        Assert.assertEquals((Object)s3FileTransferResultsDto, (Object)result);
    }

    @Test
    public void testValidateGlacierS3FilesRestored() throws RuntimeException {
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        this.s3Service.validateGlacierS3FilesRestored(s3FileTransferRequestParamsDto);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).validateGlacierS3FilesRestored(s3FileTransferRequestParamsDto);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.s3Dao});
    }
}

