/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.DocsStats;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.dao.SearchIndexDao;
import org.finra.herd.model.api.xml.SearchIndex;
import org.finra.herd.model.api.xml.SearchIndexCreateRequest;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.api.xml.SearchIndexKeys;
import org.finra.herd.model.api.xml.SearchIndexStatistics;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.SearchIndexEntity;
import org.finra.herd.model.jpa.SearchIndexStatusEntity;
import org.finra.herd.model.jpa.SearchIndexTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.SearchIndexHelperService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.ConfigurationDaoHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.helper.SearchIndexStatusDaoHelper;
import org.finra.herd.service.helper.SearchIndexTypeDaoHelper;
import org.finra.herd.service.impl.SearchIndexServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class SearchIndexServiceTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private ConfigurationDaoHelper configurationDaoHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private IndexFunctionsDao indexFunctionsDao;
    @Mock
    private SearchIndexDao searchIndexDao;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;
    @Mock
    private SearchIndexHelperService searchIndexHelperService;
    @InjectMocks
    private SearchIndexServiceImpl searchIndexService;
    @Mock
    private SearchIndexStatusDaoHelper searchIndexStatusDaoHelper;
    @Mock
    private SearchIndexTypeDaoHelper searchIndexTypeDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateSearchIndex() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name();
        String searchIndexStatus = SearchIndexStatusEntity.SearchIndexStatuses.BUILDING.name();
        SearchIndexCreateRequest searchIndexCreateRequest = new SearchIndexCreateRequest(searchIndexType);
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(searchIndexType);
        SearchIndexStatusEntity searchIndexStatusEntity = new SearchIndexStatusEntity();
        searchIndexStatusEntity.setCode(searchIndexStatus);
        SearchIndexEntity searchIndexEntity = new SearchIndexEntity();
        searchIndexEntity.setName(SEARCH_INDEX_NAME);
        searchIndexEntity.setType(searchIndexTypeEntity);
        searchIndexEntity.setStatus(searchIndexStatusEntity);
        searchIndexEntity.setCreatedBy(USER_ID);
        searchIndexEntity.setCreatedOn(new Timestamp(CREATED_ON.toGregorianCalendar().getTimeInMillis()));
        searchIndexEntity.setUpdatedOn(new Timestamp(UPDATED_ON.toGregorianCalendar().getTimeInMillis()));
        searchIndexEntity.setActive(Boolean.FALSE);
        Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("Search index type", searchIndexType)).thenReturn((Object)searchIndexType);
        Mockito.when((Object)this.searchIndexTypeDaoHelper.getSearchIndexTypeEntity(searchIndexType)).thenReturn((Object)searchIndexTypeEntity);
        Mockito.when((Object)this.searchIndexStatusDaoHelper.getSearchIndexStatusEntity(searchIndexStatus)).thenReturn((Object)searchIndexStatusEntity);
        Mockito.when((Object)this.searchIndexDao.saveAndRefresh(Matchers.any(SearchIndexEntity.class))).thenReturn((Object)searchIndexEntity);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)"bdef");
        Mockito.when((Object)this.configurationDaoHelper.getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_MAPPINGS_JSON.getKey())).thenReturn((Object)SEARCH_INDEX_MAPPING);
        Mockito.when((Object)this.configurationDaoHelper.getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SETTINGS_JSON.getKey())).thenReturn((Object)SEARCH_INDEX_SETTINGS);
        Mockito.when((Object)this.searchIndexHelperService.indexAllBusinessObjectDefinitions(searchIndexKey, SEARCH_INDEX_DOCUMENT_TYPE)).thenReturn((Object)mockedFuture);
        SearchIndex response = this.searchIndexService.createSearchIndex(searchIndexCreateRequest);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("Search index type", searchIndexType);
        ((SearchIndexTypeDaoHelper)Mockito.verify((Object)this.searchIndexTypeDaoHelper)).getSearchIndexTypeEntity(searchIndexType);
        ((SearchIndexStatusDaoHelper)Mockito.verify((Object)this.searchIndexStatusDaoHelper)).getSearchIndexStatusEntity(searchIndexStatus);
        ((SearchIndexDao)Mockito.verify((Object)this.searchIndexDao)).saveAndRefresh(Matchers.any(SearchIndexEntity.class));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationDaoHelper)Mockito.verify((Object)this.configurationDaoHelper)).getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_MAPPINGS_JSON.getKey());
        ((ConfigurationDaoHelper)Mockito.verify((Object)this.configurationDaoHelper)).getClobProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SETTINGS_JSON.getKey());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).createIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        ((SearchIndexHelperService)Mockito.verify((Object)this.searchIndexHelperService)).indexAllBusinessObjectDefinitions(searchIndexKey, SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionsDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertEquals((Object)new SearchIndex(searchIndexKey, searchIndexType, searchIndexStatus, SEARCH_INDEX_DEFAULT_ACTIVE_FLAG.booleanValue(), NO_SEARCH_INDEX_STATISTICS, USER_ID, CREATED_ON, UPDATED_ON), (Object)response);
    }

    @Test
    public void testDeleteSearchIndex() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        SearchIndexEntity searchIndexEntity = this.createTestSearchIndexEntity();
        Mockito.when((Object)this.indexFunctionsDao.isIndexExists((String)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("Search index name", SEARCH_INDEX_NAME)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getSearchIndexEntity(searchIndexKey)).thenReturn((Object)searchIndexEntity);
        SearchIndex response = this.searchIndexService.deleteSearchIndex(searchIndexKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("Search index name", SEARCH_INDEX_NAME);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getSearchIndexEntity(searchIndexKey);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).isIndexExists((String)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).deleteIndex((String)Matchers.any());
        ((SearchIndexDao)Mockito.verify((Object)this.searchIndexDao)).delete((Object)searchIndexEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionsDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertEquals((Object)new SearchIndex(searchIndexKey, SEARCH_INDEX_TYPE_BDEF, SEARCH_INDEX_STATUS, SEARCH_INDEX_DEFAULT_ACTIVE_FLAG.booleanValue(), NO_SEARCH_INDEX_STATISTICS, USER_ID, CREATED_ON, UPDATED_ON), (Object)response);
    }

    @Test
    public void testGetSearchIndex() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        SearchIndexEntity searchIndexEntity = this.createTestSearchIndexEntity();
        DocsStats mockedDocsStats = (DocsStats)Mockito.mock(DocsStats.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("index.uuid", SEARCH_INDEX_STATISTICS_INDEX_UUID);
        map.put("index.creation_date", Long.toString(SEARCH_INDEX_STATISTICS_CREATION_DATE.toGregorianCalendar().getTimeInMillis()));
        Settings settings = Settings.builder().put(map).build();
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("Search index name", SEARCH_INDEX_NAME)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getSearchIndexEntity(searchIndexKey)).thenReturn((Object)searchIndexEntity);
        Mockito.when((Object)this.indexFunctionsDao.getIndexSettings(SEARCH_INDEX_NAME)).thenReturn((Object)settings);
        Mockito.when((Object)this.indexFunctionsDao.getIndexStats(SEARCH_INDEX_NAME)).thenReturn((Object)mockedDocsStats);
        Mockito.when((Object)mockedDocsStats.getCount()).thenReturn((Object)SEARCH_INDEX_STATISTICS_NUMBER_OF_ACTIVE_DOCUMENTS);
        Mockito.when((Object)mockedDocsStats.getDeleted()).thenReturn((Object)SEARCH_INDEX_STATISTICS_NUMBER_OF_DELETED_DOCUMENTS);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"doc");
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)0L);
        SearchIndex response = this.searchIndexService.getSearchIndex(searchIndexKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("Search index name", SEARCH_INDEX_NAME);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getSearchIndexEntity(searchIndexKey);
        ((DocsStats)Mockito.verify((Object)mockedDocsStats)).getCount();
        ((DocsStats)Mockito.verify((Object)mockedDocsStats)).getDeleted();
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getIndexSettings(SEARCH_INDEX_NAME);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getIndexStats(SEARCH_INDEX_NAME);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionsDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertEquals((Object)new SearchIndex(searchIndexKey, SEARCH_INDEX_TYPE_BDEF, SEARCH_INDEX_STATUS, SEARCH_INDEX_DEFAULT_ACTIVE_FLAG.booleanValue(), new SearchIndexStatistics(SEARCH_INDEX_STATISTICS_CREATION_DATE, SEARCH_INDEX_STATISTICS_NUMBER_OF_ACTIVE_DOCUMENTS, SEARCH_INDEX_STATISTICS_NUMBER_OF_DELETED_DOCUMENTS, SEARCH_INDEX_STATISTICS_INDEX_UUID, Long.valueOf(0L)), USER_ID, CREATED_ON, UPDATED_ON), (Object)response);
    }

    @Test
    public void testGetSearchIndexes() {
        List<SearchIndexKey> searchIndexKeys = Arrays.asList(new SearchIndexKey(SEARCH_INDEX_NAME), new SearchIndexKey(SEARCH_INDEX_NAME_2));
        Mockito.when((Object)this.searchIndexDao.getSearchIndexes()).thenReturn(searchIndexKeys);
        SearchIndexKeys response = this.searchIndexService.getSearchIndexes();
        ((SearchIndexDao)Mockito.verify((Object)this.searchIndexDao)).getSearchIndexes();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionsDao, this.searchIndexDao, this.searchIndexDaoHelper, this.searchIndexHelperService, this.searchIndexStatusDaoHelper, this.searchIndexTypeDaoHelper});
        Assert.assertEquals((Object)new SearchIndexKeys(searchIndexKeys), (Object)response);
    }

    private SearchIndexEntity createTestSearchIndexEntity() {
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(SEARCH_INDEX_TYPE_BDEF);
        SearchIndexStatusEntity searchIndexStatusEntity = new SearchIndexStatusEntity();
        searchIndexStatusEntity.setCode(SEARCH_INDEX_STATUS);
        SearchIndexEntity searchIndexEntity = new SearchIndexEntity();
        searchIndexEntity.setName(SEARCH_INDEX_NAME);
        searchIndexEntity.setType(searchIndexTypeEntity);
        searchIndexEntity.setStatus(searchIndexStatusEntity);
        searchIndexEntity.setCreatedBy(USER_ID);
        searchIndexEntity.setCreatedOn(new Timestamp(CREATED_ON.toGregorianCalendar().getTimeInMillis()));
        searchIndexEntity.setUpdatedOn(new Timestamp(UPDATED_ON.toGregorianCalendar().getTimeInMillis()));
        searchIndexEntity.setActive(Boolean.FALSE);
        return searchIndexEntity;
    }
}

