/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.api.xml.SearchIndexValidation;
import org.finra.herd.model.api.xml.SearchIndexValidationCreateRequest;
import org.finra.herd.model.jpa.SearchIndexEntity;
import org.finra.herd.model.jpa.SearchIndexTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDefinitionService;
import org.finra.herd.service.TagService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.impl.SearchIndexValidationServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.scheduling.annotation.AsyncResult;

public class SearchIndexValidationServiceTest
extends AbstractServiceTest {
    @InjectMocks
    private SearchIndexValidationServiceImpl searchIndexValidationService;
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;
    @Mock
    private BusinessObjectDefinitionService businessObjectDefinitionService;
    @Mock
    private TagService tagService;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    private void searchIndexValidation(SearchIndexKey searchIndexKey, SearchIndexValidationCreateRequest searchIndexValidationCreateRequest, String searchIndexType) {
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(searchIndexType);
        SearchIndexEntity searchIndexEntity = new SearchIndexEntity();
        searchIndexEntity.setName(SEARCH_INDEX_NAME);
        searchIndexEntity.setType(searchIndexTypeEntity);
        boolean sizeCheck = ThreadLocalRandom.current().nextDouble() < 0.5;
        boolean spotCheckPercentage = ThreadLocalRandom.current().nextDouble() < 0.5;
        boolean spotCheckMostRecent = ThreadLocalRandom.current().nextDouble() < 0.5;
        Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("Search index name", SEARCH_INDEX_NAME)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getSearchIndexEntity(searchIndexKey)).thenReturn((Object)searchIndexEntity);
        Mockito.when((Object)this.businessObjectDefinitionService.indexValidateAllBusinessObjectDefinitions(SEARCH_INDEX_NAME)).thenReturn((Object)new AsyncResult(null));
        Mockito.when((Object)this.businessObjectDefinitionService.indexSizeCheckValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME)).thenReturn((Object)sizeCheck);
        Mockito.when((Object)this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME)).thenReturn((Object)spotCheckPercentage);
        Mockito.when((Object)this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME)).thenReturn((Object)spotCheckMostRecent);
        Mockito.when((Object)this.tagService.indexValidateAllTags(SEARCH_INDEX_NAME)).thenReturn((Object)new AsyncResult(null));
        Mockito.when((Object)this.tagService.indexSizeCheckValidationTags(SEARCH_INDEX_NAME)).thenReturn((Object)sizeCheck);
        Mockito.when((Object)this.tagService.indexSpotCheckPercentageValidationTags(SEARCH_INDEX_NAME)).thenReturn((Object)spotCheckPercentage);
        Mockito.when((Object)this.tagService.indexSpotCheckMostRecentValidationTags(SEARCH_INDEX_NAME)).thenReturn((Object)spotCheckMostRecent);
        SearchIndexValidation response = this.searchIndexValidationService.createSearchIndexValidation(searchIndexValidationCreateRequest);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("Search index name", SEARCH_INDEX_NAME);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getSearchIndexEntity(searchIndexKey);
        if (searchIndexType.equals(SearchIndexTypeEntity.SearchIndexTypes.TAG.name())) {
            if (searchIndexValidationCreateRequest.isPerformFullSearchIndexValidation().booleanValue()) {
                ((TagService)Mockito.verify((Object)this.tagService, (VerificationMode)Mockito.times((int)1))).indexValidateAllTags(SEARCH_INDEX_NAME);
            } else {
                ((TagService)Mockito.verify((Object)this.tagService, (VerificationMode)Mockito.times((int)0))).indexValidateAllTags(SEARCH_INDEX_NAME);
            }
            ((TagService)Mockito.verify((Object)this.tagService)).indexSizeCheckValidationTags(SEARCH_INDEX_NAME);
            ((TagService)Mockito.verify((Object)this.tagService)).indexSpotCheckPercentageValidationTags(SEARCH_INDEX_NAME);
            ((TagService)Mockito.verify((Object)this.tagService)).indexSpotCheckMostRecentValidationTags(SEARCH_INDEX_NAME);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.searchIndexDaoHelper, this.tagService});
            Assert.assertEquals((Object)new SearchIndexValidation(searchIndexKey, response.getValidateStartTime(), sizeCheck, spotCheckPercentage, spotCheckMostRecent), (Object)response);
        } else {
            if (searchIndexValidationCreateRequest.isPerformFullSearchIndexValidation().booleanValue()) {
                ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService, (VerificationMode)Mockito.times((int)1))).indexValidateAllBusinessObjectDefinitions(SEARCH_INDEX_NAME);
            } else {
                ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService, (VerificationMode)Mockito.times((int)0))).indexValidateAllBusinessObjectDefinitions(SEARCH_INDEX_NAME);
            }
            ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService)).indexSizeCheckValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
            ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService)).indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
            ((BusinessObjectDefinitionService)Mockito.verify((Object)this.businessObjectDefinitionService)).indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.searchIndexDaoHelper, this.businessObjectDefinitionService});
            Assert.assertEquals((Object)new SearchIndexValidation(searchIndexKey, response.getValidateStartTime(), sizeCheck, spotCheckPercentage, spotCheckMostRecent), (Object)response);
        }
    }

    @Test
    public void testCreateSearchIndexValidationBusinessObjectDefinitionsFull() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name();
        SearchIndexValidationCreateRequest searchIndexValidationCreateRequest = new SearchIndexValidationCreateRequest(searchIndexKey, Boolean.valueOf(PERFORM_FULL_SEARCH_INDEX_VALIDATION));
        this.searchIndexValidation(searchIndexKey, searchIndexValidationCreateRequest, searchIndexType);
    }

    @Test
    public void testCreateSearchIndexValidationBusinessObjectDefinitions() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name();
        SearchIndexValidationCreateRequest searchIndexValidationCreateRequest = new SearchIndexValidationCreateRequest(searchIndexKey, Boolean.valueOf(NO_PERFORM_FULL_SEARCH_INDEX_VALIDATION));
        this.searchIndexValidation(searchIndexKey, searchIndexValidationCreateRequest, searchIndexType);
    }

    @Test
    public void testCreateSearchIndexValidationTagsFull() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.TAG.name();
        SearchIndexValidationCreateRequest searchIndexValidationCreateRequest = new SearchIndexValidationCreateRequest(searchIndexKey, Boolean.valueOf(PERFORM_FULL_SEARCH_INDEX_VALIDATION));
        this.searchIndexValidation(searchIndexKey, searchIndexValidationCreateRequest, searchIndexType);
    }

    @Test
    public void testCreateSearchIndexValidationTags() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.TAG.name();
        SearchIndexValidationCreateRequest searchIndexValidationCreateRequest = new SearchIndexValidationCreateRequest(searchIndexKey, Boolean.valueOf(NO_PERFORM_FULL_SEARCH_INDEX_VALIDATION));
        this.searchIndexValidation(searchIndexKey, searchIndexValidationCreateRequest, searchIndexType);
    }
}

