/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import java.util.stream.Collectors;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.SecurityRole;
import org.finra.herd.model.api.xml.SecurityRoleCreateRequest;
import org.finra.herd.model.api.xml.SecurityRoleKey;
import org.finra.herd.model.api.xml.SecurityRoleKeys;
import org.finra.herd.model.api.xml.SecurityRoleUpdateRequest;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class SecurityRoleServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateSecurityRole() throws Exception {
        SecurityRole securityRole = this.securityRoleService.createSecurityRole(new SecurityRoleCreateRequest(SECURITY_ROLE, DESCRIPTION));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, DESCRIPTION), (Object)securityRole);
    }

    @Test
    public void testCreateSecurityRoleMissingRequiredParameters() {
        try {
            this.securityRoleService.createSecurityRole(new SecurityRoleCreateRequest("      \t\t ", DESCRIPTION));
            Assert.fail((String)"Should throw an IllegalArgumentException when security role name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A security role name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateSecurityRoleMissingOptionalParameters() {
        SecurityRole securityRole = this.securityRoleService.createSecurityRole(new SecurityRoleCreateRequest(SECURITY_ROLE, null));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, null), (Object)securityRole);
    }

    @Test
    public void testCreateSecurityRoleTrimParameters() {
        SecurityRole securityRole = this.securityRoleService.createSecurityRole(new SecurityRoleCreateRequest(this.addWhitespace(SECURITY_ROLE), this.addWhitespace(DESCRIPTION)));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, this.addWhitespace(DESCRIPTION)), (Object)securityRole);
    }

    @Test
    public void testCreateSecurityRoleAlreadyExists() {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        try {
            this.securityRoleService.createSecurityRole(new SecurityRoleCreateRequest(SECURITY_ROLE, DESCRIPTION));
            Assert.fail((String)"Should throw an AlreadyExistsException when security role already exists");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create security role \"%s\" because it already exists.", SECURITY_ROLE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetSecurityRole() throws Exception {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        SecurityRole securityRole = this.securityRoleService.getSecurityRole(new SecurityRoleKey(SECURITY_ROLE));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, DESCRIPTION), (Object)securityRole);
    }

    @Test
    public void testGetSecurityRoleThatDoesNotExist() {
        try {
            this.securityRoleService.getSecurityRole(new SecurityRoleKey(SECURITY_ROLE));
            Assert.fail((String)"Should throw ObjectNotFoundException when security role does not exist");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Security role with name \"%s\" doesn't exist.", SECURITY_ROLE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetSecurityRoleTrimParameters() {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        SecurityRole securityRole = this.securityRoleService.getSecurityRole(new SecurityRoleKey(this.addWhitespace(SECURITY_ROLE)));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, DESCRIPTION), (Object)securityRole);
    }

    @Test
    public void testUpdateSecurityRole() throws Exception {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        SecurityRole updatedSecurityRole = this.securityRoleService.updateSecurityRole(new SecurityRoleKey(SECURITY_ROLE), new SecurityRoleUpdateRequest(DESCRIPTION_2));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, DESCRIPTION_2), (Object)updatedSecurityRole);
    }

    @Test
    public void testUpdateSecurityRoleThatDoesNotExists() {
        try {
            this.securityRoleService.updateSecurityRole(new SecurityRoleKey(SECURITY_ROLE), new SecurityRoleUpdateRequest(DESCRIPTION));
            Assert.fail((String)"Should throw ObjectNotFoundException when security role does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Security role with name \"%s\" doesn't exist.", SECURITY_ROLE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateSecurityRoleTrimParameters() {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        SecurityRole securityRole = this.securityRoleService.updateSecurityRole(new SecurityRoleKey(this.addWhitespace(SECURITY_ROLE)), new SecurityRoleUpdateRequest(this.addWhitespace(DESCRIPTION)));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, this.addWhitespace(DESCRIPTION)), (Object)securityRole);
    }

    @Test
    public void testDeleteSecurityRole() throws Exception {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        SecurityRole securityRole = this.securityRoleService.deleteSecurityRole(new SecurityRoleKey(SECURITY_ROLE));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, DESCRIPTION), (Object)securityRole);
    }

    @Test
    public void testDeleteSecurityRoleTrimParameters() {
        this.securityRoleDaoTestHelper.createSecurityRoleEntity(SECURITY_ROLE, DESCRIPTION);
        SecurityRole securityRole = this.securityRoleService.deleteSecurityRole(new SecurityRoleKey(this.addWhitespace(SECURITY_ROLE)));
        Assert.assertEquals((Object)new SecurityRole(SECURITY_ROLE, DESCRIPTION), (Object)securityRole);
    }

    @Test
    public void testDeleteNonExistingSecurityRole() {
        try {
            this.securityRoleService.deleteSecurityRole(new SecurityRoleKey(SECURITY_ROLE));
            Assert.fail((String)"Should throw an ObjectNotFoundException when security role doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Security role with name \"%s\" doesn't exist.", SECURITY_ROLE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetAllSecurityRoles() {
        List testSecurityRoleEntities = this.securityRoleDaoTestHelper.createTestSecurityRoles();
        List keys = testSecurityRoleEntities.stream().map(securityRoleEntity -> new SecurityRoleKey(securityRoleEntity.getCode())).collect(Collectors.toList());
        SecurityRoleKeys securityRoleKeys = new SecurityRoleKeys(keys);
        SecurityRoleKeys securityRoles = this.securityRoleService.getSecurityRoles();
        Assert.assertEquals((Object)securityRoleKeys, (Object)securityRoles);
    }
}

