/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.StoragePolicyProcessorService;
import org.finra.herd.service.helper.StorageFileHelper;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class StoragePolicyProcessorServiceTest
extends AbstractServiceTest {
    @Autowired
    private StorageFileHelper storageFileHelper;
    @Autowired
    @Qualifier(value="storagePolicyProcessorServiceImpl")
    private StoragePolicyProcessorService storagePolicyProcessorServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessStoragePolicySelectionMessage() throws Exception {
        String s3KeyPrefix = StoragePolicyProcessorServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(s3KeyPrefix + "/").build();
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList("GLACIER"));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String filePath : LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, s3KeyPrefix + "/" + filePath, Long.valueOf(1024L), Long.valueOf(1000L));
        }
        List storageFiles = this.storageFileHelper.createStorageFilesFromEntities(storageUnitEntity.getStorageFiles());
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_ARN.getKey(), S3_OBJECT_TAGGER_ROLE_ARN);
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_SESSION_NAME.getKey(), S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            for (StorageFile storageFile : storageFiles) {
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFile.getFilePath(), (InputStream)new ByteArrayInputStream(new byte[storageFile.getFileSizeBytes().intValue()]), null), null);
            }
            this.storagePolicyProcessorService.processStoragePolicySelectionMessage(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.assertEquals((Object)"ARCHIVED", (Object)storageUnitEntity.getStatus().getCode());
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessStoragePolicySelectionMessageRuntimeException() throws Exception {
        String s3KeyPrefix = StoragePolicyProcessorServiceTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(s3KeyPrefix + "/").build();
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList("GLACIER"));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String filePath : LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, s3KeyPrefix + "/" + filePath, Long.valueOf(1024L), Long.valueOf(1000L));
        }
        List storageFiles = this.storageFileHelper.createStorageFilesFromEntities(storageUnitEntity.getStorageFiles());
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_ARN.getKey(), S3_OBJECT_TAGGER_ROLE_ARN);
        overrideMap.put(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_SESSION_NAME.getKey(), S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            for (StorageFile storageFile : storageFiles.subList(0, storageFiles.size() - 1)) {
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFile.getFilePath(), (InputStream)new ByteArrayInputStream(new byte[storageFile.getFileSizeBytes().intValue()]), null), null);
            }
            this.storagePolicyProcessorService.processStoragePolicySelectionMessage(new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)String.format("Registered file \"%s\" does not exist in \"%s\" storage.", ((StorageFile)storageFiles.get(storageFiles.size() - 1)).getFilePath(), STORAGE_NAME), (Object)e.getMessage());
            Assert.assertEquals((Object)1, (Object)storageUnitEntity.getStoragePolicyTransitionFailedAttempts());
            Assert.assertEquals((Object)"ARCHIVING", (Object)storageUnitEntity.getStatus().getCode());
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testStoragePolicyProcessorServiceMethodsNewTransactionPropagation() throws Exception {
        try {
            this.storagePolicyProcessorServiceImpl.processStoragePolicySelectionMessage(null);
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage policy selection must be specified.", (Object)e.getMessage());
        }
    }
}

