/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StoragePolicySelectorServiceTest
extends AbstractServiceTest {
    @Test
    public void testExecuteBusinessObjectDataNotSelectedDueToHigherPriorityLevelStoragePolicy() {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD_2, STORAGE_POLICY_NAME_2), "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, NO_BDEF_NAMESPACE, NO_BDEF_NAME, NO_FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataEntity businessObjectDataEntity = storageUnitEntity.getBusinessObjectData();
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, (long)(BDATA_AGE_IN_DAYS + 1));
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD_2, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", Integer.valueOf(BDATA_AGE_IN_DAYS + 2), NO_BDEF_NAMESPACE, NO_BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, 2L);
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME_2), "DAYS_SINCE_BDATA_REGISTERED", Integer.valueOf(BDATA_AGE_IN_DAYS + 4), BDEF_NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, 2L);
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", Integer.valueOf(BDATA_AGE_IN_DAYS + 6), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(businessObjectDataEntity, 2L);
        Assert.assertEquals((long)1L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
    }

    @Test
    public void testExecuteInvalidSqsQueueName() {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        try {
            this.storagePolicySelectorService.execute("mock_sqs_queue_not_found_name", MAX_RESULT.intValue());
            Assert.fail((String)"Should throw an IllegalStateException when invalid SQS queue name is specified.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("AWS SQS queue with \"%s\" name not found.", "mock_sqs_queue_not_found_name"), (Object)e.getMessage());
        }
    }

    @Test
    public void testExecuteInvalidStoragePolicyRuleType() {
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), STORAGE_POLICY_RULE_TYPE, BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        try {
            this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue());
            Assert.fail((String)"Should throw an IllegalStateException when a storage policy has an invalid storage policy rule type.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Storage policy type \"%s\" is not supported.", STORAGE_POLICY_RULE_TYPE), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutePrimaryPartitionValueStoragePolicyRuleType() throws Exception {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_PRIMARY_PARTITION_VALUE", BDATA_PARTITION_VALUE_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        String primaryPartitionValue = this.getTestPrimaryPartitionValue(BDATA_PARTITION_VALUE_AGE_IN_DAYS + 1);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS.getKey(), -1);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            List resultStoragePolicySelections = this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue());
            Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)resultStoragePolicySelections);
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutePrimaryPartitionValueStoragePolicyRuleTypeBusinessObjectDataUpdatedTooRecently() throws Exception {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_PRIMARY_PARTITION_VALUE", BDATA_PARTITION_VALUE_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        String primaryPartitionValue = this.getTestPrimaryPartitionValue(BDATA_PARTITION_VALUE_AGE_IN_DAYS + 1);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS.getKey(), -1);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutePrimaryPartitionValueStoragePolicyRuleTypePrimaryPartitionValueNotDate() throws Exception {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_PRIMARY_PARTITION_VALUE", BDATA_PARTITION_VALUE_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        String primaryPartitionValue = this.getTestPrimaryPartitionValue(BDATA_PARTITION_VALUE_AGE_IN_DAYS + 1);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS.getKey(), -1);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()));
            storageUnitEntity.getBusinessObjectData().setPartitionValue("yyyy-MM-dd");
            this.businessObjectDataDao.saveAndRefresh((Object)storageUnitEntity.getBusinessObjectData());
            Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutePrimaryPartitionValueStoragePolicyRuleTypePrimaryPartitionValueNotOldEnough() throws Exception {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_PRIMARY_PARTITION_VALUE", BDATA_PARTITION_VALUE_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        String primaryPartitionValue = this.getTestPrimaryPartitionValue(BDATA_PARTITION_VALUE_AGE_IN_DAYS + 1);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS.getKey(), -1);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()));
            storageUnitEntity.getBusinessObjectData().setPartitionValue(this.getTestPrimaryPartitionValue(BDATA_PARTITION_VALUE_AGE_IN_DAYS - 1));
            this.businessObjectDataDao.saveAndRefresh((Object)storageUnitEntity.getBusinessObjectData());
            Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutePrimaryPartitionValueStoragePolicyRuleTypePrimaryPartitionValueSingleDayDateMaskSizeMismatch() throws Exception {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_PRIMARY_PARTITION_VALUE", BDATA_PARTITION_VALUE_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        String primaryPartitionValue = this.getTestPrimaryPartitionValue(BDATA_PARTITION_VALUE_AGE_IN_DAYS + 1);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.STORAGE_POLICY_PROCESSOR_BDATA_UPDATED_ON_THRESHOLD_DAYS.getKey(), -1);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, primaryPartitionValue, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()));
            storageUnitEntity.getBusinessObjectData().setPartitionValue(primaryPartitionValue + "_");
            this.businessObjectDataDao.saveAndRefresh((Object)storageUnitEntity.getBusinessObjectData());
            Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testExecuteRegistrationDateStoragePolicyRuleType() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        List resultStoragePolicySelections = this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue());
        Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)resultStoragePolicySelections);
    }

    @Test
    public void testExecuteRegistrationDateStoragePolicyRuleTypeBusinessObjectDataNotOldEnough() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME), "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()));
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity.getBusinessObjectData(), -2L);
        Assert.assertEquals((long)0L, (long)this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", MAX_RESULT.intValue()).size());
    }

    @Test
    public void testExecuteTestingMaxResult() {
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, "DAYS_SINCE_BDATA_REGISTERED", BDATA_AGE_IN_DAYS, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, "GLACIER", "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        StorageUnitEntity storageUnitEntity1 = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity1.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 1));
        StorageUnitEntity storageUnitEntity2 = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.businessObjectDataDaoTestHelper.ageBusinessObjectData(storageUnitEntity2.getBusinessObjectData(), (long)(BDATA_AGE_IN_DAYS + 2));
        List resultStoragePolicySelections = this.storagePolicySelectorService.execute("AWS_SQS_QUEUE_NAME", 1);
        Assert.assertEquals(Arrays.asList(new StoragePolicySelection(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION), storagePolicyKey, INITIAL_VERSION)), (Object)resultStoragePolicySelections);
    }

    private String getTestPrimaryPartitionValue(long offsetInDays) {
        Timestamp currentTimestamp = this.herdDao.getCurrentTimestamp();
        Timestamp updatedTimestamp = new Timestamp(currentTimestamp.getTime() - offsetInDays * 86400000L);
        return new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(updatedTimestamp);
    }
}

