/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.exception.MethodInvocationException;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.S3KeyPrefixInformation;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StorageUnitServiceGetS3KeyPrefixTest
extends AbstractServiceTest {
    @Test
    public void testGetS3KeyPrefix() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        List testSubPartitionColumns = testPartitionColumns.subList(1, SUBPARTITION_VALUES.size() + 1);
        S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), DATA_VERSION);
        Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
    }

    @Test
    public void testGetS3KeyPrefixMissingRequiredParameters() {
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION), PARTITION_KEY, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t "), DATA_VERSION), PARTITION_KEY, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3KeyPrefixMissingOptionalParameters() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        for (int i = 0; i <= 4; ++i) {
            List subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
            String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
            List testSubPartitionColumns = testPartitionColumns.subList(1, subPartitionValues.size() + 1);
            S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, null), "      \t\t ", "      \t\t ", null);
            String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), INITIAL_DATA_VERSION);
            Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
        }
    }

    @Test
    public void testGetS3KeyPrefixMissingOptionalParametersPassedAsNulls() {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), null, null, Boolean.valueOf(false));
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, null, null, DATA_VERSION);
        Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
    }

    @Test
    public void testGetS3KeyPrefixTrimParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        List testSubPartitionColumns = testPartitionColumns.subList(1, SUBPARTITION_VALUES.size() + 1);
        S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION), this.addWhitespace(testPartitionKey), this.addWhitespace(STORAGE_NAME), Boolean.valueOf(false));
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), DATA_VERSION);
        Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
    }

    @Test
    public void testGetS3KeyPrefixUpperCaseParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        List testSubPartitionColumns = testPartitionColumns.subList(1, SUBPARTITION_VALUES.size() + 1);
        S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey.toUpperCase(), STORAGE_NAME.toUpperCase(), Boolean.valueOf(false));
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), DATA_VERSION);
        Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
    }

    @Test
    public void testGetS3KeyPrefixLowerCaseParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        List testSubPartitionColumns = testPartitionColumns.subList(1, SUBPARTITION_VALUES.size() + 1);
        S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey.toLowerCase(), STORAGE_NAME.toLowerCase(), Boolean.valueOf(false));
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), DATA_VERSION);
        Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
    }

    @Test
    public void testGetS3KeyPrefixInvalidParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage("I_DO_NOT_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, "I_DO_NOT_EXIST", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INVALID_FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), "I_DO_NOT_EXIST", STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when using an invalid partition key.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition key \"%s\" doesn't match configured business object format partition key \"%s\".", "I_DO_NOT_EXIST", testPartitionKey), (Object)e.getMessage());
        }
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, "I_DO_NOT_EXIST", Boolean.valueOf(false));
            Assert.fail((String)"Should throw an ObjectNotFoundException when using an invalid storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            ArrayList<String> testSubPartitionValues = new ArrayList<String>(SUBPARTITION_VALUES);
            testSubPartitionValues.add("EXTRA_SUBPARTITION_VALUE");
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, testSubPartitionValues, DATA_VERSION), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when passing too many subpartition values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Exceeded maximum number of allowed subpartitions: %d.", 4), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3KeyPrefixNonS3Storage() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(true);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, STORAGE_PLATFORM_CODE);
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME_2, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when specifying an non-S3 storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The specified storage \"%s\" is not an S3 storage platform.", STORAGE_NAME_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3KeyPrefixMissingKeyPrefixVelocityTemplate() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(true);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "S3");
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME_2, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when specifying an S3 storage without the S3 key prefix velocity template configured.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage \"%s\" has no S3 key prefix velocity template configured.", STORAGE_NAME_2), (Object)e.getMessage());
        }
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_3, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "      \t\t ")));
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME_3, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when specifying an S3 storage with the S3 key prefix velocity template being a blank string.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage \"%s\" has no S3 key prefix velocity template configured.", STORAGE_NAME_3), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3KeyPrefixKeyPrefixVelocityTemplateProducesBlankS3KeyPrefix() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(true);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        String testS3KeyPrefixVelocityTemplate = "#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#end";
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#end")));
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME_2, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an IllegalArgumentException when specifying an S3 storage with the S3 key prefix velocity template that results in a blank S3 key prefix value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("S3 key prefix velocity template \"%s\" configured for \"%s\" storage results in an empty S3 key prefix.", "#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#end", STORAGE_NAME_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3KeyPrefixUndefinedVelocityVariable() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(true);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        String undefinedVelocityVariable = "$UNDEFINED_VARIABLE";
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), undefinedVelocityVariable)));
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), testPartitionKey, STORAGE_NAME_2, Boolean.valueOf(false));
            Assert.fail((String)"Should throw an MethodInvocationException when the S3 key prefix velocity template contains an undefined variable.");
        }
        catch (MethodInvocationException e) {
            Assert.assertEquals((Object)String.format("Variable %s has not been set at %s[line 1, column 1]", undefinedVelocityVariable, this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3KeyPrefixNoDataVersionSpecifiedInitialDataVersionNoExists() throws Exception {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(false);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        List testSubPartitionColumns = testPartitionColumns.subList(1, SUBPARTITION_VALUES.size() + 1);
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), INITIAL_DATA_VERSION);
        for (Boolean createNewVersionFlag : new Boolean[]{false, true}) {
            S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null), testPartitionKey, STORAGE_NAME, createNewVersionFlag);
            Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
        }
    }

    @Test
    public void testGetS3KeyPrefixNoDataVersionSpecifiedLatestDataVersionExistsCreateNewVersionIsTrue() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(true);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        List testSubPartitionColumns = testPartitionColumns.subList(1, SUBPARTITION_VALUES.size() + 1);
        S3KeyPrefixInformation resultS3KeyPrefixInformation = this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null), testPartitionKey, STORAGE_NAME, Boolean.valueOf(true));
        String expectedS3KeyPrefix = StorageUnitServiceGetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, testPartitionKey, PARTITION_VALUE, testSubPartitionColumns.toArray(new SchemaColumn[testSubPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), DATA_VERSION + 1);
        Assert.assertEquals((Object)new S3KeyPrefixInformation(expectedS3KeyPrefix), (Object)resultS3KeyPrefixInformation);
    }

    @Test
    public void testGetS3KeyPrefixNoDataVersionSpecifiedLatestDataVersionExistsCreateNewVersionIsFalse() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForGetS3KeyPrefixTesting(true);
        List testPartitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String testPartitionKey = ((SchemaColumn)testPartitionColumns.get(0)).getName();
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null), testPartitionKey, STORAGE_NAME, Boolean.valueOf(false));
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)"Initial version of the business object data already exists.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetS3PrefixWhenSchemaWithoutPartitionColumns() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, partitionKey, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end");
        try {
            this.storageUnitService.getS3KeyPrefix(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null), partitionKey, STORAGE_NAME, Boolean.valueOf(false));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Schema partition(s) must be defined when using subpartition values for business object format {%s}.", this.businessObjectFormatHelper.businessObjectFormatKeyToString(this.businessObjectFormatHelper.getBusinessObjectFormatKey(this.businessObjectFormatHelper.createBusinessObjectFormatFromEntity(businessObjectFormatEntity)))), (Object)e.getMessage());
        }
    }
}

