/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.SubjectMatterExpert;
import org.finra.herd.model.api.xml.SubjectMatterExpertContactDetails;
import org.finra.herd.model.api.xml.SubjectMatterExpertKey;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class SubjectMatterExpertServiceTest
extends AbstractServiceTest {
    @Test
    public void testGetSubjectMatterExpert() throws Exception {
        SubjectMatterExpert result = this.subjectMatterExpertService.getSubjectMatterExpert(new SubjectMatterExpertKey(USER_ID));
        Assert.assertEquals((Object)new SubjectMatterExpert(new SubjectMatterExpertKey(USER_ID), new SubjectMatterExpertContactDetails(USER_FULL_NAME, USER_JOB_TITLE, USER_EMAIL_ADDRESS, USER_TELEPHONE_NUMBER)), (Object)result);
    }

    @Test
    public void testGetSubjectMatterExpertMissingRequiredParameters() {
        try {
            this.subjectMatterExpertService.getSubjectMatterExpert(new SubjectMatterExpertKey("      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A user id must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetSubjectMatterExpertTrimParameters() {
        SubjectMatterExpert result = this.subjectMatterExpertService.getSubjectMatterExpert(new SubjectMatterExpertKey(this.addWhitespace(USER_ID)));
        Assert.assertEquals((Object)new SubjectMatterExpert(new SubjectMatterExpertKey(USER_ID), new SubjectMatterExpertContactDetails(USER_FULL_NAME, USER_JOB_TITLE, USER_EMAIL_ADDRESS, USER_TELEPHONE_NUMBER)), (Object)result);
    }

    @Test
    public void testGetSubjectMatterExpertUserNoExists() {
        try {
            this.subjectMatterExpertService.getSubjectMatterExpert(new SubjectMatterExpertKey("mock_user_id_user_no_exists"));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("The subject matter expert with user id \"%s\" does not exist.", "mock_user_id_user_no_exists"), (Object)e.getMessage());
        }
    }
}

