/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.api.xml.SystemJobRunRequest;
import org.finra.herd.model.api.xml.SystemJobRunResponse;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class SystemJobServiceTest
extends AbstractServiceTest {
    @Test
    public void testRunSystemJobMissingRequiredParameters() throws Exception {
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("      \t\t ", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when job name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job name must be specified.", (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest(JOB_NAME, Arrays.asList(new Parameter("      \t\t ", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when parameter name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A parameter name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRunSystemJobDuplicateParameters() throws Exception {
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest(JOB_NAME, Arrays.asList(new Parameter("Attribute Name 1".toUpperCase(), "Attribute Value 1"), new Parameter("Attribute Name 1".toLowerCase(), "   Attribute Value 2  "))));
            Assert.fail((String)"Should throw an IllegalArgumentException when duplicate parameters are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate parameter name found: %s", "Attribute Name 1".toLowerCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testRunSystemJobSystemJobNoExists() throws Exception {
        String testSystemJobName = "I_DO_NOT_EXIST";
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest(testSystemJobName, null));
            Assert.fail((String)"Should throw an ObjectNotFoundException when specified system job name does not exist.");
        }
        catch (ObjectNotFoundException ex) {
            Assert.assertEquals((Object)String.format("System job with name \"%s\" doesn't exist.", testSystemJobName), (Object)ex.getMessage());
        }
    }

    @Test
    public void testRunSystemJobJobNameCaseSensitivity() throws Exception {
        for (String systemJobName : Arrays.asList("fileUploadCleanup", "jmsPublishing", "storagePolicySelector")) {
            String testSystemJobName = systemJobName.toUpperCase();
            try {
                this.systemJobService.runSystemJob(new SystemJobRunRequest(testSystemJobName, null));
                Assert.fail((String)"Should throw an ObjectNotFoundException when specified system job name does not exist.");
            }
            catch (ObjectNotFoundException ex) {
                Assert.assertEquals((Object)String.format("System job with name \"%s\" doesn't exist.", testSystemJobName), (Object)ex.getMessage());
            }
        }
    }

    @Test
    public void testRunSystemJobFileUploadCleanup() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobFileUploadCleanupMissingOptionalParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("fileUploadCleanup", null);
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("fileUploadCleanup", null), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobFileUploadCleanupTrimParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest(this.addWhitespace("fileUploadCleanup"), Arrays.asList(new Parameter(this.addWhitespace(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey()), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobFileUploadCleanupUpperCaseParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey().toUpperCase(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey().toUpperCase(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobFileUploadCleanupLowerCaseParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey().toLowerCase(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey().toLowerCase(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobFileUploadCleanupInvalidParameters() throws Exception {
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("fileUploadCleanup", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"), new Parameter("Attribute Name 2", "   Attribute Value 2  "))));
            Assert.fail((String)"Should throw an IllegalArgumentException when too many parameters are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Too many parameters are specified for \"%s\" system job.", "fileUploadCleanup"), (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("fileUploadCleanup", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when invalid parameter name is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Parameter \"%s\" is not supported by \"%s\" system job.", "Attribute Name 1", "fileUploadCleanup"), (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("fileUploadCleanup", Arrays.asList(new Parameter(ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey(), "NOT_AN_INTEGER"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when invalid parameter value is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Parameter \"%s\" specifies a non-integer value \"NOT_AN_INTEGER\".", ConfigurationValue.FILE_UPLOAD_CLEANUP_JOB_THRESHOLD_MINUTES.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testRunSystemJobJmsPublisher() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("jmsPublishing", null);
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("jmsPublishing", null), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobJmsPublishingInvalidParameters() throws Exception {
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("jmsPublishing", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when parameters are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("\"%s\" system job does not except parameters.", "jmsPublishing"), (Object)e.getMessage());
        }
    }

    @Test
    public void testRunSystemJobStoragePolicySelector() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobStoragePolicySelectorMissingOptionalParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("storagePolicySelector", null);
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("storagePolicySelector", null), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobStoragePolicySelectorTrimParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest(this.addWhitespace("storagePolicySelector"), Arrays.asList(new Parameter(this.addWhitespace(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey()), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobStoragePolicySelectorUpperCaseParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey().toUpperCase(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey().toUpperCase(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobStoragePolicySelectorLowerCaseParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey().toLowerCase(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey().toLowerCase(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobStoragePolicySelectorInvalidParameters() throws Exception {
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("storagePolicySelector", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"), new Parameter("Attribute Name 2", "   Attribute Value 2  "))));
            Assert.fail((String)"Should throw an IllegalArgumentException when too many parameters are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Too many parameters are specified for \"%s\" system job.", "storagePolicySelector"), (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("storagePolicySelector", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when invalid parameter name is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Parameter \"%s\" is not supported by \"%s\" system job.", "Attribute Name 1", "storagePolicySelector"), (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("storagePolicySelector", Arrays.asList(new Parameter(ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey(), "NOT_AN_INTEGER"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when invalid parameter value is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Parameter \"%s\" specifies a non-integer value \"NOT_AN_INTEGER\".", ConfigurationValue.STORAGE_POLICY_SELECTOR_JOB_MAX_BDATA_INSTANCES.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testRunSystemJobBusinessObjectDataFinalizeRestore() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobBusinessObjectDataFinalizeRestoreMissingOptionalParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("businessObjectDataFinalizeRestore", null);
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("businessObjectDataFinalizeRestore", null), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobBusinessObjectDataFinalizeRestoreTrimParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest(this.addWhitespace("businessObjectDataFinalizeRestore"), Arrays.asList(new Parameter(this.addWhitespace(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey()), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobBusinessObjectDataFinalizeRestoreUpperCaseParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey().toUpperCase(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey().toUpperCase(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobBusinessObjectDataFinalizeRestoreLowerCaseParameters() throws Exception {
        SystemJobRunRequest systemJobRunRequest = new SystemJobRunRequest("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey().toLowerCase(), String.valueOf(INTEGER_VALUE))));
        SystemJobRunResponse resultSystemJobRunResponse = this.systemJobService.runSystemJob(systemJobRunRequest);
        Assert.assertEquals((Object)new SystemJobRunResponse("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey().toLowerCase(), String.valueOf(INTEGER_VALUE)))), (Object)resultSystemJobRunResponse);
    }

    @Test
    public void testRunSystemJobBusinessObjectDataFinalizeRestoreInvalidParameters() throws Exception {
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"), new Parameter("Attribute Name 2", "   Attribute Value 2  "))));
            Assert.fail((String)"Should throw an IllegalArgumentException when too many parameters are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Too many parameters are specified for \"%s\" system job.", "businessObjectDataFinalizeRestore"), (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter("Attribute Name 1", "Attribute Value 1"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when invalid parameter name is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Parameter \"%s\" is not supported by \"%s\" system job.", "Attribute Name 1", "businessObjectDataFinalizeRestore"), (Object)e.getMessage());
        }
        try {
            this.systemJobService.runSystemJob(new SystemJobRunRequest("businessObjectDataFinalizeRestore", Arrays.asList(new Parameter(ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey(), "NOT_AN_INTEGER"))));
            Assert.fail((String)"Should throw an IllegalArgumentException when invalid parameter value is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Parameter \"%s\" specifies a non-integer value \"NOT_AN_INTEGER\".", ConfigurationValue.BDATA_FINALIZE_RESTORE_JOB_MAX_BDATA_INSTANCES.getKey()), (Object)e.getMessage());
        }
    }
}

