/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.dao.TagDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.SearchIndexUpdateDto;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.model.jpa.TagTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.functional.QuadConsumer;
import org.finra.herd.service.helper.TagHelper;
import org.finra.herd.service.impl.TagServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TagServiceIndexTest
extends AbstractServiceTest {
    @InjectMocks
    private TagServiceImpl tagService;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private IndexFunctionsDao indexFunctionsDao;
    @Mock
    private TagDao tagDao;
    @Mock
    private TagHelper tagHelper;
    @Mock
    private JsonHelper jsonHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testUpdateSearchIndexDocumentTagCreate() throws Exception {
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE_2, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        tagEntityList.add(tagEntity1);
        tagEntityList.add(tagEntity2);
        ArrayList tagIds = new ArrayList();
        tagEntityList.forEach(tagEntity -> tagIds.add(tagEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "CREATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagDao.getTagsByIds(tagIds)).thenReturn(tagEntityList);
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        this.tagService.updateSearchIndexDocumentTag(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)1))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagDao)Mockito.verify((Object)this.tagDao, (VerificationMode)Mockito.times((int)1))).getTagsByIds(tagIds);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
    }

    @Test
    public void testUpdateSearchIndexDocumentTagCreateEmpty() throws Exception {
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE_2, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        tagEntityList.add(tagEntity1);
        tagEntityList.add(tagEntity2);
        ArrayList tagIds = new ArrayList();
        tagEntityList.forEach(tagEntity -> tagIds.add(tagEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "CREATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagDao.getTagsByIds(tagIds)).thenReturn(tagEntityList);
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"");
        ((IndexFunctionsDao)Mockito.doNothing().when((Object)this.indexFunctionsDao)).createIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (Map)Matchers.any());
        this.tagService.updateSearchIndexDocumentTag(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)1))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagDao)Mockito.verify((Object)this.tagDao, (VerificationMode)Mockito.times((int)1))).getTagsByIds(tagIds);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)1))).createIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (Map)Matchers.any());
    }

    @Test
    public void testUpdateSearchIndexDocumentTagUpdate() throws Exception {
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE_2, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        tagEntityList.add(tagEntity1);
        tagEntityList.add(tagEntity2);
        ArrayList tagIds = new ArrayList();
        tagEntityList.forEach(tagEntity -> tagIds.add(tagEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagDao.getTagsByIds(tagIds)).thenReturn(tagEntityList);
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        this.tagService.updateSearchIndexDocumentTag(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)1))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagDao)Mockito.verify((Object)this.tagDao, (VerificationMode)Mockito.times((int)1))).getTagsByIds(tagIds);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)1))).updateIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (Map)Matchers.any());
    }

    @Test
    public void testUpdateSearchIndexDocumentTagUpdateEmpty() throws Exception {
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE_2, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        tagEntityList.add(tagEntity1);
        tagEntityList.add(tagEntity2);
        ArrayList tagIds = new ArrayList();
        tagEntityList.forEach(tagEntity -> tagIds.add(tagEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UPDATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagDao.getTagsByIds(tagIds)).thenReturn(tagEntityList);
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"");
        this.tagService.updateSearchIndexDocumentTag(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)1))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagDao)Mockito.verify((Object)this.tagDao, (VerificationMode)Mockito.times((int)1))).getTagsByIds(tagIds);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)1))).updateIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (Map)Matchers.any());
    }

    @Test
    public void testUpdateSearchIndexDocumentTagDelete() throws Exception {
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE_2, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        tagEntityList.add(tagEntity1);
        tagEntityList.add(tagEntity2);
        ArrayList tagIds = new ArrayList();
        tagEntityList.forEach(tagEntity -> tagIds.add(tagEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "DELETE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        ((IndexFunctionsDao)Mockito.doNothing().when((Object)this.indexFunctionsDao)).deleteIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any());
        this.tagService.updateSearchIndexDocumentTag(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)1))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)1))).deleteIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any());
    }

    @Test
    public void testUpdateSearchIndexDocumentTagUnknown() throws Exception {
        ArrayList<TagEntity> tagEntityList = new ArrayList<TagEntity>();
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(new TagKey(TAG_TYPE_2, TAG_CODE_2), TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        tagEntityList.add(tagEntity1);
        tagEntityList.add(tagEntity2);
        ArrayList tagIds = new ArrayList();
        tagEntityList.forEach(tagEntity -> tagIds.add(tagEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("TAG", tagIds, "UNKNOWN");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        this.tagService.updateSearchIndexDocumentTag(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)1))).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
    }

    @Test
    public void testIndexValidateTags() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> tagEntityList = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        ArrayList<String> tagEntityIdList = new ArrayList<String>();
        tagEntityIdList.add("100");
        tagEntityIdList.add("101");
        tagEntityIdList.add("110");
        Mockito.when((Object)this.tagDao.getTags()).thenReturn(tagEntityList);
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Future future = this.tagService.indexValidateAllTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index all tags method returned null value.", (Object)future, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"Tag service index all tags method return value is not instance of future.", (Object)future, (Matcher)CoreMatchers.instanceOf(Future.class));
        ((TagDao)Mockito.verify((Object)this.tagDao)).getTags();
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).executeFunctionForTagEntities((String)Matchers.eq((Object)"TAG"), (String)Matchers.eq((Object)"DOCUMENT_TYPE"), (List)Matchers.eq(tagEntityList), (QuadConsumer)Matchers.any());
    }

    @Test
    public void testIndexSizeCheckValidationTags() throws Exception {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)100L);
        Mockito.when((Object)this.tagDao.getCountOfAllTags()).thenReturn((Object)100L);
        boolean isIndexSizeValid = this.tagService.indexSizeCheckValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index size validation is false when it should have been true.", (Object)isIndexSizeValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((TagDao)Mockito.verify((Object)this.tagDao)).getCountOfAllTags();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.indexFunctionsDao, this.configurationHelper});
    }

    @Test
    public void testIndexSizeCheckValidationTagsFalse() throws Exception {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)100L);
        Mockito.when((Object)this.tagDao.getCountOfAllTags()).thenReturn((Object)200L);
        boolean isIndexSizeValid = this.tagService.indexSizeCheckValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index size validation is true when it should have been false.", (Object)isIndexSizeValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((TagDao)Mockito.verify((Object)this.tagDao)).getCountOfAllTags();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.configurationHelper});
    }

    @Test
    public void testIndexSpotCheckPercentageValidationTags() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> rootTagEntities = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.2);
        Mockito.when((Object)this.tagDao.getPercentageOfAllTags(0.2)).thenReturn(rootTagEntities);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        boolean isSpotCheckPercentageValid = this.tagService.indexSpotCheckPercentageValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index spot check random validation is false when it should have been true.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_PERCENTAGE, Double.class);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getPercentageOfAllTags(0.2);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.indexFunctionsDao, this.configurationHelper, this.jsonHelper});
    }

    @Test
    public void testIndexSpotCheckPercentageValidationTagsFalse() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> rootTagEntities = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.2);
        Mockito.when((Object)this.tagDao.getPercentageOfAllTags(0.2)).thenReturn(rootTagEntities);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.tagService.indexSpotCheckPercentageValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index spot check random validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_PERCENTAGE, Double.class);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getPercentageOfAllTags(0.2);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.indexFunctionsDao, this.configurationHelper, this.jsonHelper});
    }

    @Test
    public void testIndexSpotCheckPercentageValidationTagsObjectMappingException() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> rootTagEntities = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.2);
        Mockito.when((Object)this.tagDao.getPercentageOfAllTags(0.2)).thenReturn(rootTagEntities);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        boolean isSpotCheckPercentageValid = this.tagService.indexSpotCheckPercentageValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index spot check random validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_PERCENTAGE, Double.class);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getPercentageOfAllTags(0.2);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.configurationHelper, this.jsonHelper});
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationTags() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> rootTagEntities = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)10);
        Mockito.when((Object)this.tagDao.getMostRecentTags(10)).thenReturn(rootTagEntities);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        boolean isSpotCheckMostRecentValid = this.tagService.indexSpotCheckMostRecentValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index spot check most recent validation is false when it should have been true.", (Object)isSpotCheckMostRecentValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getMostRecentTags(10);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.indexFunctionsDao, this.configurationHelper, this.jsonHelper, this.tagHelper});
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationTagsFalse() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> rootTagEntities = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)10);
        Mockito.when((Object)this.tagDao.getMostRecentTags(10)).thenReturn(rootTagEntities);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.tagHelper.safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class))).thenReturn((Object)"JSON_STRING");
        boolean isSpotCheckMostRecentValid = this.tagService.indexSpotCheckMostRecentValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index spot check most recent validation is true when it should have been false.", (Object)isSpotCheckMostRecentValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getMostRecentTags(10);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.configurationHelper, this.jsonHelper, this.tagHelper});
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationTagsObjectMappingException() throws Exception {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        List<TagEntity> rootTagEntities = Arrays.asList(this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME, TAG_DESCRIPTION_2));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)10);
        Mockito.when((Object)this.tagDao.getMostRecentTags(10)).thenReturn(rootTagEntities);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)"DOCUMENT_TYPE");
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckMostRecentValid = this.tagService.indexSpotCheckMostRecentValidationTags(SEARCH_INDEX_TYPE_TAG);
        MatcherAssert.assertThat((String)"Tag service index spot check most recent validation is true when it should have been false.", (Object)isSpotCheckMostRecentValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_TAG_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getMostRecentTags(10);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((TagEntity)Matchers.any(TagEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tagDao, this.indexFunctionsDao, this.configurationHelper, this.jsonHelper, this.tagHelper});
    }
}

