/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Tag;
import org.finra.herd.model.api.xml.TagChild;
import org.finra.herd.model.api.xml.TagCreateRequest;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.api.xml.TagListResponse;
import org.finra.herd.model.api.xml.TagSearchFilter;
import org.finra.herd.model.api.xml.TagSearchKey;
import org.finra.herd.model.api.xml.TagSearchRequest;
import org.finra.herd.model.api.xml.TagSearchResponse;
import org.finra.herd.model.api.xml.TagUpdateRequest;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.model.jpa.TagTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.TagServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class TagServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateTag() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)tag);
    }

    @Test
    public void testCreateTagDisplayNameAlreadyExists() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME.toUpperCase(), TAG_DESCRIPTION);
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for a tag with tag type \"%s\" and tag code \"%s\".", TAG_DISPLAY_NAME.toLowerCase(), TAG_TYPE, TAG_CODE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagInvalidParameters() {
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(this.addSlash(TAG_TYPE), TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, this.addSlash(TAG_CODE)), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag code can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, new TagKey(TAG_TYPE_2, TAG_CODE_2)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code in parent tag key must match the tag type code in the request.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER.multiply(BigDecimal.valueOf(-1L)), TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The searchScoreMultiplier can not have a negative value. searchScoreMultiplier=%s", TAG_SEARCH_SCORE_MULTIPLIER.multiply(BigDecimal.valueOf(-1L))), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagLowerCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag resultTag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()), TAG_DISPLAY_NAME.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION.toLowerCase(), NO_PARENT_TAG_KEY));
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE.toLowerCase()), TAG_DISPLAY_NAME.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION.toLowerCase(), tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)resultTag);
    }

    @Test
    public void testCreateTagMissingOptionalParametersPassedAsNulls() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(tagKey, TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)tag);
    }

    @Test
    public void testCreateTagMissingOptionalParametersPassedAsWhitespace() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(tagKey, TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, "      \t\t ", NO_PARENT_TAG_KEY));
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, "      \t\t ", tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)tag);
    }

    @Test
    public void testCreateTagMissingRequiredParams() {
        try {
            this.tagService.createTag(new TagCreateRequest(null, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag key must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(null, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, null), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), null, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagParentTagNoExists() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, new TagKey(TAG_TYPE, TAG_CODE_2)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE_2, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTagAlreadyExists() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE.toUpperCase(), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE.toLowerCase()), TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create tag with tag type code \"%s\" and tag code \"%s\" because it already exists.", TAG_TYPE, TAG_CODE.toLowerCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTagTypeNoExists() {
        try {
            this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTagTrimParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag tag = this.tagService.createTag(new TagCreateRequest(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)), this.addWhitespace(TAG_DISPLAY_NAME), TAG_SEARCH_SCORE_MULTIPLIER, this.addWhitespace(TAG_DESCRIPTION), NO_PARENT_TAG_KEY));
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, this.addWhitespace(TAG_DESCRIPTION), tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)tag);
    }

    @Test
    public void testCreateTagUpperCaseParameters() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag resultTag = this.tagService.createTag(new TagCreateRequest(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()), TAG_DISPLAY_NAME.toUpperCase(), TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION.toUpperCase(), NO_PARENT_TAG_KEY));
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Assert.assertEquals((Object)new Tag(resultTag.getId(), new TagKey(TAG_TYPE, TAG_CODE.toUpperCase()), TAG_DISPLAY_NAME.toUpperCase(), TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION.toUpperCase(), tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)resultTag);
    }

    @Test
    public void testCreateTagWithParent() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag parentTag = this.tagService.createTag(new TagCreateRequest(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
        TagEntity parentTagEntity = this.tagDao.getTagByKey(parentTagKey);
        Assert.assertNotNull((Object)parentTagEntity);
        Assert.assertEquals((Object)new Tag(parentTagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, parentTagEntity.getCreatedBy(), parentTagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)parentTagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)parentTag);
        TagKey childTagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        Tag childTag = this.tagService.createTag(new TagCreateRequest(childTagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, parentTagKey));
        TagEntity childTagEntity = this.tagDao.getTagByKey(childTagKey);
        Assert.assertNotNull((Object)childTagEntity);
        Assert.assertEquals((Object)new Tag(childTagEntity.getId(), childTagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, childTagEntity.getCreatedBy(), childTagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)childTagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)childTag);
    }

    @Test
    public void testDeleteTag() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Tag deletedTag = this.tagService.deleteTag(new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagLowerCaseParameters() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Tag deletedTag = this.tagService.deleteTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagMissingRequiredParameters() {
        try {
            this.tagService.deleteTag(new TagKey("      \t\t ", TAG_CODE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.deleteTag(new TagKey(TAG_TYPE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagTagNoExists() {
        try {
            this.tagService.deleteTag(new TagKey(TAG_TYPE, TAG_CODE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteTagTrimParameters() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Tag deletedTag = this.tagService.deleteTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagUpperCaseParameters() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity tagEntity = this.tagDao.getTagByKey(tagKey);
        Assert.assertNotNull((Object)tagEntity);
        Tag deletedTag = this.tagService.deleteTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(tagKey));
    }

    @Test
    public void testDeleteTagWithParent() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Tag parentTag = this.tagService.createTag(new TagCreateRequest(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
        TagEntity parentTagEntity = this.tagDao.getTagByKey(parentTagKey);
        Assert.assertNotNull((Object)parentTagEntity);
        Assert.assertEquals((Object)new Tag(parentTagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, parentTagEntity.getCreatedBy(), parentTagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)parentTagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)parentTag);
        TagKey childTagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        Tag childTag = this.tagService.createTag(new TagCreateRequest(childTagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, parentTagKey));
        TagEntity childTagEntity = this.tagDao.getTagByKey(childTagKey);
        Assert.assertNotNull((Object)childTagEntity);
        Assert.assertEquals((Object)new Tag(childTagEntity.getId(), childTagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, childTagEntity.getCreatedBy(), childTagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)childTagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)childTag);
        Tag deletedTag = this.tagService.deleteTag(childTagKey);
        Assert.assertEquals((Object)new Tag(childTagEntity.getId(), childTagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, childTagEntity.getCreatedBy(), childTagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)childTagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)deletedTag);
        Assert.assertNull((Object)this.tagDao.getTagByKey(childTagKey));
    }

    @Test
    public void testGetTag() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)resultTag);
    }

    @Test
    public void testGetTagLowerCaseParameters() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase()));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)resultTag);
    }

    @Test
    public void testGetTagMissingRequiredParameters() {
        try {
            this.tagService.getTag(new TagKey("      \t\t ", TAG_CODE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.getTag(new TagKey(TAG_TYPE, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTagNoExists() {
        try {
            this.tagService.getTag(new TagKey(TAG_TYPE, TAG_CODE));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagTrimParameters() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE)));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)resultTag);
    }

    @Test
    public void testGetTagUpperCaseParameters() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        Tag resultTag = this.tagService.getTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase()));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)resultTag);
    }

    @Test
    public void testGetTags() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE, NO_PARENT_TAG_CODE);
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals(Arrays.asList(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN.booleanValue()), new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_HAS_NO_CHILDREN.booleanValue())), (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsLowerCaseParameters() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        TagListResponse resultTagKeys = this.tagService.getTags(this.addWhitespace(TAG_TYPE), NO_PARENT_TAG_CODE);
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals(Arrays.asList(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN.booleanValue()), new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_HAS_NO_CHILDREN.booleanValue())), (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsMissingRequiredParameters() {
        try {
            this.tagService.getTags("      \t\t ", NO_PARENT_TAG_CODE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagsTagTypeNoExists() {
        try {
            this.tagService.getTags(TAG_TYPE, NO_PARENT_TAG_CODE);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag type with code \"%s\" doesn't exist.", TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetTagsTagsNoExist() {
        this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE, NO_PARENT_TAG_CODE);
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals((long)0L, (long)resultTagKeys.getTagChildren().size());
    }

    @Test
    public void testGetTagsTrimParameters() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2);
        TagListResponse resultTagKeys = this.tagService.getTags(this.addWhitespace(TAG_TYPE), NO_PARENT_TAG_CODE);
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals(Arrays.asList(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN.booleanValue()), new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_HAS_NO_CHILDREN.booleanValue())), (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsUpperCaseParameters() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_TYPE_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE.toUpperCase(), NO_PARENT_TAG_CODE);
        Assert.assertNotNull((Object)resultTagKeys);
        Assert.assertEquals(Arrays.asList(new TagChild(new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN.booleanValue()), new TagChild(new TagKey(TAG_TYPE, TAG_CODE_2), TAG_HAS_NO_CHILDREN.booleanValue())), (Object)resultTagKeys.getTagChildren());
    }

    @Test
    public void testGetTagsWithParent() {
        TagEntity root = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity child = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME + "x", TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2 + "x", root);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2 + "y", TAG_DISPLAY_NAME_2 + "y", TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_2 + "y", child);
        TagListResponse resultTagKeys = this.tagService.getTags(TAG_TYPE, NO_PARENT_TAG_CODE);
        Assert.assertNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertNull((Object)resultTagKeys.getTagKey());
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        resultTagKeys = this.tagService.getTags(TAG_TYPE, TAG_CODE);
        Assert.assertNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        Assert.assertEquals((Object)resultTagKeys.getTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE));
        resultTagKeys = this.tagService.getTags(TAG_TYPE, TAG_CODE.toLowerCase() + " ");
        Assert.assertNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        Assert.assertEquals((Object)resultTagKeys.getTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE));
        resultTagKeys = this.tagService.getTags(TAG_TYPE, TAG_CODE_2.toLowerCase() + " ");
        Assert.assertNotNull((Object)resultTagKeys.getParentTagKey());
        Assert.assertEquals((Object)resultTagKeys.getParentTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE));
        Assert.assertEquals((long)resultTagKeys.getTagChildren().size(), (long)1L);
        Assert.assertEquals((Object)resultTagKeys.getTagKey(), (Object)new TagKey(TAG_TYPE, TAG_CODE_2));
    }

    @Test
    public void testSearchTags() {
        this.createDatabaseEntitiesForTagSearchTesting();
        TagSearchResponse tagSearchResponse = this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, TAG_CODE, NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.DISPLAY_NAME_FIELD, TagServiceImpl.SEARCH_SCORE_MULTIPLIER_FIELD, TagServiceImpl.DESCRIPTION_FIELD, TagServiceImpl.PARENT_TAG_KEY_FIELD, TagServiceImpl.HAS_CHILDREN_FIELD}));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN))), (Object)tagSearchResponse);
    }

    @Test
    public void testSearchTagsInvalidParameters() {
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(), new TagSearchFilter())), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At most one tag search filter must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(), new TagSearchKey())))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one tag search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey("I_DO_NOT_EXIST", NO_PARENT_TAG_CODE, NO_IS_PARENT_TAG_NULL_FLAG))))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)"Tag type with code \"I_DO_NOT_EXIST\" doesn't exist.", (Object)e.getMessage());
        }
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, NO_PARENT_TAG_CODE, NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{"INVALID_FIELD_OPTION"}));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Search response field \"invalid_field_option\" is not supported.", (Object)e.getMessage());
        }
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, TAG_CODE, PARENT_TAG_IS_NULL))))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A parent tag code can not be specified when isParentTagNull flag is set to true.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchTagsLowerCaseParameters() {
        this.createDatabaseEntitiesForTagSearchTesting();
        TagSearchResponse tagSearchResponse = this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase(), NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.DISPLAY_NAME_FIELD.toLowerCase(), TagServiceImpl.SEARCH_SCORE_MULTIPLIER_FIELD.toLowerCase(), TagServiceImpl.DESCRIPTION_FIELD.toLowerCase(), TagServiceImpl.PARENT_TAG_KEY_FIELD.toLowerCase(), TagServiceImpl.HAS_CHILDREN_FIELD.toLowerCase()}));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN))), (Object)tagSearchResponse);
    }

    @Test
    public void testSearchTagsMissingOptionalParameters() {
        this.createDatabaseEntitiesForTagSearchTesting();
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(), NO_SEARCH_RESPONSE_FIELDS));
        ArrayList<Object> tagSearchFilters = new ArrayList<Object>();
        tagSearchFilters.add(null);
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(tagSearchFilters), NO_SEARCH_RESPONSE_FIELDS));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, "      \t\t ", NO_IS_PARENT_TAG_NULL_FLAG))))), NO_SEARCH_RESPONSE_FIELDS));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), TAG_DISPLAY_NAME_2, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_3, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, "      \t\t ", NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.DISPLAY_NAME_FIELD})));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER_3, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER_2, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, "      \t\t ", NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.SEARCH_SCORE_MULTIPLIER_FIELD})));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION_3, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION_2, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, "      \t\t ", NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.DESCRIPTION_FIELD})));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, "      \t\t ", NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.PARENT_TAG_KEY_FIELD})));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, TAG_HAS_CHILDREN), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, TAG_HAS_NO_CHILDREN), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, TAG_HAS_NO_CHILDREN))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, "      \t\t ", NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.HAS_CHILDREN_FIELD})));
    }

    @Test
    public void testSearchTagsMissingRequiredParameters() {
        try {
            this.tagService.searchTags(null, NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag search request must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter())), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one tag search key must be specified.", (Object)e.getMessage());
        }
        try {
            ArrayList<Object> tagSearchKeys = new ArrayList<Object>();
            tagSearchKeys.add(null);
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(tagSearchKeys))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one tag search key must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey("      \t\t ", NO_PARENT_TAG_CODE, NO_IS_PARENT_TAG_NULL_FLAG))))), NO_SEARCH_RESPONSE_FIELDS);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchTagsTrimParameters() {
        this.createDatabaseEntitiesForTagSearchTesting();
        TagSearchResponse tagSearchResponse = this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE), NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{this.addWhitespace(TagServiceImpl.DISPLAY_NAME_FIELD), this.addWhitespace(TagServiceImpl.SEARCH_SCORE_MULTIPLIER_FIELD), this.addWhitespace(TagServiceImpl.DESCRIPTION_FIELD), this.addWhitespace(TagServiceImpl.PARENT_TAG_KEY_FIELD), this.addWhitespace(TagServiceImpl.HAS_CHILDREN_FIELD)}));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN))), (Object)tagSearchResponse);
    }

    @Test
    public void testSearchTagsUpperCaseParameters() {
        this.createDatabaseEntitiesForTagSearchTesting();
        TagSearchResponse tagSearchResponse = this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase(), NO_IS_PARENT_TAG_NULL_FLAG))))), (Set)Sets.newHashSet((Object[])new String[]{TagServiceImpl.DISPLAY_NAME_FIELD.toUpperCase(), TagServiceImpl.SEARCH_SCORE_MULTIPLIER_FIELD.toUpperCase(), TagServiceImpl.DESCRIPTION_FIELD.toUpperCase(), TagServiceImpl.PARENT_TAG_KEY_FIELD.toUpperCase(), TagServiceImpl.HAS_CHILDREN_FIELD.toUpperCase()}));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, new TagKey(TAG_TYPE, TAG_CODE), TAG_HAS_NO_CHILDREN))), (Object)tagSearchResponse);
    }

    @Test
    public void testSearchTagsWithIsParentTagNullFlag() {
        this.createDatabaseEntitiesForTagSearchTesting();
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, NO_PARENT_TAG_CODE, PARENT_TAG_IS_NULL))))), NO_SEARCH_RESPONSE_FIELDS));
        Assert.assertEquals((Object)new TagSearchResponse(Arrays.asList(new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_3), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), new Tag(NO_ID, new TagKey(TAG_TYPE, TAG_CODE_2), NO_TAG_DISPLAY_NAME, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_USER_ID, NO_USER_ID, NO_UPDATED_TIME, NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG))), (Object)this.tagService.searchTags(new TagSearchRequest(Arrays.asList(new TagSearchFilter(Arrays.asList(new TagSearchKey(TAG_TYPE, NO_PARENT_TAG_CODE, PARENT_TAG_IS_NOT_NULL))))), NO_SEARCH_RESPONSE_FIELDS));
    }

    @Test
    public void testUpdateTag() {
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2);
        Tag updatedTag = this.tagService.updateTag(tagKey, new TagUpdateRequest(TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, parentTagKey));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagDisplayNameAlreadyExistsForOtherTagType() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE_2, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, NO_PARENT_TAG_KEY));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), new TagKey(TAG_TYPE, TAG_CODE), TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagDisplayNameAlreadyExistsForThisTagType() {
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME_2.toUpperCase(), TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION);
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Display name \"%s\" already exists for a tag with tag type \"%s\" and tag code \"%s\".", TAG_DISPLAY_NAME_2.toLowerCase(), TAG_TYPE, TAG_CODE_2), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagInvalidParameters() {
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, new TagKey(TAG_TYPE_2, TAG_CODE_2)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Tag type code in parent tag key must match the tag type code in the request.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2.multiply(BigDecimal.valueOf(-1L)), TAG_DESCRIPTION_2, new TagKey(TAG_TYPE, TAG_CODE_2)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The searchScoreMultiplier can not have a negative value. searchScoreMultiplier=%s", TAG_SEARCH_SCORE_MULTIPLIER_2.multiply(BigDecimal.valueOf(-1L))), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagLowerCaseParameters() {
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE_2.toLowerCase()), new TagUpdateRequest(TAG_DISPLAY_NAME_3.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3.toLowerCase(), new TagKey(TAG_TYPE.toLowerCase(), TAG_CODE.toLowerCase())));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME_3.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3.toLowerCase(), tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagMissingOptionalParametersPassedAsNulls() {
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagEntity parentTagEntity = this.tagDaoTestHelper.createTagEntity(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, parentTagEntity);
        Tag updatedTag = this.tagService.updateTag(tagKey, new TagUpdateRequest(TAG_DISPLAY_NAME_3, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME_3, NO_TAG_SEARCH_SCORE_MULTIPLIER, NO_TAG_DESCRIPTION, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagMissingOptionalParametersPassedAsWhitespace() {
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagEntity parentTagEntity = this.tagDaoTestHelper.createTagEntity(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, parentTagEntity);
        Tag updatedTag = this.tagService.updateTag(tagKey, new TagUpdateRequest(TAG_DISPLAY_NAME_3, NO_TAG_SEARCH_SCORE_MULTIPLIER, "      \t\t ", NO_PARENT_TAG_KEY));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME_3, NO_TAG_SEARCH_SCORE_MULTIPLIER, "      \t\t ", tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagMissingRequiredParameters() {
        try {
            this.tagService.updateTag(new TagKey("      \t\t ", TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, "      \t\t "), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest("      \t\t ", TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, NO_PARENT_TAG_KEY));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A display name must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE_2), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, new TagKey("      \t\t ", TAG_CODE)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag type code must be specified.", (Object)e.getMessage());
        }
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE_2), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, new TagKey(TAG_TYPE, "      \t\t ")));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag code must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagNoChangesToDisplayName() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(tagKey, new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_PARENT_TAG_KEY));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagNoChangesToDisplayNameExceptForCase() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME.toUpperCase(), TAG_DESCRIPTION);
        Tag updatedTag = this.tagService.updateTag(tagKey, new TagUpdateRequest(TAG_DISPLAY_NAME.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, NO_PARENT_TAG_KEY));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME.toLowerCase(), TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), NO_PARENT_TAG_KEY, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagParentTagIsChild() {
        TagEntity rootTagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity childTagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, rootTagEntity);
        TagEntity grandchildTagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_3, TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, childTagEntity);
        for (TagEntity tagEntity : Arrays.asList(rootTagEntity, childTagEntity, grandchildTagEntity)) {
            try {
                this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_4, TAG_SEARCH_SCORE_MULTIPLIER_4, TAG_DESCRIPTION_4, new TagKey(tagEntity.getTagType().getCode(), tagEntity.getTagCode())));
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Parent tag key cannot be the requested tag key or any of its children\u2019s tag keys.", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTagParentTagMaxAllowedNestingExceeds() throws Exception {
        TagEntity rootTagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagEntity childTagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, rootTagEntity);
        TagEntity grandchildTagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE_3, TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, childTagEntity);
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.MAX_ALLOWED_TAG_NESTING.getKey(), 1);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            try {
                this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_4, TAG_SEARCH_SCORE_MULTIPLIER_4, TAG_DESCRIPTION_4, new TagKey(childTagEntity.getTagType().getCode(), childTagEntity.getTagCode())));
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Parent tag key cannot be the requested tag key or any of its children\u2019s tag keys.", (Object)e.getMessage());
            }
            try {
                this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE), new TagUpdateRequest(TAG_DISPLAY_NAME_4, TAG_SEARCH_SCORE_MULTIPLIER_4, TAG_DESCRIPTION_4, new TagKey(grandchildTagEntity.getTagType().getCode(), grandchildTagEntity.getTagCode())));
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Exceeds maximum allowed tag nesting level of 1", (Object)e.getMessage());
            }
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testUpdateTagParentTagNoExists() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        try {
            this.tagService.updateTag(tagKey, new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, new TagKey(TAG_TYPE, TAG_CODE)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTagNoExists() {
        try {
            this.tagService.updateTag(new TagKey(TAG_TYPE, TAG_CODE_2), new TagUpdateRequest(TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, new TagKey(TAG_TYPE, TAG_CODE)));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Tag with code \"%s\" doesn't exist for tag type \"%s\".", TAG_CODE_2, TAG_TYPE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateTagTrimParameters() {
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2);
        Tag updatedTag = this.tagService.updateTag(new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE_2)), new TagUpdateRequest(this.addWhitespace(TAG_DISPLAY_NAME_3), TAG_SEARCH_SCORE_MULTIPLIER_3, this.addWhitespace(TAG_DESCRIPTION_3), new TagKey(this.addWhitespace(TAG_TYPE), this.addWhitespace(TAG_CODE.toLowerCase()))));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_3, this.addWhitespace(TAG_DESCRIPTION_3), tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    @Test
    public void testUpdateTagUpperCaseParameters() {
        TagKey parentTagKey = new TagKey(TAG_TYPE, TAG_CODE);
        this.tagDaoTestHelper.createTagEntity(parentTagKey, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE_2);
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(tagKey, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2);
        Tag updatedTag = this.tagService.updateTag(new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE_2.toUpperCase()), new TagUpdateRequest(TAG_DISPLAY_NAME_3.toUpperCase(), TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3.toUpperCase(), new TagKey(TAG_TYPE.toUpperCase(), TAG_CODE.toUpperCase())));
        Assert.assertEquals((Object)new Tag(tagEntity.getId(), tagKey, TAG_DISPLAY_NAME_3.toUpperCase(), TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3.toUpperCase(), tagEntity.getCreatedBy(), tagEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)tagEntity.getUpdatedOn()), parentTagKey, NO_TAG_HAS_CHILDREN_FLAG), (Object)updatedTag);
    }

    private void createDatabaseEntitiesForTagSearchTesting() {
        TagTypeEntity tagTypeEntity = this.tagTypeDaoTestHelper.createTagTypeEntity(TAG_TYPE, TAG_TYPE_DISPLAY_NAME, TAG_TYPE_ORDER, TAG_TYPE_DESCRIPTION);
        TagEntity rootTagEntity = this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_2, TAG_DISPLAY_NAME_3, TAG_SEARCH_SCORE_MULTIPLIER_2, TAG_DESCRIPTION_2, rootTagEntity);
        this.tagDaoTestHelper.createTagEntity(tagTypeEntity, TAG_CODE_3, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER_3, TAG_DESCRIPTION_3, rootTagEntity);
    }
}

