/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.core.helper.LoggingHelper;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.BusinessObjectDataStatusDao;
import org.finra.herd.dao.BusinessObjectFormatDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.DownloadSingleInitiationResponse;
import org.finra.herd.model.api.xml.File;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.api.xml.UploadSingleInitiationRequest;
import org.finra.herd.model.api.xml.UploadSingleInitiationResponse;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDataServiceTestHelper;
import org.finra.herd.service.BusinessObjectDefinitionServiceTestHelper;
import org.finra.herd.service.UploadDownloadService;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.impl.UploadDownloadHelperServiceImpl;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UploadDownloadServiceTestHelper {
    @Autowired
    private BusinessObjectDataDao businessObjectDataDao;
    @Autowired
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Autowired
    private BusinessObjectDataServiceTestHelper businessObjectDataServiceTestHelper;
    @Autowired
    private BusinessObjectDataStatusDao businessObjectDataStatusDao;
    @Autowired
    private BusinessObjectDefinitionServiceTestHelper businessObjectDefinitionServiceTestHelper;
    @Autowired
    private BusinessObjectFormatDaoTestHelper businessObjectFormatDaoTestHelper;
    @Autowired
    private ConfigurationHelper configurationHelper;
    @Autowired
    private LoggingHelper loggingHelper;
    @Autowired
    private StorageDaoHelper storageDaoHelper;
    @Autowired
    private StorageHelper storageHelper;
    @Autowired
    private UploadDownloadService uploadDownloadService;

    public void createDatabaseEntitiesForUploadDownloadTesting() {
        this.createDatabaseEntitiesForUploadDownloadTesting(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION);
        this.createDatabaseEntitiesForUploadDownloadTesting(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME_2, AbstractServiceTest.FORMAT_USAGE_CODE_2, AbstractServiceTest.FORMAT_FILE_TYPE_CODE_2, AbstractServiceTest.FORMAT_VERSION_2);
    }

    public void createDatabaseEntitiesForUploadDownloadTesting(String namespaceCode, String businessObjectDefinitionName, String businessObjectFormatUsage, String businessObjectFormatFileType, Integer businessObjectFormatVersion) {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(namespaceCode, businessObjectDefinitionName, businessObjectFormatUsage, businessObjectFormatFileType, businessObjectFormatVersion, AbstractServiceTest.FORMAT_DESCRIPTION, AbstractServiceTest.FORMAT_DOCUMENT_SCHEMA, AbstractServiceTest.LATEST_VERSION_FLAG_SET, AbstractServiceTest.PARTITION_KEY);
    }

    public UploadSingleInitiationRequest createUploadSingleInitiationRequest() {
        return this.createUploadSingleInitiationRequest(AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME, AbstractServiceTest.FORMAT_USAGE_CODE, AbstractServiceTest.FORMAT_FILE_TYPE_CODE, AbstractServiceTest.FORMAT_VERSION, AbstractServiceTest.NAMESPACE, AbstractServiceTest.BDEF_NAME_2, AbstractServiceTest.FORMAT_USAGE_CODE_2, AbstractServiceTest.FORMAT_FILE_TYPE_CODE_2, AbstractServiceTest.FORMAT_VERSION_2, AbstractServiceTest.FILE_NAME);
    }

    public UploadSingleInitiationRequest createUploadSingleInitiationRequest(String sourceNamespaceCode, String sourceBusinessObjectDefinitionName, String sourceBusinessObjectFormatUsage, String sourceBusinessObjectFormatFileType, Integer sourceBusinessObjectFormatVersion, String targetNamespaceCode, String targetBusinessObjectDefinitionName, String targetBusinessObjectFormatUsage, String targetBusinessObjectFormatFileType, Integer targetBusinessObjectFormatVersion) {
        return this.createUploadSingleInitiationRequest(sourceNamespaceCode, sourceBusinessObjectDefinitionName, sourceBusinessObjectFormatUsage, sourceBusinessObjectFormatFileType, sourceBusinessObjectFormatVersion, targetNamespaceCode, targetBusinessObjectDefinitionName, targetBusinessObjectFormatUsage, targetBusinessObjectFormatFileType, targetBusinessObjectFormatVersion, AbstractServiceTest.FILE_NAME);
    }

    public UploadSingleInitiationRequest createUploadSingleInitiationRequest(String sourceNamespaceCode, String sourceBusinessObjectDefinitionName, String sourceBusinessObjectFormatUsage, String sourceBusinessObjectFormatFileType, Integer sourceBusinessObjectFormatVersion, String targetNamespaceCode, String targetBusinessObjectDefinitionName, String targetBusinessObjectFormatUsage, String targetBusinessObjectFormatFileType, Integer targetBusinessObjectFormatVersion, String fileName) {
        UploadSingleInitiationRequest request = new UploadSingleInitiationRequest();
        request.setSourceBusinessObjectFormatKey(new BusinessObjectFormatKey(sourceNamespaceCode, sourceBusinessObjectDefinitionName, sourceBusinessObjectFormatUsage, sourceBusinessObjectFormatFileType, sourceBusinessObjectFormatVersion));
        request.setTargetBusinessObjectFormatKey(new BusinessObjectFormatKey(targetNamespaceCode, targetBusinessObjectDefinitionName, targetBusinessObjectFormatUsage, targetBusinessObjectFormatFileType, targetBusinessObjectFormatVersion));
        request.setBusinessObjectDataAttributes(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        request.setFile(new File(fileName, Long.valueOf(1024L)));
        return request;
    }

    public UploadSingleInitiationResponse createUploadedFileData(String businessObjectDataStatusCode) {
        this.loggingHelper.setLogLevel(UploadDownloadHelperServiceImpl.class, LogLevel.OFF);
        this.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.createUploadSingleInitiationRequest());
        this.uploadDownloadService.performCompleteUploadSingleMessage(((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getSourceBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath());
        this.businessObjectDataDao.getBusinessObjectDataByAltKey(this.businessObjectDataHelper.getBusinessObjectDataKey(resultUploadSingleInitiationResponse.getTargetBusinessObjectData())).setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode(businessObjectDataStatusCode));
        resultUploadSingleInitiationResponse.getTargetBusinessObjectData().setStatus(businessObjectDataStatusCode);
        return resultUploadSingleInitiationResponse;
    }

    public void validateDownloadSingleInitiationResponse(UploadSingleInitiationResponse uploadSingleInitiationResponse, DownloadSingleInitiationResponse downloadSingleInitiationResponse) {
        BusinessObjectData targetBusinessObjectData = uploadSingleInitiationResponse.getTargetBusinessObjectData();
        this.validateDownloadSingleInitiationResponse(targetBusinessObjectData.getNamespace(), targetBusinessObjectData.getBusinessObjectDefinitionName(), targetBusinessObjectData.getBusinessObjectFormatUsage(), targetBusinessObjectData.getBusinessObjectFormatFileType(), targetBusinessObjectData.getBusinessObjectFormatVersion(), targetBusinessObjectData.getAttributes(), ((StorageFile)((StorageUnit)targetBusinessObjectData.getStorageUnits().get(0)).getStorageFiles().get(0)).getFileSizeBytes(), downloadSingleInitiationResponse);
    }

    public void validateDownloadSingleInitiationResponse(String expectedNamespaceCode, String expectedBusinessObjectDefinitionName, String expectedBusinessObjectFormatUsage, String expectedBusinessObjectFormatFileType, Integer expectedBusinessObjectFormatVersion, List<Attribute> expectedAttributes, Long expectedFileSizeBytes, DownloadSingleInitiationResponse actualDownloadSingleInitiationResponse) {
        Assert.assertNotNull((Object)actualDownloadSingleInitiationResponse);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(expectedNamespaceCode, expectedBusinessObjectDefinitionName, expectedBusinessObjectFormatUsage, expectedBusinessObjectFormatFileType, expectedBusinessObjectFormatVersion, "VALID", expectedAttributes, "S3_MANAGED_EXTERNAL", AbstractServiceTest.FILE_NAME, expectedFileSizeBytes, actualDownloadSingleInitiationResponse.getBusinessObjectData());
        Assert.assertNotNull((String)"aws access key", (Object)actualDownloadSingleInitiationResponse.getAwsAccessKey());
        Assert.assertNotNull((String)"aws secret key", (Object)actualDownloadSingleInitiationResponse.getAwsSecretKey());
        Assert.assertNotNull((String)"aws session token", (Object)actualDownloadSingleInitiationResponse.getAwsSessionToken());
        Assert.assertNotNull((String)"pre-signed URL", (Object)actualDownloadSingleInitiationResponse.getPreSignedUrl());
    }

    public void validateUploadSingleInitiationResponse(String expectedSourceNamespaceCode, String expectedSourceBusinessObjectDefinitionName, String expectedSourceBusinessObjectFormatUsage, String expectedSourceBusinessObjectFormatFileType, Integer expectedSourceBusinessObjectFormatVersion, String expectedTargetNamespaceCode, String expectedTargetBusinessObjectDefinitionName, String expectedTargetBusinessObjectFormatUsage, String expectedTargetBusinessObjectFormatFileType, Integer expectedTargetBusinessObjectFormatVersion, List<Attribute> expectedAttributes, String expectedFileName, Long expectedFileSizeBytes, String expectedTargetStorageName, UploadSingleInitiationResponse actualUploadSingleInitiationResponse) {
        if (expectedTargetStorageName == null) {
            expectedTargetStorageName = this.configurationHelper.getProperty(ConfigurationValue.S3_EXTERNAL_STORAGE_NAME_DEFAULT);
        }
        Assert.assertNotNull((Object)actualUploadSingleInitiationResponse);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(expectedSourceNamespaceCode, expectedSourceBusinessObjectDefinitionName, expectedSourceBusinessObjectFormatUsage, expectedSourceBusinessObjectFormatFileType, expectedSourceBusinessObjectFormatVersion, "UPLOADING", expectedAttributes, "S3_MANAGED_LOADING_DOCK", expectedFileName, expectedFileSizeBytes, actualUploadSingleInitiationResponse.getSourceBusinessObjectData());
        this.businessObjectDataServiceTestHelper.validateBusinessObjectData(expectedTargetNamespaceCode, expectedTargetBusinessObjectDefinitionName, expectedTargetBusinessObjectFormatUsage, expectedTargetBusinessObjectFormatFileType, expectedTargetBusinessObjectFormatVersion, "UPLOADING", expectedAttributes, expectedTargetStorageName, expectedFileName, expectedFileSizeBytes, actualUploadSingleInitiationResponse.getTargetBusinessObjectData());
        Assert.assertNotNull((Object)actualUploadSingleInitiationResponse.getFile());
        Assert.assertEquals((Object)expectedFileName, (Object)actualUploadSingleInitiationResponse.getFile().getFileName());
        Assert.assertEquals((Object)expectedFileSizeBytes, (Object)actualUploadSingleInitiationResponse.getFile().getFileSizeBytes());
        Assert.assertEquals((Object)actualUploadSingleInitiationResponse.getSourceBusinessObjectData().getPartitionValue(), (Object)actualUploadSingleInitiationResponse.getUuid());
        Assert.assertEquals((Object)actualUploadSingleInitiationResponse.getTargetBusinessObjectData().getPartitionValue(), (Object)actualUploadSingleInitiationResponse.getUuid());
        Assert.assertEquals((Object)"mock_aws_assumed_role_access_key", (Object)actualUploadSingleInitiationResponse.getAwsAccessKey());
        Assert.assertEquals((Object)"mock_aws_assumed_role_secret_key", (Object)actualUploadSingleInitiationResponse.getAwsSecretKey());
        Assert.assertEquals((Object)"mock_aws_assumed_role_session_token", (Object)actualUploadSingleInitiationResponse.getAwsSessionToken());
        Assert.assertEquals((Object)expectedTargetStorageName, (Object)actualUploadSingleInitiationResponse.getTargetStorageName());
        Assert.assertEquals((Object)this.storageHelper.getStorageAttributeValueByName(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KMS_KEY_ID), this.storageDaoHelper.getStorageEntity(expectedTargetStorageName), true), (Object)actualUploadSingleInitiationResponse.getAwsKmsKeyId());
    }
}

