/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationKey;
import org.finra.herd.model.dto.MessageHeader;
import org.finra.herd.model.dto.NotificationMessage;
import org.junit.Assert;
import org.springframework.stereotype.Component;

@Component
public class UserNamespaceAuthorizationServiceTestHelper {
    public void validateUserNamespaceAuthorizationChangeMessageWithXmlPayload(String expectedMessageType, String expectedMessageDestination, String expectedUsername, UserNamespaceAuthorizationKey expectedUserNamespaceAuthorizationKey, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        String messageText = notificationMessage.getMessageText();
        this.validateXmlFieldPresent(messageText, "triggered-by-username", expectedUsername);
        this.validateXmlFieldPresent(messageText, "context-message-type", "testDomain/testApplication/UserNamespaceAuthorizationChanged");
        this.validateXmlFieldPresent(messageText, "namespace", expectedUserNamespaceAuthorizationKey.getNamespace());
        this.validateXmlFieldPresent(messageText, "userId", expectedUserNamespaceAuthorizationKey.getUserId());
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private void validateXmlFieldPresent(String message, String xmlTagName, Object value) {
        Assert.assertTrue((String)(xmlTagName + " \"" + value + "\" expected, but not found."), (boolean)message.contains("<" + xmlTagName + ">" + (value == null ? null : value.toString()) + "</" + xmlTagName + ">"));
    }
}

