/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti;

import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ActivitiHelperTest
extends AbstractServiceTest {
    @Test
    public void testGetExpressionVariableAsBoolean() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)BOOLEAN_VALUE.toString());
        Boolean result = this.activitiHelper.getExpressionVariableAsBoolean(expression, execution, VARIABLE_NAME, NO_VARIABLE_REQUIRED.booleanValue(), NO_BOOLEAN_DEFAULT_VALUE);
        Assert.assertEquals((Object)BOOLEAN_VALUE, (Object)result);
    }

    @Test
    public void testGetExpressionVariableAsBooleanBlankValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)"      \t\t ");
        Boolean result = this.activitiHelper.getExpressionVariableAsBoolean(expression, execution, VARIABLE_NAME, NO_VARIABLE_REQUIRED.booleanValue(), BOOLEAN_DEFAULT_VALUE);
        Assert.assertEquals((Object)BOOLEAN_DEFAULT_VALUE, (Object)result);
    }

    @Test
    public void testGetExpressionVariableAsBooleanInvalidValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)INVALID_VALUE);
        try {
            this.activitiHelper.getExpressionVariableAsBoolean(expression, execution, VARIABLE_NAME, NO_VARIABLE_REQUIRED.booleanValue(), NO_BOOLEAN_DEFAULT_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("\"%s\" must be a valid boolean value of \"true\" or \"false\".", VARIABLE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpressionVariableAsBooleanRequired() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)BOOLEAN_VALUE.toString());
        Boolean result = this.activitiHelper.getExpressionVariableAsBoolean(expression, execution, VARIABLE_NAME, VARIABLE_REQUIRED.booleanValue(), NO_BOOLEAN_DEFAULT_VALUE);
        Assert.assertEquals((Object)BOOLEAN_VALUE, (Object)result);
    }

    @Test
    public void testGetExpressionVariableAsBooleanRequiredBlankValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)"      \t\t ");
        try {
            this.activitiHelper.getExpressionVariableAsBoolean(expression, execution, VARIABLE_NAME, VARIABLE_REQUIRED.booleanValue(), NO_BOOLEAN_DEFAULT_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("\"%s\" must be specified.", VARIABLE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpressionVariableAsInteger() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)INTEGER_VALUE.toString());
        Integer result = this.activitiHelper.getExpressionVariableAsInteger(expression, execution, VARIABLE_NAME, NO_VARIABLE_REQUIRED.booleanValue());
        Assert.assertEquals((Object)INTEGER_VALUE, (Object)result);
    }

    @Test
    public void testGetExpressionVariableAsIntegerBlankValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)"      \t\t ");
        Integer result = this.activitiHelper.getExpressionVariableAsInteger(expression, execution, VARIABLE_NAME, NO_VARIABLE_REQUIRED.booleanValue());
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetExpressionVariableAsIntegerInvalidValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)INVALID_VALUE);
        try {
            this.activitiHelper.getExpressionVariableAsInteger(expression, execution, VARIABLE_NAME, VARIABLE_REQUIRED.booleanValue());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("\"%s\" must be a valid integer value.", VARIABLE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpressionVariableAsIntegerRequired() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)INTEGER_VALUE.toString());
        Integer result = this.activitiHelper.getExpressionVariableAsInteger(expression, execution, VARIABLE_NAME, VARIABLE_REQUIRED.booleanValue());
        Assert.assertEquals((Object)INTEGER_VALUE, (Object)result);
    }

    @Test
    public void testGetExpressionVariableAsIntegerRequiredBlankValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)"      \t\t ");
        try {
            this.activitiHelper.getExpressionVariableAsInteger(expression, execution, VARIABLE_NAME, VARIABLE_REQUIRED.booleanValue());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("\"%s\" must be specified.", VARIABLE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetProcessIdentifyingInformation() {
        String processDefinitionId = STRING_VALUE;
        String processInstanceId = STRING_VALUE_2;
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)execution.getProcessDefinitionId()).thenReturn((Object)processDefinitionId);
        Mockito.when((Object)execution.getProcessInstanceId()).thenReturn((Object)processInstanceId);
        String result = this.activitiHelper.getProcessIdentifyingInformation(execution);
        Assert.assertEquals((Object)String.format("[ activitiProcessDefinitionId=\"%s\" activitiProcessInstanceId=\"%s\" ]", processDefinitionId, processInstanceId), (Object)result);
    }

    @Test
    public void testGetRequiredExpressionVariableAsString() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)STRING_VALUE);
        String result = this.activitiHelper.getRequiredExpressionVariableAsString(expression, execution, VARIABLE_NAME);
        Assert.assertEquals((Object)STRING_VALUE, (Object)result);
    }

    @Test
    public void testGetRequiredExpressionVariableAsStringBlankValue() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)expression.getValue((VariableScope)execution)).thenReturn((Object)"      \t\t ");
        try {
            this.activitiHelper.getRequiredExpressionVariableAsString(expression, execution, VARIABLE_NAME);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("\"%s\" must be specified.", VARIABLE_NAME), (Object)e.getMessage());
        }
    }
}

