/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti;

import org.activiti.engine.RuntimeService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ExecutionQuery;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class ActivitiRuntimeHelperTest
extends AbstractServiceTest {
    @InjectMocks
    private ActivitiRuntimeHelper activitiRuntimeHelper;
    @Mock
    private RuntimeService runtimeService;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testBuildTaskWorkflowVariableName() {
        Assert.assertEquals((Object)(ACTIVITI_ID + "_" + VARIABLE_NAME), (Object)this.activitiRuntimeHelper.buildTaskWorkflowVariableName(ACTIVITI_ID, VARIABLE_NAME));
    }

    @Test
    public void testSetTaskErrorInWorkflow() {
        String currentActivityId = ACTIVITI_ID;
        String executionId = ACTIVITI_ID_2;
        String statusTaskWorkflowVariableName = this.activitiRuntimeHelper.buildTaskWorkflowVariableName(currentActivityId, "taskStatus");
        String errorMessageTaskWorkflowVariableName = this.activitiRuntimeHelper.buildTaskWorkflowVariableName(currentActivityId, "taskErrorMessage");
        Exception exception = new Exception(ERROR_CODE);
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)execution.getCurrentActivityId()).thenReturn((Object)currentActivityId);
        Mockito.when((Object)execution.getId()).thenReturn((Object)executionId);
        this.activitiRuntimeHelper.setTaskErrorInWorkflow(execution, ERROR_MESSAGE, exception);
        ((DelegateExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)3))).getCurrentActivityId();
        ((DelegateExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)3))).getId();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)2))).getVariables(executionId);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).setVariable(executionId, statusTaskWorkflowVariableName, (Object)"ERROR");
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).setVariable(executionId, errorMessageTaskWorkflowVariableName, (Object)ERROR_MESSAGE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{execution, this.runtimeService});
    }

    @Test
    public void testSetTaskErrorInWorkflowNoException() {
        String currentActivityId = ACTIVITI_ID;
        String executionId = ACTIVITI_ID_2;
        String statusTaskWorkflowVariableName = this.activitiRuntimeHelper.buildTaskWorkflowVariableName(currentActivityId, "taskStatus");
        String errorMessageTaskWorkflowVariableName = this.activitiRuntimeHelper.buildTaskWorkflowVariableName(currentActivityId, "taskErrorMessage");
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)execution.getCurrentActivityId()).thenReturn((Object)currentActivityId);
        Mockito.when((Object)execution.getId()).thenReturn((Object)executionId);
        this.activitiRuntimeHelper.setTaskErrorInWorkflow(execution, ERROR_MESSAGE, null);
        ((DelegateExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)2))).getCurrentActivityId();
        ((DelegateExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)2))).getId();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)2))).getVariables(executionId);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).setVariable(executionId, statusTaskWorkflowVariableName, (Object)"ERROR");
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).setVariable(executionId, errorMessageTaskWorkflowVariableName, (Object)ERROR_MESSAGE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{execution, this.runtimeService});
    }

    @Test
    public void testSetTaskSuccessInWorkflow() {
        String currentActivityId = ACTIVITI_ID;
        String executionId = ACTIVITI_ID_2;
        String statusTaskWorkflowVariableName = this.activitiRuntimeHelper.buildTaskWorkflowVariableName(currentActivityId, "taskStatus");
        DelegateExecution execution = (DelegateExecution)Mockito.mock(DelegateExecution.class);
        Mockito.when((Object)execution.getCurrentActivityId()).thenReturn((Object)currentActivityId);
        Mockito.when((Object)execution.getId()).thenReturn((Object)executionId);
        this.activitiRuntimeHelper.setTaskSuccessInWorkflow(execution);
        ((DelegateExecution)Mockito.verify((Object)execution)).getCurrentActivityId();
        ((DelegateExecution)Mockito.verify((Object)execution)).getId();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).getVariables(executionId);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).setVariable(executionId, statusTaskWorkflowVariableName, (Object)"SUCCESS");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{execution, this.runtimeService});
    }

    @Test
    public void testSignal() {
        String processInstanceId = ACTIVITI_ID;
        String signalTaskId = ACTIVITI_ID_2;
        String executionId = ACTIVITI_ID_3;
        ExecutionQuery executionQuery = (ExecutionQuery)Mockito.mock(ExecutionQuery.class);
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)this.runtimeService.createExecutionQuery()).thenReturn((Object)executionQuery);
        Mockito.when((Object)executionQuery.processInstanceId(processInstanceId)).thenReturn((Object)executionQuery);
        Mockito.when((Object)executionQuery.activityId(signalTaskId)).thenReturn((Object)executionQuery);
        Mockito.when((Object)executionQuery.singleResult()).thenReturn((Object)execution);
        Mockito.when((Object)execution.getId()).thenReturn((Object)executionId);
        this.activitiRuntimeHelper.signal(processInstanceId, signalTaskId);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).createExecutionQuery();
        ((ExecutionQuery)Mockito.verify((Object)executionQuery)).processInstanceId(processInstanceId);
        ((ExecutionQuery)Mockito.verify((Object)executionQuery)).activityId(signalTaskId);
        ((ExecutionQuery)Mockito.verify((Object)executionQuery)).singleResult();
        ((Execution)Mockito.verify((Object)execution)).getId();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).signal(executionId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{executionQuery, execution, this.runtimeService});
    }
}

