/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageFilesCreateRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.AddBusinessObjectDataStorageFiles;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class AddBusinessObjectDataStorageFilesTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testAddBusinessObjectDataStorageFilesXml() throws Exception {
        BusinessObjectDataStorageFilesCreateRequest businessObjectDataStorageFilesCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataStorageFilesCreateRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageFilesCreateRequest", "${businessObjectDataStorageFilesCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataStorageFilesCreateRequest", this.xmlHelper.objectToXml((Object)businessObjectDataStorageFilesCreateRequest)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", "NOT_NULL");
        this.testActivitiServiceTaskSuccess(AddBusinessObjectDataStorageFiles.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testAddBusinessObjectDataStorageFilesJson() throws Exception {
        BusinessObjectDataStorageFilesCreateRequest businessObjectDataStorageFilesCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataStorageFilesCreateRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageFilesCreateRequest", "${businessObjectDataStorageFilesCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataStorageFilesCreateRequest", this.jsonHelper.objectToJson((Object)businessObjectDataStorageFilesCreateRequest)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", "NOT_NULL");
        this.testActivitiServiceTaskSuccess(AddBusinessObjectDataStorageFiles.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testAddBusinessObjectDataStorageFilesWrongContentType() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageFilesCreateRequest", "${businessObjectDataStorageFilesCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "wrong_content_type"));
        parameters.add(this.buildParameter("businessObjectDataStorageFilesCreateRequest", "some_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"ContentType\" must be a valid value of either \"xml\" or \"json\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageFiles.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageFilesNoRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageFilesCreateRequest", "${businessObjectDataStorageFilesCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataStorageFilesCreateRequest", ""));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataCreateRequest\" must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageFiles.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageFilesWrongXmlRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageFilesCreateRequest", "${businessObjectDataStorageFilesCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataStorageFilesCreateRequest", "wrong_xml_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataStorageFilesCreateRequest\" must be valid xml string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageFiles.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageFilesWrongJsonRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageFilesCreateRequest", "${businessObjectDataStorageFilesCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataStorageFilesCreateRequest", "wrong_json_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataStorageFilesCreateRequest\" must be valid json string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageFiles.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

