/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitCreateRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.AddBusinessObjectDataStorageUnit;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class AddBusinessObjectDataStorageUnitTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testAddBusinessObjectDataStorageUnitInvalidContentType() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageUnitCreateRequest", "${businessObjectDataStorageUnitCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "wrong_content_type"));
        parameters.add(this.buildParameter("businessObjectDataStorageUnitCreateRequest", "some_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"ContentType\" must be a valid value of either \"xml\" or \"json\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageUnit.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageUnitInvalidJsonRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageUnitCreateRequest", "${businessObjectDataStorageUnitCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataStorageUnitCreateRequest", "wrong_json_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataStorageUnitCreateRequest\" must be valid json string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageUnit.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageUnitInvalidXmlRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageUnitCreateRequest", "${businessObjectDataStorageUnitCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataStorageUnitCreateRequest", "wrong_xml_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataStorageUnitCreateRequest\" must be valid xml string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageUnit.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageUnitMissingRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageUnitCreateRequest", "${businessObjectDataStorageUnitCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataStorageUnitCreateRequest", ""));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataStorageUnitCreateRequest\" must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddBusinessObjectDataStorageUnit.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testAddBusinessObjectDataStorageUnitUsingJsonRequest() throws Exception {
        BusinessObjectDataStorageUnitCreateRequest businessObjectDataStorageUnitCreateRequest = this.businessObjectDataServiceTestHelper.getBusinessObjectDataStorageUnitCreateRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageUnitCreateRequest", "${businessObjectDataStorageUnitCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataStorageUnitCreateRequest", this.jsonHelper.objectToJson((Object)businessObjectDataStorageUnitCreateRequest)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", "NOT_NULL");
        this.testActivitiServiceTaskSuccess(AddBusinessObjectDataStorageUnit.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testAddBusinessObjectDataStorageUnitUsingXmlRequest() throws Exception {
        BusinessObjectDataStorageUnitCreateRequest businessObjectDataStorageUnitCreateRequest = this.businessObjectDataServiceTestHelper.getBusinessObjectDataStorageUnitCreateRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStorageUnitCreateRequest", "${businessObjectDataStorageUnitCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataStorageUnitCreateRequest", this.xmlHelper.objectToXml((Object)businessObjectDataStorageUnitCreateRequest)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", "NOT_NULL");
        this.testActivitiServiceTaskSuccess(AddBusinessObjectDataStorageUnit.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }
}

