/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.apache.commons.io.IOUtils;
import org.finra.herd.model.api.xml.EmrClusterCreateRequest;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.AddEmrMasterSecurityGroup;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class AddEmrMasterSecurityGroupTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testAddEmrMasterSecurityGroup() throws Exception {
        String securityGroupIds = EC2_SECURITY_GROUP_1 + "|" + EC2_SECURITY_GROUP_2;
        this.ec2OnDemandPricingDaoTestHelper.createEc2OnDemandPricingEntities();
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.trustingAccountDaoTestHelper.createTrustingAccountEntity(AWS_ACCOUNT_ID, AWS_ROLE_ARN);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterDefinitionOverride.setAccountId(AWS_ACCOUNT_ID);
        this.emrService.createCluster(new EmrClusterCreateRequest(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, EMR_CLUSTER_NAME, NO_DRY_RUN, emrClusterDefinitionOverride));
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("emrClusterDefinitionName", "${emrClusterDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("emrClusterName", "${emrClusterName}"));
        fieldExtensionList.add(this.buildFieldExtension("securityGroupIds", "${securityGroupIds}"));
        fieldExtensionList.add(this.buildFieldExtension("accountId", "${accountId}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("emrClusterDefinitionName", EMR_CLUSTER_DEFINITION_NAME));
        parameters.add(this.buildParameter("emrClusterName", EMR_CLUSTER_NAME));
        parameters.add(this.buildParameter("securityGroupIds", securityGroupIds));
        parameters.add(this.buildParameter("accountId", AWS_ACCOUNT_ID));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("emrMasterSecurityGroupIds", securityGroupIds);
        this.testActivitiServiceTaskSuccess(AddEmrMasterSecurityGroup.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testAddEmrMasterSecurityGroupMissingSecurityGroupIds() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("emrClusterDefinitionName", "${emrClusterDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("emrClusterName", "${emrClusterName}"));
        fieldExtensionList.add(this.buildFieldExtension("securityGroupIds", "${securityGroupIds}"));
        fieldExtensionList.add(this.buildFieldExtension("accountId", "${accountId}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("emrClusterDefinitionName", EMR_CLUSTER_DEFINITION_NAME));
        parameters.add(this.buildParameter("emrClusterName", EMR_CLUSTER_NAME));
        parameters.add(this.buildParameter("securityGroupIds", "      \t\t "));
        parameters.add(this.buildParameter("accountId", AWS_ACCOUNT_ID));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "At least one security group must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(AddEmrMasterSecurityGroup.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

