/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.dto.AwsParamsDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEmrClusterTest
extends AbstractServiceTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateEmrClusterTest.class);

    @Before
    public void createDatabaseEntities() {
        this.ec2OnDemandPricingDaoTestHelper.createEc2OnDemandPricingEntities();
    }

    private Map<String, Object> createJob(String clusterName, String dryRun, String contentType, String emrClusterDefinitionOverride) throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("dryRun", dryRun));
        parameters.add(new Parameter("contentType", contentType));
        parameters.add(new Parameter("emrClusterDefinitionOverride", emrClusterDefinitionOverride));
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowCreateEmrCluster.bpmn20.xml", parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        return hisInstance.getProcessVariables();
    }

    private void terminateCluster(String namespace, String clusterDefinitionName, String clusterName) {
        try {
            String fullClusterName = this.emrHelper.buildEmrClusterName(namespace, clusterDefinitionName, clusterName);
            AwsParamsDto awsParams = this.emrHelper.getAwsParamsDto();
            this.emrDao.terminateEmrCluster(fullClusterName, true, awsParams);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to terminate cluster namespace = %s, clusterDefinitionName = %s, clusterName = %s", namespace, clusterDefinitionName, clusterName));
        }
    }

    @Test
    public void testCreateCluster() throws Exception {
        String clusterName = "testCluster" + Math.random();
        Map<String, Object> variables = this.createJob(clusterName, null, null, null);
        Assert.assertEquals((String)"taskStatus", (Object)"SUCCESS", (Object)variables.get("createClusterServiceTask_taskStatus"));
        Assert.assertNotNull((String)"emrClusterId", (Object)variables.get("createClusterServiceTask_emrClusterId"));
        Assert.assertNotNull((String)"emrClusterStatus", (Object)variables.get("createClusterServiceTask_emrClusterStatus"));
        Assert.assertNotNull((String)"emrClusterCreated", (Object)variables.get("createClusterServiceTask_emrClusterCreated"));
        Assert.assertNotNull((String)"emrClusterDefinition", (Object)variables.get("createClusterServiceTask_emrClusterDefinition"));
        this.terminateCluster("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName);
    }

    @Test
    public void testCreateClusterDryRunTrue() throws Exception {
        String clusterName = "testCluster" + Math.random();
        Map<String, Object> variables = this.createJob(clusterName, "true", null, null);
        Assert.assertEquals((String)"taskStatus", (Object)"SUCCESS", (Object)variables.get("createClusterServiceTask_taskStatus"));
        Assert.assertNull((String)"emrClusterId", (Object)variables.get("createClusterServiceTask_emrClusterId"));
        Assert.assertNull((String)"emrClusterStatus", (Object)variables.get("createClusterServiceTask_emrClusterStatus"));
        Assert.assertNotNull((String)"emrClusterCreated", (Object)variables.get("createClusterServiceTask_emrClusterCreated"));
        Assert.assertNotNull((String)"emrClusterDefinition", (Object)variables.get("createClusterServiceTask_emrClusterDefinition"));
        this.terminateCluster("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName);
    }

    @Test
    public void testCreateClusterDryRunFalse() throws Exception {
        String clusterName = "testCluster" + Math.random();
        Map<String, Object> variables = this.createJob(clusterName, "false", null, null);
        Assert.assertEquals((String)"taskStatus", (Object)"SUCCESS", (Object)variables.get("createClusterServiceTask_taskStatus"));
        Assert.assertNotNull((String)"emrClusterId", (Object)variables.get("createClusterServiceTask_emrClusterId"));
        Assert.assertNotNull((String)"emrClusterStatus", (Object)variables.get("createClusterServiceTask_emrClusterStatus"));
        Assert.assertNotNull((String)"emrClusterCreated", (Object)variables.get("createClusterServiceTask_emrClusterCreated"));
        Assert.assertNotNull((String)"emrClusterDefinition", (Object)variables.get("createClusterServiceTask_emrClusterDefinition"));
        this.terminateCluster("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName);
    }

    @Test
    public void testCreateClusterOverrideJson() throws Exception {
        String clusterName = "testCluster" + Math.random();
        String override = this.jsonHelper.objectToJson((Object)new EmrClusterDefinition());
        Map<String, Object> variables = this.createJob(clusterName, "false", "json", override);
        Assert.assertEquals((String)"taskStatus", (Object)"SUCCESS", (Object)variables.get("createClusterServiceTask_taskStatus"));
        Assert.assertNotNull((String)"emrClusterId", (Object)variables.get("createClusterServiceTask_emrClusterId"));
        Assert.assertNotNull((String)"emrClusterStatus", (Object)variables.get("createClusterServiceTask_emrClusterStatus"));
        Assert.assertNotNull((String)"emrClusterCreated", (Object)variables.get("createClusterServiceTask_emrClusterCreated"));
        Assert.assertNotNull((String)"emrClusterDefinition", (Object)variables.get("createClusterServiceTask_emrClusterDefinition"));
        this.terminateCluster("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName);
    }

    @Test
    public void testCreateClusterOverrideXml() throws Exception {
        String clusterName = "testCluster" + Math.random();
        String override = this.xmlHelper.objectToXml((Object)new EmrClusterDefinition());
        Map<String, Object> variables = this.createJob(clusterName, "false", "xml", override);
        Assert.assertEquals((String)"taskStatus", (Object)"SUCCESS", (Object)variables.get("createClusterServiceTask_taskStatus"));
        Assert.assertNotNull((String)"emrClusterId", (Object)variables.get("createClusterServiceTask_emrClusterId"));
        Assert.assertNotNull((String)"emrClusterStatus", (Object)variables.get("createClusterServiceTask_emrClusterStatus"));
        Assert.assertNotNull((String)"emrClusterCreated", (Object)variables.get("createClusterServiceTask_emrClusterCreated"));
        Assert.assertNotNull((String)"emrClusterDefinition", (Object)variables.get("createClusterServiceTask_emrClusterDefinition"));
        this.terminateCluster("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName);
    }

    @Test
    public void testCreateClusterContentTypeNullOverrideNotNull() throws Exception {
        String clusterName = "testCluster" + Math.random();
        String override = this.jsonHelper.objectToJson((Object)new EmrClusterDefinition());
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.createJob(clusterName, "false", null, override);
            Assert.assertEquals((String)"taskStatus", (Object)"ERROR", (Object)variables.get("createClusterServiceTask_taskStatus"));
        });
    }

    @Test
    public void testCreateClusterContentTypeNotNullOverrideNull() throws Exception {
        String clusterName = "testCluster" + Math.random();
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.createJob(clusterName, "false", "xml", null);
            Assert.assertEquals((String)"taskStatus", (Object)"ERROR", (Object)variables.get("createClusterServiceTask_taskStatus"));
        });
    }

    @Test
    public void testCreateClusterContentTypeInvalid() throws Exception {
        String clusterName = "testCluster" + Math.random();
        String override = this.jsonHelper.objectToJson((Object)new EmrClusterDefinition());
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.createJob(clusterName, "false", "invalid", override);
            Assert.assertEquals((String)"taskStatus", (Object)"ERROR", (Object)variables.get("createClusterServiceTask_taskStatus"));
        });
    }

    @Test
    public void testDelegateCallExceptionNotThrown() throws Exception {
        ArrayList parameters = new ArrayList();
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowCreateEmrCluster.bpmn20.xml", parameters));
    }
}

