/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.finra.herd.dao.JobDefinitionDao;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.model.api.xml.JobDefinitionCreateRequest;
import org.finra.herd.model.jpa.JobDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.JobDefinitionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(value="herdTransactionManager")
public class ExecuteJdbcTestHelper {
    @Autowired
    private JobDefinitionDao jobDefinitionDao;
    @Autowired
    private JobDefinitionService jobDefinitionService;
    @Autowired
    private NamespaceDao namespaceDao;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    protected ResourceLoader resourceLoader;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void cleanUpHerdDatabaseAfterExecuteJdbcWithReceiveTaskTest(String jobDefinitionNamespace, String jobDefinitionName) {
        NamespaceEntity namespaceEntity;
        JobDefinitionEntity jobDefinitionEntity = this.jobDefinitionDao.getJobDefinitionByAltKey(jobDefinitionNamespace, jobDefinitionName);
        if (jobDefinitionEntity != null) {
            this.jobDefinitionDao.delete((Object)jobDefinitionEntity);
        }
        if ((namespaceEntity = this.namespaceDao.getNamespaceByCd(jobDefinitionNamespace)) != null) {
            this.namespaceDao.delete((Object)namespaceEntity);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void prepareHerdDatabaseForExecuteJdbcWithReceiveTaskTest(String jobDefinitionNamespace, String jobDefinitionName, String activitiXmlClasspathResourceName) throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(jobDefinitionNamespace);
        JobDefinitionCreateRequest jobDefinitionCreateRequest = new JobDefinitionCreateRequest();
        jobDefinitionCreateRequest.setNamespace(jobDefinitionNamespace);
        jobDefinitionCreateRequest.setJobName(jobDefinitionName);
        jobDefinitionCreateRequest.setDescription("This is a test job definition.");
        jobDefinitionCreateRequest.setActivitiJobXml(IOUtils.toString((InputStream)this.resourceLoader.getResource(activitiXmlClasspathResourceName).getInputStream()));
        jobDefinitionCreateRequest.setParameters(null);
        this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
    }
}

