/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlOutputFormatEnum;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GenerateBusinessObjectFormatDdl;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.finra.herd.service.activiti.task.LogVariables;
import org.junit.Test;

public class GenerateBusinessObjectFormatDdlTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testGenerateBusinessObjectFormatDdl() throws Exception {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>(this.getMandatoryFields());
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("customDdlName", "${customDdlName}"));
        fieldExtensionList.add(this.buildFieldExtension("includeDropTableStatement", "${includeDropTableStatement}"));
        fieldExtensionList.add(this.buildFieldExtension("includeIfNotExistsOption", "${includeIfNotExistsOption}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getMandatoryParameters());
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("customDdlName", CUSTOM_DDL_NAME));
        parameters.add(this.buildParameter("includeDropTableStatement", "false"));
        parameters.add(this.buildParameter("includeIfNotExistsOption", "false"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("businessObjectFormatDdl", "NOT_NULL");
        this.executeWithoutLogging(LogVariables.class, () -> this.testActivitiServiceTaskSuccess(GenerateBusinessObjectFormatDdl.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlMissingOptional() throws Exception {
        this.businessObjectFormatServiceTestHelper.createDatabaseEntitiesForBusinessObjectFormatDdlTesting();
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("businessObjectFormatDdl", "NOT_NULL");
        this.executeWithoutLogging(LogVariables.class, () -> this.testActivitiServiceTaskSuccess(GenerateBusinessObjectFormatDdl.class.getCanonicalName(), this.getMandatoryFields(), this.getMandatoryParameters(), variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWithInvalidFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "invalid_integer"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdl.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWithInvalidIncludeDropTableStatement() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>(this.getMandatoryFields());
        fieldExtensionList.add(this.buildFieldExtension("includeDropTableStatement", "${includeDropTableStatement}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getMandatoryParameters());
        parameters.add(this.buildParameter("includeDropTableStatement", "NOT_A_BOOLEAN"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"includeDropTableStatement\" must be a valid boolean value of \"true\" or \"false\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdl.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWithInvalidIncludeIfNotExistsOption() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>(this.getMandatoryFields());
        fieldExtensionList.add(this.buildFieldExtension("includeIfNotExistsOption", "${includeIfNotExistsOption}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getMandatoryParameters());
        parameters.add(this.buildParameter("includeIfNotExistsOption", "NOT_A_BOOLEAN"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"includeIfNotExistsOption\" must be a valid boolean value of \"true\" or \"false\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdl.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGenerateBusinessObjectFormatDdlWithInvalidOutputFormat() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("outputFormat", "${outputFormat}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("outputFormat", "INVALID_OUTPUT_FORMAT"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "No enum constant org.finra.herd.model.api.xml.BusinessObjectDataDdlOutputFormatEnum.INVALID_OUTPUT_FORMAT");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GenerateBusinessObjectFormatDdl.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    private List<FieldExtension> getMandatoryFields() {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("outputFormat", "${outputFormat}"));
        fieldExtensionList.add(this.buildFieldExtension("tableName", "${tableName}"));
        return fieldExtensionList;
    }

    private List<Parameter> getMandatoryParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", "TXT"));
        parameters.add(this.buildParameter("outputFormat", BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL.value()));
        parameters.add(this.buildParameter("tableName", TABLE_NAME));
        return parameters;
    }
}

