/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GetS3KeyPrefix;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class GetS3KeyPrefixTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testGetS3KeyPrefix() throws Exception {
        List columns = this.schemaColumnDaoTestHelper.getTestSchemaColumns("Test_COLUMN", SCHEMA_COLUMNS);
        List partitionColumns = columns.subList(0, 5);
        List subPartitionColumns = partitionColumns.subList(1, 5);
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, LATEST_VERSION_FLAG_SET, partitionKey, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", columns, partitionColumns);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionKey", "${partitionKey}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("createNewVersion", "${createNewVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionKey", partitionKey));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", this.herdStringHelper.buildStringWithDefaultDelimiter(SUBPARTITION_VALUES)));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("storageName", STORAGE_NAME));
        parameters.add(this.buildParameter("createNewVersion", "false"));
        String expectedS3KeyPrefix = GetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, partitionKey, PARTITION_VALUE, subPartitionColumns.toArray(new SchemaColumn[subPartitionColumns.size()]), SUBPARTITION_VALUES.toArray(new String[SUBPARTITION_VALUES.size()]), DATA_VERSION);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("s3KeyPrefix", expectedS3KeyPrefix);
        this.testActivitiServiceTaskSuccess(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetS3KeyPrefixMissingBusinessObjectDefinitionName() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("createNewVersion", "${createNewVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("createNewVersion", "false"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "A business object definition name must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGetS3KeyPrefixMissingBusinessObjectFormatVersion() throws Exception {
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetS3KeyPrefix.class.getCanonicalName(), new ArrayList<FieldExtension>(), new ArrayList<Parameter>(), variableValuesToValidate));
    }

    @Test
    public void testGetS3KeyPrefixMissingOptionalParameters() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        String expectedS3KeyPrefix = GetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, INITIAL_DATA_VERSION);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("s3KeyPrefix", expectedS3KeyPrefix);
        this.testActivitiServiceTaskSuccess(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetS3KeyPrefixMissingOptionalParametersSubPartitionValuesAsEmptyString() throws Exception {
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, FORMAT_DOCUMENT_SCHEMA, Boolean.valueOf(true), PARTITION_KEY);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", ""));
        String expectedS3KeyPrefix = GetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, INITIAL_DATA_VERSION);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("s3KeyPrefix", expectedS3KeyPrefix);
        this.testActivitiServiceTaskSuccess(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetS3KeyPrefixInvalidBusinessObjectFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGetS3KeyPrefixInvalidBusinessObjectDataVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectDataVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGetS3KeyPrefixInvalidCreateNewVersionFlag() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("createNewVersion", "${createNewVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("createNewVersion", "NOT_A_BOOLEAN"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"createNewVersion\" must be a valid boolean value of \"true\" or \"false\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, null));
    }

    @Test
    public void testGetS3KeyPrefixInitialDataVersionExists() throws Exception {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionKey", "${partitionKey}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("createNewVersion", "${createNewVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionKey", PARTITION_KEY));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("createNewVersion", "true"));
        String expectedS3KeyPrefix = GetS3KeyPrefixTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, SECOND_DATA_VERSION);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("s3KeyPrefix", expectedS3KeyPrefix);
        this.testActivitiServiceTaskSuccess(GetS3KeyPrefix.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }
}

