/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.Execution;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HerdActivitiServiceTaskTest
extends AbstractServiceTest {
    private static Logger LOGGER = LoggerFactory.getLogger(HerdActivitiServiceTaskTest.class);
    private final String serviceTaskId = "testServiceTask";
    public final String VARIABLE_VALUE_NOT_NULL = "NOT_NULL";
    public final String VARIABLE_VALUE_IS_NULL = "IS_NULL";

    protected FieldExtension buildFieldExtension(String name, String expression) {
        FieldExtension exceptionField = new FieldExtension();
        exceptionField.setFieldName(name);
        exceptionField.setExpression(expression);
        return exceptionField;
    }

    protected Parameter buildParameter(String name, String value) {
        return new Parameter(name, value);
    }

    protected String buildActivitiXml(String implementation, List<FieldExtension> fieldExtensionList) throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("classpath:org/finra/herd/service/testActivitiWorkflowServiceTask.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("testServiceTask");
        serviceTask.setImplementation(implementation);
        serviceTask.getFieldExtensions().addAll(fieldExtensionList);
        return this.getActivitiXmlFromBpmnModel(bpmnModel);
    }

    protected Job testActivitiServiceTaskSuccess(String implementation, List<FieldExtension> fieldExtensionList, List<Parameter> parameters, Map<String, Object> variableValuesToValidate) throws Exception {
        String activitiXml = this.buildActivitiXml(implementation, fieldExtensionList);
        return this.createJobAndCheckTaskStatusSuccess(activitiXml, parameters, variableValuesToValidate);
    }

    private Job createJobAndCheckTaskStatusSuccess(String activitiXml, List<Parameter> parameters, Map<String, Object> variableValuesToValidate) throws Exception {
        Job job = this.jobServiceTestHelper.createJobFromActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        if (variableValuesToValidate != null) {
            for (Map.Entry<String, Object> varEntry : variableValuesToValidate.entrySet()) {
                Object wfVariableValue = variables.get(this.getServiceTaskVariableName(varEntry.getKey()));
                Object expectedVariableValue = varEntry.getValue();
                if (expectedVariableValue.equals("NOT_NULL")) {
                    Assert.assertNotNull(wfVariableValue);
                    continue;
                }
                if (expectedVariableValue.equals("IS_NULL")) {
                    Assert.assertNull(wfVariableValue);
                    continue;
                }
                Assert.assertEquals((Object)expectedVariableValue, wfVariableValue);
            }
        }
        return job;
    }

    protected Job testActivitiServiceTaskFailure(String implementation, List<FieldExtension> fieldExtensionList, List<Parameter> parameters, Map<String, Object> variableValuesToValidate) throws Exception {
        String activitiXml = this.buildActivitiXml(implementation, fieldExtensionList);
        return this.createJobAndCheckTaskStatusFailure(activitiXml, parameters, variableValuesToValidate);
    }

    private Job createJobAndCheckTaskStatusFailure(String activitiXml, List<Parameter> parameters, Map<String, Object> variableValuesToValidate) throws Exception {
        Job job = this.jobServiceTestHelper.createJobFromActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        if (variableValuesToValidate != null) {
            for (Map.Entry<String, Object> varEntry : variableValuesToValidate.entrySet()) {
                Object wfVariableValue = variables.get(this.getServiceTaskVariableName(varEntry.getKey()));
                Object expectedVariableValue = varEntry.getValue();
                if (expectedVariableValue.equals("NOT_NULL")) {
                    Assert.assertNotNull(wfVariableValue);
                    continue;
                }
                if (expectedVariableValue.equals("IS_NULL")) {
                    Assert.assertNull(wfVariableValue);
                    continue;
                }
                Assert.assertEquals((Object)expectedVariableValue, wfVariableValue);
            }
        }
        return job;
    }

    protected String getServiceTaskVariableName(String variableName) {
        return "testServiceTask_" + variableName;
    }

    protected void waitUntilAllProcessCompleted() {
        long startTime = System.currentTimeMillis();
        while (this.activitiRuntimeService.createProcessInstanceQuery().active().count() > 0L) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - startTime;
            if (elapsedTime <= 15000L) continue;
            StringBuilder builder = new StringBuilder("dumping workflow variables due to error:\n");
            List executions = this.activitiRuntimeService.createExecutionQuery().list();
            for (Execution execution : executions) {
                Map executionVariables = this.activitiRuntimeService.getVariables(execution.getId());
                builder.append(execution).append('\n');
                for (Map.Entry variable : executionVariables.entrySet()) {
                    builder.append(variable).append('\n');
                }
            }
            LOGGER.error(builder.toString());
            Assert.fail((String)"The test did not finished in the specified timeout (15s). See error logs for variable dump.");
        }
    }
}

