/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataCreateRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.finra.herd.service.activiti.task.RegisterBusinessObjectData;
import org.junit.Test;

public class RegisterBusinessObjectDataTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testRegisterBusinessObjectDataXml() throws Exception {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataCreateRequest", "${businessObjectDataCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataCreateRequest", this.xmlHelper.objectToXml((Object)businessObjectDataCreateRequest)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("id", "NOT_NULL");
        variableValuesToValidate.put("jsonResponse", "NOT_NULL");
        this.testActivitiServiceTaskSuccess(RegisterBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testRegisterBusinessObjectDataJson() throws Exception {
        BusinessObjectDataCreateRequest businessObjectDataCreateRequest = this.businessObjectDataServiceTestHelper.getNewBusinessObjectDataCreateRequest();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataCreateRequest", "${businessObjectDataCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataCreateRequest", this.jsonHelper.objectToJson((Object)businessObjectDataCreateRequest)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("id", "NOT_NULL");
        variableValuesToValidate.put("jsonResponse", "NOT_NULL");
        this.testActivitiServiceTaskSuccess(RegisterBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testRegisterBusinessObjectDataWrongContentType() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataCreateRequest", "${businessObjectDataCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "wrong_content_type"));
        parameters.add(this.buildParameter("businessObjectDataCreateRequest", "some_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"ContentType\" must be a valid value of either \"xml\" or \"json\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(RegisterBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testRegisterBusinessObjectDataNoRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataCreateRequest", "${businessObjectDataCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataCreateRequest", ""));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataCreateRequest\" must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(RegisterBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testRegisterBusinessObjectDataWrongXmlRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataCreateRequest", "${businessObjectDataCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataCreateRequest", "wrong_xml_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataCreateRequest\" must be valid xml string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(RegisterBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testRegisterBusinessObjectDataWrongJsonRequest() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataCreateRequest", "${businessObjectDataCreateRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataCreateRequest", "wrong_json_request"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"BusinessObjectDataCreateRequest\" must be valid json string.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(RegisterBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

