/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.advice;

import com.amazonaws.AmazonServiceException;
import java.lang.reflect.Method;
import java.util.Collections;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.model.annotation.PublishNotificationMessages;
import org.finra.herd.model.dto.MessageHeader;
import org.finra.herd.model.dto.NotificationMessage;
import org.finra.herd.model.jpa.MessageTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.advice.PublishNotificationMessagesAdvice;
import org.finra.herd.service.helper.NotificationMessageInMemoryQueue;
import org.finra.herd.service.impl.NotificationMessagePublishingServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class PublishNotificationMessagesAdviceTest
extends AbstractServiceTest {
    @Mock
    private NotificationMessageInMemoryQueue notificationMessageInMemoryQueue;
    @Mock
    private NotificationMessagePublishingServiceImpl notificationMessagePublishingService;
    @InjectMocks
    private PublishNotificationMessagesAdvice publishNotificationMessagesAdvice;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testPublishNotificationMessages() throws Throwable {
        NotificationMessage notificationMessage = new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE)));
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint("testPublishNotificationMessages");
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).clear();
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
        Mockito.when((Object)this.notificationMessageInMemoryQueue.isEmpty()).thenCallRealMethod();
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).remove();
        this.notificationMessageInMemoryQueue.clear();
        this.notificationMessageInMemoryQueue.add(notificationMessage);
        Assert.assertFalse((boolean)this.notificationMessageInMemoryQueue.isEmpty());
        this.publishNotificationMessagesAdvice.publishNotificationMessages(joinPoint);
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)2))).clear();
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)3))).isEmpty();
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).remove();
        ((NotificationMessagePublishingServiceImpl)Mockito.verify((Object)this.notificationMessagePublishingService)).publishNotificationMessage(notificationMessage);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertTrue((boolean)this.notificationMessageInMemoryQueue.isEmpty());
    }

    @Test
    public void testPublishNotificationMessagesAmazonServiceException() throws Throwable {
        NotificationMessage notificationMessage = new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE)));
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint("testPublishNotificationMessages");
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).clear();
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
        Mockito.when((Object)this.notificationMessageInMemoryQueue.isEmpty()).thenCallRealMethod();
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).remove();
        ((NotificationMessagePublishingServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AmazonServiceException(ERROR_MESSAGE)}).when((Object)this.notificationMessagePublishingService)).publishNotificationMessage(notificationMessage);
        this.notificationMessageInMemoryQueue.clear();
        this.notificationMessageInMemoryQueue.add(notificationMessage);
        Assert.assertFalse((boolean)this.notificationMessageInMemoryQueue.isEmpty());
        this.publishNotificationMessagesAdvice.publishNotificationMessages(joinPoint);
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)2))).clear();
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)3))).isEmpty();
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).remove();
        ((NotificationMessagePublishingServiceImpl)Mockito.verify((Object)this.notificationMessagePublishingService)).publishNotificationMessage(notificationMessage);
        ((NotificationMessagePublishingServiceImpl)Mockito.verify((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(notificationMessage);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertTrue((boolean)this.notificationMessageInMemoryQueue.isEmpty());
    }

    @Test
    public void testPublishNotificationMessagesDatabaseException() throws Throwable {
        NotificationMessage notificationMessage = new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE)));
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint("testPublishNotificationMessages");
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).clear();
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
        Mockito.when((Object)this.notificationMessageInMemoryQueue.isEmpty()).thenCallRealMethod();
        ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).remove();
        ((NotificationMessagePublishingServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AmazonServiceException(ERROR_MESSAGE)}).when((Object)this.notificationMessagePublishingService)).publishNotificationMessage(notificationMessage);
        ((NotificationMessagePublishingServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(ERROR_MESSAGE)}).when((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(notificationMessage);
        this.notificationMessageInMemoryQueue.clear();
        this.notificationMessageInMemoryQueue.add(notificationMessage);
        Assert.assertFalse((boolean)this.notificationMessageInMemoryQueue.isEmpty());
        this.publishNotificationMessagesAdvice.publishNotificationMessages(joinPoint);
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)2))).clear();
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)3))).isEmpty();
        ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).remove();
        ((NotificationMessagePublishingServiceImpl)Mockito.verify((Object)this.notificationMessagePublishingService)).publishNotificationMessage(notificationMessage);
        ((NotificationMessagePublishingServiceImpl)Mockito.verify((Object)this.notificationMessagePublishingService)).addNotificationMessageToDatabaseQueue(notificationMessage);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertTrue((boolean)this.notificationMessageInMemoryQueue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishNotificationMessagesDebugEnabled() throws Throwable {
        LogLevel originalLogLevel = this.getLogLevel(PublishNotificationMessagesAdvice.class);
        try {
            this.setLogLevel(PublishNotificationMessagesAdvice.class, LogLevel.DEBUG);
            NotificationMessage notificationMessage = new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE)));
            ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint("testPublishNotificationMessages");
            ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).clear();
            ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
            Mockito.when((Object)this.notificationMessageInMemoryQueue.size()).thenCallRealMethod();
            Mockito.when((Object)this.notificationMessageInMemoryQueue.isEmpty()).thenCallRealMethod();
            ((NotificationMessageInMemoryQueue)Mockito.doCallRealMethod().when((Object)this.notificationMessageInMemoryQueue)).remove();
            this.notificationMessageInMemoryQueue.clear();
            this.notificationMessageInMemoryQueue.add(notificationMessage);
            Assert.assertFalse((boolean)this.notificationMessageInMemoryQueue.isEmpty());
            this.publishNotificationMessagesAdvice.publishNotificationMessages(joinPoint);
            ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)2))).clear();
            ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).add(notificationMessage);
            ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).size();
            ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue, (VerificationMode)Mockito.times((int)3))).isEmpty();
            ((NotificationMessageInMemoryQueue)Mockito.verify((Object)this.notificationMessageInMemoryQueue)).remove();
            ((NotificationMessagePublishingServiceImpl)Mockito.verify((Object)this.notificationMessagePublishingService)).publishNotificationMessage(notificationMessage);
            this.verifyNoMoreInteractionsHelper();
            Assert.assertTrue((boolean)this.notificationMessageInMemoryQueue.isEmpty());
        }
        finally {
            this.setLogLevel(PublishNotificationMessagesAdvice.class, originalLogLevel);
        }
    }

    private ProceedingJoinPoint getMockedProceedingJoinPoint(String methodName) throws Exception {
        ProceedingJoinPoint joinPoint = (ProceedingJoinPoint)Mockito.mock(ProceedingJoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = PublishNotificationMessagesAdviceTest.class.getDeclaredMethod("mockMethod", new Class[0]);
        Mockito.when((Object)joinPoint.getTarget()).thenReturn((Object)new PublishNotificationMessagesAdviceTest());
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)methodSignature.getName()).thenReturn((Object)methodName);
        return joinPoint;
    }

    @PublishNotificationMessages
    private void mockMethod() {
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.notificationMessageInMemoryQueue, this.notificationMessagePublishingService});
    }
}

