/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AttributeValueListDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.AttributeValueListKey;
import org.finra.herd.model.jpa.AttributeValueListEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AttributeValueListDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AttributeValueListDaoHelperTest
extends AbstractServiceTest {
    @Mock
    private AttributeValueListDao attributeValueListDao;
    @InjectMocks
    private AttributeValueListDaoHelper attributeValueListDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetAttributeValueListEntity() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AttributeValueListEntity attributeValueListEntity = new AttributeValueListEntity();
        Mockito.when((Object)this.attributeValueListDao.getAttributeValueListByKey(attributeValueListKey)).thenReturn((Object)attributeValueListEntity);
        AttributeValueListEntity result = this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey);
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).getAttributeValueListByKey(attributeValueListKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attributeValueListDao});
        Assert.assertEquals((Object)attributeValueListEntity, (Object)result);
    }

    @Test
    public void testGetAttributeValueListEntityAttributeValueListEntityNoExists() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.when((Object)this.attributeValueListDao.getAttributeValueListByKey(attributeValueListKey)).thenReturn(null);
        try {
            this.attributeValueListDaoHelper.getAttributeValueListEntity(attributeValueListKey);
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute value list with name \"%s\" doesn't exist for namespace \"%s\".", ATTRIBUTE_VALUE_LIST_NAME, ATTRIBUTE_VALUE_LIST_NAMESPACE), (Object)e.getMessage());
        }
        ((AttributeValueListDao)Mockito.verify((Object)this.attributeValueListDao)).getAttributeValueListByKey(attributeValueListKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attributeValueListDao});
    }
}

