/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.api.xml.AttributeValueListCreateRequest;
import org.finra.herd.model.api.xml.AttributeValueListKey;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.AttributeValueListHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AttributeValueListHelperTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @InjectMocks
    private AttributeValueListHelper attributeValueListHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void createValidateAttributeValueListCreateRequest() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        AttributeValueListCreateRequest request = new AttributeValueListCreateRequest(attributeValueListKey);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", ATTRIBUTE_VALUE_LIST_NAMESPACE)).thenReturn((Object)ATTRIBUTE_VALUE_LIST_NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "attribute value list name", ATTRIBUTE_VALUE_LIST_NAME)).thenReturn((Object)ATTRIBUTE_VALUE_LIST_NAME);
        this.attributeValueListHelper.validateAttributeValueListCreateRequest(request);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", ATTRIBUTE_VALUE_LIST_NAMESPACE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "attribute value list name", ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
        Assert.assertEquals((Object)new AttributeValueListCreateRequest(attributeValueListKey), (Object)request);
    }

    @Test
    public void createValidateAttributeValueListCreateRequestMissingRequiredParameters() {
        try {
            this.attributeValueListHelper.validateAttributeValueListCreateRequest(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute value list create request must be specified.", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void createValidateAttributeValueListKey() {
        AttributeValueListKey attributeValueListKey = new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", ATTRIBUTE_VALUE_LIST_NAMESPACE)).thenReturn((Object)ATTRIBUTE_VALUE_LIST_NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "attribute value list name", ATTRIBUTE_VALUE_LIST_NAME)).thenReturn((Object)ATTRIBUTE_VALUE_LIST_NAME);
        this.attributeValueListHelper.validateAttributeValueListKey(attributeValueListKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", ATTRIBUTE_VALUE_LIST_NAMESPACE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "attribute value list name", ATTRIBUTE_VALUE_LIST_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
        Assert.assertEquals((Object)new AttributeValueListKey(ATTRIBUTE_VALUE_LIST_NAMESPACE, ATTRIBUTE_VALUE_LIST_NAME), (Object)attributeValueListKey);
    }

    @Test
    public void createValidateAttributeValueListKeyMissingRequiredParameters() {
        try {
            this.attributeValueListHelper.validateAttributeValueListKey(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An attribute value list key must be specified.", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }
}

