/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.RegistrationDateRangeFilter;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataHelperTest
extends AbstractServiceTest {
    @After
    public void cleanupEnv() {
        try {
            this.restorePropertySourceInEnvironment();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void getStorageUnitByStorageName() {
        BusinessObjectData businessObjectData = new BusinessObjectData();
        List<String> testStorageNames = Arrays.asList("Storage_1", "storage-2", "STORAGE3");
        ArrayList<StorageUnit> storageUnits = new ArrayList<StorageUnit>();
        businessObjectData.setStorageUnits(storageUnits);
        for (String testStorageName : testStorageNames) {
            StorageUnit storageUnit = new StorageUnit();
            storageUnits.add(storageUnit);
            Storage storage = new Storage();
            storageUnit.setStorage(storage);
            storage.setName(testStorageName);
        }
        for (String testStorageName : testStorageNames) {
            Assert.assertEquals((Object)testStorageName, (Object)this.businessObjectDataHelper.getStorageUnitByStorageName(businessObjectData, testStorageName).getStorage().getName());
            Assert.assertEquals((Object)testStorageName, (Object)this.businessObjectDataHelper.getStorageUnitByStorageName(businessObjectData, testStorageName.toUpperCase()).getStorage().getName());
            Assert.assertEquals((Object)testStorageName, (Object)this.businessObjectDataHelper.getStorageUnitByStorageName(businessObjectData, testStorageName.toLowerCase()).getStorage().getName());
        }
    }

    @Test
    public void getStorageUnitByStorageNameStorageUnitNoExists() {
        String testStorageName = "I_DO_NOT_EXIST";
        try {
            this.businessObjectDataHelper.getStorageUnitByStorageName(new BusinessObjectData(INTEGER_VALUE.intValue(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue(), PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION.intValue(), LATEST_VERSION_FLAG_SET, "VALID", NO_STORAGE_UNITS, NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_BUSINESS_OBJECT_DATA_CHILDREN, NO_BUSINESS_OBJECT_DATA_STATUS_HISTORY, NO_RETENTION_EXPIRATION_DATE), testStorageName);
            Assert.fail((String)"Should throw a IllegalStateException when storage unit does not exist.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Business object data has no storage unit with storage name \"%s\".", testStorageName), (Object)e.getMessage());
        }
    }

    @Test
    public void testBusinessObjectDataKeyToString() {
        BusinessObjectDataKey testBusinessObjectDataKey = new BusinessObjectDataKey();
        testBusinessObjectDataKey.setNamespace(NAMESPACE);
        testBusinessObjectDataKey.setBusinessObjectDefinitionName(BDEF_NAME);
        testBusinessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        testBusinessObjectDataKey.setBusinessObjectFormatFileType(FORMAT_FILE_TYPE_CODE);
        testBusinessObjectDataKey.setBusinessObjectFormatVersion(FORMAT_VERSION);
        testBusinessObjectDataKey.setPartitionValue(PARTITION_VALUE);
        testBusinessObjectDataKey.setSubPartitionValues(SUBPARTITION_VALUES);
        testBusinessObjectDataKey.setBusinessObjectDataVersion(DATA_VERSION);
        String expectedOutput = String.format("namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s\", businessObjectDataVersion: %d", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, StringUtils.join((Iterable)SUBPARTITION_VALUES, (String)","), DATA_VERSION);
        Assert.assertEquals((Object)expectedOutput, (Object)this.businessObjectDataHelper.businessObjectDataKeyToString(testBusinessObjectDataKey));
        Assert.assertEquals((Object)expectedOutput, (Object)this.businessObjectDataHelper.businessObjectDataKeyToString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue(), PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION.intValue()));
    }

    @Test
    public void testBusinessObjectDataKeyToStringWithNull() {
        Assert.assertNull((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(null));
    }

    @Test
    public void testGetPartitionValue() {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        Assert.assertEquals(null, (Object)this.businessObjectDataHelper.getPartitionValue(businessObjectDataEntity, 0));
        Assert.assertEquals((Object)PARTITION_VALUE, (Object)this.businessObjectDataHelper.getPartitionValue(businessObjectDataEntity, 1));
        for (int partitionColumnPosition = 2; partitionColumnPosition <= 5; ++partitionColumnPosition) {
            Assert.assertEquals(SUBPARTITION_VALUES.get(partitionColumnPosition - 2), (Object)this.businessObjectDataHelper.getPartitionValue(businessObjectDataEntity, partitionColumnPosition));
        }
        Assert.assertEquals(null, (Object)this.businessObjectDataHelper.getPartitionValue(businessObjectDataEntity, 6));
    }

    @Test
    public void testSubPartitions() {
        String namespace = NAMESPACE;
        String businessObjectDefinitionName = BDEF_NAME;
        String businessObjectFormatUsage = FORMAT_USAGE_CODE;
        String fileType = FORMAT_FILE_TYPE_CODE;
        Integer businessObjectFormatVersion = FORMAT_VERSION;
        String businessObjectFormatPartitionKey = PARTITION_KEY;
        List schemaColumns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionValue = PARTITION_VALUE;
        List subPartitionValues = SUBPARTITION_VALUES;
        Integer businessObjectDataVersion = DATA_VERSION;
        String actualS3KeyPrefix = this.buildS3KeyPrefix(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileType, businessObjectFormatVersion, businessObjectFormatPartitionKey, schemaColumns, partitionColumns, partitionValue, subPartitionValues, businessObjectDataVersion);
        String expectedS3KeyPrefix = this.getExpectedS3KeyPrefix(namespace, DATA_PROVIDER_NAME, businessObjectDefinitionName, businessObjectFormatUsage, fileType, businessObjectFormatVersion, businessObjectFormatPartitionKey, partitionColumns, partitionValue, subPartitionValues, businessObjectDataVersion);
        Assert.assertEquals((Object)expectedS3KeyPrefix, (Object)actualS3KeyPrefix);
    }

    @Test
    public void testValidateRegistrationDateRangeFilter() throws DatatypeConfigurationException {
        XMLGregorianCalendar start = DatatypeFactory.newInstance().newXMLGregorianCalendar("2018-04-01");
        XMLGregorianCalendar end = DatatypeFactory.newInstance().newXMLGregorianCalendar("2018-04-02");
        this.businessObjectDataHelper.validateRegistrationDateRangeFilter(new RegistrationDateRangeFilter(start, end));
        this.businessObjectDataHelper.validateRegistrationDateRangeFilter(new RegistrationDateRangeFilter(start, start));
    }

    @Test
    public void testValidateRegistrationDateRangeFilterMissingStartAndEndDate() {
        try {
            this.businessObjectDataHelper.validateRegistrationDateRangeFilter(new RegistrationDateRangeFilter());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Either start registration date or end registration date must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateRegistrationDateRangeFilterStartDateIsGreaterThenEndDate() throws DatatypeConfigurationException {
        XMLGregorianCalendar end = DatatypeFactory.newInstance().newXMLGregorianCalendar("2018-04-01");
        XMLGregorianCalendar start = DatatypeFactory.newInstance().newXMLGregorianCalendar("2018-04-02");
        try {
            this.businessObjectDataHelper.validateRegistrationDateRangeFilter(new RegistrationDateRangeFilter(start, end));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The start registration date\u00a0\"%s\"\u00a0cannot be greater than the end registration date\u00a0\"%s\".", start, end), (Object)e.getMessage());
        }
    }

    private String buildS3KeyPrefix(String namespace, String businessObjectDefinitionName, String businessObjectFormatUsage, String fileType, Integer businessObjectFormatVersion, String businessObjectFormatPartitionKey, List<SchemaColumn> schemaColumns, List<SchemaColumn> partitionColumns, String partitionValue, List<String> subPartitionValues, Integer businessObjectDataVersion) {
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileType, businessObjectFormatVersion, null, null, LATEST_VERSION_FLAG_SET, businessObjectFormatPartitionKey, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, null, null, null, schemaColumns, partitionColumns);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileType, businessObjectFormatVersion, partitionValue, subPartitionValues, businessObjectDataVersion);
        return this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, businessObjectDataKey, STORAGE_NAME);
    }

    private String getExpectedS3KeyPrefix(String namespace, String dataProvider, String businessObjectDefinitionName, String businessObjectFormatUsage, String fileType, Integer businessObjectFormatVersion, String businessObjectFormatPartitionKey, List<SchemaColumn> partitionColumns, String partitionValue, List<String> subPartitionValues, Integer businessObjectDataVersion) {
        partitionColumns = partitionColumns.subList(0, Math.min(partitionColumns.size(), 5));
        SchemaColumn[] subPartitionKeys = new SchemaColumn[partitionColumns.size() - 1];
        subPartitionKeys = partitionColumns.subList(1, partitionColumns.size()).toArray(subPartitionKeys);
        String[] subPartitionValueArray = new String[subPartitionValues.size()];
        subPartitionValueArray = subPartitionValues.toArray(subPartitionValueArray);
        return BusinessObjectDataHelperTest.getExpectedS3KeyPrefix(namespace, dataProvider, businessObjectDefinitionName, businessObjectFormatUsage, fileType, businessObjectFormatVersion, businessObjectFormatPartitionKey, partitionValue, subPartitionKeys, subPartitionValueArray, businessObjectDataVersion);
    }
}

