/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.BusinessObjectDefinitionDescriptionSuggestionDao;
import org.finra.herd.dao.BusinessObjectDefinitionDescriptionSuggestionStatusDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.jpa.BusinessObjectDefinitionDescriptionSuggestionEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionDescriptionSuggestionStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.BusinessObjectDefinitionDescriptionSuggestionDaoHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDefinitionDescriptionSuggestionDaoHelperTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionDescriptionSuggestionDao businessObjectDefinitionDescriptionSuggestionDao;
    @Mock
    private BusinessObjectDefinitionDescriptionSuggestionStatusDao businessObjectDefinitionDescriptionSuggestionStatusDao;
    @InjectMocks
    private BusinessObjectDefinitionDescriptionSuggestionDaoHelper businessObjectDefinitionDescriptionSuggestionDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionEntity() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = (BusinessObjectDefinitionEntity)Mockito.mock(BusinessObjectDefinitionEntity.class);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(USER_ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, USER_ID)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntity);
        BusinessObjectDefinitionDescriptionSuggestionEntity result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, USER_ID);
        Assert.assertThat((String)"Result does not equal businessObjectDefinitionDescriptionSuggestionEntity.", (Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionEntity)));
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, USER_ID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDescriptionSuggestionDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionEntityWithException() {
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = new BusinessObjectDefinitionEntity();
        businessObjectDefinitionEntity.setName(BDEF_NAME);
        businessObjectDefinitionEntity.setNamespace(namespaceEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, USER_ID)).thenReturn(null);
        try {
            this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionEntity(businessObjectDefinitionEntity, USER_ID);
            Assert.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)objectNotFoundException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)String.format("Business object definition description suggestion with the parameters  {namespace=\"%s\", businessObjectDefinitionName=\"%s\", userId=\"%s\"} does not exist.", businessObjectDefinitionEntity.getNamespace().getCode(), businessObjectDefinitionEntity.getName(), USER_ID))));
        }
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionByBusinessObjectDefinitionAndUserId(businessObjectDefinitionEntity, USER_ID);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDescriptionSuggestionDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus() {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity.getCode(), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = this.businessObjectDefinitionDescriptionSuggestionStatusDaoTestHelper.createBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(USER_ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity2 = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity2.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity2.setDescriptionSuggestion(DESCRIPTION_SUGGESTION_2);
        businessObjectDefinitionDescriptionSuggestionEntity2.setUserId(USER_ID_2);
        businessObjectDefinitionDescriptionSuggestionEntity2.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        ArrayList businessObjectDefinitionDescriptionSuggestionEntities = Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionEntity[]{businessObjectDefinitionDescriptionSuggestionEntity, businessObjectDefinitionDescriptionSuggestionEntity2});
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao.getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionStatusEntity)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntities);
        List result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Assert.assertThat((String)"Result size does not equal businessObjectDefinitionDescriptionSuggestionEntities.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionEntities.size())));
        for (int i = 0; i < result.size(); ++i) {
            Assert.assertThat((String)"Result is not equal businessObjectDefinitionDescriptionSuggestionEntity.", result.get(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(businessObjectDefinitionDescriptionSuggestionEntities.get(i))));
        }
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao)).getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatusWithEmptyStatus() {
        int i;
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity.getCode(), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = this.businessObjectDefinitionDescriptionSuggestionStatusDaoTestHelper.createBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(USER_ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity2 = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity2.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity2.setDescriptionSuggestion(DESCRIPTION_SUGGESTION_2);
        businessObjectDefinitionDescriptionSuggestionEntity2.setUserId(USER_ID_2);
        businessObjectDefinitionDescriptionSuggestionEntity2.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        ArrayList businessObjectDefinitionDescriptionSuggestionEntities = Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionEntity[]{businessObjectDefinitionDescriptionSuggestionEntity, businessObjectDefinitionDescriptionSuggestionEntity2});
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, null)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntities);
        List result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, "");
        Assert.assertThat((String)"Result size does not equal businessObjectDefinitionDescriptionSuggestionEntities.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionEntities.size())));
        for (i = 0; i < result.size(); ++i) {
            Assert.assertThat((String)"Result is not equal businessObjectDefinitionDescriptionSuggestionEntity.", result.get(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(businessObjectDefinitionDescriptionSuggestionEntities.get(i))));
        }
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
        Mockito.reset((Object[])new BusinessObjectDefinitionDao[]{this.businessObjectDefinitionDao});
        Mockito.reset((Object[])new BusinessObjectDefinitionDescriptionSuggestionDao[]{this.businessObjectDefinitionDescriptionSuggestionDao});
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, null)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntities);
        result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, "  ");
        Assert.assertThat((String)"Result size does not equal businessObjectDefinitionDescriptionSuggestionEntities.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionEntities.size())));
        for (i = 0; i < result.size(); ++i) {
            Assert.assertThat((String)"Result is not equal businessObjectDefinitionDescriptionSuggestionEntity.", result.get(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(businessObjectDefinitionDescriptionSuggestionEntities.get(i))));
        }
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatusWithNullStatus() {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity.getCode(), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = this.businessObjectDefinitionDescriptionSuggestionStatusDaoTestHelper.createBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity.setDescriptionSuggestion(DESCRIPTION_SUGGESTION);
        businessObjectDefinitionDescriptionSuggestionEntity.setUserId(USER_ID);
        businessObjectDefinitionDescriptionSuggestionEntity.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        BusinessObjectDefinitionDescriptionSuggestionEntity businessObjectDefinitionDescriptionSuggestionEntity2 = new BusinessObjectDefinitionDescriptionSuggestionEntity();
        businessObjectDefinitionDescriptionSuggestionEntity2.setBusinessObjectDefinition(businessObjectDefinitionEntity);
        businessObjectDefinitionDescriptionSuggestionEntity2.setDescriptionSuggestion(DESCRIPTION_SUGGESTION_2);
        businessObjectDefinitionDescriptionSuggestionEntity2.setUserId(USER_ID_2);
        businessObjectDefinitionDescriptionSuggestionEntity2.setStatus(businessObjectDefinitionDescriptionSuggestionStatusEntity);
        ArrayList businessObjectDefinitionDescriptionSuggestionEntities = Lists.newArrayList((Object[])new BusinessObjectDefinitionDescriptionSuggestionEntity[]{businessObjectDefinitionDescriptionSuggestionEntity, businessObjectDefinitionDescriptionSuggestionEntity2});
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, null)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionEntities);
        List result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, null);
        Assert.assertThat((String)"Result size does not equal businessObjectDefinitionDescriptionSuggestionEntities.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionEntities.size())));
        for (int i = 0; i < result.size(); ++i) {
            Assert.assertThat((String)"Result is not equal businessObjectDefinitionDescriptionSuggestionEntity.", result.get(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(businessObjectDefinitionDescriptionSuggestionEntities.get(i))));
        }
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatusWithEmptyResultList() {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity.getCode(), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = this.businessObjectDefinitionDescriptionSuggestionStatusDaoTestHelper.createBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao.getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionDao.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionStatusEntity)).thenReturn(null);
        List result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Assert.assertThat((String)"Result size does not equal zero.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao)).getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        ((BusinessObjectDefinitionDescriptionSuggestionDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionDao)).getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionEntity, businessObjectDefinitionDescriptionSuggestionStatusEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatusWithNullBusinessObjectDefinition() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn(null);
        List result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Assert.assertThat((String)"Result size does not equal zero.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatusWithNoStatusEntityFound() {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(namespaceEntity.getCode(), BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        Mockito.when((Object)this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao.getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS)).thenReturn(null);
        List result = this.businessObjectDefinitionDescriptionSuggestionDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionsByBusinessObjectDefinitionAndStatus(businessObjectDefinitionKey, BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Assert.assertThat((String)"Result size does not equal zero.", (Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getBusinessObjectDefinitionByKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao)).getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionDescriptionSuggestionDao, this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }
}

