/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.BusinessObjectDefinitionDescriptionSuggestionStatusDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.jpa.BusinessObjectDefinitionDescriptionSuggestionStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelperTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDefinitionDescriptionSuggestionStatusDao businessObjectDefinitionDescriptionSuggestionStatusDao;
    @InjectMocks
    private BusinessObjectDefinitionDescriptionSuggestionStatusDaoHelper businessObjectDefinitionDescriptionSuggestionStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionStatusEntity() {
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity businessObjectDefinitionDescriptionSuggestionStatusEntity = new BusinessObjectDefinitionDescriptionSuggestionStatusEntity();
        businessObjectDefinitionDescriptionSuggestionStatusEntity.setCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao.getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS)).thenReturn((Object)businessObjectDefinitionDescriptionSuggestionStatusEntity);
        BusinessObjectDefinitionDescriptionSuggestionStatusEntity result = this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Assert.assertThat((String)"Result does not equal businessObjectDefinitionDescriptionSuggestionStatusEntity.", (Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)businessObjectDefinitionDescriptionSuggestionStatusEntity)));
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao)).getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionStatusEntityWithException() {
        Mockito.when((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao.getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS)).thenReturn(null);
        try {
            this.businessObjectDefinitionDescriptionSuggestionStatusDaoHelper.getBusinessObjectDefinitionDescriptionSuggestionStatusEntity(BDEF_DESCRIPTION_SUGGESTION_STATUS);
            Assert.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            Assert.assertThat((String)"Exception message is not correct.", (Object)objectNotFoundException.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)String.format("Business object definition description suggestion status with code \"%s\" doesn't exist.", BDEF_DESCRIPTION_SUGGESTION_STATUS))));
        }
        ((BusinessObjectDefinitionDescriptionSuggestionStatusDao)Mockito.verify((Object)this.businessObjectDefinitionDescriptionSuggestionStatusDao)).getBusinessObjectDefinitionDescriptionSuggestionStatusByCode(BDEF_DESCRIPTION_SUGGESTION_STATUS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDescriptionSuggestionStatusDao});
    }
}

