/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionColumnKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionTagEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class BusinessObjectDefinitionHelperTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @InjectMocks
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private JsonHelper jsonHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testBusinessObjectDefinitionKeyToString() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        String response = this.businessObjectDefinitionHelper.businessObjectDefinitionKeyToString(businessObjectDefinitionKey);
        Assert.assertEquals((Object)String.format("namespace: \"%s\", businessObjectDefinitionName: \"%s\"", BDEF_NAMESPACE, BDEF_NAME), (Object)response);
    }

    @Test
    public void testExecuteFunctionForBusinessObjectDefinitionEntities() {
        List<BusinessObjectDefinitionEntity> businessObjectDefinitionEntities = Collections.unmodifiableList(Arrays.asList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2())));
        businessObjectDefinitionEntities.forEach(entity -> {
            entity.setDescriptiveBusinessObjectFormat(new BusinessObjectFormatEntity());
            entity.getDescriptiveBusinessObjectFormat().setSchemaColumns(new ArrayList());
            entity.setSubjectMatterExperts(new ArrayList());
        });
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionHelper.executeFunctionForBusinessObjectDefinitionEntities(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE, businessObjectDefinitionEntities, (indexName, documentType, id, json) -> {});
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper, (VerificationMode)Mockito.times((int)businessObjectDefinitionEntities.size()))).objectToJson(Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
    }

    @Test
    public void testExecuteFunctionForBusinessObjectDefinitionEntitiesJsonParseException() {
        List<BusinessObjectDefinitionEntity> businessObjectDefinitionEntities = Collections.unmodifiableList(Arrays.asList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2())));
        businessObjectDefinitionEntities.forEach(entity -> {
            entity.setDescriptiveBusinessObjectFormat(new BusinessObjectFormatEntity());
            entity.getDescriptiveBusinessObjectFormat().setSchemaColumns(new ArrayList());
            entity.setSubjectMatterExperts(new ArrayList());
        });
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        this.businessObjectDefinitionHelper.executeFunctionForBusinessObjectDefinitionEntities(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE, businessObjectDefinitionEntities, (indexName, documentType, id, json) -> {});
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper, (VerificationMode)Mockito.times((int)businessObjectDefinitionEntities.size()))).objectToJson(Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
    }

    @Test
    public void testGetBusinessObjectDefinitionKey() {
        BusinessObjectDefinitionColumnKey businessObjectDefinitionColumnKey = new BusinessObjectDefinitionColumnKey(BDEF_NAMESPACE, BDEF_NAME, BDEF_COLUMN_NAME);
        BusinessObjectDefinitionKey response = this.businessObjectDefinitionHelper.getBusinessObjectDefinitionKey(businessObjectDefinitionColumnKey);
        Assert.assertEquals((Object)new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), (Object)response);
    }

    @Test
    public void testValidateBusinessObjectDefinitionKey() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", BDEF_NAMESPACE)).thenReturn((Object)BDEF_NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", BDEF_NAME)).thenReturn((Object)BDEF_NAME);
        this.businessObjectDefinitionHelper.validateBusinessObjectDefinitionKey(businessObjectDefinitionKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", BDEF_NAMESPACE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", BDEF_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
        Assert.assertEquals((Object)new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), (Object)businessObjectDefinitionKey);
    }

    @Test
    public void testValidateBusinessObjectDefinitionKeyBusinessObjectDefinitionKeyIsNull() {
        try {
            this.businessObjectDefinitionHelper.validateBusinessObjectDefinitionKey(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition key must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testProcessTagSearchScoreMultiplier() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2());
        TagEntity tagEntity1 = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME_2, TAG_SEARCH_SCORE_MULTIPLIER, TAG_DESCRIPTION, null);
        TagEntity tagEntity2 = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_SEARCH_SCORE_MULTIPLIER_NULL, TAG_DESCRIPTION, null);
        List<BusinessObjectDefinitionTagEntity> businessObjectDefinitionTagEntities = Arrays.asList(this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionEntity, tagEntity1), this.businessObjectDefinitionTagDaoTestHelper.createBusinessObjectDefinitionTagEntity(businessObjectDefinitionEntity, tagEntity2));
        businessObjectDefinitionEntity.setBusinessObjectDefinitionTags(businessObjectDefinitionTagEntities);
        this.businessObjectDefinitionHelper.processTagSearchScoreMultiplier(businessObjectDefinitionEntity);
        Assert.assertEquals((Object)businessObjectDefinitionEntity.getTagSearchScoreMultiplier(), (Object)TAG_SEARCH_SCORE_MULTIPLIER.setScale(3, RoundingMode.HALF_UP));
    }

    @Test
    public void testProcessTagSearchScoreMultiplierTagsEmpty() {
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2());
        ArrayList businessObjectDefinitionTagEntities = new ArrayList();
        businessObjectDefinitionEntity.setBusinessObjectDefinitionTags(businessObjectDefinitionTagEntities);
        this.businessObjectDefinitionHelper.processTagSearchScoreMultiplier(businessObjectDefinitionEntity);
        Assert.assertEquals((Object)businessObjectDefinitionEntity.getTagSearchScoreMultiplier(), (Object)BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP));
    }
}

