/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestion;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionDescriptionSuggestionKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.MessageHeaderDefinition;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.api.xml.NotificationMessageDefinition;
import org.finra.herd.model.api.xml.NotificationMessageDefinitions;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.MessageHeader;
import org.finra.herd.model.dto.NotificationMessage;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionDescriptionSuggestionStatusEntity;
import org.finra.herd.model.jpa.ConfigurationEntity;
import org.finra.herd.model.jpa.MessageTypeEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.DefaultNotificationMessageBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class DefaultNotificationMessageBuilderTest
extends AbstractServiceTest {
    private static final String SUFFIX_ESCAPED_JSON = "\\\"\\\"<test>";
    private static final String SUFFIX_ESCAPED_XML = "&quot;&quot;&lt;test&gt;";
    private static final String SUFFIX_UNESCAPED = "\"\"<test>";
    @Autowired
    private DefaultNotificationMessageBuilder defaultNotificationMessageBuilder;

    @Test
    public void testAddObjectPropertyToContext() {
        LinkedHashMap context = new LinkedHashMap();
        Object propertyValue = new Object();
        Object jsonEscapedPropertyValue = new Object();
        Object xmlEscapedPropertyValue = new Object();
        this.defaultNotificationMessageBuilder.addObjectPropertyToContext(context, ATTRIBUTE_NAME + SUFFIX_UNESCAPED, propertyValue, jsonEscapedPropertyValue, xmlEscapedPropertyValue);
        Assert.assertEquals((long)3L, (long)CollectionUtils.size(context));
        Assert.assertEquals((Object)propertyValue, context.get(ATTRIBUTE_NAME + SUFFIX_UNESCAPED));
        Assert.assertEquals((Object)jsonEscapedPropertyValue, context.get(ATTRIBUTE_NAME + SUFFIX_UNESCAPED + "WithJson"));
        Assert.assertEquals((Object)xmlEscapedPropertyValue, context.get(ATTRIBUTE_NAME + SUFFIX_UNESCAPED + "WithXml"));
    }

    @Test
    public void testAddStringPropertyToContext() {
        LinkedHashMap context = new LinkedHashMap();
        this.defaultNotificationMessageBuilder.addStringPropertyToContext(context, ATTRIBUTE_NAME + SUFFIX_UNESCAPED, ATTRIBUTE_VALUE + SUFFIX_UNESCAPED);
        Assert.assertEquals((long)3L, (long)CollectionUtils.size(context));
        Assert.assertEquals((Object)(ATTRIBUTE_VALUE + SUFFIX_UNESCAPED), context.get(ATTRIBUTE_NAME + SUFFIX_UNESCAPED));
        Assert.assertEquals((Object)(ATTRIBUTE_VALUE + SUFFIX_ESCAPED_JSON), context.get(ATTRIBUTE_NAME + SUFFIX_UNESCAPED + "WithJson"));
        Assert.assertEquals((Object)(ATTRIBUTE_VALUE + SUFFIX_ESCAPED_XML), context.get(ATTRIBUTE_NAME + SUFFIX_UNESCAPED + "WithXml"));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayload() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadMultipleAttributes() throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1"));
        attributes.add(new Attribute("Attribute Name 2", "   Attribute Value 2  "));
        attributes.add(new Attribute("Attribute Name 3", "Attribute Value 3"));
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 1", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        attributeDefinitions.add(new AttributeDefinition("Attribute Name 2", AbstractServiceTest.PUBLISH_ATTRIBUTE));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, attributeDefinitions, attributes);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, attributes.subList(0, 2), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadNoMessageDestination() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadNoMessageHeaders() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadNoMessageType() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadNoOldBusinessObjectDataStatus() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, NO_BDATA_STATUS);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, NO_BDATA_STATUS, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadNoSubPartitionValues() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(NO_SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        BusinessObjectDataKey expectedBusinessObjectDataKey = (BusinessObjectDataKey)businessObjectDataKey.clone();
        expectedBusinessObjectDataKey.setSubPartitionValues(null);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, expectedBusinessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadSingleAttribute() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, Collections.singletonList(new Attribute("Attribute Name 3", "Attribute Value 3")), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesJsonPayloadSingleSubPartitionValue() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES.subList(0, 1), NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"newBusinessObjectDataStatus\" : \"$newBusinessObjectDataStatus\"#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus)),\n  \"oldBusinessObjectDataStatus\" : \"$oldBusinessObjectDataStatus\"#end\n#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet())),\n  \"attributes\" : {\n#set ($keys = $Collections.list($Collections.enumeration($businessObjectDataAttributes.keySet())))\n    \"$keys.get(0)\" : \"$!businessObjectDataAttributes.get($keys.get(0))\"#foreach($key in $keys.subList(1, $keys.size()))\n,\n    \"$key\" : \"$!businessObjectDataAttributes.get($key)\"#end\n\n  }\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDataStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesNoMessageDefinitions() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2).size());
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesXmlPayload() throws Exception {
        this.testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(SUBPARTITION_VALUES, "SYSTEM");
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesXmlPayloadAndMessageHeaders() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesXmlPayloadNoSubPartitionValues() throws Exception {
        this.testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(NO_SUBPARTITION_VALUES, "SYSTEM");
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessagesXmlPayloadUserInContext() throws Exception {
        Authentication originalAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            SecurityContextHolder.getContext().setAuthentication(new Authentication(){

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return null;
                }

                public Object getCredentials() {
                    return null;
                }

                public Object getDetails() {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public Object getPrincipal() {
                    List authorities = Collections.emptyList();
                    return new User("testUsername", "", authorities);
                }

                public boolean isAuthenticated() {
                    return false;
                }

                public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                }
            });
            this.testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(SUBPARTITION_VALUES, "testUsername");
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(originalAuthentication);
        }
    }

    @Test
    public void testBuildBusinessObjectDefinitionDescriptionSuggestionChangeMessages() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(USER_ID_3, namespaceEntity, (List)Lists.newArrayList((Object[])new NamespacePermissionEnum[]{NamespacePermissionEnum.WRITE}));
        this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(USER_ID_2, namespaceEntity, (List)Lists.newArrayList((Object[])new NamespacePermissionEnum[]{NamespacePermissionEnum.WRITE_DESCRIPTIVE_CONTENT}));
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDefinitionDescriptionSuggestionKey\" : {\n    \"namespace\" : \"$businessObjectDefinitionDescriptionSuggestionKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName\",\n    \"userId\" : \"$businessObjectDefinitionDescriptionSuggestionKey.userId\"\n  },\n  \"status\" : \"$businessObjectDefinitionDescriptionSuggestion.status\",\n  \"createdByUserId\" : \"$businessObjectDefinitionDescriptionSuggestion.createdByUserId\",\n  \"createdOn\" : \"$businessObjectDefinitionDescriptionSuggestion.createdOn\",\n  \"lastUpdatedByUserId\" : \"$lastUpdatedByUserId\",\n  \"lastUpdatedOn\" : \"$lastUpdatedOn\",\n#if($CollectionUtils.isNotEmpty($notificationList))  \"notificationList\" : [\n    \"$notificationList.get(0)\"#foreach ($userId in $notificationList.subList(1, $notificationList.size())),\n    \"$userId\"#end\n\n  ],\n  \"businessObjectDefinitionUri\" : \"https://udc.dev.finra.org/data-entities/${businessObjectDefinitionDescriptionSuggestionKey.namespace}/${businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName}\"\n#end\n}\n", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateBusinessObjectDefinitionDescriptionSuggestionChangeMessage(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON.toString(), Lists.newArrayList((Object[])new String[]{CREATED_BY, USER_ID_2, USER_ID_3}), String.format("https://udc.dev.finra.org/data-entities/%s/%s", BDEF_NAMESPACE, BDEF_NAME), this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDefinitionDescriptionSuggestionChangeMessagesNoMessageDefinitions() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity).size());
    }

    @Test
    public void testBuildBusinessObjectDefinitionDescriptionSuggestionChangeMessagesNoMessageDestination() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDefinitionDescriptionSuggestionKey\" : {\n    \"namespace\" : \"$businessObjectDefinitionDescriptionSuggestionKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName\",\n    \"userId\" : \"$businessObjectDefinitionDescriptionSuggestionKey.userId\"\n  },\n  \"status\" : \"$businessObjectDefinitionDescriptionSuggestion.status\",\n  \"createdByUserId\" : \"$businessObjectDefinitionDescriptionSuggestion.createdByUserId\",\n  \"createdOn\" : \"$businessObjectDefinitionDescriptionSuggestion.createdOn\",\n  \"lastUpdatedByUserId\" : \"$lastUpdatedByUserId\",\n  \"lastUpdatedOn\" : \"$lastUpdatedOn\",\n#if($CollectionUtils.isNotEmpty($notificationList))  \"notificationList\" : [\n    \"$notificationList.get(0)\"#foreach ($userId in $notificationList.subList(1, $notificationList.size())),\n    \"$userId\"#end\n\n  ],\n  \"businessObjectDefinitionUri\" : \"https://udc.dev.finra.org/data-entities/${businessObjectDefinitionDescriptionSuggestionKey.namespace}/${businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName}\"\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectDefinitionDescriptionSuggestionChangeMessagesNoMessageHeaders() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(USER_ID_3, namespaceEntity, (List)Lists.newArrayList((Object[])new NamespacePermissionEnum[]{NamespacePermissionEnum.WRITE}));
        this.userNamespaceAuthorizationDaoTestHelper.createUserNamespaceAuthorizationEntity(USER_ID_2, namespaceEntity, (List)Lists.newArrayList((Object[])new NamespacePermissionEnum[]{NamespacePermissionEnum.WRITE_DESCRIPTIVE_CONTENT}));
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDefinitionDescriptionSuggestionKey\" : {\n    \"namespace\" : \"$businessObjectDefinitionDescriptionSuggestionKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName\",\n    \"userId\" : \"$businessObjectDefinitionDescriptionSuggestionKey.userId\"\n  },\n  \"status\" : \"$businessObjectDefinitionDescriptionSuggestion.status\",\n  \"createdByUserId\" : \"$businessObjectDefinitionDescriptionSuggestion.createdByUserId\",\n  \"createdOn\" : \"$businessObjectDefinitionDescriptionSuggestion.createdOn\",\n  \"lastUpdatedByUserId\" : \"$lastUpdatedByUserId\",\n  \"lastUpdatedOn\" : \"$lastUpdatedOn\",\n#if($CollectionUtils.isNotEmpty($notificationList))  \"notificationList\" : [\n    \"$notificationList.get(0)\"#foreach ($userId in $notificationList.subList(1, $notificationList.size())),\n    \"$userId\"#end\n\n  ],\n  \"businessObjectDefinitionUri\" : \"https://udc.dev.finra.org/data-entities/${businessObjectDefinitionDescriptionSuggestionKey.namespace}/${businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName}\"\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectDefinitionDescriptionSuggestionChangeMessage(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON.toString(), Lists.newArrayList((Object[])new String[]{CREATED_BY, USER_ID_2, USER_ID_3}), String.format("https://udc.dev.finra.org/data-entities/%s/%s", BDEF_NAMESPACE, BDEF_NAME), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectDefinitionDescriptionSuggestionChangeMessagesNoMessageType() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDefinitionDescriptionSuggestionKey\" : {\n    \"namespace\" : \"$businessObjectDefinitionDescriptionSuggestionKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName\",\n    \"userId\" : \"$businessObjectDefinitionDescriptionSuggestionKey.userId\"\n  },\n  \"status\" : \"$businessObjectDefinitionDescriptionSuggestion.status\",\n  \"createdByUserId\" : \"$businessObjectDefinitionDescriptionSuggestion.createdByUserId\",\n  \"createdOn\" : \"$businessObjectDefinitionDescriptionSuggestion.createdOn\",\n  \"lastUpdatedByUserId\" : \"$lastUpdatedByUserId\",\n  \"lastUpdatedOn\" : \"$lastUpdatedOn\",\n#if($CollectionUtils.isNotEmpty($notificationList))  \"notificationList\" : [\n    \"$notificationList.get(0)\"#foreach ($userId in $notificationList.subList(1, $notificationList.size())),\n    \"$userId\"#end\n\n  ],\n  \"businessObjectDefinitionUri\" : \"https://udc.dev.finra.org/data-entities/${businessObjectDefinitionDescriptionSuggestionKey.namespace}/${businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName}\"\n#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectDefinitionDescriptionSuggestionChangeMessagesOnlyOneUserIdInNotificationList() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE, BDEF_NAME, USER_ID);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION, BusinessObjectDefinitionDescriptionSuggestionStatusEntity.BusinessObjectDefinitionDescriptionSuggestionStatuses.PENDING.name(), CREATED_BY, CREATED_ON);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DEFINITION_DESCRIPTION_SUGGESTION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDefinitionDescriptionSuggestionKey\" : {\n    \"namespace\" : \"$businessObjectDefinitionDescriptionSuggestionKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName\",\n    \"userId\" : \"$businessObjectDefinitionDescriptionSuggestionKey.userId\"\n  },\n  \"status\" : \"$businessObjectDefinitionDescriptionSuggestion.status\",\n  \"createdByUserId\" : \"$businessObjectDefinitionDescriptionSuggestion.createdByUserId\",\n  \"createdOn\" : \"$businessObjectDefinitionDescriptionSuggestion.createdOn\",\n  \"lastUpdatedByUserId\" : \"$lastUpdatedByUserId\",\n  \"lastUpdatedOn\" : \"$lastUpdatedOn\",\n#if($CollectionUtils.isNotEmpty($notificationList))  \"notificationList\" : [\n    \"$notificationList.get(0)\"#foreach ($userId in $notificationList.subList(1, $notificationList.size())),\n    \"$userId\"#end\n\n  ],\n  \"businessObjectDefinitionUri\" : \"https://udc.dev.finra.org/data-entities/${businessObjectDefinitionDescriptionSuggestionKey.namespace}/${businessObjectDefinitionDescriptionSuggestionKey.businessObjectDefinitionName}\"\n#end\n}\n", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDefinitionDescriptionSuggestionChangeMessages(businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON, namespaceEntity);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateBusinessObjectDefinitionDescriptionSuggestionChangeMessage(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDefinitionDescriptionSuggestion, UPDATED_BY, UPDATED_ON.toString(), Lists.newArrayList((Object[])new String[]{CREATED_BY}), String.format("https://udc.dev.finra.org/data-entities/%s/%s", BDEF_NAMESPACE, BDEF_NAME), this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesJsonPayload() throws Exception {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, FORMAT_VERSION_2.toString());
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateBusinessObjectFormatVersionChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectFormatKey, businessObjectFormatKey.getBusinessObjectFormatVersion().toString(), FORMAT_VERSION_2.toString(), this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesJsonPayloadNoMessageDestination() throws Exception {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, FORMAT_VERSION_2.toString());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesJsonPayloadNoMessageHeaders() throws Exception {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, FORMAT_VERSION_2.toString());
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectFormatVersionChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectFormatKey, businessObjectFormatKey.getBusinessObjectFormatVersion().toString(), FORMAT_VERSION_2.toString(), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesJsonPayloadNoMessageType() throws Exception {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, FORMAT_VERSION_2.toString());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesJsonPayloadNoOldBusinessObjectFormatVersion() throws Exception {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateBusinessObjectFormatVersionChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectFormatKey, businessObjectFormatKey.getBusinessObjectFormatVersion().toString(), NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildBusinessObjectFormatVersionChangeMessagesNoMessageDefinitions() throws Exception {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildBusinessObjectFormatVersionChangeMessages(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION).size());
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayload() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"storageName\" : \"$storageName\",\n  \"newStorageUnitStatus\" : \"$newStorageUnitStatus\"#if($StringUtils.isNotEmpty($oldStorageUnitStatus)),\n  \"oldStorageUnitStatus\" : \"$oldStorageUnitStatus\"#end\n}\n", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateStorageUnitStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayloadNoMessageDestination() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)illegalStateException.getMessage());
        }
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayloadNoMessageHeaders() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"storageName\" : \"$storageName\",\n  \"newStorageUnitStatus\" : \"$newStorageUnitStatus\"#if($StringUtils.isNotEmpty($oldStorageUnitStatus)),\n  \"oldStorageUnitStatus\" : \"$oldStorageUnitStatus\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateStorageUnitStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayloadNoMessageType() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectFormatKey\" : {\n    \"namespace\" : \"$businessObjectFormatKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectFormatKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectFormatKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectFormatKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectFormatKey.businessObjectFormatVersion\n  },\n  \"newBusinessObjectFormatVersion\" : \"$newBusinessObjectFormatVersion\"#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion)),\n  \"oldBusinessObjectFormatVersion\" : \"$oldBusinessObjectFormatVersion\"#end\n}\n", Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)illegalStateException.getMessage());
        }
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayloadNoOldStorageUnitStatus() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"storageName\" : \"$storageName\",\n  \"newStorageUnitStatus\" : \"$newStorageUnitStatus\"#if($StringUtils.isNotEmpty($oldStorageUnitStatus)),\n  \"oldStorageUnitStatus\" : \"$oldStorageUnitStatus\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateStorageUnitStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayloadNoSubPartitionValues() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(NO_SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        BusinessObjectDataKey expectedBusinessObjectDataKey = (BusinessObjectDataKey)businessObjectDataKey.clone();
        expectedBusinessObjectDataKey.setSubPartitionValues(null);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"storageName\" : \"$storageName\",\n  \"newStorageUnitStatus\" : \"$newStorageUnitStatus\"#if($StringUtils.isNotEmpty($oldStorageUnitStatus)),\n  \"oldStorageUnitStatus\" : \"$oldStorageUnitStatus\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateStorageUnitStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, expectedBusinessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesJsonPayloadSingleSubPartitionValue() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES.subList(0, 1), NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"eventDate\" : \"$current_time\",\n  \"businessObjectDataKey\" : {\n    \"namespace\" : \"$businessObjectDataKey.namespace\",\n    \"businessObjectDefinitionName\" : \"$businessObjectDataKey.businessObjectDefinitionName\",\n    \"businessObjectFormatUsage\" : \"$businessObjectDataKey.businessObjectFormatUsage\",\n    \"businessObjectFormatFileType\" : \"$businessObjectDataKey.businessObjectFormatFileType\",\n    \"businessObjectFormatVersion\" : $businessObjectDataKey.businessObjectFormatVersion,\n    \"partitionValue\" : \"$businessObjectDataKey.partitionValue\",\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))    \"subPartitionValues\" : [ \"$businessObjectDataKey.subPartitionValues.get(0)\"#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues.subList(1, $businessObjectDataKey.subPartitionValues.size())), \"$subPartitionValue\"#end\n ],\n#end\n    \"businessObjectDataVersion\" : $businessObjectDataKey.businessObjectDataVersion\n  },\n  \"storageName\" : \"$storageName\",\n  \"newStorageUnitStatus\" : \"$newStorageUnitStatus\"#if($StringUtils.isNotEmpty($oldStorageUnitStatus)),\n  \"oldStorageUnitStatus\" : \"$oldStorageUnitStatus\"#end\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateStorageUnitStatusChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildStorageUnitStatusChangeMessagesNoMessageDefinitions() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_STORAGE_UNIT_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildStorageUnitStatusChangeMessages(businessObjectDataKey, STORAGE_NAME, STORAGE_UNIT_STATUS, STORAGE_UNIT_STATUS_2).size());
    }

    @Test
    public void testBuildUserNamespaceAuthorizationChangeMessagesJsonPayload() throws Exception {
        UserNamespaceAuthorizationKey userNamespaceAuthorizationKey = new UserNamespaceAuthorizationKey(USER_ID, BDEF_NAMESPACE);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"userId\" : \"$userNamespaceAuthorizationKey.userId\",\n  \"namespace\" : \"$userNamespaceAuthorizationKey.namespace\"\n}\n", this.getMessageHeaderDefinitions())))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildUserNamespaceAuthorizationChangeMessages(userNamespaceAuthorizationKey);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((long)7L, (long)CollectionUtils.size((Object)((NotificationMessage)result.get(0)).getMessageHeaders()));
        String uuid = ((MessageHeader)((NotificationMessage)result.get(0)).getMessageHeaders().get(4)).getValue();
        Assert.assertEquals((long)UUID.randomUUID().toString().length(), (long)StringUtils.length((CharSequence)uuid));
        this.validateUserNamespaceAuthorizationChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, userNamespaceAuthorizationKey, this.getExpectedMessageHeaders(uuid), (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildUserNamespaceAuthorizationChangeMessagesJsonPayloadNoMessageDestination() throws Exception {
        UserNamespaceAuthorizationKey userNamespaceAuthorizationKey = new UserNamespaceAuthorizationKey(USER_ID, BDEF_NAMESPACE);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, "{\n  \"userId\" : \"$userNamespaceAuthorizationKey.userId\",\n  \"namespace\" : \"$userNamespaceAuthorizationKey.namespace\"\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildUserNamespaceAuthorizationChangeMessages(userNamespaceAuthorizationKey);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildUserNamespaceAuthorizationChangeMessagesJsonPayloadNoMessageHeaders() throws Exception {
        UserNamespaceAuthorizationKey userNamespaceAuthorizationKey = new UserNamespaceAuthorizationKey(USER_ID, BDEF_NAMESPACE);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"userId\" : \"$userNamespaceAuthorizationKey.userId\",\n  \"namespace\" : \"$userNamespaceAuthorizationKey.namespace\"\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildUserNamespaceAuthorizationChangeMessages(userNamespaceAuthorizationKey);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.validateUserNamespaceAuthorizationChangeMessageWithJsonPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, userNamespaceAuthorizationKey, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testBuildUserNamespaceAuthorizationChangeMessagesJsonPayloadNoMessageType() throws Exception {
        UserNamespaceAuthorizationKey userNamespaceAuthorizationKey = new UserNamespaceAuthorizationKey(USER_ID, BDEF_NAMESPACE);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, "{\n  \"userId\" : \"$userNamespaceAuthorizationKey.userId\",\n  \"namespace\" : \"$userNamespaceAuthorizationKey.namespace\"\n}\n", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.defaultNotificationMessageBuilder.buildUserNamespaceAuthorizationChangeMessages(userNamespaceAuthorizationKey);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testBuildUserNamespaceAuthorizationChangeMessagesNoMessageDefinitions() throws Exception {
        UserNamespaceAuthorizationKey userNamespaceAuthorizationKey = new UserNamespaceAuthorizationKey(USER_ID, BDEF_NAMESPACE);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_USER_NAMESPACE_AUTHORIZATION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(null);
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildUserNamespaceAuthorizationChangeMessages(userNamespaceAuthorizationKey).size());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions()));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        Assert.assertEquals((long)0L, (long)this.defaultNotificationMessageBuilder.buildUserNamespaceAuthorizationChangeMessages(userNamespaceAuthorizationKey).size());
    }

    @Test
    public void testBuildSystemMonitorResponse() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            NotificationMessage result = this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            this.validateSystemMonitorResponseNotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "HERD_OUTGOING_QUEUE", result);
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidVelocityTemplate() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "#if($missingEndOfIfStatement");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (ParseErrorException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Encountered \"<EOF>\" at systemMonitorResponse[line 1, column 28]"));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidXmlRequestPayload() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(INVALID_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Payload is not valid XML:\n%s", INVALID_VALUE), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidXpathExpression() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), "key=///");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("XPath expression \"///\" could not be evaluated against payload"));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseInvalidXpathProperties() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), "key=\\uxxxx");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Unable to load XPath properties from configuration with key '%s'", ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey()), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseNoMessageVelocityTemplate() throws Exception {
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertNull((Object)this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage()));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseNoXPathExpressions() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultNotificationMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail();
        }
        catch (MethodInvocationException e) {
            Assert.assertEquals((Object)"Variable $incoming_message_correlation_id has not been set at systemMonitorResponse[line 11, column 29]", (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testGetBaseVelocityContextMap() {
        Map result = this.defaultNotificationMessageBuilder.getBaseVelocityContextMap();
        Assert.assertEquals((long)14L, (long)CollectionUtils.size((Object)result));
    }

    @Test
    public void testGetBaseVelocityContextMapHelper() {
        String herdEnvironmentKey = "herd_environment";
        String herdNotificationSqsEnvironmentKey = "herd_notification_sqs_environment";
        String herdEnvironmentValue = this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT);
        String herdNotificationSqsEnvironmentValue = this.configurationHelper.getProperty(ConfigurationValue.HERD_NOTIFICATION_SQS_ENVIRONMENT);
        Map result = this.defaultNotificationMessageBuilder.getBaseVelocityContextMapHelper(USER_ID + SUFFIX_UNESCAPED, "herd_environment\"\"<test>", herdEnvironmentValue + SUFFIX_UNESCAPED, "herd_notification_sqs_environment\"\"<test>", herdNotificationSqsEnvironmentValue + SUFFIX_UNESCAPED);
        Assert.assertEquals((long)14L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((Object)(herdEnvironmentValue + SUFFIX_UNESCAPED), result.get("herd_environment\"\"<test>"));
        Assert.assertEquals((Object)(herdEnvironmentValue + SUFFIX_ESCAPED_JSON), result.get("herd_environment\\\"\\\"<test>_with_json"));
        Assert.assertEquals((Object)(herdEnvironmentValue + SUFFIX_ESCAPED_XML), result.get("herd_environment&quot;&quot;&lt;test&gt;_with_xml"));
        Assert.assertEquals((Object)(herdNotificationSqsEnvironmentValue + SUFFIX_UNESCAPED), result.get("herd_notification_sqs_environment\"\"<test>"));
        Assert.assertEquals((Object)(herdNotificationSqsEnvironmentValue + SUFFIX_ESCAPED_JSON), result.get("herd_notification_sqs_environment\\\"\\\"<test>_with_json"));
        Assert.assertEquals((Object)(herdNotificationSqsEnvironmentValue + SUFFIX_ESCAPED_XML), result.get("herd_notification_sqs_environment&quot;&quot;&lt;test&gt;_with_xml"));
        Assert.assertEquals((Object)(USER_ID + SUFFIX_UNESCAPED), result.get("username"));
        Assert.assertEquals((Object)(USER_ID + SUFFIX_ESCAPED_JSON), result.get("usernameWithJson"));
        Assert.assertEquals((Object)(USER_ID + SUFFIX_ESCAPED_XML), result.get("usernameWithXml"));
    }

    @Test
    public void testGetBusinessObjectDataStatusChangeMessageVelocityContextMap() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE + SUFFIX_UNESCAPED, BDEF_NAME + SUFFIX_UNESCAPED, FORMAT_USAGE_CODE + SUFFIX_UNESCAPED, FORMAT_FILE_TYPE_CODE + SUFFIX_UNESCAPED, FORMAT_VERSION, PARTITION_VALUE + SUFFIX_UNESCAPED, (List)Lists.newArrayList((Object[])new String[]{(String)SUBPARTITION_VALUES.get(0) + SUFFIX_UNESCAPED, (String)SUBPARTITION_VALUES.get(1) + SUFFIX_UNESCAPED, (String)SUBPARTITION_VALUES.get(2) + SUFFIX_UNESCAPED, (String)SUBPARTITION_VALUES.get(3) + SUFFIX_UNESCAPED}), DATA_VERSION);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1\"\"<test>", "Attribute Value 1\"\"<test>"));
        attributes.add(new Attribute("Attribute Name 2\"\"<test>", "   Attribute Value 2  \"\"<test>"));
        attributes.add(new Attribute("Attribute Name 3\"\"<test>", null));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        for (Attribute attribute : attributes) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataEntity, attribute.getName(), attribute.getValue());
        }
        for (Attribute attribute : attributes) {
            this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(businessObjectDataEntity.getBusinessObjectFormat(), attribute.getName(), PUBLISH_ATTRIBUTE.booleanValue());
        }
        Map result = this.defaultNotificationMessageBuilder.getBusinessObjectDataStatusChangeMessageVelocityContextMap(businessObjectDataKey, BDATA_STATUS_2 + SUFFIX_UNESCAPED, BDATA_STATUS + SUFFIX_UNESCAPED);
        LinkedHashMap<String, String> expectedBusinessObjectDataAttributes = new LinkedHashMap<String, String>();
        expectedBusinessObjectDataAttributes.put("Attribute Name 1\"\"<test>", "Attribute Value 1\"\"<test>");
        expectedBusinessObjectDataAttributes.put("Attribute Name 2\"\"<test>", "   Attribute Value 2  \"\"<test>");
        expectedBusinessObjectDataAttributes.put("Attribute Name 3\"\"<test>", null);
        LinkedHashMap<String, String> expectedBusinessObjectDataAttributesWithJson = new LinkedHashMap<String, String>();
        expectedBusinessObjectDataAttributesWithJson.put("Attribute Name 1\\\"\\\"<test>", "Attribute Value 1\\\"\\\"<test>");
        expectedBusinessObjectDataAttributesWithJson.put("Attribute Name 2\\\"\\\"<test>", "   Attribute Value 2  \\\"\\\"<test>");
        expectedBusinessObjectDataAttributesWithJson.put("Attribute Name 3\\\"\\\"<test>", null);
        LinkedHashMap<String, String> expectedBusinessObjectDataAttributesWithXml = new LinkedHashMap<String, String>();
        expectedBusinessObjectDataAttributesWithXml.put("Attribute Name 1&quot;&quot;&lt;test&gt;", "Attribute Value 1&quot;&quot;&lt;test&gt;");
        expectedBusinessObjectDataAttributesWithXml.put("Attribute Name 2&quot;&quot;&lt;test&gt;", "   Attribute Value 2  &quot;&quot;&lt;test&gt;");
        expectedBusinessObjectDataAttributesWithXml.put("Attribute Name 3&quot;&quot;&lt;test&gt;", null);
        BusinessObjectDataKey expectedBusinessObjectDataKeyWithJson = new BusinessObjectDataKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON, BDEF_NAME + SUFFIX_ESCAPED_JSON, FORMAT_USAGE_CODE + SUFFIX_ESCAPED_JSON, FORMAT_FILE_TYPE_CODE + SUFFIX_ESCAPED_JSON, FORMAT_VERSION, PARTITION_VALUE + SUFFIX_ESCAPED_JSON, (List)Lists.newArrayList((Object[])new String[]{(String)SUBPARTITION_VALUES.get(0) + SUFFIX_ESCAPED_JSON, (String)SUBPARTITION_VALUES.get(1) + SUFFIX_ESCAPED_JSON, (String)SUBPARTITION_VALUES.get(2) + SUFFIX_ESCAPED_JSON, (String)SUBPARTITION_VALUES.get(3) + SUFFIX_ESCAPED_JSON}), DATA_VERSION);
        BusinessObjectDataKey expectedBusinessObjectDataKeyWithXml = new BusinessObjectDataKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML, BDEF_NAME + SUFFIX_ESCAPED_XML, FORMAT_USAGE_CODE + SUFFIX_ESCAPED_XML, FORMAT_FILE_TYPE_CODE + SUFFIX_ESCAPED_XML, FORMAT_VERSION, PARTITION_VALUE + SUFFIX_ESCAPED_XML, (List)Lists.newArrayList((Object[])new String[]{(String)SUBPARTITION_VALUES.get(0) + SUFFIX_ESCAPED_XML, (String)SUBPARTITION_VALUES.get(1) + SUFFIX_ESCAPED_XML, (String)SUBPARTITION_VALUES.get(2) + SUFFIX_ESCAPED_XML, (String)SUBPARTITION_VALUES.get(3) + SUFFIX_ESCAPED_XML}), DATA_VERSION);
        Assert.assertEquals((long)16L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((Object)businessObjectDataKey, result.get("businessObjectDataKey"));
        Assert.assertEquals((Object)expectedBusinessObjectDataKeyWithJson, result.get("businessObjectDataKeyWithJson"));
        Assert.assertEquals((Object)expectedBusinessObjectDataKeyWithXml, result.get("businessObjectDataKeyWithXml"));
        Assert.assertEquals((Object)(BDATA_STATUS_2 + SUFFIX_UNESCAPED), result.get("newBusinessObjectDataStatus"));
        Assert.assertEquals((Object)(BDATA_STATUS_2 + SUFFIX_ESCAPED_JSON), result.get("newBusinessObjectDataStatusWithJson"));
        Assert.assertEquals((Object)(BDATA_STATUS_2 + SUFFIX_ESCAPED_XML), result.get("newBusinessObjectDataStatusWithXml"));
        Assert.assertEquals((Object)(BDATA_STATUS + SUFFIX_UNESCAPED), result.get("oldBusinessObjectDataStatus"));
        Assert.assertEquals((Object)(BDATA_STATUS + SUFFIX_ESCAPED_JSON), result.get("oldBusinessObjectDataStatusWithJson"));
        Assert.assertEquals((Object)(BDATA_STATUS + SUFFIX_ESCAPED_XML), result.get("oldBusinessObjectDataStatusWithXml"));
        Assert.assertEquals((Object)businessObjectDataEntity.getId(), result.get("businessObjectDataId"));
        Assert.assertEquals(expectedBusinessObjectDataAttributes, result.get("businessObjectDataAttributes"));
        Assert.assertEquals(expectedBusinessObjectDataAttributesWithJson, result.get("businessObjectDataAttributesWithJson"));
        Assert.assertEquals(expectedBusinessObjectDataAttributesWithXml, result.get("businessObjectDataAttributesWithXml"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_UNESCAPED), result.get("namespace"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON), result.get("namespaceWithJson"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML), result.get("namespaceWithXml"));
    }

    @Test
    public void testGetBusinessObjectDefinitionDescriptionSuggestionChangeMessageVelocityContextMap() {
        BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE + SUFFIX_UNESCAPED, BDEF_NAME + SUFFIX_UNESCAPED, USER_ID + SUFFIX_UNESCAPED);
        BusinessObjectDefinitionDescriptionSuggestion businessObjectDefinitionDescriptionSuggestion = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), businessObjectDefinitionDescriptionSuggestionKey, DESCRIPTION_SUGGESTION + SUFFIX_UNESCAPED, BDEF_DESCRIPTION_SUGGESTION_STATUS + SUFFIX_UNESCAPED, USER_ID + SUFFIX_UNESCAPED, CREATED_ON);
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(businessObjectDefinitionDescriptionSuggestionKey.getNamespace());
        Map result = this.defaultNotificationMessageBuilder.getBusinessObjectDefinitionDescriptionSuggestionChangeMessageVelocityContextMap(businessObjectDefinitionDescriptionSuggestion, USER_ID_2 + SUFFIX_UNESCAPED, UPDATED_ON, namespaceEntity);
        BusinessObjectDefinitionDescriptionSuggestionKey expectedBusinessObjectDefinitionDescriptionSuggestionKeyWithJson = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON, BDEF_NAME + SUFFIX_ESCAPED_JSON, USER_ID + SUFFIX_ESCAPED_JSON);
        BusinessObjectDefinitionDescriptionSuggestion expectedBusinessObjectDefinitionDescriptionSuggestionWithJson = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), expectedBusinessObjectDefinitionDescriptionSuggestionKeyWithJson, DESCRIPTION_SUGGESTION + SUFFIX_ESCAPED_JSON, BDEF_DESCRIPTION_SUGGESTION_STATUS + SUFFIX_ESCAPED_JSON, USER_ID + SUFFIX_ESCAPED_JSON, CREATED_ON);
        BusinessObjectDefinitionDescriptionSuggestionKey expectedBusinessObjectDefinitionDescriptionSuggestionKeyWithXml = new BusinessObjectDefinitionDescriptionSuggestionKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML, BDEF_NAME + SUFFIX_ESCAPED_XML, USER_ID + SUFFIX_ESCAPED_XML);
        BusinessObjectDefinitionDescriptionSuggestion expectedBusinessObjectDefinitionDescriptionSuggestionWithXml = new BusinessObjectDefinitionDescriptionSuggestion(ID.intValue(), expectedBusinessObjectDefinitionDescriptionSuggestionKeyWithXml, DESCRIPTION_SUGGESTION + SUFFIX_ESCAPED_XML, BDEF_DESCRIPTION_SUGGESTION_STATUS + SUFFIX_ESCAPED_XML, USER_ID + SUFFIX_ESCAPED_XML, CREATED_ON);
        ArrayList expectedNotificationList = Lists.newArrayList((Object[])new String[]{USER_ID + SUFFIX_UNESCAPED});
        ArrayList expectedNotificationListWithJson = Lists.newArrayList((Object[])new String[]{USER_ID + SUFFIX_ESCAPED_JSON});
        ArrayList expectedNotificationListWithXml = Lists.newArrayList((Object[])new String[]{USER_ID + SUFFIX_ESCAPED_XML});
        Assert.assertEquals((long)16L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((Object)businessObjectDefinitionDescriptionSuggestion, result.get("businessObjectDefinitionDescriptionSuggestion"));
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestionWithJson, result.get("businessObjectDefinitionDescriptionSuggestionWithJson"));
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestionWithXml, result.get("businessObjectDefinitionDescriptionSuggestionWithXml"));
        Assert.assertEquals((Object)businessObjectDefinitionDescriptionSuggestionKey, result.get("businessObjectDefinitionDescriptionSuggestionKey"));
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestionKeyWithJson, result.get("businessObjectDefinitionDescriptionSuggestionKeyWithJson"));
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestionKeyWithXml, result.get("businessObjectDefinitionDescriptionSuggestionKeyWithXml"));
        Assert.assertEquals((Object)(USER_ID_2 + SUFFIX_UNESCAPED), result.get("lastUpdatedByUserId"));
        Assert.assertEquals((Object)(USER_ID_2 + SUFFIX_ESCAPED_JSON), result.get("lastUpdatedByUserIdWithJson"));
        Assert.assertEquals((Object)(USER_ID_2 + SUFFIX_ESCAPED_XML), result.get("lastUpdatedByUserIdWithXml"));
        Assert.assertEquals((Object)UPDATED_ON, result.get("lastUpdatedOn"));
        Assert.assertEquals((Object)expectedNotificationList, result.get("notificationList"));
        Assert.assertEquals((Object)expectedNotificationListWithJson, result.get("notificationListWithJson"));
        Assert.assertEquals((Object)expectedNotificationListWithXml, result.get("notificationListWithXml"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_UNESCAPED), result.get("namespace"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON), result.get("namespaceWithJson"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML), result.get("namespaceWithXml"));
    }

    @Test
    public void testGetBusinessObjectFormatVersionChangeMessageVelocityContextMap() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE + SUFFIX_UNESCAPED, BDEF_NAME + SUFFIX_UNESCAPED, FORMAT_USAGE_CODE + SUFFIX_UNESCAPED, FORMAT_FILE_TYPE_CODE + SUFFIX_UNESCAPED, FORMAT_VERSION_2);
        Map result = this.defaultNotificationMessageBuilder.getBusinessObjectFormatVersionChangeMessageVelocityContextMap(businessObjectFormatKey, String.valueOf(FORMAT_VERSION));
        BusinessObjectFormatKey expectedBusinessObjectFormatKeyWithJson = new BusinessObjectFormatKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON, BDEF_NAME + SUFFIX_ESCAPED_JSON, FORMAT_USAGE_CODE + SUFFIX_ESCAPED_JSON, FORMAT_FILE_TYPE_CODE + SUFFIX_ESCAPED_JSON, FORMAT_VERSION_2);
        BusinessObjectFormatKey expectedBusinessObjectFormatKeyWithXml = new BusinessObjectFormatKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML, BDEF_NAME + SUFFIX_ESCAPED_XML, FORMAT_USAGE_CODE + SUFFIX_ESCAPED_XML, FORMAT_FILE_TYPE_CODE + SUFFIX_ESCAPED_XML, FORMAT_VERSION_2);
        Assert.assertEquals((long)8L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((Object)businessObjectFormatKey, result.get("businessObjectFormatKey"));
        Assert.assertEquals((Object)expectedBusinessObjectFormatKeyWithJson, result.get("businessObjectFormatKeyWithJson"));
        Assert.assertEquals((Object)expectedBusinessObjectFormatKeyWithXml, result.get("businessObjectFormatKeyWithXml"));
        Assert.assertEquals((Object)FORMAT_VERSION_2, result.get("newBusinessObjectFormatVersion"));
        Assert.assertEquals((Object)FORMAT_VERSION.toString(), result.get("oldBusinessObjectFormatVersion"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_UNESCAPED), result.get("namespace"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON), result.get("namespaceWithJson"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML), result.get("namespaceWithXml"));
    }

    @Test
    public void testgetUserNamespaceAuthorizationChangeMessageVelocityContextMap() {
        UserNamespaceAuthorizationKey userNamespaceAuthorizationKey = new UserNamespaceAuthorizationKey(USER_ID + SUFFIX_UNESCAPED, BDEF_NAMESPACE + SUFFIX_UNESCAPED);
        Map result = this.defaultNotificationMessageBuilder.getUserNamespaceAuthorizationChangeMessageVelocityContextMap(userNamespaceAuthorizationKey);
        UserNamespaceAuthorizationKey expectedUserNamespaceAuthorizationKeyWithJson = new UserNamespaceAuthorizationKey(USER_ID + SUFFIX_ESCAPED_JSON, BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON);
        UserNamespaceAuthorizationKey expectedUserNamespaceAuthorizationKeyWithXml = new UserNamespaceAuthorizationKey(USER_ID + SUFFIX_ESCAPED_XML, BDEF_NAMESPACE + SUFFIX_ESCAPED_XML);
        Assert.assertEquals((long)6L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((Object)userNamespaceAuthorizationKey, result.get("userNamespaceAuthorizationKey"));
        Assert.assertEquals((Object)expectedUserNamespaceAuthorizationKeyWithJson, result.get("userNamespaceAuthorizationKeyWithJson"));
        Assert.assertEquals((Object)expectedUserNamespaceAuthorizationKeyWithXml, result.get("userNamespaceAuthorizationKeyWithXml"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_UNESCAPED), result.get("namespace"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON), result.get("namespaceWithJson"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML), result.get("namespaceWithXml"));
    }

    @Test
    public void testGetStorageUnitStatusChangeMessageVelocityContextMap() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE + SUFFIX_UNESCAPED, BDEF_NAME + SUFFIX_UNESCAPED, FORMAT_USAGE_CODE + SUFFIX_UNESCAPED, FORMAT_FILE_TYPE_CODE + SUFFIX_UNESCAPED, FORMAT_VERSION, PARTITION_VALUE + SUFFIX_UNESCAPED, (List)Lists.newArrayList((Object[])new String[]{(String)SUBPARTITION_VALUES.get(0) + SUFFIX_UNESCAPED, (String)SUBPARTITION_VALUES.get(1) + SUFFIX_UNESCAPED, (String)SUBPARTITION_VALUES.get(2) + SUFFIX_UNESCAPED, (String)SUBPARTITION_VALUES.get(3) + SUFFIX_UNESCAPED}), DATA_VERSION);
        Map result = this.defaultNotificationMessageBuilder.getStorageUnitStatusChangeMessageVelocityContextMap(businessObjectDataKey, STORAGE_NAME + SUFFIX_UNESCAPED, STORAGE_UNIT_STATUS_2 + SUFFIX_UNESCAPED, STORAGE_UNIT_STATUS + SUFFIX_UNESCAPED);
        BusinessObjectDataKey expectedBusinessObjectDataKeyWithJson = new BusinessObjectDataKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON, BDEF_NAME + SUFFIX_ESCAPED_JSON, FORMAT_USAGE_CODE + SUFFIX_ESCAPED_JSON, FORMAT_FILE_TYPE_CODE + SUFFIX_ESCAPED_JSON, FORMAT_VERSION, PARTITION_VALUE + SUFFIX_ESCAPED_JSON, (List)Lists.newArrayList((Object[])new String[]{(String)SUBPARTITION_VALUES.get(0) + SUFFIX_ESCAPED_JSON, (String)SUBPARTITION_VALUES.get(1) + SUFFIX_ESCAPED_JSON, (String)SUBPARTITION_VALUES.get(2) + SUFFIX_ESCAPED_JSON, (String)SUBPARTITION_VALUES.get(3) + SUFFIX_ESCAPED_JSON}), DATA_VERSION);
        BusinessObjectDataKey expectedBusinessObjectDataKeyWithXml = new BusinessObjectDataKey(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML, BDEF_NAME + SUFFIX_ESCAPED_XML, FORMAT_USAGE_CODE + SUFFIX_ESCAPED_XML, FORMAT_FILE_TYPE_CODE + SUFFIX_ESCAPED_XML, FORMAT_VERSION, PARTITION_VALUE + SUFFIX_ESCAPED_XML, (List)Lists.newArrayList((Object[])new String[]{(String)SUBPARTITION_VALUES.get(0) + SUFFIX_ESCAPED_XML, (String)SUBPARTITION_VALUES.get(1) + SUFFIX_ESCAPED_XML, (String)SUBPARTITION_VALUES.get(2) + SUFFIX_ESCAPED_XML, (String)SUBPARTITION_VALUES.get(3) + SUFFIX_ESCAPED_XML}), DATA_VERSION);
        Assert.assertEquals((long)15L, (long)CollectionUtils.size((Object)result));
        Assert.assertEquals((Object)businessObjectDataKey, result.get("businessObjectDataKey"));
        Assert.assertEquals((Object)expectedBusinessObjectDataKeyWithJson, result.get("businessObjectDataKeyWithJson"));
        Assert.assertEquals((Object)expectedBusinessObjectDataKeyWithXml, result.get("businessObjectDataKeyWithXml"));
        Assert.assertEquals((Object)(STORAGE_NAME + SUFFIX_UNESCAPED), result.get("storageName"));
        Assert.assertEquals((Object)(STORAGE_NAME + SUFFIX_ESCAPED_JSON), result.get("storageNameWithJson"));
        Assert.assertEquals((Object)(STORAGE_NAME + SUFFIX_ESCAPED_XML), result.get("storageNameWithXml"));
        Assert.assertEquals((Object)(STORAGE_UNIT_STATUS_2 + SUFFIX_UNESCAPED), result.get("newStorageUnitStatus"));
        Assert.assertEquals((Object)(STORAGE_UNIT_STATUS_2 + SUFFIX_ESCAPED_JSON), result.get("newStorageUnitStatusWithJson"));
        Assert.assertEquals((Object)(STORAGE_UNIT_STATUS_2 + SUFFIX_ESCAPED_XML), result.get("newStorageUnitStatusWithXml"));
        Assert.assertEquals((Object)(STORAGE_UNIT_STATUS + SUFFIX_UNESCAPED), result.get("oldStorageUnitStatus"));
        Assert.assertEquals((Object)(STORAGE_UNIT_STATUS + SUFFIX_ESCAPED_JSON), result.get("oldStorageUnitStatusWithJson"));
        Assert.assertEquals((Object)(STORAGE_UNIT_STATUS + SUFFIX_ESCAPED_XML), result.get("oldStorageUnitStatusWithXml"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_UNESCAPED), result.get("namespace"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_JSON), result.get("namespaceWithJson"));
        Assert.assertEquals((Object)(BDEF_NAMESPACE + SUFFIX_ESCAPED_XML), result.get("namespaceWithXml"));
    }

    private List<MessageHeader> getExpectedMessageHeaders(String expectedUuid) {
        ArrayList<MessageHeader> messageHeaders = new ArrayList<MessageHeader>();
        messageHeaders.add(new MessageHeader("environment", this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)));
        messageHeaders.add(new MessageHeader("messageType", MESSAGE_TYPE));
        messageHeaders.add(new MessageHeader("messageVersion", MESSAGE_VERSION));
        messageHeaders.add(new MessageHeader("sourceSystem", SOURCE_SYSTEM));
        messageHeaders.add(new MessageHeader("messageId", expectedUuid));
        messageHeaders.add(new MessageHeader("userId", "SYSTEM"));
        messageHeaders.add(new MessageHeader("namespace", BDEF_NAMESPACE));
        return messageHeaders;
    }

    private List<MessageHeaderDefinition> getMessageHeaderDefinitions() {
        ArrayList<MessageHeaderDefinition> messageHeaderDefinitions = new ArrayList<MessageHeaderDefinition>();
        messageHeaderDefinitions.add(new MessageHeaderDefinition("environment", "$herd_environment"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageType", MESSAGE_TYPE));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageVersion", MESSAGE_VERSION));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("sourceSystem", SOURCE_SYSTEM));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("messageId", "$uuid"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("userId", "$username"));
        messageHeaderDefinitions.add(new MessageHeaderDefinition("namespace", "$namespace"));
        return messageHeaderDefinitions;
    }

    private void testBuildBusinessObjectDataStatusChangeMessagesWithXmlPayloadHelper(List<String> subPartitionValues, String expectedTriggeredByUsername) throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(subPartitionValues, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.defaultNotificationMessageBuilder.buildBusinessObjectDataStatusChangeMessages(businessObjectDataKey, BDATA_STATUS, BDATA_STATUS_2);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), expectedTriggeredByUsername, BDATA_STATUS, BDATA_STATUS_2, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    private void validateBusinessObjectDataStatusChangeMessageWithJsonPayload(String expectedMessageType, String expectedMessageDestination, BusinessObjectDataKey expectedBusinessObjectDataKey, String expectedNewBusinessObjectDataStatus, String expectedOldBusinessObjectDataStatus, List<Attribute> expectedBusinessObjectDataAttributes, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        BusinessObjectDataStatusChangeJsonMessagePayload businessObjectDataStatusChangeJsonMessagePayload = (BusinessObjectDataStatusChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(BusinessObjectDataStatusChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((long)StringUtils.length((CharSequence)businessObjectDataStatusChangeJsonMessagePayload.eventDate), (long)StringUtils.length((CharSequence)HerdDateUtils.now().toString()));
        Assert.assertEquals((Object)expectedBusinessObjectDataKey, (Object)businessObjectDataStatusChangeJsonMessagePayload.businessObjectDataKey);
        Assert.assertEquals((Object)expectedNewBusinessObjectDataStatus, (Object)businessObjectDataStatusChangeJsonMessagePayload.newBusinessObjectDataStatus);
        Assert.assertEquals((Object)expectedOldBusinessObjectDataStatus, (Object)businessObjectDataStatusChangeJsonMessagePayload.oldBusinessObjectDataStatus);
        Assert.assertEquals((long)CollectionUtils.size(expectedBusinessObjectDataAttributes), (long)CollectionUtils.size(businessObjectDataStatusChangeJsonMessagePayload.attributes));
        if (CollectionUtils.isNotEmpty(expectedBusinessObjectDataAttributes)) {
            for (Attribute expectedAttribute : expectedBusinessObjectDataAttributes) {
                Assert.assertTrue((boolean)businessObjectDataStatusChangeJsonMessagePayload.attributes.containsKey(expectedAttribute.getName()));
                Assert.assertEquals((Object)expectedAttribute.getValue(), (Object)businessObjectDataStatusChangeJsonMessagePayload.attributes.get(expectedAttribute.getName()));
            }
        }
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private void validateBusinessObjectDefinitionDescriptionSuggestionChangeMessage(String expectedMessageType, String expectedMessageDestination, BusinessObjectDefinitionDescriptionSuggestion expectedBusinessObjectDefinitionDescriptionSuggestion, String expectedLastUpdatedByUserId, String expectedLastUpdatedOn, List<String> expectedNotificationList, String expectedBusinessObjectDefinitionUri, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        BusinessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload = (BusinessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(BusinessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((long)StringUtils.length((CharSequence)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.eventDate), (long)StringUtils.length((CharSequence)HerdDateUtils.now().toString()));
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestion.getBusinessObjectDefinitionDescriptionSuggestionKey(), (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.businessObjectDefinitionDescriptionSuggestionKey);
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestion.getStatus(), (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.status);
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestion.getCreatedByUserId(), (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.createdByUserId);
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionDescriptionSuggestion.getCreatedOn().toString(), (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.createdOn);
        Assert.assertEquals((Object)expectedLastUpdatedByUserId, (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.lastUpdatedByUserId);
        Assert.assertEquals((Object)expectedLastUpdatedOn, (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.lastUpdatedOn);
        Assert.assertEquals(expectedNotificationList, businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.notificationList);
        Assert.assertEquals((Object)expectedBusinessObjectDefinitionUri, (Object)businessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload.businessObjectDefinitionUri);
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private void validateBusinessObjectFormatVersionChangeMessageWithJsonPayload(String expectedMessageType, String expectedMessageDestination, BusinessObjectFormatKey expectedBusinessObjectFormatKey, String expectedNewBusinessObjectFormatVersion, String expectedOldBusinessObjectFormatVersion, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        BusinessObjectFormatVersionChangeJsonMessagePayload businessObjectFormatVersionChangeJsonMessagePayload = (BusinessObjectFormatVersionChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(BusinessObjectFormatVersionChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((long)StringUtils.length((CharSequence)businessObjectFormatVersionChangeJsonMessagePayload.eventDate), (long)StringUtils.length((CharSequence)HerdDateUtils.now().toString()));
        Assert.assertEquals((Object)expectedBusinessObjectFormatKey, (Object)businessObjectFormatVersionChangeJsonMessagePayload.businessObjectFormatKey);
        Assert.assertEquals((Object)expectedNewBusinessObjectFormatVersion, (Object)businessObjectFormatVersionChangeJsonMessagePayload.newBusinessObjectFormatVersion);
        Assert.assertEquals((Object)expectedOldBusinessObjectFormatVersion, (Object)businessObjectFormatVersionChangeJsonMessagePayload.oldBusinessObjectFormatVersion);
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private void validateUserNamespaceAuthorizationChangeMessageWithJsonPayload(String expectedMessageType, String expectedMessageDestination, UserNamespaceAuthorizationKey expectedUserNamespaceAuthorizationKey, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        UserNamespaceAuthorizationChangeJsonMessagePayload businessObjectFormatVersionChangeJsonMessagePayload = (UserNamespaceAuthorizationChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(UserNamespaceAuthorizationChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((Object)expectedUserNamespaceAuthorizationKey.getUserId(), (Object)businessObjectFormatVersionChangeJsonMessagePayload.userId);
        Assert.assertEquals((Object)expectedUserNamespaceAuthorizationKey.getNamespace(), (Object)businessObjectFormatVersionChangeJsonMessagePayload.namespace);
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private void validateStorageUnitStatusChangeMessageWithJsonPayload(String expectedMessageType, String expectedMessageDestination, BusinessObjectDataKey expectedBusinessObjectDataKey, String expectedStorageName, String expectedNewStorageUnitStatus, String expectedOldStorageUnitStatus, List<MessageHeader> expectedMessageHeaders, NotificationMessage notificationMessage) throws IOException {
        Assert.assertNotNull((Object)notificationMessage);
        Assert.assertEquals((Object)expectedMessageType, (Object)notificationMessage.getMessageType());
        Assert.assertEquals((Object)expectedMessageDestination, (Object)notificationMessage.getMessageDestination());
        StorageUnitStatusChangeJsonMessagePayload storageUnitStatusChangeJsonMessagePayload = (StorageUnitStatusChangeJsonMessagePayload)this.jsonHelper.unmarshallJsonToObject(StorageUnitStatusChangeJsonMessagePayload.class, notificationMessage.getMessageText());
        Assert.assertEquals((long)StringUtils.length((CharSequence)storageUnitStatusChangeJsonMessagePayload.eventDate), (long)StringUtils.length((CharSequence)HerdDateUtils.now().toString()));
        Assert.assertEquals((Object)expectedBusinessObjectDataKey, (Object)storageUnitStatusChangeJsonMessagePayload.businessObjectDataKey);
        Assert.assertEquals((Object)expectedStorageName, (Object)storageUnitStatusChangeJsonMessagePayload.storageName);
        Assert.assertEquals((Object)expectedNewStorageUnitStatus, (Object)storageUnitStatusChangeJsonMessagePayload.newStorageUnitStatus);
        Assert.assertEquals((Object)expectedOldStorageUnitStatus, (Object)storageUnitStatusChangeJsonMessagePayload.oldStorageUnitStatus);
        Assert.assertEquals(expectedMessageHeaders, (Object)notificationMessage.getMessageHeaders());
    }

    private static class UserNamespaceAuthorizationChangeJsonMessagePayload {
        public String userId;
        public String namespace;

        private UserNamespaceAuthorizationChangeJsonMessagePayload() {
        }
    }

    private static class BusinessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload {
        public BusinessObjectDefinitionDescriptionSuggestionKey businessObjectDefinitionDescriptionSuggestionKey;
        public String businessObjectDefinitionUri;
        public String createdByUserId;
        public String createdOn;
        public String eventDate;
        public String lastUpdatedByUserId;
        public String lastUpdatedOn;
        public List<String> notificationList;
        public String status;

        private BusinessObjectDefinitionDescriptionSuggestionChangeJsonMessagePayload() {
        }
    }

    private static class BusinessObjectFormatVersionChangeJsonMessagePayload {
        public BusinessObjectFormatKey businessObjectFormatKey;
        public String eventDate;
        public String newBusinessObjectFormatVersion;
        public String oldBusinessObjectFormatVersion;

        private BusinessObjectFormatVersionChangeJsonMessagePayload() {
        }
    }

    private static class BusinessObjectDataStatusChangeJsonMessagePayload {
        public Map<String, String> attributes;
        public BusinessObjectDataKey businessObjectDataKey;
        public String eventDate;
        public String newBusinessObjectDataStatus;
        public String oldBusinessObjectDataStatus;

        private BusinessObjectDataStatusChangeJsonMessagePayload() {
        }
    }

    private static class StorageUnitStatusChangeJsonMessagePayload {
        public BusinessObjectDataKey businessObjectDataKey;
        public String eventDate;
        public String newStorageUnitStatus;
        public String oldStorageUnitStatus;
        public String storageName;

        private StorageUnitStatusChangeJsonMessagePayload() {
        }
    }
}

